/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.ReplenishmentItemMapper;
import com.yqbsoft.laser.service.contract.dao.ReplenishmentOrderMapper;
import com.yqbsoft.laser.service.contract.domain.ReplenishmentItemDomain;
import com.yqbsoft.laser.service.contract.domain.ReplenishmentOrderDomain;
import com.yqbsoft.laser.service.contract.model.ProjectReport;
import com.yqbsoft.laser.service.contract.model.ReplenishmentItem;
import com.yqbsoft.laser.service.contract.model.ReplenishmentOrder;
import com.yqbsoft.laser.service.contract.service.ReplenishmentOrderService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

public class ReplenishmentOrderServiceImpl
extends BaseServiceImpl
implements ReplenishmentOrderService {
    private ReplenishmentOrderMapper replenishmentOrderMapper;
    private ReplenishmentItemMapper replenishmentItemMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ReplenishmentOrder save(ReplenishmentOrderDomain replenishmentOrderDomain) throws Exception {
        boolean isNew;
        ReplenishmentOrder replenishmentOrder = new ReplenishmentOrder();
        BeanUtils.copyProperties((Object)replenishmentOrderDomain, (Object)replenishmentOrder, (String[])new String[]{"items"});
        boolean bl = isNew = replenishmentOrderDomain.getId() == null;
        if (isNew) {
            this.replenishmentOrderMapper.insert(replenishmentOrder);
        } else {
            this.replenishmentOrderMapper.updateByPrimaryKeySelective(replenishmentOrder);
        }
        List<ReplenishmentItemDomain> domainItems = replenishmentOrderDomain.getItems();
        if (domainItems != null && (isNew || !domainItems.isEmpty())) {
            if (!isNew) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("replenishmentId", replenishmentOrder.getId());
                this.replenishmentItemMapper.delByCode(param);
            }
            if (!domainItems.isEmpty()) {
                Date now = new Date();
                List<ReplenishmentItem> items = domainItems.stream().map(domainItem -> {
                    ReplenishmentItem item = new ReplenishmentItem();
                    BeanUtils.copyProperties((Object)domainItem, (Object)item);
                    item.setReplenishmentId(replenishmentOrder.getId());
                    item.setCreatedAt(now);
                    item.setUpdatedAt(now);
                    return item;
                }).collect(Collectors.toList());
                replenishmentOrder.setItems(items);
                this.insertItems(replenishmentOrder);
            }
        }
        return replenishmentOrder;
    }

    private void insertItems(ReplenishmentOrder replenishmentOrder) {
        if (replenishmentOrder.getItems() != null && !replenishmentOrder.getItems().isEmpty()) {
            replenishmentOrder.getItems().forEach(item -> item.setReplenishmentId(replenishmentOrder.getId()));
            this.replenishmentItemMapper.insertBatch(replenishmentOrder.getItems());
        }
    }

    @Override
    public SupQueryResult<ReplenishmentOrder> queryReplenishmentOrderPage(Map<String, Object> param) throws Exception {
        List<ReplenishmentOrder> list = this.replenishmentOrderMapper.query(param);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.replenishmentOrderMapper.count(param));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    @Override
    public ReplenishmentOrder getById(Long id) throws Exception {
        ReplenishmentOrder replenishmentOrder = this.replenishmentOrderMapper.selectByPrimaryKey(id);
        if (replenishmentOrder != null) {
            replenishmentOrder.setItems(this.getItemsByReplenishmentId(replenishmentOrder.getId()));
        }
        return replenishmentOrder;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ReplenishmentOrder audit(ReplenishmentOrderDomain replenishmentOrderDomain) throws Exception {
        ReplenishmentOrder replenishmentOrder = new ReplenishmentOrder();
        BeanUtils.copyProperties((Object)replenishmentOrderDomain, (Object)replenishmentOrder);
        this.replenishmentOrderMapper.updateByPrimaryKey(replenishmentOrder);
        return replenishmentOrder;
    }

    @Override
    public ProjectReport reject(ReplenishmentOrderDomain replenishmentOrderDomain) throws Exception {
        return null;
    }

    private List<ReplenishmentItem> getItemsByReplenishmentId(Long replenishmentId) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("replenishmentId", replenishmentId);
        return this.replenishmentItemMapper.query(param);
    }

    private boolean isExist(String replenishmentCode) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("replenishmentCode", replenishmentCode);
        List<ReplenishmentOrder> list = this.replenishmentOrderMapper.query(param);
        return !list.isEmpty();
    }

    public void setReplenishmentOrderMapper(ReplenishmentOrderMapper replenishmentOrderMapper) {
        this.replenishmentOrderMapper = replenishmentOrderMapper;
    }

    public void setReplenishmentItemMapper(ReplenishmentItemMapper replenishmentItemMapper) {
        this.replenishmentItemMapper = replenishmentItemMapper;
    }
}

