/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.handler.approval;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.enums.OrderStatusEnum;
import com.yqbsoft.laser.service.contract.handler.approval.AbstractContractApprovalHandler;
import com.yqbsoft.laser.service.contract.model.OcApprovalInstance;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="order_cancelHandler")
public class OrderCancelHandler
extends AbstractContractApprovalHandler {
    private static final Logger log = LoggerFactory.getLogger(OrderCancelHandler.class);
    private static final String BIZ_TYPE = "ORDER";

    public OrderCancelHandler(OcContractService contractService, OcContractEngineService contractEngineService) {
        super(contractService, contractEngineService);
    }

    @Override
    public String getBizType() {
        return BIZ_TYPE;
    }

    @Override
    public String validateBeforeApply(String bizId) {
        OcContractReDomain contract = this.getContractByCode(bizId);
        this.validateCancelable(contract);
        log.info("\u8ba2\u5355 [{}] \u6821\u9a8c\u901a\u8fc7\uff0c\u53ef\u53d1\u8d77\u53d6\u6d88\u5ba1\u6279", (Object)bizId);
        return JSONObject.toJSONString((Object)contract);
    }

    @Override
    public void onApproved(OcApprovalInstance instance) {
        String contractCode = instance.getBizId();
        log.info("\u8ba2\u5355\u53d6\u6d88\u5ba1\u6279\u901a\u8fc7\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)contractCode);
        try {
            this.contractEngineService.sendContractNext(contractCode, instance.getTenantId(), null);
            log.info("\u8ba2\u5355 [{}] \u5df2\u6210\u529f\u53d6\u6d88\u5e76\u6d41\u8f6c\u5b8c\u6210", (Object)contractCode);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u53d6\u6d88\u5ba1\u6279\u901a\u8fc7\u540e\u5904\u7406\u5f02\u5e38\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)contractCode, (Object)e);
            throw new ApiException("\u8ba2\u5355\u53d6\u6d88\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    @Override
    public void onRejected(OcApprovalInstance instance) {
        String contractCode = instance.getBizId();
        log.info("\u8ba2\u5355\u53d6\u6d88\u5ba1\u6279\u88ab\u9a73\u56de\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)contractCode);
        this.contractEngineService.sendContractBack(contractCode, instance.getTenantId(), null);
    }

    private void validateCancelable(OcContractReDomain contract) {
        OrderStatusEnum state = OrderStatusEnum.of(contract.getDataState());
        String contractCode = contract.getContractBillcode();
        switch (state) {
            case CANCELED: {
                throw new ApiException("\u8ba2\u5355\u5df2\u53d6\u6d88\uff01\u8ba2\u5355\u53f7\uff1a" + contractCode);
            }
            case PRICE_APPROVING: {
                throw new ApiException("\u4ef7\u683c\u5ba1\u6279\u4e2d\uff01\u8bf7\u5148\u64a4\u9500\u5ba1\u6279\u518d\u53d6\u6d88\u8ba2\u5355\uff1a" + contractCode);
            }
            case CANCEL_APPROVING: {
                throw new ApiException("\u8ba2\u5355\u53d6\u6d88\u5ba1\u6279\u4e2d\uff01\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\uff1a" + contractCode);
            }
        }
        log.debug("\u8ba2\u5355 [{}] \u72b6\u6001\u6821\u9a8c\u901a\u8fc7\uff1a{}", (Object)contractCode, (Object)state.getDesc());
    }
}

