/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.demologin.service.impl;

import com.yqbsoft.laser.service.demologin.dao.DemoLoginMapper;
import com.yqbsoft.laser.service.demologin.domain.DemoLoginDomain;
import com.yqbsoft.laser.service.demologin.domain.DemoLoginReDomain;
import com.yqbsoft.laser.service.demologin.model.DemoLogin;
import com.yqbsoft.laser.service.demologin.service.DemoLoginService;
import com.yqbsoft.laser.service.demologin.utils.MD5utils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DemoLoginServiceImpl
extends BaseServiceImpl
implements DemoLoginService {
    private static final String SYS_CODE = "demo.DemoLoginServiceImpl";
    private DemoLoginMapper demoLoginMapper;

    public void setDemoLoginMapper(DemoLoginMapper demoLoginMapper) {
        this.demoLoginMapper = demoLoginMapper;
    }

    private Date getSysDate() {
        try {
            return this.demoLoginMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checklogin(DemoLoginDomain demoLoginDomain) {
        if (null == demoLoginDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)demoLoginDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setloginDefault(DemoLogin demoLogin) {
        if (null == demoLogin) {
            return;
        }
        if (null == demoLogin.getDataState()) {
            demoLogin.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == demoLogin.getGmtCreate()) {
            demoLogin.setGmtCreate(date);
        }
        demoLogin.setGmtModified(date);
        if (StringUtils.isBlank((String)demoLogin.getLoginCode())) {
            demoLogin.setLoginCode(this.getNo(null, "DemoLogin", "demoLogin", demoLogin.getTenantCode()));
        }
    }

    private int getloginMaxCode() {
        int code = 0;
        try {
            return this.demoLoginMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.getloginMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setloginUpdataDefault(DemoLogin demoLogin) {
        if (null == demoLogin) {
            return;
        }
        demoLogin.setGmtModified(this.getSysDate());
    }

    private void saveloginModel(DemoLogin demoLogin) throws ApiException {
        if (null == demoLogin) {
            return;
        }
        try {
            this.demoLoginMapper.insert(demoLogin);
        }
        catch (Exception e) {
            throw new ApiException("demo.DemoLoginServiceImpl.saveloginModel.ex", (Throwable)e);
        }
    }

    private void saveloginBatchModel(List<DemoLogin> demoLoginList) throws ApiException {
        if (null == demoLoginList || demoLoginList.isEmpty()) {
            return;
        }
        try {
            this.demoLoginMapper.insertBatch(demoLoginList);
        }
        catch (Exception e) {
            throw new ApiException("demo.DemoLoginServiceImpl.saveloginBatchModel.ex", (Throwable)e);
        }
    }

    private DemoLogin getloginModelById(Integer loginId) {
        if (null == loginId) {
            return null;
        }
        try {
            return this.demoLoginMapper.selectByPrimaryKey(loginId);
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.getloginModelById", (Throwable)e);
            return null;
        }
    }

    private DemoLogin getloginModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.demoLoginMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.getloginModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delloginModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.demoLoginMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("demo.DemoLoginServiceImpl.delloginModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("demo.DemoLoginServiceImpl.delloginModelByCode.num");
        }
    }

    private void deleteloginModel(Integer loginId) throws ApiException {
        if (null == loginId) {
            return;
        }
        int i = 0;
        try {
            i = this.demoLoginMapper.deleteByPrimaryKey(loginId);
        }
        catch (Exception e) {
            throw new ApiException("demo.DemoLoginServiceImpl.deleteloginModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("demo.DemoLoginServiceImpl.deleteloginModel.num");
        }
    }

    private void updateloginModel(DemoLogin demoLogin) throws ApiException {
        if (null == demoLogin) {
            return;
        }
        int i = 0;
        try {
            i = this.demoLoginMapper.updateByPrimaryKey(demoLogin);
        }
        catch (Exception e) {
            throw new ApiException("demo.DemoLoginServiceImpl.updateloginModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("demo.DemoLoginServiceImpl.updateloginModel.num");
        }
    }

    private void updateStateloginModel(Integer loginId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == loginId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("loginId", loginId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.demoLoginMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("demo.DemoLoginServiceImpl.updateStateloginModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("demo.DemoLoginServiceImpl.updateStateloginModel.null");
        }
    }

    private void updateStateloginModelByCode(String tenantCode, String loginCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)loginCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("loginCode", loginCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.demoLoginMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("demo.DemoLoginServiceImpl.updateStateloginModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("demo.DemoLoginServiceImpl.updateStateloginModelByCode.null");
        }
    }

    private DemoLogin makelogin(DemoLoginDomain demoLoginDomain, DemoLogin demoLogin) {
        if (null == demoLoginDomain) {
            return null;
        }
        if (null == demoLogin) {
            demoLogin = new DemoLogin();
        }
        try {
            BeanUtils.copyAllPropertys((Object)demoLogin, (Object)demoLoginDomain);
            return demoLogin;
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.makelogin", (Throwable)e);
            return null;
        }
    }

    private DemoLoginReDomain makeDemoLoginReDomain(DemoLogin demoLogin) {
        if (null == demoLogin) {
            return null;
        }
        DemoLoginReDomain demoLoginReDomain = new DemoLoginReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)demoLoginReDomain, (Object)demoLogin);
            return demoLoginReDomain;
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.makeDemoLoginReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DemoLogin> queryloginModelPage(Map<String, Object> parammap) {
        try {
            return this.demoLoginMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.queryloginModel", (Throwable)e);
            return null;
        }
    }

    private int countlogin(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.demoLoginMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.countlogin", (Throwable)e);
        }
        return i;
    }

    private DemoLogin createDemoLogin(DemoLoginDomain demoLoginDomain) {
        String msg = this.checklogin(demoLoginDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("demo.DemoLoginServiceImpl.savelogin.checklogin", msg);
        }
        DemoLogin demoLogin = this.makelogin(demoLoginDomain, null);
        this.setloginDefault(demoLogin);
        return demoLogin;
    }

    @Override
    public String savelogin(DemoLoginDomain demoLoginDomain) throws ApiException {
        DemoLogin demoLogin = this.createDemoLogin(demoLoginDomain);
        this.saveloginModel(demoLogin);
        return demoLogin.getLoginCode();
    }

    @Override
    public String saveloginBatch(List<DemoLoginDomain> demoLoginDomainList) throws ApiException {
        if (null == demoLoginDomainList || demoLoginDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DemoLogin> demoLoginList = new ArrayList<DemoLogin>();
        String code = "";
        for (DemoLoginDomain demoLoginDomain : demoLoginDomainList) {
            DemoLogin demoLogin = this.createDemoLogin(demoLoginDomain);
            code = demoLogin.getLoginCode();
            demoLoginList.add(demoLogin);
        }
        this.saveloginBatchModel(demoLoginList);
        return code;
    }

    @Override
    public void updateloginState(Integer loginId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == loginId) {
            return;
        }
        this.updateStateloginModel(loginId, dataState, oldDataState, map);
    }

    @Override
    public void updateloginStateByCode(String tenantCode, String loginCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)loginCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateloginModelByCode(tenantCode, loginCode, dataState, oldDataState, map);
    }

    @Override
    public void updatelogin(DemoLoginDomain demoLoginDomain) throws ApiException {
        String msg = this.checklogin(demoLoginDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("demo.DemoLoginServiceImpl.updatelogin.checklogin", msg);
        }
        DemoLogin oldDemoLogin = this.getloginModelById(demoLoginDomain.getLoginId());
        if (null == oldDemoLogin) {
            throw new ApiException("demo.DemoLoginServiceImpl.updatelogin.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DemoLogin demoLogin = this.makelogin(demoLoginDomain, oldDemoLogin);
        this.setloginUpdataDefault(demoLogin);
        this.updateloginModel(demoLogin);
    }

    @Override
    public DemoLogin getlogin(Integer loginId) {
        if (null == loginId) {
            return null;
        }
        return this.getloginModelById(loginId);
    }

    @Override
    public void deletelogin(Integer loginId) throws ApiException {
        if (null == loginId) {
            return;
        }
        this.deleteloginModel(loginId);
    }

    @Override
    public QueryResult<DemoLogin> queryloginPage(Map<String, Object> map) {
        List<DemoLogin> demoLoginList = this.queryloginModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countlogin(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(demoLoginList);
        return queryResult;
    }

    @Override
    public DemoLogin getloginByCode(String tenantCode, String loginCode) throws ApiException {
        if (StringUtils.isBlank((String)loginCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("loginCode", loginCode);
        return this.getloginModelByCode(map);
    }

    @Override
    public void deleteloginByCode(String tenantCode, String loginCode) throws ApiException {
        if (StringUtils.isBlank((String)loginCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("loginCode", loginCode);
        this.delloginModelByCode(map);
    }

    @Override
    public DemoLoginDomain LoginUserDemo(Map<String, Object> map) throws ApiException {
        if (null == map) {
            this.logger.error("demo.DemoLoginServiceImpl.LoginUserDemo", (Object)"\u53c2\u6570\u4e3a\u7a7a\uff01");
            return null;
        }
        String loginName = (String)map.get("loginName");
        String passwd = (String)map.get("passwd");
        if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd)) {
            this.logger.error("demo.DemoLoginServiceImpl.LoginUserDemo", (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return null;
        }
        passwd = MD5utils.string2MD5(passwd);
        map.put("passwd", passwd);
        DemoLoginDomain demoLoginDomain = this.checkLoginInfo(map);
        if (demoLoginDomain != null) {
            this.logger.info("demo.DemoLoginServiceImpl.LoginUserDemo", (Object)"\u767b\u5f55\u6210\u529f\uff01");
            return demoLoginDomain;
        }
        this.logger.error("demo.DemoLoginServiceImpl.LoginUserDemo", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01");
        return null;
    }

    private DemoLoginDomain checkLoginInfo(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        try {
            return this.demoLoginMapper.getInfoByAccount(map);
        }
        catch (Exception e) {
            this.logger.error("demo.DemoLoginServiceImpl.checklogininfo", (Throwable)e);
            return null;
        }
    }
}

