/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisStatementBankMapper;
import com.yqbsoft.laser.service.distribution.dao.DisStatementContractMapper;
import com.yqbsoft.laser.service.distribution.dao.DisStatementMapper;
import com.yqbsoft.laser.service.distribution.domain.DisStatementBankDomain;
import com.yqbsoft.laser.service.distribution.domain.DisStatementBankReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisStatementContractDomain;
import com.yqbsoft.laser.service.distribution.domain.DisStatementContractReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisStatementDomain;
import com.yqbsoft.laser.service.distribution.domain.DisStatementReDomain;
import com.yqbsoft.laser.service.distribution.model.DisStatement;
import com.yqbsoft.laser.service.distribution.model.DisStatementBank;
import com.yqbsoft.laser.service.distribution.model.DisStatementContract;
import com.yqbsoft.laser.service.distribution.service.DisStatementService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisStatementServiceImpl
extends BaseServiceImpl
implements DisStatementService {
    private static final String SYS_CODE = "dis.DisStatementServiceImpl";
    private DisStatementMapper disStatementMapper;
    private DisStatementContractMapper disStatementContractMapper;
    private DisStatementBankMapper disStatementBankMapper;

    public void setDisStatementMapper(DisStatementMapper disStatementMapper) {
        this.disStatementMapper = disStatementMapper;
    }

    public void setDisStatementContractMapper(DisStatementContractMapper disStatementContractMapper) {
        this.disStatementContractMapper = disStatementContractMapper;
    }

    public void setDisStatementBankMapper(DisStatementBankMapper disStatementBankMapper) {
        this.disStatementBankMapper = disStatementBankMapper;
    }

    private Date getSysDate() {
        try {
            return this.disStatementMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStatement(DisStatementDomain disStatementDomain) {
        if (null == disStatementDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disStatementDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStatementDefault(DisStatement disStatement) {
        if (null == disStatement) {
            return;
        }
        if (null == disStatement.getDataState()) {
            disStatement.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disStatement.getGmtCreate()) {
            disStatement.setGmtCreate(date);
        }
        disStatement.setGmtModified(date);
        if (StringUtils.isBlank((String)disStatement.getStatementCode())) {
            disStatement.setStatementCode(this.getNo(null, "DisStatement", "disStatement", disStatement.getTenantCode()));
        }
    }

    private int getStatementMaxCode() {
        int code = 0;
        try {
            return this.disStatementMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStatementUpdataDefault(DisStatement disStatement) {
        if (null == disStatement) {
            return;
        }
        disStatement.setGmtModified(this.getSysDate());
    }

    private void saveStatementModel(DisStatement disStatement) throws ApiException {
        if (null == disStatement) {
            return;
        }
        try {
            this.disStatementMapper.insert(disStatement);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatementModel.ex", (Throwable)e);
        }
    }

    private void saveStatementBatchModel(List<DisStatement> disStatementList) throws ApiException {
        if (null == disStatementList || disStatementList.isEmpty()) {
            return;
        }
        try {
            this.disStatementMapper.insertBatch(disStatementList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatementBatchModel.ex", (Throwable)e);
        }
    }

    private DisStatement getStatementModelById(Integer statementId) {
        if (null == statementId) {
            return null;
        }
        try {
            return this.disStatementMapper.selectByPrimaryKey(statementId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementModelById", (Throwable)e);
            return null;
        }
    }

    private DisStatement getStatementModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disStatementMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStatementModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.delStatementModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.delStatementModelByCode.num");
        }
    }

    private void deleteStatementModel(Integer statementId) throws ApiException {
        if (null == statementId) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementMapper.deleteByPrimaryKey(statementId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.deleteStatementModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.deleteStatementModel.num");
        }
    }

    private void updateStatementModel(DisStatement disStatement) throws ApiException {
        if (null == disStatement) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementMapper.updateByPrimaryKey(disStatement);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementModel.num");
        }
    }

    private void updateStateStatementModel(Integer statementId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == statementId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statementId", statementId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disStatementMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementModel.null");
        }
    }

    private void updateStateStatementModelByCode(String tenantCode, String statementCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)statementCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementCode", statementCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disStatementMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementModelByCode.null");
        }
    }

    private DisStatement makeStatement(DisStatementDomain disStatementDomain, DisStatement disStatement) {
        if (null == disStatementDomain) {
            return null;
        }
        if (null == disStatement) {
            disStatement = new DisStatement();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disStatement, (Object)disStatementDomain);
            return disStatement;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.makeStatement", (Throwable)e);
            return null;
        }
    }

    private DisStatementReDomain makeDisStatementReDomain(DisStatement disStatement) {
        if (null == disStatement) {
            return null;
        }
        DisStatementReDomain disStatementReDomain = new DisStatementReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disStatementReDomain, (Object)disStatement);
            return disStatementReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.makeDisStatementReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisStatement> queryStatementModelPage(Map<String, Object> parammap) {
        try {
            return this.disStatementMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.queryStatementModel", (Throwable)e);
            return null;
        }
    }

    private int countStatement(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disStatementMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.countStatement", (Throwable)e);
        }
        return i;
    }

    private DisStatement createDisStatement(DisStatementDomain disStatementDomain) {
        String msg = this.checkStatement(disStatementDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatement.checkStatement", msg);
        }
        DisStatement disStatement = this.makeStatement(disStatementDomain, null);
        this.setStatementDefault(disStatement);
        return disStatement;
    }

    private String checkStatementContract(DisStatementContractDomain disStatementContractDomain) {
        if (null == disStatementContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disStatementContractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStatementContractDefault(DisStatementContract disStatementContract) {
        if (null == disStatementContract) {
            return;
        }
        if (null == disStatementContract.getDataState()) {
            disStatementContract.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disStatementContract.getGmtCreate()) {
            disStatementContract.setGmtCreate(date);
        }
        disStatementContract.setGmtModified(date);
        if (StringUtils.isBlank((String)disStatementContract.getStatementContractCode())) {
            disStatementContract.setStatementContractCode(this.getNo(null, "DisStatementContract", "disStatementContract", disStatementContract.getTenantCode()));
        }
    }

    private int getStatementContractMaxCode() {
        int code = 0;
        try {
            return this.disStatementContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStatementContractUpdataDefault(DisStatementContract disStatementContract) {
        if (null == disStatementContract) {
            return;
        }
        disStatementContract.setGmtModified(this.getSysDate());
    }

    private void saveStatementContractModel(DisStatementContract disStatementContract) throws ApiException {
        if (null == disStatementContract) {
            return;
        }
        try {
            this.disStatementContractMapper.insert(disStatementContract);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatementContractModel.ex", (Throwable)e);
        }
    }

    private void saveStatementContractBatchModel(List<DisStatementContract> disStatementContractList) throws ApiException {
        if (null == disStatementContractList || disStatementContractList.isEmpty()) {
            return;
        }
        try {
            this.disStatementContractMapper.insertBatch(disStatementContractList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatementContractBatchModel.ex", (Throwable)e);
        }
    }

    private DisStatementContract getStatementContractModelById(Integer statementContractId) {
        if (null == statementContractId) {
            return null;
        }
        try {
            return this.disStatementContractMapper.selectByPrimaryKey(statementContractId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementContractModelById", (Throwable)e);
            return null;
        }
    }

    private DisStatementContract getStatementContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disStatementContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementContractModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStatementContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.delStatementContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.delStatementContractModelByCode.num");
        }
    }

    private void deleteStatementContractModel(Integer statementContractId) throws ApiException {
        if (null == statementContractId) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementContractMapper.deleteByPrimaryKey(statementContractId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.deleteStatementContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.deleteStatementContractModel.num");
        }
    }

    private void updateStatementContractModel(DisStatementContract disStatementContract) throws ApiException {
        if (null == disStatementContract) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementContractMapper.updateByPrimaryKey(disStatementContract);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementContractModel.num");
        }
    }

    private void updateStateStatementContractModel(Integer statementContractId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == statementContractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statementContractId", statementContractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disStatementContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementContractModel.null");
        }
    }

    private void updateStateStatementContractModelByCode(String tenantCode, String statementContractCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)statementContractCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementContractCode", statementContractCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disStatementContractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementContractModelByCode.null");
        }
    }

    private DisStatementContract makeStatementContract(DisStatementContractDomain disStatementContractDomain, DisStatementContract disStatementContract) {
        if (null == disStatementContractDomain) {
            return null;
        }
        if (null == disStatementContract) {
            disStatementContract = new DisStatementContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disStatementContract, (Object)disStatementContractDomain);
            return disStatementContract;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.makeStatementContract", (Throwable)e);
            return null;
        }
    }

    private DisStatementContractReDomain makeDisStatementContractReDomain(DisStatementContract disStatementContract) {
        if (null == disStatementContract) {
            return null;
        }
        DisStatementContractReDomain disStatementContractReDomain = new DisStatementContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disStatementContractReDomain, (Object)disStatementContract);
            return disStatementContractReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.makeDisStatementContractReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisStatementContract> queryStatementContractModelPage(Map<String, Object> parammap) {
        try {
            return this.disStatementContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.queryStatementContractModel", (Throwable)e);
            return null;
        }
    }

    private int countStatementContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disStatementContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.countStatementContract", (Throwable)e);
        }
        return i;
    }

    private DisStatementContract createDisStatementContract(DisStatementContractDomain disStatementContractDomain) {
        String msg = this.checkStatementContract(disStatementContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatementContract.checkStatementContract", msg);
        }
        DisStatementContract disStatementContract = this.makeStatementContract(disStatementContractDomain, null);
        this.setStatementContractDefault(disStatementContract);
        return disStatementContract;
    }

    private String checkStatementBank(DisStatementBankDomain disStatementBankDomain) {
        if (null == disStatementBankDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disStatementBankDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStatementBankDefault(DisStatementBank disStatementBank) {
        if (null == disStatementBank) {
            return;
        }
        if (null == disStatementBank.getDataState()) {
            disStatementBank.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disStatementBank.getGmtCreate()) {
            disStatementBank.setGmtCreate(date);
        }
        disStatementBank.setGmtModified(date);
        if (StringUtils.isBlank((String)disStatementBank.getStatementBankCode())) {
            disStatementBank.setStatementBankCode(this.getNo(null, "DisStatementBank", "disStatementBank", disStatementBank.getTenantCode()));
        }
    }

    private int getStatementBankMaxCode() {
        int code = 0;
        try {
            return this.disStatementBankMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementBankMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStatementBankUpdataDefault(DisStatementBank disStatementBank) {
        if (null == disStatementBank) {
            return;
        }
        disStatementBank.setGmtModified(this.getSysDate());
    }

    private void saveStatementBankModel(DisStatementBank disStatementBank) throws ApiException {
        if (null == disStatementBank) {
            return;
        }
        try {
            this.disStatementBankMapper.insert(disStatementBank);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatementBankModel.ex", (Throwable)e);
        }
    }

    private void saveStatementBankBatchModel(List<DisStatementBank> disStatementBankList) throws ApiException {
        if (null == disStatementBankList || disStatementBankList.isEmpty()) {
            return;
        }
        try {
            this.disStatementBankMapper.insertBatch(disStatementBankList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatementBankBatchModel.ex", (Throwable)e);
        }
    }

    private DisStatementBank getStatementBankModelById(Integer statementBankId) {
        if (null == statementBankId) {
            return null;
        }
        try {
            return this.disStatementBankMapper.selectByPrimaryKey(statementBankId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementBankModelById", (Throwable)e);
            return null;
        }
    }

    private DisStatementBank getStatementBankModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disStatementBankMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.getStatementBankModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStatementBankModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementBankMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.delStatementBankModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.delStatementBankModelByCode.num");
        }
    }

    private void deleteStatementBankModel(Integer statementBankId) throws ApiException {
        if (null == statementBankId) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementBankMapper.deleteByPrimaryKey(statementBankId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.deleteStatementBankModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.deleteStatementBankModel.num");
        }
    }

    private void updateStatementBankModel(DisStatementBank disStatementBank) throws ApiException {
        if (null == disStatementBank) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatementBankMapper.updateByPrimaryKey(disStatementBank);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementBankModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementBankModel.num");
        }
    }

    private void updateStateStatementBankModel(Integer statementBankId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == statementBankId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statementBankId", statementBankId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disStatementBankMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementBankModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementBankModel.null");
        }
    }

    private void updateStateStatementBankModelByCode(String tenantCode, String statementBankCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)statementBankCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementBankCode", statementBankCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disStatementBankMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementBankModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStateStatementBankModelByCode.null");
        }
    }

    private DisStatementBank makeStatementBank(DisStatementBankDomain disStatementBankDomain, DisStatementBank disStatementBank) {
        if (null == disStatementBankDomain) {
            return null;
        }
        if (null == disStatementBank) {
            disStatementBank = new DisStatementBank();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disStatementBank, (Object)disStatementBankDomain);
            return disStatementBank;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.makeStatementBank", (Throwable)e);
            return null;
        }
    }

    private DisStatementBankReDomain makeDisStatementBankReDomain(DisStatementBank disStatementBank) {
        if (null == disStatementBank) {
            return null;
        }
        DisStatementBankReDomain disStatementBankReDomain = new DisStatementBankReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disStatementBankReDomain, (Object)disStatementBank);
            return disStatementBankReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.makeDisStatementBankReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisStatementBank> queryStatementBankModelPage(Map<String, Object> parammap) {
        try {
            return this.disStatementBankMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.queryStatementBankModel", (Throwable)e);
            return null;
        }
    }

    private int countStatementBank(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disStatementBankMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatementServiceImpl.countStatementBank", (Throwable)e);
        }
        return i;
    }

    private DisStatementBank createDisStatementBank(DisStatementBankDomain disStatementBankDomain) {
        String msg = this.checkStatementBank(disStatementBankDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatementServiceImpl.saveStatementBank.checkStatementBank", msg);
        }
        DisStatementBank disStatementBank = this.makeStatementBank(disStatementBankDomain, null);
        this.setStatementBankDefault(disStatementBank);
        return disStatementBank;
    }

    @Override
    public String saveStatement(DisStatementDomain disStatementDomain) throws ApiException {
        DisStatement disStatement = this.createDisStatement(disStatementDomain);
        this.saveStatementModel(disStatement);
        return disStatement.getStatementCode();
    }

    @Override
    public String saveStatementBatch(List<DisStatementDomain> disStatementDomainList) throws ApiException {
        if (null == disStatementDomainList || disStatementDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisStatement> disStatementList = new ArrayList<DisStatement>();
        String code = "";
        for (DisStatementDomain disStatementDomain : disStatementDomainList) {
            DisStatement disStatement = this.createDisStatement(disStatementDomain);
            code = disStatement.getStatementCode();
            disStatementList.add(disStatement);
        }
        this.saveStatementBatchModel(disStatementList);
        return code;
    }

    @Override
    public void updateStatementState(Integer statementId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == statementId) {
            return;
        }
        this.updateStateStatementModel(statementId, dataState, oldDataState, map);
    }

    @Override
    public void updateStatementStateByCode(String tenantCode, String statementCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)statementCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStatementModelByCode(tenantCode, statementCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStatement(DisStatementDomain disStatementDomain) throws ApiException {
        String msg = this.checkStatement(disStatementDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatement.checkStatement", msg);
        }
        DisStatement oldDisStatement = this.getStatementModelById(disStatementDomain.getStatementId());
        if (null == oldDisStatement) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatement.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisStatement disStatement = this.makeStatement(disStatementDomain, oldDisStatement);
        this.setStatementUpdataDefault(disStatement);
        this.updateStatementModel(disStatement);
    }

    @Override
    public DisStatement getStatement(Integer statementId) {
        if (null == statementId) {
            return null;
        }
        return this.getStatementModelById(statementId);
    }

    @Override
    public void deleteStatement(Integer statementId) throws ApiException {
        if (null == statementId) {
            return;
        }
        this.deleteStatementModel(statementId);
    }

    @Override
    public QueryResult<DisStatement> queryStatementPage(Map<String, Object> map) {
        List<DisStatement> disStatementList = this.queryStatementModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStatement(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disStatementList);
        return queryResult;
    }

    @Override
    public DisStatement getStatementByCode(String tenantCode, String statementCode) throws ApiException {
        if (StringUtils.isBlank((String)statementCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementCode", statementCode);
        return this.getStatementModelByCode(map);
    }

    @Override
    public void deleteStatementByCode(String tenantCode, String statementCode) throws ApiException {
        if (StringUtils.isBlank((String)statementCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementCode", statementCode);
        this.delStatementModelByCode(map);
    }

    @Override
    public String saveStatementContract(DisStatementContractDomain disStatementContractDomain) throws ApiException {
        DisStatementContract disStatementContract = this.createDisStatementContract(disStatementContractDomain);
        this.saveStatementContractModel(disStatementContract);
        return disStatementContract.getStatementContractCode();
    }

    @Override
    public String saveStatementContractBatch(List<DisStatementContractDomain> disStatementContractDomainList) throws ApiException {
        if (null == disStatementContractDomainList || disStatementContractDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisStatementContract> disStatementContractList = new ArrayList<DisStatementContract>();
        String code = "";
        for (DisStatementContractDomain disStatementContractDomain : disStatementContractDomainList) {
            DisStatementContract disStatementContract = this.createDisStatementContract(disStatementContractDomain);
            code = disStatementContract.getStatementContractCode();
            disStatementContractList.add(disStatementContract);
        }
        this.saveStatementContractBatchModel(disStatementContractList);
        return code;
    }

    @Override
    public void updateStatementContractState(Integer statementContractId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == statementContractId) {
            return;
        }
        this.updateStateStatementContractModel(statementContractId, dataState, oldDataState, map);
    }

    @Override
    public void updateStatementContractStateByCode(String tenantCode, String statementContractCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)statementContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStatementContractModelByCode(tenantCode, statementContractCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStatementContract(DisStatementContractDomain disStatementContractDomain) throws ApiException {
        String msg = this.checkStatementContract(disStatementContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementContract.checkStatementContract", msg);
        }
        DisStatementContract oldDisStatementContract = this.getStatementContractModelById(disStatementContractDomain.getStatementContractId());
        if (null == oldDisStatementContract) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisStatementContract disStatementContract = this.makeStatementContract(disStatementContractDomain, oldDisStatementContract);
        this.setStatementContractUpdataDefault(disStatementContract);
        this.updateStatementContractModel(disStatementContract);
    }

    @Override
    public DisStatementContract getStatementContract(Integer statementContractId) {
        if (null == statementContractId) {
            return null;
        }
        return this.getStatementContractModelById(statementContractId);
    }

    @Override
    public void deleteStatementContract(Integer statementContractId) throws ApiException {
        if (null == statementContractId) {
            return;
        }
        this.deleteStatementContractModel(statementContractId);
    }

    @Override
    public QueryResult<DisStatementContract> queryStatementContractPage(Map<String, Object> map) {
        List<DisStatementContract> disStatementContractList = this.queryStatementContractModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStatementContract(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disStatementContractList);
        return queryResult;
    }

    @Override
    public DisStatementContract getStatementContractByCode(String tenantCode, String statementContractCode) throws ApiException {
        if (StringUtils.isBlank((String)statementContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementContractCode", statementContractCode);
        return this.getStatementContractModelByCode(map);
    }

    @Override
    public void deleteStatementContractByCode(String tenantCode, String statementContractCode) throws ApiException {
        if (StringUtils.isBlank((String)statementContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementContractCode", statementContractCode);
        this.delStatementContractModelByCode(map);
    }

    @Override
    public String saveStatementBank(DisStatementBankDomain disStatementBankDomain) throws ApiException {
        DisStatementBank disStatementBank = this.createDisStatementBank(disStatementBankDomain);
        this.saveStatementBankModel(disStatementBank);
        return disStatementBank.getStatementBankCode();
    }

    @Override
    public String saveStatementBankBatch(List<DisStatementBankDomain> disStatementBankDomainList) throws ApiException {
        if (null == disStatementBankDomainList || disStatementBankDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisStatementBank> disStatementBankList = new ArrayList<DisStatementBank>();
        String code = "";
        for (DisStatementBankDomain disStatementBankDomain : disStatementBankDomainList) {
            DisStatementBank disStatementBank = this.createDisStatementBank(disStatementBankDomain);
            code = disStatementBank.getStatementBankCode();
            disStatementBankList.add(disStatementBank);
        }
        this.saveStatementBankBatchModel(disStatementBankList);
        return code;
    }

    @Override
    public void updateStatementBankState(Integer statementBankId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == statementBankId) {
            return;
        }
        this.updateStateStatementBankModel(statementBankId, dataState, oldDataState, map);
    }

    @Override
    public void updateStatementBankStateByCode(String tenantCode, String statementBankCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)statementBankCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStatementBankModelByCode(tenantCode, statementBankCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStatementBank(DisStatementBankDomain disStatementBankDomain) throws ApiException {
        String msg = this.checkStatementBank(disStatementBankDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementBank.checkStatementBank", msg);
        }
        DisStatementBank oldDisStatementBank = this.getStatementBankModelById(disStatementBankDomain.getStatementBankId());
        if (null == oldDisStatementBank) {
            throw new ApiException("dis.DisStatementServiceImpl.updateStatementBank.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisStatementBank disStatementBank = this.makeStatementBank(disStatementBankDomain, oldDisStatementBank);
        this.setStatementBankUpdataDefault(disStatementBank);
        this.updateStatementBankModel(disStatementBank);
    }

    @Override
    public DisStatementBank getStatementBank(Integer statementBankId) {
        if (null == statementBankId) {
            return null;
        }
        return this.getStatementBankModelById(statementBankId);
    }

    @Override
    public void deleteStatementBank(Integer statementBankId) throws ApiException {
        if (null == statementBankId) {
            return;
        }
        this.deleteStatementBankModel(statementBankId);
    }

    @Override
    public QueryResult<DisStatementBank> queryStatementBankPage(Map<String, Object> map) {
        List<DisStatementBank> disStatementBankList = this.queryStatementBankModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStatementBank(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disStatementBankList);
        return queryResult;
    }

    @Override
    public DisStatementBank getStatementBankByCode(String tenantCode, String statementBankCode) throws ApiException {
        if (StringUtils.isBlank((String)statementBankCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementBankCode", statementBankCode);
        return this.getStatementBankModelByCode(map);
    }

    @Override
    public void deleteStatementBankByCode(String tenantCode, String statementBankCode) throws ApiException {
        if (StringUtils.isBlank((String)statementBankCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("statementBankCode", statementBankCode);
        this.delStatementBankModelByCode(map);
    }
}

