/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftSpecMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftSpecDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftSpecReDomain;
import com.yqbsoft.laser.service.gt.model.GtGiftSpec;
import com.yqbsoft.laser.service.gt.service.GtGiftSpecService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftSpecServiceImpl
extends BaseServiceImpl
implements GtGiftSpecService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftSpecServiceImpl";
    private GtGiftSpecMapper gtGiftSpecMapper;

    public void setGtGiftSpecMapper(GtGiftSpecMapper gtGiftSpecMapper) {
        this.gtGiftSpecMapper = gtGiftSpecMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftSpecMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSpecServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftSpec(GtGiftSpecDomain gtGiftSpecDomain) {
        if (null == gtGiftSpecDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftSpecDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftSpecDefault(GtGiftSpec gtGiftSpec) {
        if (null == gtGiftSpec) {
            return;
        }
        if (null == gtGiftSpec.getDataState()) {
            gtGiftSpec.setDataState(0);
        }
        if (null == gtGiftSpec.getGmtCreate()) {
            gtGiftSpec.setGmtCreate(this.getSysDate());
        }
        gtGiftSpec.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftSpec.getGiftSpecCode())) {
            gtGiftSpec.setGiftSpecCode(this.createUUIDString());
        }
    }

    private int getGiftSpecMaxCode() {
        int code = 0;
        try {
            return this.gtGiftSpecMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSpecServiceImpl.getGiftSpecMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftSpecUpdataDefault(GtGiftSpec gtGiftSpec) {
        if (null == gtGiftSpec) {
            return;
        }
        gtGiftSpec.setGmtModified(this.getSysDate());
    }

    private void saveGiftSpecModel(GtGiftSpec gtGiftSpec) throws ApiException {
        if (null == gtGiftSpec) {
            return;
        }
        try {
            this.gtGiftSpecMapper.insert(gtGiftSpec);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.saveGiftSpecModel.ex", (Throwable)e);
        }
    }

    private void saveGiftSpecBatchModel(List<GtGiftSpec> gtGiftSpecList) throws ApiException {
        if (null == gtGiftSpecList || gtGiftSpecList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftSpecMapper.insertBatch(gtGiftSpecList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.saveGiftSpecBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftSpec getGiftSpecModelById(Integer giftSpecId) {
        if (null == giftSpecId) {
            return null;
        }
        try {
            return this.gtGiftSpecMapper.selectByPrimaryKey(giftSpecId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSpecServiceImpl.getGiftSpecModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftSpec getGiftSpecModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftSpecMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSpecServiceImpl.getGiftSpecModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftSpecModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftSpecMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.delGiftSpecModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.delGiftSpecModelByCode.num");
        }
    }

    private void delGiftSpecModelByGiftCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.gtGiftSpecMapper.delByGiftCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.delGiftSpecModelByGiftCode.ex", (Throwable)e);
        }
    }

    private void deleteGiftSpecModel(Integer giftSpecId) throws ApiException {
        if (null == giftSpecId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftSpecMapper.deleteByPrimaryKey(giftSpecId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.deleteGiftSpecModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.deleteGiftSpecModel.num");
        }
    }

    private void updateGiftSpecModel(GtGiftSpec gtGiftSpec) throws ApiException {
        if (null == gtGiftSpec) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftSpecMapper.updateByPrimaryKeySelective(gtGiftSpec);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.updateGiftSpecModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.updateGiftSpecModel.num");
        }
    }

    private void updateStateGiftSpecModel(Integer giftSpecId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftSpecId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftSpecId", giftSpecId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftSpecMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.updateStateGiftSpecModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.updateStateGiftSpecModel.null");
        }
    }

    private void updateStateGiftSpecModelByCode(String tenantCode, String giftSpecCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftSpecCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftSpecCode", giftSpecCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftSpecMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.updateStateGiftSpecModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.updateStateGiftSpecModelByCode.null");
        }
    }

    private GtGiftSpec makeGiftSpec(GtGiftSpecDomain gtGiftSpecDomain, GtGiftSpec gtGiftSpec) {
        if (null == gtGiftSpecDomain) {
            return null;
        }
        if (null == gtGiftSpec) {
            gtGiftSpec = new GtGiftSpec();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftSpec, (Object)gtGiftSpecDomain);
            return gtGiftSpec;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSpecServiceImpl.makeGiftSpec", (Throwable)e);
            return null;
        }
    }

    private GtGiftSpecReDomain makeGtGiftSpecReDomain(GtGiftSpec gtGiftSpec) {
        if (null == gtGiftSpec) {
            return null;
        }
        GtGiftSpecReDomain gtGiftSpecReDomain = new GtGiftSpecReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftSpecReDomain, (Object)gtGiftSpec);
            return gtGiftSpecReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSpecServiceImpl.makeGtGiftSpecReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftSpec> queryGiftSpecModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftSpecMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSpecServiceImpl.queryGiftSpecModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftSpec(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftSpecMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSpecServiceImpl.countGiftSpec", (Throwable)e);
        }
        return i;
    }

    private GtGiftSpec createGtGiftSpec(GtGiftSpecDomain gtGiftSpecDomain) {
        String msg = this.checkGiftSpec(gtGiftSpecDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.saveGiftSpec.checkGiftSpec", msg);
        }
        GtGiftSpec gtGiftSpec = this.makeGiftSpec(gtGiftSpecDomain, null);
        this.setGiftSpecDefault(gtGiftSpec);
        return gtGiftSpec;
    }

    @Override
    public String saveGiftSpec(GtGiftSpecDomain gtGiftSpecDomain) throws ApiException {
        GtGiftSpec gtGiftSpec = this.createGtGiftSpec(gtGiftSpecDomain);
        this.saveGiftSpecModel(gtGiftSpec);
        return gtGiftSpec.getGiftSpecCode();
    }

    @Override
    public String saveGiftSpecBatch(List<GtGiftSpecDomain> gtGiftSpecDomainList) throws ApiException {
        if (null == gtGiftSpecDomainList || gtGiftSpecDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftSpec> gtGiftSpecList = new ArrayList<GtGiftSpec>();
        String code = "";
        for (GtGiftSpecDomain gtGiftSpecDomain : gtGiftSpecDomainList) {
            GtGiftSpec gtGiftSpec = this.createGtGiftSpec(gtGiftSpecDomain);
            code = gtGiftSpec.getGiftSpecCode();
            gtGiftSpecList.add(gtGiftSpec);
        }
        this.saveGiftSpecBatchModel(gtGiftSpecList);
        return code;
    }

    @Override
    public void updateGiftSpecState(Integer giftSpecId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftSpecModel(giftSpecId, dataState, oldDataState);
    }

    @Override
    public void updateGiftSpecStateByCode(String tenantCode, String giftSpecCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftSpecModelByCode(tenantCode, giftSpecCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftSpec(GtGiftSpecDomain gtGiftSpecDomain) throws ApiException {
        String msg = this.checkGiftSpec(gtGiftSpecDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.updateGiftSpec.checkGiftSpec", msg);
        }
        GtGiftSpec oldGtGiftSpec = this.getGiftSpecModelById(gtGiftSpecDomain.getGiftSpecId());
        if (null == oldGtGiftSpec) {
            throw new ApiException("gt.GIFT.GtGiftSpecServiceImpl.updateGiftSpec.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftSpec gtGiftSpec = this.makeGiftSpec(gtGiftSpecDomain, oldGtGiftSpec);
        this.setGiftSpecUpdataDefault(gtGiftSpec);
        this.updateGiftSpecModel(gtGiftSpec);
    }

    @Override
    public GtGiftSpec getGiftSpec(Integer giftSpecId) {
        return this.getGiftSpecModelById(giftSpecId);
    }

    @Override
    public void deleteGiftSpec(Integer giftSpecId) throws ApiException {
        this.deleteGiftSpecModel(giftSpecId);
    }

    @Override
    public QueryResult<GtGiftSpec> queryGiftSpecPage(Map<String, Object> map) {
        List<GtGiftSpec> gtGiftSpecList = this.queryGiftSpecModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftSpec(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftSpecList);
        return queryResult;
    }

    @Override
    public GtGiftSpec getGiftSpecByCode(String tenantCode, String giftSpecCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftSpecCode", giftSpecCode);
        return this.getGiftSpecModelByCode(map);
    }

    @Override
    public void deleteGiftSpecByCode(String tenantCode, String giftSpecCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftSpecCode", giftSpecCode);
        this.delGiftSpecModelByCode(map);
    }

    @Override
    public void deleteGiftSpecByGiftCode(String tenantCode, String giftCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftCode", giftCode);
        this.delGiftSpecModelByGiftCode(map);
    }
}

