/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.validate;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.token.cache.OAuthTokenCacheImpl;
import com.yqbsoft.laser.service.oauthserver.token.validate.AbstractOAuthTokenValidator;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;

public class SaasOAuthTokenValidator
extends AbstractOAuthTokenValidator<OsOAuthToken> {
    private OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private String SYSCODE = "com.yqbsoft.laser.service.oauthserver.token.validate.SaasOAuthTokenValidator";

    public boolean delay(OsOAuthToken token) {
        if (token == null) {
            this.logger.debug(this.SYSCODE, (Object)".delay.token.null");
            return false;
        }
        token.setOauthTokenUpdateTime(new Date());
        String key = token.getOauthTokenToken();
        OAuthTokenCacheImpl.getInstance().addToken(key, token);
        return true;
    }

    public boolean checkToken(OsOAuthToken token, String oauthTokenToken) {
        if (token == null) {
            this.logger.info(this.SYSCODE, (Object)".checkToken.token.null");
            return false;
        }
        if (StringUtils.isBlank((String)token.getOauthTokenToken())) {
            this.logger.info(this.SYSCODE, (Object)".checkToken.token.oauthTokenToken.null");
            return false;
        }
        if (StringUtils.isBlank((String)oauthTokenToken)) {
            this.logger.info(this.SYSCODE, (Object)".checkToken.oauthTokenToken.null");
            return false;
        }
        return oauthTokenToken.equals(token.getOauthTokenToken());
    }
}

