/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.router.MarketApiLink;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtrade;
import com.yqbsoft.laser.service.paytradeengine.service.PteMarketingProcessService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PteMarketingProcessServiceImpl
extends BaseServiceImpl
implements PteMarketingProcessService {
    public static final String SYS_CODE = "pte.PteMarketingProcessServiceImpl";

    @Override
    public void saveMarketingOrder(PtePtrade ptePtrade) throws ApiException {
        block11: {
            try {
                if (ptePtrade == null) {
                    return;
                }
                Integer dataState = ptePtrade.getDataState();
                if (dataState != PteConstants.DATA_STATE_3) {
                    return;
                }
                this.logger.info(SYS_CODE, (Object)("\u4ea4\u6613\u56de\u8c03\u8425\u9500,ptePtrade:" + JsonUtil.buildNormalBinder().toJson((Object)ptePtrade)));
                String nowAppapiCode = "pte.ptrade.sendCallBack." + ptePtrade.getPtradpdeCode();
                this.logger.debug(SYS_CODE, (Object)("nowAppapiCode = " + nowAppapiCode));
                String appId = ptePtrade.getAppId();
                Map marketApiLinkMap = LocalCache.getMarketApiLinkMap();
                if (MapUtil.isEmpty((Map)marketApiLinkMap)) {
                    this.logger.info(SYS_CODE, (Object)"marketApiLinkMap is null");
                    return;
                }
                List marketApiLinkList = (List)marketApiLinkMap.get(appId);
                if (ListUtil.isEmpty((Collection)marketApiLinkList)) {
                    return;
                }
                boolean flag = false;
                String ruleNo = "";
                String apilistNo = "";
                for (MarketApiLink marketApiLink : marketApiLinkList) {
                    String[] appapiCodes;
                    String appapiCode = marketApiLink.getAppapiCode();
                    if (StringUtils.isBlank((String)appapiCode) || !marketApiLink.getTenantCode().equals(ptePtrade.getTenantCode())) continue;
                    for (String api : appapiCodes = appapiCode.split(",")) {
                        if (!nowAppapiCode.equals(api)) continue;
                        ruleNo = marketApiLink.getRuleNo();
                        apilistNo = marketApiLink.getApilistNo();
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    break;
                }
                this.logger.info(SYS_CODE, (Object)("match flag = " + flag));
                if (!flag) break block11;
                this.logger.info(SYS_CODE, (Object)"mk.marketing.executeGenOrder");
                ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
                Map allParamMap = MapUtil.castMapByObject((Object)ptePtrade);
                allParamMap.put("userId", ptePtrade.getOpuserCode());
                allParamMap.put("openUserCode", ptePtrade.getMerchantCode());
                allParamMap.put("app_id", ptePtrade.getAppId());
                allParamMap.put("ruleNo", ruleNo);
                allParamMap.put("apilistNo", apilistNo);
                allParamMap.put("opBiclno", ptePtrade.getPtradeSeqno());
                String extension = ptePtrade.getExtension();
                if (StringUtils.isNotBlank((String)extension)) {
                    try {
                        Map extMap = JsonUtil.buildNormalBinder().getJsonToMap(extension, String.class, Object.class);
                        allParamMap.put("transferAmount", extMap.get("transferAmount"));
                    }
                    catch (Exception e) {
                        this.logger.error(SYS_CODE, (Object)"extension change to map error");
                    }
                }
                this.logger.info(SYS_CODE, (Object)("allParamMap = " + allParamMap));
                paramMap.put("map", JsonUtil.buildNormalBinder().toJson((Object)allParamMap));
                this.inAsyncInvoke("mk.marketing.executeGenOrder", paramMap);
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)e.getMessage());
            }
        }
    }
}

