/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.biz;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.Integration.OcContractIntegration;
import com.yqbsoft.laser.service.paytradeengine.Integration.QueryPromotionSavgPage;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.core.PteBalanceCore;
import com.yqbsoft.laser.service.paytradeengine.domain.ContractDivDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.ContractGoodsDivBean;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractPmGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcPackageDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PmPromotionSavgDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopPmgoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopPmgoodslistDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteDpriceDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.paytradeengine.enumc.ContractGoodsGtype;
import com.yqbsoft.laser.service.paytradeengine.enumc.ContractSettlType;
import com.yqbsoft.laser.service.paytradeengine.enumc.PbCodeEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.PromotionSavgEnum;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceop;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceopGoods;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceopPmgoods;
import com.yqbsoft.laser.service.paytradeengine.model.PteDpriceConf;
import com.yqbsoft.laser.service.paytradeengine.model.dto.enums.BusinessTypeEnum;
import com.yqbsoft.laser.service.paytradeengine.model.dto.req.QueryBalanceBatchReqDTO;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopGoodsService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopPmgoodsService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopService;
import com.yqbsoft.laser.service.paytradeengine.service.convert.PteBalanceBaseConvert;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Component
@Service
public class PteBalanceBaseServiceBiz
extends BaseServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(PteBalanceBaseServiceBiz.class);
    @Autowired
    private PteBalanceopService pteBalanceopService;
    @Autowired
    private PteBalanceopGoodsService pteBalanceopGoodsService;
    @Autowired
    private PteBalanceopPmgoodsService pteBalanceopPmgoodsService;
    @Autowired
    private PteBalanceService pteBalanceService;
    @Autowired
    private QueryPromotionSavgPage queryPromotionSavgPage;
    @Autowired
    private OcContractIntegration ocContractIntegration;
    @Autowired
    private PteBalanceCore pteBalanceCore;

    public QueryResult<PteBalanceop> pteBalanceOpQuery(QueryBalanceBatchReqDTO queryBalanceBatchReqDTO) {
        Map<String, Object> map = this.creatOpQueryReq(queryBalanceBatchReqDTO);
        log.debug("queryBalanceBatch \u67e5\u8be2OP\u5217\u8868\u5165\u53c2\uff1a{}", map);
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (queryResult != null && !ListUtil.isEmpty((Collection)queryResult.getList())) {
            return queryResult;
        }
        return null;
    }

    public QueryResult<PteBalanceop> pteBalanceOpQuery(String contractBill) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessOrder", contractBill);
        log.debug("\u67e5\u8be2OP\u5217\u8868\u5165\u53c2\uff1a{}", map);
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (queryResult != null && !ListUtil.isEmpty((Collection)queryResult.getList())) {
            return queryResult;
        }
        return null;
    }

    public List<PteBalanceopGoods> pteBalanceOpGoodsQuery(List<String> contractBillList) {
        QueryResult<PteBalanceopGoods> queryResult = this.pteBalanceopGoodsService.queryBalanceOpGoodsList(contractBillList);
        if (queryResult != null && !ListUtil.isEmpty((Collection)queryResult.getList())) {
            return queryResult.getList();
        }
        return null;
    }

    public List<PteBalanceopPmgoods> pteBalanceOpPmGoodsQuery(List<String> contractBillList) {
        QueryResult<PteBalanceopPmgoods> queryResult = this.pteBalanceopPmgoodsService.queryBalanceopPmgoodsList(contractBillList);
        if (queryResult != null && !ListUtil.isEmpty((Collection)queryResult.getList())) {
            return queryResult.getList();
        }
        return null;
    }

    private Map<String, Object> creatOpQueryReq(QueryBalanceBatchReqDTO queryBalanceBatchReqDTO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", String.valueOf(PteConstants.BalanceopData_State2));
        map.put("businessOrder", queryBalanceBatchReqDTO.getBusinessOrder());
        map.put("refundOrderCode", queryBalanceBatchReqDTO.getRefundOrderCode());
        map.put("memberCode", queryBalanceBatchReqDTO.getMemberCode());
        map.put("balanceType", queryBalanceBatchReqDTO.getBalanceType());
        map.put("businessOrderno", queryBalanceBatchReqDTO.getShoppingCartOrderNo());
        map.put("businessDes3", queryBalanceBatchReqDTO.getYzfOrderNo());
        map.put("memberBname", queryBalanceBatchReqDTO.getBuyerMobileNum());
        map.put("gmtPaySubmitQstart", queryBalanceBatchReqDTO.getStartDate());
        map.put("gmtPaySubmitQend", queryBalanceBatchReqDTO.getEndDate());
        map.put("rows", queryBalanceBatchReqDTO.getPageSize());
        map.put("startRow", (queryBalanceBatchReqDTO.getCurrentPage() - 1) * queryBalanceBatchReqDTO.getPageSize());
        map.put("channelCode", queryBalanceBatchReqDTO.getChannelCode());
        map.put("tenantCode", queryBalanceBatchReqDTO.getTenantCode());
        return map;
    }

    public Map<String, PteBalanceopGoods> getRefundPlatDIv(OcRefundReDomain ocRefundDomain) {
        HashMap<String, PteBalanceopGoods> balanceopGoodsMap = new HashMap<String, PteBalanceopGoods>();
        ArrayList<String> contractGoodsCodeList = new ArrayList<String>();
        if (null == ocRefundDomain.getOcRefundGoodsDomainList() || ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return balanceopGoodsMap;
        }
        for (OcRefundGoodsDomain ocRefundDO : ocRefundDomain.getOcRefundGoodsDomainList()) {
            contractGoodsCodeList.add(ocRefundDO.getContractGoodsCode());
        }
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("contractGoodsCode", contractGoodsCodeList);
        query.put("contractBillcode", ocRefundDomain.getContractBillcode());
        query.put("tenantCode", ocRefundDomain.getTenantCode());
        query.put("refundFlag", 0);
        QueryResult<PteBalanceopGoods> goodsQueryResult = this.pteBalanceopGoodsService.queryBalanceopGoodsDiv(query);
        if (null == goodsQueryResult || ListUtil.isEmpty((Collection)goodsQueryResult.getList())) {
            return balanceopGoodsMap;
        }
        balanceopGoodsMap.clear();
        goodsQueryResult.getList().forEach(s -> balanceopGoodsMap.put(s.getContractGoodsCode(), (PteBalanceopGoods)s));
        return balanceopGoodsMap;
    }

    public String sendBalance(OcContractReDomain ocContractDomain, boolean supplier) {
        List<PteDpriceDomain> disDpriceList;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u7ed3\u7b97\u5165\u53c2\u521d\u59cb\u5316");
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        PteBalanceBaseServiceBiz.convertSendBalanceDTO2BO(ocContractDomain, pteBalanceopDomain, supplier);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u67e5\u8be2\u6e20\u9053\u548c\u5206\u4f63\u8bbe\u7f6e");
        try {
            stopWatch.stop();
            stopWatch.start("\u7ed3\u7b97\u5355-\u67e5\u8be2\u6e20\u9053");
            this.checkBalanceSetting(pteBalanceopDomain);
            stopWatch.stop();
            stopWatch.start("\u7ed3\u7b97\u5355-\u5206\u4f63\u603b\u8bbe\u7f6e");
            disDpriceList = this.getDivList(pteBalanceopDomain);
            this.logger.debug("\u62bd\u4f63\u603b\u8bbe\u7f6e\uff1a", (Object)JsonUtil.buildNormalBinder().toJson(disDpriceList));
        }
        catch (ApiException e) {
            log.error("\u7ed3\u7b97\u5355\u751f\u6210\u5931\u8d25");
            return null;
        }
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u83b7\u53d6\u5206\u644a\u6bd4\u4f8b");
        Map<String, BigDecimal> platPromotionCostSetting = this.getPromotionCostSetting(pteBalanceopDomain);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u8ba1\u7b97\u8425\u9500\u6210\u672c\u5206\u644a");
        this.promotionCostCal(pteBalanceopDomain, platPromotionCostSetting);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u8ba1\u7b97\u62bd\u4f63\u91d1\u989d");
        this.divCalculate(pteBalanceopDomain, disDpriceList);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u4fdd\u5b58\u7ed3\u7b97\u5355");
        this.logger.debug("pte_balanceop database Save start");
        this.pteBalanceCore.pteBalanceSave(pteBalanceopDomain);
        stopWatch.stop();
        stopWatch.start("invoke \u8ba2\u5355\u7ed3\u7b97");
        this.saveDivInfo2Oc(ocContractDomain, pteBalanceopDomain);
        stopWatch.stop();
        this.logger.debug("\u7ed3\u7b97\u5355\u751f\u6210\u6210\u529f,\u8017\u65f6:{}", (Object)stopWatch.prettyPrint());
        return pteBalanceopDomain.getBalanceopCode();
    }

    public String sendBalance(SgSendgoodsReDomain sgSendgoodsDomain, boolean supplier) {
        List<PteDpriceDomain> disDpriceList;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u7ed3\u7b97\u5165\u53c2\u521d\u59cb\u5316");
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        PteBalanceBaseServiceBiz.convertSendBalanceDTO2BO(sgSendgoodsDomain, pteBalanceopDomain, supplier);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u67e5\u8be2\u6e20\u9053\u548c\u5206\u4f63\u8bbe\u7f6e");
        try {
            stopWatch.stop();
            stopWatch.start("\u7ed3\u7b97\u5355-\u67e5\u8be2\u6e20\u9053");
            this.checkBalanceSetting(pteBalanceopDomain);
            stopWatch.stop();
            stopWatch.start("\u7ed3\u7b97\u5355-\u5206\u4f63\u603b\u8bbe\u7f6e");
            disDpriceList = this.getDivList(pteBalanceopDomain);
            this.logger.debug("\u62bd\u4f63\u603b\u8bbe\u7f6e\uff1a", (Object)JsonUtil.buildNormalBinder().toJson(disDpriceList));
        }
        catch (ApiException e) {
            log.error("\u7ed3\u7b97\u5355\u751f\u6210\u5931\u8d25");
            return null;
        }
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u83b7\u53d6\u5206\u644a\u6bd4\u4f8b");
        Map<String, BigDecimal> platPromotionCostSetting = this.getPromotionCostSetting(pteBalanceopDomain);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u8ba1\u7b97\u8425\u9500\u6210\u672c\u5206\u644a");
        this.promotionCostCal(pteBalanceopDomain, platPromotionCostSetting);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u8ba1\u7b97\u62bd\u4f63\u91d1\u989d");
        this.divCalculate(pteBalanceopDomain, disDpriceList);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5355-\u4fdd\u5b58\u7ed3\u7b97\u5355");
        this.logger.debug("pte_balanceop database Save start");
        this.pteBalanceCore.pteBalanceSave(pteBalanceopDomain);
        stopWatch.stop();
        stopWatch.start("invoke \u8ba2\u5355\u7ed3\u7b97");
        stopWatch.stop();
        this.logger.debug("\u7ed3\u7b97\u5355\u751f\u6210\u6210\u529f,\u8017\u65f6:{}", (Object)stopWatch.prettyPrint());
        return pteBalanceopDomain.getBalanceopCode();
    }

    private void divCalculate(PteBalanceopDomain pteBalanceopDomain, List<PteDpriceDomain> disDpriceList) {
        if (ListUtil.isEmpty(disDpriceList)) {
            return;
        }
        boolean divCheckFlag = false;
        BigDecimal orderDivTotal = BigDecimal.ZERO;
        for (PteBalanceopGoodsDomain opGoodsDO : pteBalanceopDomain.getPteBalanceopGoodsDomainList()) {
            PteDpriceDomain pteDpriceDomain = this.getDivSetting(opGoodsDO, disDpriceList);
            this.logger.info("\u62bd\u4f63\u5339\u914d\u7ed3\u679c:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteDpriceDomain));
            opGoodsDO.setPricesetRefrice(BigDecimal.ZERO);
            opGoodsDO.setOrderDviAmt(BigDecimal.ZERO);
            opGoodsDO.setPlatPromotionDviAmt(BigDecimal.ZERO);
            opGoodsDO.setOrderDviTotalAmt(BigDecimal.ZERO);
            if (null != pteDpriceDomain) {
                divCheckFlag = true;
                if ("0".equals(pteDpriceDomain.getDpricePro())) {
                    opGoodsDO.setPricesetRefrice(pteDpriceDomain.getDpricePrice().divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP).multiply(opGoodsDO.getContractGoodsMoney()).setScale(2, RoundingMode.UP));
                    opGoodsDO.setOrderDviAmt(opGoodsDO.getPricesetRefrice());
                    BigDecimal goodsPlatPromotionTotalCost = this.sumPmGoodsPlatAmt(opGoodsDO.getPteBalanceopPmgoodsDomainList());
                    opGoodsDO.setPlatPromotionDviAmt(pteDpriceDomain.getDpricePrice().multiply(goodsPlatPromotionTotalCost).divide(new BigDecimal("100"), 2, RoundingMode.UP));
                    opGoodsDO.setOrderDviTotalAmt(opGoodsDO.getOrderDviAmt().add(opGoodsDO.getPlatPromotionDviAmt()));
                } else if ("2".equals(pteDpriceDomain.getDpricePro())) {
                    BigDecimal divAmt = pteDpriceDomain.getDpricePrice().multiply(opGoodsDO.getGoodsCamount()).setScale(2, RoundingMode.UP);
                    if (0 < divAmt.compareTo(opGoodsDO.getContractGoodsMoney())) {
                        opGoodsDO.setPricesetRefrice(opGoodsDO.getContractGoodsMoney());
                    } else {
                        opGoodsDO.setPricesetRefrice(divAmt);
                    }
                    opGoodsDO.setOrderDviAmt(opGoodsDO.getPricesetRefrice());
                    opGoodsDO.setPlatPromotionDviAmt(new BigDecimal(0));
                    opGoodsDO.setOrderDviTotalAmt(opGoodsDO.getOrderDviAmt());
                }
            }
            orderDivTotal = orderDivTotal.add(opGoodsDO.getOrderDviTotalAmt());
            HashMap<String, Object> dpricemap = new HashMap<String, Object>();
            dpricemap.put("pteDpriceDomain", JsonUtil.buildNormalBinder().toJson((Object)pteDpriceDomain));
            dpricemap.put("goodsRemark", opGoodsDO.getGoodsRemark());
            dpricemap.put("checkConf", divCheckFlag);
            opGoodsDO.setGoodsRemark(JsonUtil.buildNonDefaultBinder().toJson(dpricemap));
        }
        this.logger.info("\u8ba2\u5355\u53f7: " + pteBalanceopDomain.getBusinessOrder() + " \u62bd\u4f63\u91d1\u989d\u4e3a: " + orderDivTotal);
        pteBalanceopDomain.setOrderDviAmt(orderDivTotal);
        pteBalanceopDomain.setBalanceopFee(orderDivTotal);
    }

    private PteDpriceDomain getDivSetting(PteBalanceopGoodsDomain opGoodsDO, List<PteDpriceDomain> disDpriceList) {
        Map<String, Object> objMap = this.makeObject(opGoodsDO);
        this.logger.info("objMap: " + objMap);
        for (PteDpriceDomain pteDpriceDomain : disDpriceList) {
            Map keymap = DisUtil.getRemotMapAll((String)("PteDpriceConf-key-" + pteDpriceDomain.getDpriceCode() + "-" + pteDpriceDomain.getTenantCode()));
            String vaulemap = "PteDpriceConf-value-" + pteDpriceDomain.getDpriceCode() + "-" + pteDpriceDomain.getTenantCode();
            log.info("\u67e5\u8be2keymap\u7ed3\u679c:{}", (Object)keymap);
            log.info("\u67e5\u8be2vaulemap\u7ed3\u679c:{}", (Object)vaulemap);
            if (MapUtil.isEmpty((Map)keymap)) continue;
            boolean checkConf = this.checkConf(keymap, vaulemap, objMap, (Object)pteDpriceDomain);
            if (!checkConf) {
                this.logger.info("Matching failed , DpriceCode:{}", (Object)pteDpriceDomain.getDpriceCode());
                continue;
            }
            return pteDpriceDomain;
        }
        this.logger.info("Matching failed ,contractGoodsCode:{}", (Object)opGoodsDO.getContractGoodsCode());
        return null;
    }

    private Map<String, Object> makeObject(PteBalanceopGoodsDomain pteBalanceopGoods) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (null != pteBalanceopGoods) {
            obj.putAll(JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopGoods), String.class, Object.class));
        }
        return obj;
    }

    protected boolean checkConf(Map<String, String> keymap, String valuemap, Object obj, Object mainObj) {
        boolean flag = false;
        String key = keymap.get("skuNo-=");
        if (StringUtils.isNotBlank((String)key)) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
            this.logger.info("checkConf  skuNo-= ======", (Object)flag);
        }
        if (StringUtils.isNotBlank((String)(key = keymap.get("classtreeCode-="))) && !flag) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
            this.logger.info("checkConf  classtreeCode--= ======", (Object)flag);
        }
        if (StringUtils.isNotBlank((String)(key = keymap.get("memberCcode-="))) && !flag) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
            this.logger.info("checkConf  memberCcode-= ======", (Object)flag);
        }
        return flag;
    }

    protected boolean checkConf(String keys, String valuemap, Object obj, Object mainObj) {
        if (StringUtils.isBlank((String)keys) || StringUtils.isBlank((String)valuemap)) {
            this.logger.info("ptecheckConf", (Object)("keys=" + keys + "valuemap=" + valuemap));
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        String[] keyStr = keys.split("\\-");
        if (null == keyStr || keyStr.length == 0) {
            return false;
        }
        key = keyStr[0];
        if (keyStr.length > 1) {
            term = keyStr[1];
        }
        Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key);
        this.logger.info("ptecheckConf.objValue", (Object)("-----------keys=" + keys + "--------valuemap =" + valuemap + "-------------objValue = " + objValue));
        if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
            this.logger.info("In condition first");
            String[] otrs = objValue.toString().split("\\,");
            flag = false;
            for (String o : otrs) {
                if (!this.cond(keys, valuemap, term, o, mainObj)) continue;
                this.logger.info("cond 1");
                flag = true;
                break;
            }
        } else if (!this.cond(keys, valuemap, term, objValue, mainObj)) {
            flag = false;
        }
        return flag;
    }

    protected boolean cond(String keys, String valuemap, String term, Object objValue, Object mainObj) {
        if (StringUtils.isBlank((String)valuemap)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        if (term.equals("=") || term.equals("!=")) {
            keys = keys + "-" + objValue;
        }
        String value = DisUtil.getRemotMap((String)valuemap, (String)keys);
        this.logger.info("pte.cond value -- ", (Object)value);
        PteDpriceConf confObj = null;
        if (mainObj instanceof PteDpriceDomain) {
            PteDpriceConf disDpriceConf = null;
            if (StringUtils.isNotBlank((String)value)) {
                disDpriceConf = (PteDpriceConf)JsonUtil.buildNormalBinder().getJsonToObject(value, PteDpriceConf.class);
                value = disDpriceConf.getDpriceConfValue();
                confObj = disDpriceConf;
            }
        }
        this.logger.info("term: " + term);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                flag = false;
            }
            if (StringUtils.isNotBlank((String)value)) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                flag = false;
            }
            if (StringUtils.isBlank((String)value)) {
                flag = false;
            }
        }
        if (!flag) {
            return false;
        }
        if (null != mainObj && null != confObj) {
            PteBalanceBaseServiceBiz.setDivReturn(mainObj, confObj);
        }
        return flag;
    }

    protected static void setDivReturn(Object mainObj, Object obj) {
        if (null == mainObj || null == obj) {
            return;
        }
        log.info("setDivReturn mainObj: {}", (Object)JsonUtil.buildNormalBinder().toJson(mainObj));
        log.info("setDivReturn obj: {}", (Object)JsonUtil.buildNormalBinder().toJson(obj));
        if (mainObj instanceof PteDpriceDomain && obj instanceof PteDpriceConf) {
            PteDpriceDomain pteDpriceDomain = (PteDpriceDomain)mainObj;
            PteDpriceConf pteDpriceConf = (PteDpriceConf)obj;
            pteDpriceDomain.setPteDpriceConf(pteDpriceConf);
            pteDpriceDomain.setDpricePro(pteDpriceConf.getDpriceConfPro());
            if (null != pteDpriceConf.getDpriceConfPrice() && pteDpriceConf.getDpriceConfPrice().compareTo(BigDecimal.ZERO) >= 0) {
                pteDpriceDomain.setDpricePrice(pteDpriceConf.getDpriceConfPrice());
            }
            if (null != pteDpriceConf.getDpriceConfMprice() && pteDpriceConf.getDpriceConfMprice().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpriceMprice(pteDpriceConf.getDpriceConfMprice());
            }
            if (null != pteDpriceConf.getDpriceConfPricedef() && pteDpriceConf.getDpriceConfPricedef().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpricePricedef(pteDpriceConf.getDpriceConfPricedef());
            }
            if (null != pteDpriceConf.getDpriceConfMpricedef() && pteDpriceConf.getDpriceConfMpricedef().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpriceMpricedef(pteDpriceConf.getDpriceConfMpricedef());
            }
            log.info("setDivReturn : {}", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteDpriceDomain));
        }
    }

    private Map<String, BigDecimal> getPromotionCostSetting(PteBalanceopDomain pteBalanceopDomain) {
        HashMap<String, BigDecimal> settingRes = new HashMap<String, BigDecimal>();
        List<Object> activityIds = new ArrayList();
        List<Object> promotionCodes = new ArrayList();
        if (null == pteBalanceopDomain.getPteBalanceopGoodsDomainList() || pteBalanceopDomain.getPteBalanceopGoodsDomainList().isEmpty()) {
            return settingRes;
        }
        for (PteBalanceopGoodsDomain pteBalanceopGoodsDomain : pteBalanceopDomain.getPteBalanceopGoodsDomainList()) {
            if (null == pteBalanceopGoodsDomain.getPteBalanceopPmgoodsDomainList()) continue;
            for (PteBalanceopPmgoodsDomain pteBalanceopPmgoodsDomain : pteBalanceopGoodsDomain.getPteBalanceopPmgoodsDomainList()) {
                pteBalanceopPmgoodsDomain.setBalanceopPmgoodsBillcode(this.createUUIDString());
                if (pteBalanceopPmgoodsDomain.getContractSettlBlance().equals(PbCodeEnum._0030.getCode()) || pteBalanceopPmgoodsDomain.getContractSettlBlance().equals(PbCodeEnum._0007.getCode())) {
                    activityIds.add(pteBalanceopPmgoodsDomain.getContractSettlOpno());
                    continue;
                }
                promotionCodes.add(pteBalanceopPmgoodsDomain.getContractSettlOpno());
            }
            activityIds = activityIds.stream().distinct().collect(Collectors.toList());
            if (!(promotionCodes = promotionCodes.stream().distinct().collect(Collectors.toList())).isEmpty()) {
                for (String string : promotionCodes) {
                    PmPromotionSavgDomain pmPromotionSavgRes = this.queryPromotionSavgPage.queryPromotionCostSetting(string, pteBalanceopDomain.getTenantCode());
                    if (null == pmPromotionSavgRes) continue;
                    settingRes.put(string, pmPromotionSavgRes.getPromotionSavgRa());
                }
            }
            for (PteBalanceopPmgoodsDomain pteBalanceopPmgoodsDomain : pteBalanceopGoodsDomain.getPteBalanceopPmgoodsDomainList()) {
                ArrayList<PteBalanceopPmgoodslistDomain> pteBalanceopPmgoodslistDomainList = new ArrayList<PteBalanceopPmgoodslistDomain>();
                PteBalanceopPmgoodslistDomain pteBalanceopPmgoodslistDomain = new PteBalanceopPmgoodslistDomain();
                pteBalanceopPmgoodslistDomain.setContractBillcode(pteBalanceopPmgoodsDomain.getContractBillcode());
                pteBalanceopPmgoodslistDomain.setContractPmgoodsBillcode(pteBalanceopPmgoodsDomain.getContractPmgoodsBillcode());
                pteBalanceopPmgoodslistDomain.setBalanceopPmgoodsBillcode(pteBalanceopPmgoodsDomain.getBalanceopPmgoodsBillcode());
                pteBalanceopPmgoodslistDomain.setContractGoodsCode(pteBalanceopGoodsDomain.getContractGoodsCode());
                pteBalanceopPmgoodslistDomain.setContractSettlOpno(pteBalanceopPmgoodsDomain.getContractSettlOpno());
                pteBalanceopPmgoodslistDomain.setPromotionSavgRa((BigDecimal)settingRes.get(pteBalanceopPmgoodsDomain.getContractSettlOpno()));
                pteBalanceopPmgoodslistDomain.setPromotionSavgOtype(PromotionSavgEnum.PLAT.getCode());
                pteBalanceopPmgoodslistDomain.setPromotionSavgType(pteBalanceopPmgoodsDomain.getContractSettlBlance());
                pteBalanceopPmgoodslistDomain.setPackageCode(pteBalanceopGoodsDomain.getPackageCode());
                pteBalanceopPmgoodslistDomain.setContractPmode(pteBalanceopPmgoodsDomain.getContractPmode());
                pteBalanceopPmgoodslistDomain.setTenantCode(pteBalanceopDomain.getTenantCode());
                pteBalanceopPmgoodslistDomainList.add(pteBalanceopPmgoodslistDomain);
                pteBalanceopPmgoodsDomain.setPteBalanceopPmgoodslistDomainList(pteBalanceopPmgoodslistDomainList);
            }
        }
        return settingRes;
    }

    private void setAcInPmGoods(OcContractReDomain ocContractDomain) {
    }

    public static void convertSendBalanceDTO2BO(SgSendgoodsReDomain sgSendgoodsDomain, PteBalanceopDomain pteBalanceopDomain, boolean supplier) {
        pteBalanceopDomain.setGoodsPmoney(sgSendgoodsDomain.getGoodsPmoney());
        pteBalanceopDomain.setMsChannelName(sgSendgoodsDomain.getMschannelName());
        pteBalanceopDomain.setPartnerCode(DateUtils.getDateString((Date)new Date(), (String)"yyyyMM"));
        pteBalanceopDomain.setOrderPortion(sgSendgoodsDomain.getGoodsLogmoney());
        pteBalanceopDomain.setBusinessType(sgSendgoodsDomain.getMschannelCode());
        pteBalanceopDomain.setMemberBcode(sgSendgoodsDomain.getMemberBcode());
        pteBalanceopDomain.setMemberBname(sgSendgoodsDomain.getMemberBname());
        pteBalanceopDomain.setMemberMcode(sgSendgoodsDomain.getMemberMcode());
        pteBalanceopDomain.setMemberMname(sgSendgoodsDomain.getMemberMname());
        pteBalanceopDomain.setTenantCode(sgSendgoodsDomain.getTenantCode());
        pteBalanceopDomain.setChannelCode(sgSendgoodsDomain.getChannelCode());
        pteBalanceopDomain.setChannelName(sgSendgoodsDomain.getChannelName());
        pteBalanceopDomain.setBusinessOrderno(sgSendgoodsDomain.getContractBillcode());
        pteBalanceopDomain.setBusinessOrder(sgSendgoodsDomain.getSendgoodsCode());
        pteBalanceopDomain.setGmtPaySubmit(sgSendgoodsDomain.getGmtCreate());
        pteBalanceopDomain.setGmtPayout(sgSendgoodsDomain.getContractPaydate());
        ArrayList<PteBalanceopGoodsDomain> pteBalanceopGoodsDomains = new ArrayList<PteBalanceopGoodsDomain>();
        BigDecimal dataMoney = BigDecimal.ZERO;
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
            if (null == sgSendgoodsGoodsDomain.getPricesetNprice1()) {
                sgSendgoodsGoodsDomain.setPricesetNprice1(BigDecimal.ZERO);
            }
            if (null == sgSendgoodsGoodsDomain.getGoodsCamount()) {
                sgSendgoodsGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            dataMoney = dataMoney.add(sgSendgoodsGoodsDomain.getGoodsCamount().multiply(sgSendgoodsGoodsDomain.getPricesetNprice1()));
            PteBalanceopGoodsDomain pteBalanceopGoods = new PteBalanceopGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalanceopGoods, (Object)sgSendgoodsGoodsDomain);
                pteBalanceopGoods.setContractBillcode(sgSendgoodsGoodsDomain.getSendgoodsCode());
            }
            catch (Exception e) {
                log.error("pte.saveBalance\uff1a ocContractGoodsDomain \u53c2\u6570\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
            pteBalanceopGoodsDomains.add(pteBalanceopGoods);
        }
        if (supplier) {
            pteBalanceopDomain.setBalanceType(BusinessTypeEnum.OC_SENDSUPPER.getCode());
            pteBalanceopDomain.setMemberCode(sgSendgoodsDomain.getMemberCcode());
            pteBalanceopDomain.setMemberName(sgSendgoodsDomain.getMemberCname());
            pteBalanceopDomain.setBalanceopAmount(dataMoney);
            pteBalanceopDomain.setOrderOamount(dataMoney);
        } else {
            pteBalanceopDomain.setBalanceType(BusinessTypeEnum.OC_SEND.getCode());
            pteBalanceopDomain.setMemberCode(sgSendgoodsDomain.getMemberCode());
            pteBalanceopDomain.setMemberName(sgSendgoodsDomain.getMemberName());
            pteBalanceopDomain.setBalanceopAmount(sgSendgoodsDomain.getDataBmoney());
            pteBalanceopDomain.setOrderOamount(sgSendgoodsDomain.getContractMoney());
        }
        pteBalanceopDomain.setPteBalanceopGoodsDomainList(pteBalanceopGoodsDomains);
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getDateString((Date)new Date(), (String)"yyyyMM"));
    }

    public static void convertSendBalanceDTO2BO(OcContractReDomain ocContractDomain, PteBalanceopDomain pteBalanceopDomain, boolean supplier) {
        pteBalanceopDomain.setGoodsPmoney(ocContractDomain.getGoodsPmoney());
        pteBalanceopDomain.setMsChannelName(ocContractDomain.getMschannelName());
        pteBalanceopDomain.setPartnerCode(DateUtils.getDateString((Date)new Date(), (String)"yyyyMM"));
        if (supplier) {
            pteBalanceopDomain.setBalanceType(BusinessTypeEnum.OC_ORDERSUPPER.getCode());
        } else {
            pteBalanceopDomain.setBalanceType(BusinessTypeEnum.OC_ORDER.getCode());
        }
        pteBalanceopDomain.setBalanceopAmount(ocContractDomain.getDataBmoney());
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getContractInmoney().add(ocContractDomain.getGoodsLogmoney()));
        pteBalanceopDomain.setOrderPortion(ocContractDomain.getGoodsLogmoney());
        pteBalanceopDomain.setBusinessType(ocContractDomain.getContractTypepro());
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberCode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberName());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setMemberMcode(ocContractDomain.getMemberMcode());
        pteBalanceopDomain.setMemberMname(ocContractDomain.getMemberMname());
        pteBalanceopDomain.setUserName(ocContractDomain.getUserName());
        pteBalanceopDomain.setUserCode(ocContractDomain.getUserCode());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setChannelCode(ocContractDomain.getChannelCode());
        pteBalanceopDomain.setChannelName(ocContractDomain.getChannelName());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setGmtPaySubmit(ocContractDomain.getGmtCreate());
        pteBalanceopDomain.setGmtPayout(ocContractDomain.getContractPaydate());
        ArrayList<PteBalanceopGoodsDomain> pteBalanceopGoodsDomains = new ArrayList<PteBalanceopGoodsDomain>();
        for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                PteBalanceopGoodsDomain pteBalanceopGoods = new PteBalanceopGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)pteBalanceopGoods, (Object)ocContractGoodsDomain);
                }
                catch (Exception e) {
                    log.error("pte.saveBalance\uff1a ocContractGoodsDomain \u53c2\u6570\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                }
                PteBalanceBaseServiceBiz.checkGift(ocContractGoodsDomain);
                if (ListUtil.isNotEmpty(ocContractGoodsDomain.getOcContractPmGoodsDomainList())) {
                    ArrayList<PteBalanceopPmgoodsDomain> pteBalanceopPmgoodsDomainList = new ArrayList<PteBalanceopPmgoodsDomain>();
                    for (OcContractPmGoodsDomain ocContractPmGoodsDomain : ocContractGoodsDomain.getOcContractPmGoodsDomainList()) {
                        PteBalanceopPmgoodsDomain pteBalanceopPmgoodsDomain = new PteBalanceopPmgoodsDomain();
                        if (null == ocContractPmGoodsDomain) continue;
                        try {
                            BeanUtils.copyAllPropertys((Object)pteBalanceopPmgoodsDomain, (Object)ocContractPmGoodsDomain);
                        }
                        catch (Exception e) {
                            log.error("pte.saveBalance\uff1aocContractPmGoodsDomain \u53c2\u6570\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                        }
                        pteBalanceopPmgoodsDomainList.add(pteBalanceopPmgoodsDomain);
                    }
                    pteBalanceopGoods.setPteBalanceopPmgoodsDomainList(pteBalanceopPmgoodsDomainList);
                }
                pteBalanceopGoodsDomains.add(pteBalanceopGoods);
            }
        }
        pteBalanceopDomain.setPteBalanceopGoodsDomainList(pteBalanceopGoodsDomains);
    }

    private static void checkGift(OcContractGoodsDomain ocContractGoodsDomain) {
        if (!ContractGoodsGtype.NORMAL.getCode().equals(ocContractGoodsDomain.getContractGoodsGtype())) {
            log.info("\u5546\u54c1ContractGoodsCode\uff1a{},\u4e3a\u8d60\u54c1\uff0c\u8425\u9500\u4fe1\u606f\u7f6e\u7a7a", (Object)ocContractGoodsDomain.getContractGoodsCode());
            ocContractGoodsDomain.setOcContractPmGoodsDomainList(null);
        }
    }

    private void checkBalanceSetting(PteBalanceopDomain pteBalanceopDomain) {
    }

    private List<PteDpriceDomain> getDivList(PteBalanceopDomain pteBalanceopDomain) {
        List<PteDpriceDomain> divSettingList = new ArrayList<PteDpriceDomain>();
        List list = DisUtil.getMapListJson((String)"PteDprice", (String)(pteBalanceopDomain.getBalanceType() + "-" + pteBalanceopDomain.getTenantCode()), PteDpriceDomain.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("pte.disDpriceList.null,\u8ba2\u5355\u7c7b\u578b-\u79df\u6237\u53f7", (Object)(pteBalanceopDomain.getBalanceType() + "-" + pteBalanceopDomain.getTenantCode()));
            return null;
        }
        this.logger.info("pte.disDpriceList", (Object)JsonUtil.buildNormalBinder().toJson((Object)list));
        for (Object item : list) {
            PteDpriceDomain pteDpriceDomain = new PteDpriceDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteDpriceDomain, (Object)((PteDpriceDomain)item));
            }
            catch (Exception e2) {
                log.error(" BeanUtils.copyAllPropertys(pteDpriceDomain)  Error", (Throwable)e2);
            }
            divSettingList.add(pteDpriceDomain);
        }
        if (ListUtil.isNotEmpty(divSettingList) && StringUtils.isNotBlank((String)pteBalanceopDomain.getChannelCode())) {
            divSettingList = divSettingList.stream().filter(e -> StringUtils.isNotBlank((String)e.getChannelCode()) && e.getChannelCode().equals(pteBalanceopDomain.getChannelCode())).collect(Collectors.toList());
        }
        if (ListUtil.isEmpty((Collection)list)) {
            log.error("pte.disDpriceList.null,\u8ba2\u5355\u7c7b\u578b:{},\u79df\u6237\u53f7:{}", (Object)pteBalanceopDomain.getBalanceType(), (Object)pteBalanceopDomain.getTenantCode());
            throw new ApiException("pte\u83b7\u53d6\u5206\u4f63\u603b\u8bbe\u7f6e\u5931\u8d25");
        }
        return divSettingList;
    }

    private void promotionCostCal(PteBalanceopDomain pteBalanceopDomain, Map<String, BigDecimal> platPromotionCostSetting) {
        if (null == platPromotionCostSetting || platPromotionCostSetting.isEmpty()) {
            return;
        }
        for (PteBalanceopGoodsDomain pteGoods : pteBalanceopDomain.getPteBalanceopGoodsDomainList()) {
            if (null == pteGoods || ListUtil.isEmpty(pteGoods.getPteBalanceopPmgoodsDomainList())) continue;
            for (PteBalanceopPmgoodsDomain pteGoodsPm : pteGoods.getPteBalanceopPmgoodsDomainList()) {
                if (null == pteGoodsPm.getContractPmgoodsPmoney()) {
                    pteGoodsPm.setContractPmgoodsPmoney(BigDecimal.ZERO);
                    continue;
                }
                if (!platPromotionCostSetting.containsKey(pteGoodsPm.getContractSettlOpno())) {
                    log.error("pte.sandBalance promotionCostCal\u5339\u914d\u8425\u9500\u5206\u644a\u5931\u8d25,\u8425\u9500id\uff1a{}", (Object)pteGoodsPm.getContractSettlOpno());
                    continue;
                }
                BigDecimal platCostProportion = null == platPromotionCostSetting.get(pteGoodsPm.getContractSettlOpno()) ? BigDecimal.ZERO : platPromotionCostSetting.get(pteGoodsPm.getContractSettlOpno());
                pteGoodsPm.setOrderPlatAmt(pteGoodsPm.getContractPmgoodsPmoney().multiply(platCostProportion).divide(new BigDecimal("100"), 2, RoundingMode.DOWN));
                pteGoodsPm.setOrderMerAmt(pteGoodsPm.getContractPmgoodsPmoney().subtract(pteGoodsPm.getOrderPlatAmt()));
                ArrayList<PteBalanceopPmgoodslistDomain> pmgoodslistDomainList = new ArrayList<PteBalanceopPmgoodslistDomain>();
                PteBalanceBaseConvert.convertPmGoodsListBO2DO(pmgoodslistDomainList, pteGoodsPm, PromotionSavgEnum.PLAT, platCostProportion);
                PteBalanceBaseConvert.convertPmGoodsListBO2DO(pmgoodslistDomainList, pteGoodsPm, PromotionSavgEnum.MERCHANT, BigDecimal.valueOf(100L).subtract(platCostProportion));
            }
        }
    }

    private BigDecimal sumPmGoodsPlatAmt(List<PteBalanceopPmgoodsDomain> pteBalanceopPmgoodsDomainList) {
        BigDecimal res = new BigDecimal(0);
        if (null == pteBalanceopPmgoodsDomainList || ListUtil.isEmpty(pteBalanceopPmgoodsDomainList)) {
            return res;
        }
        for (PteBalanceopPmgoodsDomain pmGoods : pteBalanceopPmgoodsDomainList) {
            if (null == pmGoods.getOrderPlatAmt()) continue;
            res = res.add(pmGoods.getOrderPlatAmt());
        }
        return res;
    }

    private void saveDivInfo2Oc(OcContractReDomain ocContractDomain, PteBalanceopDomain pteBalanceopDomain) {
        StopWatch saveDivInfo2OcWatch = new StopWatch();
        saveDivInfo2OcWatch.start("saveDivInfo2Oc");
        ContractDivDomain contractDivDomain = new ContractDivDomain();
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        ArrayList<ContractGoodsDivBean> contractGoodsDivBeanList = new ArrayList<ContractGoodsDivBean>();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettlDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            log.error(" BeanUtils.copyAllPropertys(ocContractSettlDomain)  Error");
        }
        BigDecimal paidDivAmt = BigDecimal.ZERO;
        for (PteBalanceopGoodsDomain goodsDomain : pteBalanceopDomain.getPteBalanceopGoodsDomainList()) {
            if (null == goodsDomain.getOrderDviAmt()) {
                goodsDomain.setOrderDviAmt(BigDecimal.ZERO);
            }
            paidDivAmt = paidDivAmt.add(goodsDomain.getOrderDviAmt());
            ContractGoodsDivBean contractGoodsDivBean = new ContractGoodsDivBean();
            contractGoodsDivBean.setContractBillcode(goodsDomain.getContractBillcode());
            contractGoodsDivBean.setContractGoodsCode(goodsDomain.getContractGoodsCode());
            contractGoodsDivBean.setTenantCode(goodsDomain.getTenantCode());
            contractGoodsDivBean.setContractGoodsPefprice(goodsDomain.getPricesetRefrice());
            contractGoodsDivBeanList.add(contractGoodsDivBean);
        }
        ocContractSettlDomain.setContractSettlType(ContractSettlType.PTE.getType());
        ocContractSettlDomain.setContractSettlBlance(ContractSettlType.PTE.getCode());
        ocContractSettlDomain.setContractSettlPmoney(paidDivAmt);
        ocContractSettlDomain.setContractSettlGmoney(pteBalanceopDomain.getOrderDviAmt());
        ArrayList<OcContractSettlDomain> ocContractSettlDomainList = new ArrayList<OcContractSettlDomain>();
        ocContractSettlDomainList.add(ocContractSettlDomain);
        contractDivDomain.setOcContractSettlDomainList(ocContractSettlDomainList);
        contractDivDomain.setContractGoodsDivBeanList(contractGoodsDivBeanList);
        contractDivDomain.setContractBillcode(ocContractDomain.getContractBillcode());
        contractDivDomain.setTenantCode(ocContractDomain.getTenantCode());
        saveDivInfo2OcWatch.stop();
        saveDivInfo2OcWatch.start("ocContractIntegration.sendSaveContractDiv");
        this.ocContractIntegration.sendSaveContractDiv(contractDivDomain);
        saveDivInfo2OcWatch.stop();
        log.debug("saveDivInfo2OcWatch:{}", (Object)saveDivInfo2OcWatch.prettyPrint());
    }
}

