/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgPackimgsMapper;
import com.yqbsoft.laser.service.pg.domain.PgPackimgsDomain;
import com.yqbsoft.laser.service.pg.domain.PgPackimgsReDomain;
import com.yqbsoft.laser.service.pg.model.PgPackimgs;
import com.yqbsoft.laser.service.pg.service.PgPackimgsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgPackimgsServiceImpl
extends BaseServiceImpl
implements PgPackimgsService {
    private static final String SYS_CODE = "pg.PICK.PgPackimgsServiceImpl";
    private PgPackimgsMapper pgPackimgsMapper;

    public void setPgPackimgsMapper(PgPackimgsMapper pgPackimgsMapper) {
        this.pgPackimgsMapper = pgPackimgsMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgPackimgsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgPackimgsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPackimgs(PgPackimgsDomain pgPackimgsDomain) {
        if (null == pgPackimgsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgPackimgsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPackimgsDefault(PgPackimgs pgPackimgs) {
        if (null == pgPackimgs) {
            return;
        }
        if (null == pgPackimgs.getDataState()) {
            pgPackimgs.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgPackimgs.getGmtCreate()) {
            pgPackimgs.setGmtCreate(date);
        }
        pgPackimgs.setGmtModified(date);
        if (StringUtils.isBlank((String)pgPackimgs.getPackimgsCode())) {
            pgPackimgs.setPackimgsCode(this.getNo(null, "PgPackimgs", "pgPackimgs", pgPackimgs.getTenantCode()));
        }
    }

    private int getPackimgsMaxCode() {
        int code = 0;
        try {
            return this.pgPackimgsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgPackimgsServiceImpl.getPackimgsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPackimgsUpdataDefault(PgPackimgs pgPackimgs) {
        if (null == pgPackimgs) {
            return;
        }
        pgPackimgs.setGmtModified(this.getSysDate());
    }

    private void savePackimgsModel(PgPackimgs pgPackimgs) throws ApiException {
        if (null == pgPackimgs) {
            return;
        }
        try {
            this.pgPackimgsMapper.insert(pgPackimgs);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.savePackimgsModel.ex", (Throwable)e);
        }
    }

    private void savePackimgsBatchModel(List<PgPackimgs> pgPackimgsList) throws ApiException {
        if (null == pgPackimgsList || pgPackimgsList.isEmpty()) {
            return;
        }
        try {
            this.pgPackimgsMapper.insertBatch(pgPackimgsList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.savePackimgsBatchModel.ex", (Throwable)e);
        }
    }

    private PgPackimgs getPackimgsModelById(Integer packimgsId) {
        if (null == packimgsId) {
            return null;
        }
        try {
            return this.pgPackimgsMapper.selectByPrimaryKey(packimgsId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgPackimgsServiceImpl.getPackimgsModelById", (Throwable)e);
            return null;
        }
    }

    private PgPackimgs getPackimgsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgPackimgsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgPackimgsServiceImpl.getPackimgsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPackimgsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgPackimgsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.delPackimgsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.delPackimgsModelByCode.num");
        }
    }

    private void deletePackimgsModel(Integer packimgsId) throws ApiException {
        if (null == packimgsId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgPackimgsMapper.deleteByPrimaryKey(packimgsId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.deletePackimgsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.deletePackimgsModel.num");
        }
    }

    private void updatePackimgsModel(PgPackimgs pgPackimgs) throws ApiException {
        if (null == pgPackimgs) {
            return;
        }
        int i = 0;
        try {
            i = this.pgPackimgsMapper.updateByPrimaryKey(pgPackimgs);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.updatePackimgsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.updatePackimgsModel.num");
        }
    }

    private void updateStatePackimgsModel(Integer packimgsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == packimgsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packimgsId", packimgsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgPackimgsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.updateStatePackimgsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.updateStatePackimgsModel.null");
        }
    }

    private void updateStatePackimgsModelByCode(String tenantCode, String packimgsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)packimgsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("packimgsCode", packimgsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgPackimgsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.updateStatePackimgsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.updateStatePackimgsModelByCode.null");
        }
    }

    private PgPackimgs makePackimgs(PgPackimgsDomain pgPackimgsDomain, PgPackimgs pgPackimgs) {
        if (null == pgPackimgsDomain) {
            return null;
        }
        if (null == pgPackimgs) {
            pgPackimgs = new PgPackimgs();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgPackimgs, (Object)pgPackimgsDomain);
            return pgPackimgs;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgPackimgsServiceImpl.makePackimgs", (Throwable)e);
            return null;
        }
    }

    private PgPackimgsReDomain makePgPackimgsReDomain(PgPackimgs pgPackimgs) {
        if (null == pgPackimgs) {
            return null;
        }
        PgPackimgsReDomain pgPackimgsReDomain = new PgPackimgsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgPackimgsReDomain, (Object)pgPackimgs);
            return pgPackimgsReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgPackimgsServiceImpl.makePgPackimgsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgPackimgs> queryPackimgsModelPage(Map<String, Object> parammap) {
        try {
            return this.pgPackimgsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgPackimgsServiceImpl.queryPackimgsModel", (Throwable)e);
            return null;
        }
    }

    private int countPackimgs(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgPackimgsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgPackimgsServiceImpl.countPackimgs", (Throwable)e);
        }
        return i;
    }

    private PgPackimgs createPgPackimgs(PgPackimgsDomain pgPackimgsDomain) {
        String msg = this.checkPackimgs(pgPackimgsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.savePackimgs.checkPackimgs", msg);
        }
        PgPackimgs pgPackimgs = this.makePackimgs(pgPackimgsDomain, null);
        this.setPackimgsDefault(pgPackimgs);
        return pgPackimgs;
    }

    @Override
    public String savePackimgs(PgPackimgsDomain pgPackimgsDomain) throws ApiException {
        PgPackimgs pgPackimgs = this.createPgPackimgs(pgPackimgsDomain);
        this.savePackimgsModel(pgPackimgs);
        return pgPackimgs.getPackimgsCode();
    }

    @Override
    public String savePackimgsBatch(List<PgPackimgsDomain> pgPackimgsDomainList) throws ApiException {
        if (null == pgPackimgsDomainList || pgPackimgsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgPackimgs> pgPackimgsList = new ArrayList<PgPackimgs>();
        String code = "";
        for (PgPackimgsDomain pgPackimgsDomain : pgPackimgsDomainList) {
            PgPackimgs pgPackimgs = this.createPgPackimgs(pgPackimgsDomain);
            code = pgPackimgs.getPackimgsCode();
            pgPackimgsList.add(pgPackimgs);
        }
        this.savePackimgsBatchModel(pgPackimgsList);
        return code;
    }

    @Override
    public void updatePackimgsState(Integer packimgsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == packimgsId) {
            return;
        }
        this.updateStatePackimgsModel(packimgsId, dataState, oldDataState, map);
    }

    @Override
    public void updatePackimgsStateByCode(String tenantCode, String packimgsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)packimgsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePackimgsModelByCode(tenantCode, packimgsCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePackimgs(PgPackimgsDomain pgPackimgsDomain) throws ApiException {
        String msg = this.checkPackimgs(pgPackimgsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.updatePackimgs.checkPackimgs", msg);
        }
        PgPackimgs oldPgPackimgs = this.getPackimgsModelById(pgPackimgsDomain.getPackimgsId());
        if (null == oldPgPackimgs) {
            throw new ApiException("pg.PICK.PgPackimgsServiceImpl.updatePackimgs.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgPackimgs pgPackimgs = this.makePackimgs(pgPackimgsDomain, oldPgPackimgs);
        this.setPackimgsUpdataDefault(pgPackimgs);
        this.updatePackimgsModel(pgPackimgs);
    }

    @Override
    public PgPackimgs getPackimgs(Integer packimgsId) {
        if (null == packimgsId) {
            return null;
        }
        return this.getPackimgsModelById(packimgsId);
    }

    @Override
    public void deletePackimgs(Integer packimgsId) throws ApiException {
        if (null == packimgsId) {
            return;
        }
        this.deletePackimgsModel(packimgsId);
    }

    @Override
    public QueryResult<PgPackimgs> queryPackimgsPage(Map<String, Object> map) {
        List<PgPackimgs> pgPackimgsList = this.queryPackimgsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPackimgs(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgPackimgsList);
        return queryResult;
    }

    @Override
    public PgPackimgs getPackimgsByCode(String tenantCode, String packimgsCode) throws ApiException {
        if (StringUtils.isBlank((String)packimgsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("packimgsCode", packimgsCode);
        return this.getPackimgsModelByCode(map);
    }

    @Override
    public void deletePackimgsByCode(String tenantCode, String packimgsCode) throws ApiException {
        if (StringUtils.isBlank((String)packimgsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("packimgsCode", packimgsCode);
        this.delPackimgsModelByCode(map);
    }
}

