/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsNoticeConfigMapper;
import com.yqbsoft.laser.service.portal.dao.CmsNoticeMapper;
import com.yqbsoft.laser.service.portal.domain.CmsNoticeConfigDomain;
import com.yqbsoft.laser.service.portal.domain.CmsNoticeConfigReDomain;
import com.yqbsoft.laser.service.portal.domain.CmsNoticeDomain;
import com.yqbsoft.laser.service.portal.domain.CmsNoticeReDomain;
import com.yqbsoft.laser.service.portal.model.CmsNotice;
import com.yqbsoft.laser.service.portal.model.CmsNoticeConfig;
import com.yqbsoft.laser.service.portal.service.CmsNoticeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class CmsNoticeServiceImpl
extends BaseServiceImpl
implements CmsNoticeService {
    private static final String SYS_CODE = "cms.CmsNoticeServiceImpl";
    private CmsNoticeMapper cmsNoticeMapper;
    private CmsNoticeConfigMapper cmsNoticeConfigMapper;
    private String cachekey = "CmsNoticeConf-type";
    private String cachekey_key = "CmsNoticeConf-type-key";
    private String cachekey_value = "CmsNoticeConf-type-value";

    public void setCmsNoticeMapper(CmsNoticeMapper cmsNoticeMapper) {
        this.cmsNoticeMapper = cmsNoticeMapper;
    }

    public void setCmsNoticeConfigMapper(CmsNoticeConfigMapper cmsNoticeConfigMapper) {
        this.cmsNoticeConfigMapper = cmsNoticeConfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsNoticeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkNotice(CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsNoticeDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsNoticeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setNoticeDefault(CmsNotice cmsNotice) {
        if (null == cmsNotice) {
            return;
        }
        if (null == cmsNotice.getDataState()) {
            cmsNotice.setDataState(0);
        }
        if (null == cmsNotice.getGmtCreate()) {
            cmsNotice.setGmtCreate(this.getSysDate());
        }
        cmsNotice.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsNotice.getNoticeCode())) {
            cmsNotice.setNoticeCode(this.createUUIDString());
        }
    }

    private int getNoticeMaxCode() {
        int code = 0;
        try {
            return this.cmsNoticeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setNoticeUpdataDefault(CmsNotice cmsNotice) {
        if (null == cmsNotice) {
            return;
        }
        cmsNotice.setGmtModified(this.getSysDate());
    }

    private void saveNoticeModel(CmsNotice cmsNotice) throws ApiException {
        if (null == cmsNotice) {
            return;
        }
        try {
            this.cmsNoticeMapper.insert(cmsNotice);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNoticeModel.ex", (Throwable)e);
        }
    }

    private void saveNoticeBatchModel(List<CmsNotice> cmsNoticeList) throws ApiException {
        if (null == cmsNoticeList || cmsNoticeList.isEmpty()) {
            return;
        }
        try {
            this.cmsNoticeMapper.insertBatch(cmsNoticeList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNoticeBatchModel.ex", (Throwable)e);
        }
    }

    private CmsNotice getNoticeModelById(Integer noticeId) {
        if (null == noticeId) {
            return null;
        }
        try {
            return this.cmsNoticeMapper.selectByPrimaryKey(noticeId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeModelById", (Throwable)e);
            return null;
        }
    }

    private CmsNotice getNoticeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsNoticeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delNoticeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.delNoticeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.delNoticeModelByCode.num");
        }
    }

    private void deleteNoticeModel(Integer noticeId) throws ApiException {
        if (null == noticeId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.deleteByPrimaryKey(noticeId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.deleteNoticeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.deleteNoticeModel.num");
        }
    }

    private void updateNoticeModel(CmsNotice cmsNotice) throws ApiException {
        if (null == cmsNotice) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.updateByPrimaryKeySelective(cmsNotice);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNoticeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNoticeModel.num");
        }
    }

    private void updateStateNoticeModel(Integer noticeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == noticeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noticeId", noticeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeModel.null");
        }
    }

    private void updateStateNoticeModelByCode(String tenantCode, String noticeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeCode", noticeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsNoticeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeModelByCode.null");
        }
    }

    private CmsNotice makeNotice(CmsNoticeDomain cmsNoticeDomain, CmsNotice cmsNotice) {
        if (null == cmsNoticeDomain) {
            return null;
        }
        if (null == cmsNotice) {
            cmsNotice = new CmsNotice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsNotice, (Object)cmsNoticeDomain);
            return cmsNotice;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.makeNotice", (Throwable)e);
            return null;
        }
    }

    private CmsNoticeReDomain makeCmsNoticeReDomain(CmsNotice cmsNotice) {
        if (null == cmsNotice) {
            return null;
        }
        CmsNoticeReDomain cmsNoticeReDomain = new CmsNoticeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsNoticeReDomain, (Object)cmsNotice);
            return cmsNoticeReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.makeCmsNoticeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsNotice> queryNoticeModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsNoticeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.queryNoticeModel", (Throwable)e);
            return null;
        }
    }

    private int countNotice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsNoticeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.countNotice", (Throwable)e);
        }
        return i;
    }

    private CmsNotice createCmsNotice(CmsNoticeDomain cmsNoticeDomain) {
        String msg = this.checkNotice(cmsNoticeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNotice.checkNotice", msg);
        }
        CmsNotice cmsNotice = this.makeNotice(cmsNoticeDomain, null);
        this.setNoticeDefault(cmsNotice);
        return cmsNotice;
    }

    private String checkNoticeConfig(CmsNoticeConfigDomain cmsNoticeConfigDomain) {
        if (null == cmsNoticeConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsNoticeConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setNoticeConfigDefault(CmsNoticeConfig cmsNoticeConfig) {
        if (null == cmsNoticeConfig) {
            return;
        }
        if (null == cmsNoticeConfig.getDataState()) {
            cmsNoticeConfig.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cmsNoticeConfig.getGmtCreate()) {
            cmsNoticeConfig.setGmtCreate(date);
        }
        cmsNoticeConfig.setGmtModified(date);
        if (StringUtils.isBlank((String)cmsNoticeConfig.getNoticeConfigCode())) {
            cmsNoticeConfig.setNoticeConfigCode(this.getNo(null, "CmsNoticeConfig", "cmsNoticeConfig", cmsNoticeConfig.getTenantCode()));
        }
    }

    private int getNoticeConfigMaxCode() {
        int code = 0;
        try {
            return this.cmsNoticeConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setNoticeConfigUpdataDefault(CmsNoticeConfig cmsNoticeConfig) {
        if (null == cmsNoticeConfig) {
            return;
        }
        cmsNoticeConfig.setGmtModified(this.getSysDate());
    }

    private void saveNoticeConfigModel(CmsNoticeConfig cmsNoticeConfig) throws ApiException {
        if (null == cmsNoticeConfig) {
            return;
        }
        try {
            this.cmsNoticeConfigMapper.insert(cmsNoticeConfig);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNoticeConfigModel.ex", (Throwable)e);
        }
    }

    private void saveNoticeConfigBatchModel(List<CmsNoticeConfig> cmsNoticeConfigList) throws ApiException {
        if (null == cmsNoticeConfigList || cmsNoticeConfigList.isEmpty()) {
            return;
        }
        try {
            this.cmsNoticeConfigMapper.insertBatch(cmsNoticeConfigList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNoticeConfigBatchModel.ex", (Throwable)e);
        }
    }

    private CmsNoticeConfig getNoticeConfigModelById(Integer noticeConfigId) {
        if (null == noticeConfigId) {
            return null;
        }
        try {
            return this.cmsNoticeConfigMapper.selectByPrimaryKey(noticeConfigId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeConfigModelById", (Throwable)e);
            return null;
        }
    }

    private CmsNoticeConfig getNoticeConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsNoticeConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.getNoticeConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delNoticeConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.delNoticeConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.delNoticeConfigModelByCode.num");
        }
    }

    private void delNoticeConfigModelByNoticeCode(String noticeCode, String tenantCode) {
        if (StringUtils.isBlank((String)noticeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noticeCode", noticeCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.cmsNoticeConfigMapper.delByNoticeCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.delNoticeConfigModelByCode.ex", (Throwable)e);
        }
    }

    private void deleteNoticeConfigModel(Integer noticeConfigId) throws ApiException {
        if (null == noticeConfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeConfigMapper.deleteByPrimaryKey(noticeConfigId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.deleteNoticeConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.deleteNoticeConfigModel.num");
        }
    }

    private void updateNoticeConfigModel(CmsNoticeConfig cmsNoticeConfig) throws ApiException {
        if (null == cmsNoticeConfig) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsNoticeConfigMapper.updateByPrimaryKey(cmsNoticeConfig);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNoticeConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNoticeConfigModel.num");
        }
    }

    private void updateStateNoticeConfigModel(Integer noticeConfigId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == noticeConfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noticeConfigId", noticeConfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsNoticeConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeConfigModel.null");
        }
    }

    private void updateStateNoticeConfigModelByCode(String tenantCode, String noticeConfigCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)noticeConfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeConfigCode", noticeConfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsNoticeConfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeConfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeConfigModelByCode.null");
        }
    }

    private void updateStateNoticeConfigModelByNoticeCode(String tenantCode, String noticeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeCode", noticeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        try {
            int n = this.cmsNoticeConfigMapper.updateStateByNoticeCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateStateNoticeConfigModelByCode.ex", (Throwable)e);
        }
    }

    private CmsNoticeConfig makeNoticeConfig(CmsNoticeConfigDomain cmsNoticeConfigDomain, CmsNoticeConfig cmsNoticeConfig) {
        if (null == cmsNoticeConfigDomain) {
            return null;
        }
        if (null == cmsNoticeConfig) {
            cmsNoticeConfig = new CmsNoticeConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsNoticeConfig, (Object)cmsNoticeConfigDomain);
            return cmsNoticeConfig;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.makeNoticeConfig", (Throwable)e);
            return null;
        }
    }

    private CmsNoticeConfigReDomain makeCmsNoticeConfigReDomain(CmsNoticeConfig cmsNoticeConfig) {
        if (null == cmsNoticeConfig) {
            return null;
        }
        CmsNoticeConfigReDomain cmsNoticeConfigReDomain = new CmsNoticeConfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsNoticeConfigReDomain, (Object)cmsNoticeConfig);
            return cmsNoticeConfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.makeCmsNoticeConfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsNoticeConfig> queryNoticeConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsNoticeConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.queryNoticeConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countNoticeConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsNoticeConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsNoticeServiceImpl.countNoticeConfig", (Throwable)e);
        }
        return i;
    }

    private CmsNoticeConfig createCmsNoticeConfig(CmsNoticeConfigDomain cmsNoticeConfigDomain) {
        String msg = this.checkNoticeConfig(cmsNoticeConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsNoticeServiceImpl.saveNoticeConfig.checkNoticeConfig", msg);
        }
        CmsNoticeConfig cmsNoticeConfig = this.makeNoticeConfig(cmsNoticeConfigDomain, null);
        this.setNoticeConfigDefault(cmsNoticeConfig);
        return cmsNoticeConfig;
    }

    @Override
    public String saveNotice(CmsNoticeDomain cmsNoticeDomain) throws ApiException {
        CmsNotice cmsNotice = this.createCmsNotice(cmsNoticeDomain);
        this.saveNoticeModel(cmsNotice);
        return cmsNotice.getNoticeCode();
    }

    @Override
    public String saveNoticeBatch(List<CmsNoticeDomain> cmsNoticeDomainList) throws ApiException {
        if (null == cmsNoticeDomainList || cmsNoticeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsNotice> cmsNoticeList = new ArrayList<CmsNotice>();
        String code = "";
        for (CmsNoticeDomain cmsNoticeDomain : cmsNoticeDomainList) {
            CmsNotice cmsNotice = this.createCmsNotice(cmsNoticeDomain);
            code = cmsNotice.getNoticeCode();
            cmsNoticeList.add(cmsNotice);
        }
        this.saveNoticeBatchModel(cmsNoticeList);
        return code;
    }

    @Override
    public void updateNoticeState(Integer noticeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == noticeId) {
            return;
        }
        this.updateStateNoticeModel(noticeId, dataState, oldDataState, map);
        if (1 != dataState) {
            CmsNotice notice = this.getNotice(noticeId);
            this.deleteDpriceCache(notice);
        } else if (1 == dataState) {
            CmsNotice notice = this.getNotice(noticeId);
            this.updateDpriceCache(notice);
        }
    }

    @Override
    public void updateNoticeStateByCode(String tenantCode, String noticeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateNoticeModelByCode(tenantCode, noticeCode, dataState, oldDataState, map);
        if (1 != dataState) {
            CmsNotice notice = this.getNoticeByCode(tenantCode, noticeCode);
            this.deleteDpriceCache(notice);
        } else if (1 == dataState) {
            CmsNotice notice = this.getNoticeByCode(tenantCode, noticeCode);
            this.updateDpriceCache(notice);
        }
    }

    @Override
    public void updateNotice(CmsNoticeDomain cmsNoticeDomain) throws ApiException {
        String msg = this.checkNotice(cmsNoticeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNotice.checkNotice", msg);
        }
        CmsNotice oldCmsNotice = this.getNoticeModelById(cmsNoticeDomain.getNoticeId());
        if (null == oldCmsNotice) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNotice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsNotice cmsNotice = this.makeNotice(cmsNoticeDomain, oldCmsNotice);
        this.setNoticeUpdataDefault(cmsNotice);
        this.updateNoticeModel(cmsNotice);
    }

    @Override
    public CmsNotice getNotice(Integer noticeId) {
        if (null == noticeId) {
            return null;
        }
        return this.getNoticeModelById(noticeId);
    }

    @Override
    public void deleteNotice(Integer noticeId) throws ApiException {
        if (null == noticeId) {
            return;
        }
        this.deleteNoticeModel(noticeId);
    }

    @Override
    public QueryResult<CmsNotice> queryNoticePage(Map<String, Object> map) {
        List<CmsNotice> cmsNoticeList = this.queryNoticeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countNotice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsNoticeList);
        return queryResult;
    }

    @Override
    public CmsNotice getNoticeByCode(String tenantCode, String noticeCode) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeCode", noticeCode);
        return this.getNoticeModelByCode(map);
    }

    @Override
    public void deleteNoticeByCode(String tenantCode, String noticeCode) throws ApiException {
        if (StringUtils.isBlank((String)noticeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeCode", noticeCode);
        this.delNoticeModelByCode(map);
    }

    @Override
    public String saveNoticeConfig(CmsNoticeConfigDomain cmsNoticeConfigDomain) throws ApiException {
        CmsNoticeConfig cmsNoticeConfig = this.createCmsNoticeConfig(cmsNoticeConfigDomain);
        this.saveNoticeConfigModel(cmsNoticeConfig);
        return cmsNoticeConfig.getNoticeConfigCode();
    }

    @Override
    public String saveNoticeConfigBatch(List<CmsNoticeConfigDomain> cmsNoticeConfigDomainList) throws ApiException {
        if (null == cmsNoticeConfigDomainList || cmsNoticeConfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsNoticeConfig> cmsNoticeConfigList = new ArrayList<CmsNoticeConfig>();
        String code = "";
        for (CmsNoticeConfigDomain cmsNoticeConfigDomain : cmsNoticeConfigDomainList) {
            this.updateStateNoticeConfigModelByNoticeCode(cmsNoticeConfigDomain.getTenantCode(), cmsNoticeConfigDomain.getNoticeCode(), -1, null, null);
            CmsNoticeConfig cmsNoticeConfig = this.createCmsNoticeConfig(cmsNoticeConfigDomain);
            code = cmsNoticeConfig.getNoticeConfigCode();
            cmsNoticeConfigList.add(cmsNoticeConfig);
        }
        this.saveNoticeConfigBatchModel(cmsNoticeConfigList);
        return code;
    }

    @Override
    public void updateNoticeConfigState(Integer noticeConfigId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == noticeConfigId) {
            return;
        }
        this.updateStateNoticeConfigModel(noticeConfigId, dataState, oldDataState, map);
    }

    @Override
    public void updateNoticeConfigStateByCode(String tenantCode, String noticeConfigCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)noticeConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateNoticeConfigModelByCode(tenantCode, noticeConfigCode, dataState, oldDataState, map);
    }

    @Override
    public void updateNoticeConfig(CmsNoticeConfigDomain cmsNoticeConfigDomain) throws ApiException {
        String msg = this.checkNoticeConfig(cmsNoticeConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNoticeConfig.checkNoticeConfig", msg);
        }
        CmsNoticeConfig oldCmsNoticeConfig = this.getNoticeConfigModelById(cmsNoticeConfigDomain.getNoticeConfigId());
        if (null == oldCmsNoticeConfig) {
            throw new ApiException("cms.CmsNoticeServiceImpl.updateNoticeConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsNoticeConfig cmsNoticeConfig = this.makeNoticeConfig(cmsNoticeConfigDomain, oldCmsNoticeConfig);
        this.setNoticeConfigUpdataDefault(cmsNoticeConfig);
        this.updateNoticeConfigModel(cmsNoticeConfig);
    }

    @Override
    public CmsNoticeConfig getNoticeConfig(Integer noticeConfigId) {
        if (null == noticeConfigId) {
            return null;
        }
        return this.getNoticeConfigModelById(noticeConfigId);
    }

    @Override
    public void deleteNoticeConfig(Integer noticeConfigId) throws ApiException {
        if (null == noticeConfigId) {
            return;
        }
        this.deleteNoticeConfigModel(noticeConfigId);
    }

    @Override
    public QueryResult<CmsNoticeConfig> queryNoticeConfigPage(Map<String, Object> map) {
        List<CmsNoticeConfig> cmsNoticeConfigList = this.queryNoticeConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countNoticeConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsNoticeConfigList);
        return queryResult;
    }

    @Override
    public CmsNoticeConfig getNoticeConfigByCode(String tenantCode, String noticeConfigCode) throws ApiException {
        if (StringUtils.isBlank((String)noticeConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeConfigCode", noticeConfigCode);
        return this.getNoticeConfigModelByCode(map);
    }

    @Override
    public void deleteNoticeConfigByCode(String tenantCode, String noticeConfigCode) throws ApiException {
        if (StringUtils.isBlank((String)noticeConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("noticeConfigCode", noticeConfigCode);
        this.delNoticeConfigModelByCode(map);
    }

    private void deleteDpriceCache(CmsNotice cmsNotice) {
        if (null == cmsNotice) {
            return;
        }
        if (StringUtils.isBlank((String)cmsNotice.getChannelCode())) {
            cmsNotice.setChannelCode("all");
        }
        DisUtil.del((String)(this.cachekey_key + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()));
        DisUtil.del((String)(this.cachekey_value + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()));
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)(cmsNotice.getNoticeType() + "-" + cmsNotice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            return;
        }
        List dlist = JsonUtil.buildNormalBinder().getJsonToList(json, CmsNoticeDomain.class);
        ArrayList<CmsNoticeDomain> dlist2 = new ArrayList<CmsNoticeDomain>();
        if (ListUtil.isNotEmpty((Collection)dlist)) {
            for (CmsNoticeDomain cmsNoticeDomain2 : dlist) {
                if (cmsNoticeDomain2.getNoticeCode().equals(cmsNotice.getNoticeCode())) continue;
                dlist2.add(cmsNoticeDomain2);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(cmsNotice.getNoticeType() + "-" + cmsNotice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(CmsNoticeServiceImpl.disDomainsort(dlist2)));
    }

    private void deleteDpriceConfCache(CmsNoticeConfig cmsNoticeConfig, CmsNotice cmsNotice) {
        if (null == cmsNoticeConfig) {
            return;
        }
        if (StringUtils.isNotBlank((String)cmsNoticeConfig.getNoticeConfigType())) {
            cmsNoticeConfig.setNoticeConfigType("=");
        }
        if (null == cmsNotice) {
            cmsNotice = this.getNoticeByCode(cmsNoticeConfig.getTenantCode(), cmsNoticeConfig.getNoticeCode());
        }
        if (cmsNoticeConfig.getNoticeConfigType().equals("=") || cmsNoticeConfig.getNoticeConfigType().equals("!=")) {
            DisUtil.delMapVer((String)(this.cachekey_value + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()), (String[])new String[]{cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType() + "-" + cmsNoticeConfig.getNoticeConfigValue()});
        } else {
            DisUtil.delMapVer((String)(this.cachekey_value + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()), (String[])new String[]{cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType()});
        }
    }

    private void updateDpriceCache(CmsNotice cmsNotice) {
        List<CmsNoticeDomain> dlist;
        if (null == cmsNotice || StringUtils.isBlank((String)cmsNotice.getNoticeType())) {
            return;
        }
        CmsNoticeDomain cmsNoticeDomain = this.makeCmsNoticeDomain(cmsNotice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("noticeCode", cmsNotice.getNoticeCode());
        confparammap.put("tenantCode", cmsNotice.getTenantCode());
        confparammap.put("dataState", 0);
        List<CmsNoticeConfig> upcachelist = this.queryNoticeConfigModelPage(confparammap);
        if (ListUtil.isNotEmpty(upcachelist)) {
            HashMap<String, String> keymap = new HashMap<String, String>();
            HashMap<String, String> valuemap = new HashMap<String, String>();
            for (CmsNoticeConfig cmsNoticeConfig : upcachelist) {
                if (StringUtils.isNotBlank((String)cmsNoticeConfig.getNoticeConfigType())) {
                    cmsNoticeConfig.setNoticeConfigType("=");
                }
                keymap.put(cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType(), cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType());
                if (cmsNoticeConfig.getNoticeConfigType().equals("=") || cmsNoticeConfig.getNoticeConfigType().equals("!=")) {
                    valuemap.put(cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType() + "-" + cmsNoticeConfig.getNoticeConfigValue(), JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeConfig));
                    continue;
                }
                valuemap.put(cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType(), JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeConfig));
            }
            DisUtil.setMapVer((String)(this.cachekey_key + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()), keymap);
            DisUtil.setMapVer((String)(this.cachekey_value + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()), valuemap);
        } else {
            DisUtil.del((String)(this.cachekey_key + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()));
            DisUtil.del((String)(this.cachekey_value + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()));
        }
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)(cmsNotice.getNoticeType() + "-" + cmsNotice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            dlist = new ArrayList<CmsNoticeDomain>();
            dlist.add(cmsNoticeDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(cmsNotice.getNoticeType() + "-" + cmsNotice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(CmsNoticeServiceImpl.disDomainsort(dlist)));
        } else {
            dlist = JsonUtil.buildNormalBinder().getJsonToList(json, CmsNoticeDomain.class);
            ArrayList<CmsNoticeDomain> redlist = new ArrayList<CmsNoticeDomain>();
            if (ListUtil.isNotEmpty(dlist)) {
                boolean flag = false;
                for (CmsNoticeDomain cmsNoticeDomain2 : dlist) {
                    if (cmsNoticeDomain2.getNoticeCode().equals(cmsNotice.getNoticeCode())) {
                        flag = true;
                        redlist.add(cmsNoticeDomain);
                        continue;
                    }
                    redlist.add(cmsNoticeDomain2);
                }
                if (!flag) {
                    redlist.add(cmsNoticeDomain);
                }
            } else {
                redlist.add(cmsNoticeDomain);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(cmsNotice.getNoticeType() + "-" + cmsNotice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(CmsNoticeServiceImpl.disDomainsort(redlist)));
        }
    }

    private void updateDpriceConfCache(CmsNoticeConfig cmsNoticeConfig) {
        if (null == cmsNoticeConfig) {
            return;
        }
        if (StringUtils.isNotBlank((String)cmsNoticeConfig.getNoticeConfigType())) {
            cmsNoticeConfig.setNoticeConfigType("=");
        }
        DisUtil.setMapVer((String)(this.cachekey_key + "-" + cmsNoticeConfig.getNoticeCode() + "-" + cmsNoticeConfig.getTenantCode()), (String)(cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType()), (String)(cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType()));
        if (cmsNoticeConfig.getNoticeConfigType().equals("=") || cmsNoticeConfig.getNoticeConfigType().equals("!=")) {
            DisUtil.setMapVer((String)(this.cachekey_value + "-" + cmsNoticeConfig.getNoticeCode() + "-" + cmsNoticeConfig.getTenantCode()), (String)(cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType() + "-" + cmsNoticeConfig.getNoticeConfigValue()), (String)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeConfig));
        } else {
            DisUtil.setMapVer((String)(this.cachekey_value + "-" + cmsNoticeConfig.getNoticeCode() + "-" + cmsNoticeConfig.getTenantCode()), (String)(cmsNoticeConfig.getNoticeConfigKey() + "-" + cmsNoticeConfig.getNoticeConfigType()), (String)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeConfig));
        }
    }

    @Override
    public void queryNoticeLoadCache() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataStateStr", "1");
        List<CmsNotice> cmsNoticeList = this.queryNoticeModelPage(parammap);
        if (null == cmsNoticeList || cmsNoticeList.isEmpty()) {
            Map ddMap = DisUtil.getMapAll((String)this.cachekey);
            DisUtil.delVer((String)this.cachekey);
            if (MapUtil.isNotEmpty((Map)ddMap)) {
                for (String key : ddMap.keySet()) {
                    DisUtil.del((String)(this.cachekey_key + "-" + key));
                    DisUtil.del((String)(this.cachekey_value + "-" + key));
                }
            }
            this.logger.info("CmsNoticeService.queryDpriceLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<CmsNoticeDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<CmsNoticeDomain>>();
        for (CmsNotice cmsNotice : cmsNoticeList) {
            if (StringUtils.isBlank((String)cmsNotice.getNoticeType())) continue;
            CmsNoticeDomain cmsNoticeDomain = this.makeCmsNoticeDomain(cmsNotice);
            confparammap.put("noticeCode", cmsNotice.getNoticeCode());
            confparammap.put("tenantCode", cmsNotice.getTenantCode());
            confparammap.put("dataState", 0);
            List<CmsNoticeConfig> upcachelist = this.queryNoticeConfigModelPage(confparammap);
            if (ListUtil.isNotEmpty(upcachelist)) {
                HashMap<String, String> keymap = new HashMap<String, String>();
                HashMap<String, String> valuemap = new HashMap<String, String>();
                for (CmsNoticeConfig cmsNoticeConf : upcachelist) {
                    if (StringUtils.isBlank((String)cmsNoticeConf.getNoticeConfigType())) {
                        cmsNoticeConf.setNoticeConfigType("=");
                    }
                    keymap.put(cmsNoticeConf.getNoticeConfigKey() + "-" + cmsNoticeConf.getNoticeConfigType(), cmsNoticeConf.getNoticeConfigKey() + "-" + cmsNoticeConf.getNoticeConfigType());
                    if (cmsNoticeConf.getNoticeConfigType().equals("=") || cmsNoticeConf.getNoticeConfigType().equals("!=")) {
                        valuemap.put(cmsNoticeConf.getNoticeConfigKey() + "-" + cmsNoticeConf.getNoticeConfigType() + "-" + cmsNoticeConf.getNoticeConfigValue(), JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeConf));
                        continue;
                    }
                    valuemap.put(cmsNoticeConf.getNoticeConfigKey() + "-" + cmsNoticeConf.getNoticeConfigType(), JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeConf));
                }
                DisUtil.setMapVer((String)(this.cachekey_key + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()), keymap);
                DisUtil.setMapVer((String)(this.cachekey_value + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()), valuemap);
            } else {
                DisUtil.del((String)(this.cachekey_key + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()));
                DisUtil.del((String)(this.cachekey_value + "-" + cmsNotice.getNoticeCode() + "-" + cmsNotice.getTenantCode()));
            }
            ArrayList<CmsNoticeDomain> dlist = (ArrayList<CmsNoticeDomain>)ddListMap.get(cmsNotice.getNoticeType() + "-" + cmsNotice.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<CmsNoticeDomain>();
                ddListMap.put(cmsNotice.getNoticeType() + "-" + cmsNotice.getTenantCode(), dlist);
            }
            dlist.add(cmsNoticeDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(CmsNoticeServiceImpl.disDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("CmsNoticeService.queryDpriceLoadCache", (Object)"===========add-end==========");
    }

    private static List<CmsNoticeDomain> disDomainsort(List<CmsNoticeDomain> dlist) {
        if (ListUtil.isEmpty(dlist)) {
            return null;
        }
        Collections.sort(dlist, new Comparator<CmsNoticeDomain>(){

            @Override
            public int compare(CmsNoticeDomain arg0, CmsNoticeDomain arg1) {
                if (Objects.isNull(arg0.getNoticeStart()) || Objects.isNull(arg1.getNoticeStart())) {
                    return -1;
                }
                if (arg0.getNoticeStart().getTime() > arg1.getNoticeStart().getTime()) {
                    return -1;
                }
                if (arg0.getNoticeStart().getTime() < arg1.getNoticeStart().getTime()) {
                    return 1;
                }
                return 0;
            }
        });
        return dlist;
    }

    private CmsNoticeDomain makeCmsNoticeDomain(CmsNotice cmsNotice) {
        if (null == cmsNotice) {
            return null;
        }
        CmsNoticeDomain cmsNoticeDomain = new CmsNoticeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsNoticeDomain, (Object)cmsNotice);
            return cmsNoticeDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void updateNoticeLoadCacheDataState(String tenantCode) {
        if (null == tenantCode) {
            this.logger.error("cms.CmsNoticeServiceImpl.updateNoticeLoadCacheDataState", (Object)"is null");
        }
        this.noticeStart(tenantCode);
        this.noticeEnd(tenantCode);
    }

    @Override
    public List<CmsNoticeDomain> queryNoticePageList(Map<String, Object> objMap, String tenantCode, String noticeType) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)noticeType)) {
            this.logger.error("cms.CmsNoticeServiceImpl.queryNoticePageList is null");
            return null;
        }
        List dlist = DisUtil.getMapListJson((String)this.cachekey, (String)(noticeType + "-" + tenantCode), CmsNoticeDomain.class);
        if (ListUtil.isEmpty((Collection)dlist)) {
            this.logger.error("cms.CmsNoticeServiceImpl.dlist is null");
            return null;
        }
        if (MapUtil.isEmpty(objMap)) {
            return dlist;
        }
        ArrayList<CmsNoticeDomain> cmsNoticeDomainList = new ArrayList<CmsNoticeDomain>();
        for (CmsNoticeDomain cmsNoticeDomain : dlist) {
            String vaulemap;
            Map keymap = DisUtil.getRemotMapAll((String)(this.cachekey_key + "-" + cmsNoticeDomain.getNoticeCode() + "-" + cmsNoticeDomain.getTenantCode()));
            if (!this.checkConf(keymap, vaulemap = this.cachekey_value + "-" + cmsNoticeDomain.getNoticeCode() + "-" + cmsNoticeDomain.getTenantCode(), objMap, cmsNoticeDomain)) continue;
            cmsNoticeDomainList.add(cmsNoticeDomain);
        }
        return cmsNoticeDomainList;
    }

    protected boolean checkConf(Map<String, String> keymap, String valuemap, Object obj, Object mainObj) {
        if (MapUtil.isEmpty(keymap) || StringUtils.isBlank((String)valuemap)) {
            this.logger.info("cms.CmsNoticeServiceImplcheckConf", (Object)("keymap=" + keymap + "valuemap=" + valuemap));
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        block0: for (String keys : keymap.keySet()) {
            Object objValue;
            String[] keyStr = keys.split("\\-");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            if ((objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key)) instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = false;
                for (String o : otrs) {
                    if (!this.cond(keys, valuemap, term, o, mainObj)) continue;
                    flag = true;
                    continue block0;
                }
                continue;
            }
            if (this.cond(keys, valuemap, term, objValue, mainObj)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    protected boolean cond(String keys, String valuemap, String term, Object objValue, Object mainObj) {
        if (StringUtils.isBlank((String)valuemap)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        if (term.equals("=") || term.equals("!=")) {
            keys = keys + "-" + objValue;
        }
        String value = DisUtil.getRemotMap((String)valuemap, (String)keys);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (StringUtils.isNotBlank((String)value)) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (StringUtils.isBlank((String)value)) {
                flag = false;
            }
        }
        return flag;
    }

    private void noticeStart(String tenantCode) {
        List<CmsNotice> cmsNoticeList;
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = df.format(this.getSysDate());
        map.put("noticeStartQend", format);
        map.put("noticeEndQstart", format);
        map.put("dataState", 0);
        map.put("publishingType", "1");
        if (StringUtils.isNotBlank((String)tenantCode)) {
            map.put("tenantCode", tenantCode);
        }
        if (ListUtil.isEmpty(cmsNoticeList = this.queryNoticeModelPage(map))) {
            this.logger.error("cms.CmsNoticeServiceImpl.updateNoticeLoadCacheDataState", map);
            return;
        }
        for (CmsNotice cmsNotice : cmsNoticeList) {
            if (null != cmsNotice.getNoticeEnd() && cmsNotice.getNoticeEnd().getTime() <= this.getSysDate().getTime()) continue;
            this.updateNoticeState(cmsNotice.getNoticeId(), 1, cmsNotice.getDataState(), null);
        }
    }

    private void noticeEnd(String tenantCode) {
        List<CmsNotice> cmsNoticeList;
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = df.format(this.getSysDate());
        map.put("noticeEndQend", format);
        map.put("dataState", 1);
        map.put("publishingType", "1");
        if (StringUtils.isNotBlank((String)tenantCode)) {
            map.put("tenantCode", tenantCode);
        }
        if (ListUtil.isEmpty(cmsNoticeList = this.queryNoticeModelPage(map))) {
            this.logger.error("cms.CmsNoticeServiceImpl.updateNoticeLoadCacheDataState", map);
            return;
        }
        for (CmsNotice cmsNotice : cmsNoticeList) {
            this.updateNoticeState(cmsNotice.getNoticeId(), 0, cmsNotice.getDataState(), null);
        }
    }
}

