/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.nacos.client.utils.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.potential.dao.MarginPolicySettingMapper;
import com.yqbsoft.laser.service.potential.dao.OrderMarginRelationMapper;
import com.yqbsoft.laser.service.potential.domain.margin.MarginPolicySetting;
import com.yqbsoft.laser.service.potential.domain.margin.OrderMarginRelation;
import com.yqbsoft.laser.service.potential.request.margin.OrderMarginRelationRequest;
import com.yqbsoft.laser.service.potential.result.margin.OrderMarginRelationResponse;
import com.yqbsoft.laser.service.potential.service.OrderMarginRelationService;
import com.yqbsoft.laser.service.potential.utils.LocalDateHelper;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderMarginRelationService")
public class OrderMarginRelationServiceImpl
implements OrderMarginRelationService {
    private static final Logger log = LoggerFactory.getLogger(OrderMarginRelationServiceImpl.class);
    private final OrderMarginRelationMapper orderMarginRelationMapper;
    private final MarginPolicySettingMapper marginPolicySettingMapper;
    private static final ObjectMapper JSON = new ObjectMapper();

    @Override
    public SupQueryResult<OrderMarginRelation> pageQuery(Map<String, Object> params) {
        int pageNum = (Integer)(params.get("page") == null ? Integer.valueOf(1) : params.get("page"));
        int pageSize = (Integer)(params.get("rows") == null ? Integer.valueOf(10) : params.get("rows"));
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 20;
        }
        int offset = (pageNum - 1) * pageSize;
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        long total = this.orderMarginRelationMapper.countByParams(params);
        List<OrderMarginRelation> list = this.orderMarginRelationMapper.selectByPage(params);
        SupQueryResult result = new SupQueryResult();
        result.setTotal(total);
        result.setRows(list);
        return result;
    }

    @Override
    public OrderMarginRelation getById(Long id) {
        return this.orderMarginRelationMapper.selectById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrderMarginRelation create(OrderMarginRelation record) {
        MarginPolicySetting setting = this.resolveSetting(record.getChannelCode(), record.getOrderTypeCode());
        record.setSettingId(setting.getId());
        record.setMarginAmount(this.calcMarginAmount(record.getOrderAmount(), setting));
        this.fillDefaultFields(record);
        this.orderMarginRelationMapper.insert(record);
        return record;
    }

    @Override
    public void updateByList(List<OrderMarginRelation> recordList) {
        for (OrderMarginRelation record : recordList) {
            this.orderMarginRelationMapper.updateSelective(record);
        }
    }

    @Override
    public OrderMarginRelationResponse calculateOrderMargin(OrderMarginRelationRequest request) {
        MarginPolicySetting setting = this.resolveSetting(request.getChannelCode(), request.getOrderTypeCode());
        BigDecimal margin = setting == null ? BigDecimal.ZERO : this.calcMarginAmount(request.getOrderAmount(), setting);
        OrderMarginRelationResponse response = new OrderMarginRelationResponse();
        response.setMarginAmount(margin);
        return response;
    }

    @Override
    public String orderRequireDeposit(OrderMarginRelation record) {
        int usedTimes;
        log.info("===================orderRequireDeposit={}", (Object)record);
        MarginPolicySetting setting = this.resolveSetting(record.getChannelCode(), record.getOrderTypeCode());
        log.info("===================setting={}", (Object)setting);
        if (setting != null) {
            return this.saveRelationAndAllow(record, setting);
        }
        List<MarginPolicySetting> settingList = this.marginPolicySettingMapper.queryList(Collections.singletonMap("channel", record.getChannelCode()));
        if (settingList == null || settingList.isEmpty()) {
            log.info("\u6e20\u9053={} \u672a\u914d\u7f6e\u653f\u7b56\u4fdd\u8bc1\u91d1\uff0c\u5141\u8bb8\u5236\u4f5c\u53d1\u8d27\u5355\u3002", (Object)record.getChannelCode());
            return "1";
        }
        setting = this.matchSettingByOrderType(settingList, record.getOrderTypeCode());
        if (setting == null) {
            log.info("\u6e20\u9053={}, \u8ba2\u5355\u7c7b\u578b={} \u672a\u5339\u914d\u5230\u653f\u7b56\uff0c\u5141\u8bb8\u5236\u4f5c\u53d1\u8d27\u5355\u3002", (Object)record.getChannelCode(), (Object)record.getOrderTypeCode());
            return "1";
        }
        List<OrderMarginRelation> orderList = this.orderMarginRelationMapper.selectByCustomerCode(record.getCustomerCode(), setting.getQuarterStart(), setting.getQuarterEnd());
        int n = usedTimes = orderList == null ? 0 : orderList.size();
        if (usedTimes < setting.getTempOrderCount()) {
            return this.saveRelationAndAllow(record, setting);
        }
        log.warn("\u5ba2\u6237={} \u8d85\u51fa\u4e34\u65f6\u8ba2\u5355\u6b21\u6570\u9650\u5236\uff1a\u5df2\u4e0b\u5355={}, \u9650\u5236={}", new Object[]{record.getCustomerCode(), usedTimes, setting.getTempOrderCount()});
        return "0";
    }

    private MarginPolicySetting matchSettingByOrderType(List<MarginPolicySetting> list, String orderTypeCode) {
        if (list == null || list.isEmpty() || orderTypeCode == null) {
            return null;
        }
        return list.stream().filter(s -> {
            if (s.getOrderTypeCode() == null) {
                return false;
            }
            return Arrays.stream(s.getOrderTypeCode().split(",")).map(String::trim).anyMatch(code -> code.equals(orderTypeCode));
        }).findFirst().orElse(null);
    }

    private MarginPolicySetting resolveSetting(String channelCode, String orderTypeCode) {
        List<MarginPolicySetting> settingList = this.marginPolicySettingMapper.queryList(Collections.singletonMap("channel", channelCode));
        if (settingList == null || settingList.isEmpty()) {
            log.warn("\u6e20\u9053 {} \u672a\u8bbe\u7f6e\u653f\u7b56\u4fdd\u8bc1\u91d1", (Object)channelCode);
            return null;
        }
        LocalDate today = LocalDate.now();
        MarginPolicySetting setting = settingList.stream().filter(s -> this.containsOrderType((MarginPolicySetting)s, orderTypeCode)).filter(s -> this.isSettingEffectiveToday((MarginPolicySetting)s, today)).findFirst().orElse(null);
        if (setting == null) {
            log.warn("\u653f\u7b56\u4fdd\u8bc1\u91d1\u672a\u547d\u4e2d\uff1achannel={}, type={}, date={}", new Object[]{channelCode, orderTypeCode, today});
        }
        return setting;
    }

    private boolean containsOrderType(MarginPolicySetting s, String orderTypeCode) {
        return Arrays.asList(s.getOrderTypeCode().split(",")).contains(orderTypeCode);
    }

    private String saveRelationAndAllow(OrderMarginRelation record, MarginPolicySetting setting) {
        record.setSettingId(setting.getId());
        record.setMarginAmount(this.calcMarginAmount(record.getOrderAmount(), setting));
        this.fillDefaultFields(record);
        this.orderMarginRelationMapper.insert(record);
        return "1";
    }

    private boolean isSettingEffectiveToday(MarginPolicySetting s, LocalDate today) {
        if (StringUtils.isNotBlank((String)s.getCollectTimes())) {
            try {
                List dates = (List)new ObjectMapper().readValue(s.getCollectTimes(), (TypeReference)new TypeReference<List<String>>(){});
                for (String d : dates) {
                    LocalDate dt = LocalDateHelper.safeParseToLocalDate(d);
                    if (!today.equals(dt)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                log.error("collectTimes parse error: {}", (Object)s.getCollectTimes(), (Object)e);
                return false;
            }
        }
        LocalDate start = LocalDateHelper.safeParseToLocalDate(s.getQuarterStart());
        LocalDate end = LocalDateHelper.safeParseToLocalDate(s.getQuarterEnd());
        if (start != null && end != null) {
            return !today.isBefore(start) && !today.isAfter(end);
        }
        return false;
    }

    private BigDecimal calcMarginAmount(BigDecimal orderAmount, MarginPolicySetting setting) {
        BigDecimal marginAmount = orderAmount.multiply(setting.getRatio());
        return marginAmount.min(setting.getCapAmount());
    }

    private void fillDefaultFields(OrderMarginRelation r) {
        if (r.getRemark() == null) {
            r.setRemark("\u81ea\u52a8\u5173\u8054\u521b\u5efa");
        }
        if (r.getStatus() == null) {
            r.setStatus(0);
        }
        Date now = new Date();
        if (r.getCreatedAt() == null) {
            r.setCreatedAt(now);
        }
        r.setCreatedBy("system");
        r.setUpdatedBy("system");
        r.setUpdatedAt(now);
    }

    public OrderMarginRelationServiceImpl(OrderMarginRelationMapper orderMarginRelationMapper, MarginPolicySettingMapper marginPolicySettingMapper) {
        this.orderMarginRelationMapper = orderMarginRelationMapper;
        this.marginPolicySettingMapper = marginPolicySettingMapper;
    }
}

