/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.enums;

import com.google.common.collect.Lists;
import com.yqbsoft.laser.service.potential.enums.PotentialLevel;
import java.util.ArrayList;
import java.util.List;

public enum PotentialCustomerStatus {
    PENDING_CREATE_CONTRACT(1, "\u5f85\u521b\u5efa\u4e24\u65b9\u5408\u540c", PotentialLevel.LEVEL_ONE),
    PENDING_SET_CONTRACT_DEPOSIT(2, "\u5f85\u8bbe\u7f6e\u5408\u540c\u4fdd\u8bc1\u91d1", PotentialLevel.LEVEL_ONE),
    PENDING_PAY_CONTRACT_DEPOSIT(3, "\u5f85\u7f34\u7eb3\u5408\u540c\u4fdd\u8bc1\u91d1", PotentialLevel.LEVEL_ONE),
    PENDING_CONTRACT_SIGNING(4, "\u5f85\u5408\u540c\u7b7e\u7ea6", PotentialLevel.LEVEL_ONE),
    PENDING_ERP_APPROVAL(5, "\u5f85ERP\u5ba1\u6279", PotentialLevel.LEVEL_ONE),
    CONVERTED(6, "\u5df2\u8f6c\u5316", PotentialLevel.LEVEL_ONE),
    CLOSED(7, "\u5173\u95ed", PotentialLevel.LEVEL_ONE),
    PENDING_SET_INTENT_DEPOSIT(21, "\u5f85\u8bbe\u7f6e\u62db\u5546\u610f\u5411\u91d1", PotentialLevel.LEVEL_TWO),
    PENDING_PAY_INTENT_DEPOSIT(22, "\u5f85\u7f34\u7eb3\u62db\u5546\u610f\u5411\u91d1", PotentialLevel.LEVEL_TWO),
    PENDING_CONVERSION(23, "\u5f85\u8f6c\u5316", PotentialLevel.LEVEL_TWO),
    CONVERTED_SECONDARY(24, "\u5df2\u8f6c\u5316", PotentialLevel.LEVEL_TWO),
    CLOSED_SECONDARY(25, "\u5173\u95ed", PotentialLevel.LEVEL_TWO);

    private final int code;
    private final String description;
    private final PotentialLevel potentialLevel;

    private PotentialCustomerStatus(int code, String description, PotentialLevel potentialLevel) {
        this.code = code;
        this.description = description;
        this.potentialLevel = potentialLevel;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public PotentialLevel getPotentialLevel() {
        return this.potentialLevel;
    }

    public static PotentialCustomerStatus fromCode(int code) {
        for (PotentialCustomerStatus status : PotentialCustomerStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalArgumentException("Unknown code: " + code);
    }

    public static List<PotentialCustomerStatus> getStatusesByLevel(PotentialLevel level) {
        ArrayList statuses = Lists.newArrayList();
        for (PotentialCustomerStatus status : PotentialCustomerStatus.values()) {
            if (status.getPotentialLevel() != level) continue;
            statuses.add(status);
        }
        return statuses;
    }

    public static boolean checkLevelAndCode(PotentialLevel level, int code) {
        for (PotentialCustomerStatus status : PotentialCustomerStatus.values()) {
            if (status.getPotentialLevel() != level || status.getCode() != code) continue;
            return true;
        }
        return false;
    }
}

