/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.es.RebUpointEsSendEnginePollThread;
import com.yqbsoft.laser.service.reb.es.RebUpointEsSendEnginePutThread;
import com.yqbsoft.laser.service.reb.es.RebUpointEsSendEngineService;
import com.yqbsoft.laser.service.reb.model.RebUpoints;
import com.yqbsoft.laser.service.reb.service.RebUpointsBaseService;
import com.yqbsoft.laser.service.reb.service.RebUpointsService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.Collection;
import java.util.HashMap;

public class RebUpointsBaseServiceImpl
extends BaseServiceImpl
implements RebUpointsBaseService {
    private static final String SYS_CODE = "reb.RebUpointsBaseServiceImpl";
    private RebUpointsService rebUpointsService;
    private static RebUpointEsSendEngineService rebUpointEsSendEngineService;
    private static Object lock;

    public RebUpointsService getRebUpointsService() {
        return this.rebUpointsService;
    }

    public void setRebUpointsService(RebUpointsService rebUpointsService) {
        this.rebUpointsService = rebUpointsService;
    }

    @Override
    public void loadRebUpoints(String tenantCode) throws ApiException {
        this.loadDb(tenantCode);
    }

    private void loadDb(String tenantCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("order", true);
            this.logger.info("reb.RebUpointsBaseServiceImpl.updateBmoneyCrpToReturn.map", (Object)JsonUtil.buildNonNullBinder().toJson(map));
            QueryResult<RebUpoints> result = null;
            result = this.rebUpointsService.queryUpointsPage(map);
            this.logger.info("reb.RebUpointsBaseServiceImpl.result===", (Object)JsonUtil.buildNormalBinder().toJson(result));
            if (result == null || result.getPageTools() == null || ListUtil.isEmpty((Collection)result.getRows())) {
                return;
            }
            RebUpointsBaseServiceImpl.getEsSendEngineService().addPutPool(new RebUpointEsSendEnginePutThread(RebUpointsBaseServiceImpl.getEsSendEngineService(), result.getRows()));
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsBaseServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RebUpointEsSendEngineService getEsSendEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == rebUpointEsSendEngineService) {
                rebUpointEsSendEngineService = new RebUpointEsSendEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 30; ++i) {
                    rebUpointEsSendEngineService.addPollPool(new RebUpointEsSendEnginePollThread(rebUpointEsSendEngineService));
                }
            }
            return rebUpointEsSendEngineService;
        }
    }

    static {
        lock = new Object();
    }
}

