/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.RebConstants;
import com.yqbsoft.laser.service.reb.dao.RebAdApplyCancelMapper;
import com.yqbsoft.laser.service.reb.domain.RebAdApplyCancelDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsOpDomain;
import com.yqbsoft.laser.service.reb.service.RebAdApplyCancelService;
import com.yqbsoft.laser.service.reb.service.RebUpointsOpBaseService;
import com.yqbsoft.laser.service.reb.service.ReviewProcessService;
import com.yqbsoft.laser.service.reb.vo.req.RebAdApplyCancelReq;
import com.yqbsoft.laser.service.reb.vo.req.RebAdReviewReq;
import com.yqbsoft.laser.service.reb.vo.resp.RebAdApplyCancelResp;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class RebAdApplyCancelServiceImpl
extends BaseServiceImpl
implements RebAdApplyCancelService {
    private static final String SYS_CODE = "reb.RebAdApplyCancelServiceImpl";
    private RebAdApplyCancelMapper rebAdApplyCancelMapper;
    @Autowired
    private RebUpointsOpBaseService rebUpointsOpBaseService;
    @Autowired
    private ReviewProcessService reviewProcessService;

    @Autowired
    public void setRebAdApplyCancelMapper(RebAdApplyCancelMapper rebAdApplyCancelMapper) {
        this.rebAdApplyCancelMapper = rebAdApplyCancelMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebAdApplyCancelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyCancelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    @Override
    public String saveRebAdApplyCancel(RebAdApplyCancelDomain rebAdApplyCancelDomain) throws ApiException {
        RebAdApplyCancelReq adApplyCancelReq = this.createRebAdApplyCancel(rebAdApplyCancelDomain);
        this.saveRebAdApplyCancelModel(adApplyCancelReq);
        return adApplyCancelReq.getAdApplyCode();
    }

    @Override
    public RebAdApplyCancelResp getRebAdApplyCancelById(Long adApplyCancelId) {
        if (null == adApplyCancelId) {
            return null;
        }
        return this.getAdApplyModelById(adApplyCancelId);
    }

    @Override
    public QueryResult<RebAdApplyCancelResp> queryRebAdApplyCancelPage(Map<String, Object> map) {
        List<RebAdApplyCancelResp> rebAdApplyCancelRespList = this.queryAdApplyCancelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAdApply(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebAdApplyCancelRespList);
        return queryResult;
    }

    @Override
    public void updateRebAdCancelStateByCode(RebAdReviewReq rebAdReviewReq, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)String.valueOf(rebAdReviewReq.getAdCancelId())) || StringUtils.isBlank((String)rebAdReviewReq.getTenantCode())) {
            return;
        }
        this.updateStateAdApplyCancelModelByCode(rebAdReviewReq, map);
    }

    private void updateStateAdApplyCancelModelByCode(RebAdReviewReq reviewReq, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)String.valueOf(reviewReq.getAdCancelId())) || null == reviewReq.getDataState()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String tenantCode = reviewReq.getTenantCode();
        Long adCancelId = reviewReq.getAdCancelId();
        Integer dataState = reviewReq.getDataState();
        map.put("tenantCode", tenantCode);
        map.put("adCancelId", adCancelId);
        map.put("dataState", dataState);
        map.put("oldDataState", reviewReq.getOldDataState());
        map.put("upointsOpAuname", reviewReq.getReviewName());
        map.put("upointsOpAucode", reviewReq.getReviewCode());
        map.put("upointsOpAudate", new Date());
        map.put("upointsOpAuremark", reviewReq.getReviewRemark());
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            RebAdApplyCancelResp oldAdApply;
            RebAdApplyCancelDomain rebAdApplyCancelDomain;
            RebUpointsOpDomain rebUpointsOpDomain;
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_TO_APPROVE) && map.containsKey("currentCancelAmount") && map.get("dmType").equals("1")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("3");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("currentCancelAmount"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_REJECTED) && map.containsKey("currentCancelAmount") && map.get("dmType").equals("1")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("4");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("currentCancelAmount"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_APPROVED) && map.containsKey("currentCancelAmount") && map.get("dmType").equals("1")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("5");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("currentCancelAmount"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_TO_APPROVE) && map.containsKey("currentCancelAmount") && map.get("dmType").equals("2")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("10");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("currentCancelAmount"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
                rebAdApplyCancelDomain = new RebAdApplyCancelDomain();
                oldAdApply = this.getAdApplyCancelModelByCode(this.getQueryParamMap("adCancelId", new Object[]{map.get("adApplyCode")}));
                BeanUtils.copyAllPropertys((Object)rebAdApplyCancelDomain, (Object)oldAdApply);
                rebAdApplyCancelDomain.setToverifyAmount(oldAdApply.getToverifyAmount().subtract(new BigDecimal(String.valueOf(map.get("currentCancelAmount")))));
                this.updateRebAdApply(rebAdApplyCancelDomain);
                this.updateRebAdApplyState(oldAdApply.getAdCancelId(), RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF, RebConstants.AD_APPLY_STATUS_APPROVED, new HashMap<String, Object>());
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_REJECTED) && map.containsKey("currentCancelAmount") && map.get("dmType").equals("2")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("12");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("currentCancelAmount"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
                rebAdApplyCancelDomain = new RebAdApplyCancelDomain();
                oldAdApply = this.getAdApplyCancelModelByCode(this.getQueryParamMap("adCancelId", new Object[]{map.get("adApplyCode")}));
                BeanUtils.copyAllPropertys((Object)rebAdApplyCancelDomain, (Object)oldAdApply);
                rebAdApplyCancelDomain.setToverifyAmount(oldAdApply.getToverifyAmount().add(new BigDecimal(String.valueOf(map.get("currentCancelAmount")))));
                this.updateRebAdApply(rebAdApplyCancelDomain);
                this.updateRebAdApplyState(oldAdApply.getAdCancelId(), RebConstants.AD_APPLY_STATUS_APPROVED, RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF, new HashMap<String, Object>());
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_APPROVED) && map.containsKey("currentCancelAmount") && map.get("dmType").equals("2")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("11");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("currentCancelAmount"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
                rebAdApplyCancelDomain = new RebAdApplyCancelDomain();
                oldAdApply = this.getAdApplyCancelModelByCode(this.getQueryParamMap("adCancelId", new Object[]{map.get("adApplyCode")}));
                BeanUtils.copyAllPropertys((Object)rebAdApplyCancelDomain, (Object)oldAdApply);
                rebAdApplyCancelDomain.setToverifyAmount(oldAdApply.getToverifyAmount().add(new BigDecimal(String.valueOf(map.get("currentCancelAmount")))));
                this.updateRebAdApply(rebAdApplyCancelDomain);
                if (rebAdApplyCancelDomain.getYearCompleteAmount().compareTo(new BigDecimal(String.valueOf(oldAdApply.getCurrentCancelAmount()))) == 0) {
                    Integer dataState1 = oldAdApply.getDataState();
                    if (RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF.equals(dataState1) || RebConstants.AD_APPLY_STATUS_PARTIAL_WRITTEN_OFF.equals(dataState1)) {
                        this.updateRebAdApplyState(oldAdApply.getAdCancelId(), RebConstants.AD_APPLY_STATUS_COMPLETED, null, new HashMap<String, Object>());
                    }
                } else {
                    this.updateRebAdApplyState(oldAdApply.getAdCancelId(), RebConstants.AD_APPLY_STATUS_PARTIAL_WRITTEN_OFF, RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF, new HashMap<String, Object>());
                }
            }
            i = this.rebAdApplyCancelMapper.updateStateByCode(map);
            this.reviewProcessService.saveReviewProcess(reviewReq);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.updateStateAdCancelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.updateStateAdCancelModelByCode.null");
        }
    }

    public void updateRebAdApplyState(Long adCancelId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == adCancelId) {
            return;
        }
        this.updateStateAdCancelModel(adCancelId, dataState, oldDataState, map);
    }

    private void updateStateAdCancelModel(Long adCancelId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == adCancelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adCancelId", adCancelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebAdApplyCancelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.updateStateAdCancelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.updateStateAdCancelModel.null");
        }
    }

    public void updateRebAdApply(RebAdApplyCancelDomain rebAdApplyCancelDomain) throws Exception {
        String msg = this.checkAdApply(rebAdApplyCancelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.updateAdApplyCancel.checkAdApplyCancel", msg);
        }
        RebAdApplyCancelResp oldRebAdApply = null;
        if (rebAdApplyCancelDomain.getAdCancelId() != null) {
            oldRebAdApply = this.getAdApplyModelById(rebAdApplyCancelDomain.getAdCancelId());
        } else if (StringUtils.isNotBlank((String)rebAdApplyCancelDomain.getAdApplyCode())) {
            oldRebAdApply = this.getAdApplyCancelModelByCode(this.getQueryParamMap("adApplyCode", new Object[]{rebAdApplyCancelDomain.getAdApplyCode()}));
        }
        if (null == oldRebAdApply) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.updateAdApply.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebAdApplyCancelReq rebAdApplyCancelReq = new RebAdApplyCancelReq();
        BeanUtils.copyAllPropertys((Object)rebAdApplyCancelReq, (Object)oldRebAdApply);
        RebAdApplyCancelReq adApplyCancelReq = this.makeAdApply(rebAdApplyCancelDomain, rebAdApplyCancelReq);
        adApplyCancelReq.setUpdateTime(new Date());
        this.updateAdApplyModel(adApplyCancelReq);
    }

    private void updateAdApplyModel(RebAdApplyCancelReq adApplyCancelReq) throws ApiException {
        if (null == adApplyCancelReq) {
            return;
        }
        int i = 0;
        try {
            i = this.rebAdApplyCancelMapper.updateByPrimaryKey(adApplyCancelReq);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.updateAdApplyCancelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.updateAdApplyCancelModel.num");
        }
    }

    private RebAdApplyCancelResp getAdApplyCancelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebAdApplyCancelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyCancelServiceImpl.getAdApplyCancelModelByCode", (Throwable)e);
            return null;
        }
    }

    private RebAdApplyCancelResp getAdApplyModelById(Long adCancelId) {
        if (null == adCancelId) {
            return null;
        }
        try {
            return this.rebAdApplyCancelMapper.selectByPrimaryKey(adCancelId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyCancelServiceImpl.getAdApplyCancelModelById", (Throwable)e);
            return null;
        }
    }

    private List<RebAdApplyCancelResp> queryAdApplyCancelModelPage(Map<String, Object> parammap) {
        try {
            return this.rebAdApplyCancelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyCancelServiceImpl.queryAdApplyCancelModel", (Throwable)e);
            return null;
        }
    }

    private int countAdApply(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebAdApplyCancelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyCancelServiceImpl.countAdApply", (Throwable)e);
        }
        return i;
    }

    private RebAdApplyCancelReq createRebAdApplyCancel(RebAdApplyCancelDomain rebAdApplyCancelDomain) {
        String msg = this.checkAdApply(rebAdApplyCancelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.rebAdApplyCancelDomain.checkAdApply", msg);
        }
        RebAdApplyCancelReq rebAdApplyCancelResp = this.makeAdApply(rebAdApplyCancelDomain, null);
        Date date = new Date();
        if (Objects.isNull(rebAdApplyCancelResp.getGmtCreate())) {
            rebAdApplyCancelResp.setGmtCreate(date);
        }
        if (StringUtils.isBlank((String)rebAdApplyCancelResp.getAdApplyCode())) {
            rebAdApplyCancelResp.setAdApplyCode(this.getNo(null, "RebAdApplyCancel", "RebAdApplyCancel", rebAdApplyCancelResp.getTenantCode()));
        }
        rebAdApplyCancelResp.setDataState(1);
        rebAdApplyCancelResp.setCreateTime(date);
        rebAdApplyCancelResp.setUpdateTime(date);
        return rebAdApplyCancelResp;
    }

    private RebAdApplyCancelReq makeAdApply(RebAdApplyCancelDomain rebAdApplyCancelDomain, RebAdApplyCancelReq adApplyCancelReq) {
        if (null == rebAdApplyCancelDomain) {
            return null;
        }
        if (null == adApplyCancelReq) {
            adApplyCancelReq = new RebAdApplyCancelReq();
        }
        try {
            BeanUtils.copyAllPropertys((Object)adApplyCancelReq, (Object)rebAdApplyCancelDomain);
            return adApplyCancelReq;
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyCancelServiceImpl.makeAdApply", (Throwable)e);
            return null;
        }
    }

    private String checkAdApply(RebAdApplyCancelDomain rebAdApplyCancelDomain) {
        if (null == rebAdApplyCancelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebAdApplyCancelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void saveRebAdApplyCancelModel(RebAdApplyCancelReq rebAdApplyCancelReq) throws ApiException {
        if (null == rebAdApplyCancelReq) {
            return;
        }
        try {
            this.rebAdApplyCancelMapper.insert(rebAdApplyCancelReq);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyCancelServiceImpl.saveAdApplyModel.ex", (Throwable)e);
        }
    }
}

