/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsShopMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsShopDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsShopReDomain;
import com.yqbsoft.laser.service.resources.model.RsGoodsShop;
import com.yqbsoft.laser.service.resources.service.RsGoodsShopService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsShopServiceImpl
extends BaseServiceImpl
implements RsGoodsShopService {
    private static final String SYS_CODE = "rs.RsGoodsShopServiceImpl";
    private RsGoodsShopMapper rsGoodsShopMapper;

    public void setRsGoodsShopMapper(RsGoodsShopMapper rsGoodsShopMapper) {
        this.rsGoodsShopMapper = rsGoodsShopMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsShopMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsShop(RsGoodsShopDomain rsGoodsShopDomain) {
        if (null == rsGoodsShopDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsGoodsShopDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGoodsShopDefault(RsGoodsShop rsGoodsShop) {
        if (null == rsGoodsShop) {
            return;
        }
        if (null == rsGoodsShop.getDataState()) {
            rsGoodsShop.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsGoodsShop.getGmtCreate()) {
            rsGoodsShop.setGmtCreate(date);
        }
        rsGoodsShop.setGmtModified(date);
        if (StringUtils.isBlank((String)rsGoodsShop.getGoodsShopCode())) {
            rsGoodsShop.setGoodsShopCode(this.getNo(null, "RsGoodsShop", "rsGoodsShop", rsGoodsShop.getTenantCode()));
        }
    }

    private int getGoodsShopMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsShopMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.getGoodsShopMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsShopUpdataDefault(RsGoodsShop rsGoodsShop) {
        if (null == rsGoodsShop) {
            return;
        }
        rsGoodsShop.setGmtModified(this.getSysDate());
    }

    private void saveGoodsShopModel(RsGoodsShop rsGoodsShop) throws ApiException {
        if (null == rsGoodsShop) {
            return;
        }
        try {
            this.rsGoodsShopMapper.insert(rsGoodsShop);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.saveGoodsShopModel.ex", (Throwable)e);
        }
    }

    private void saveGoodsShopBatchModel(List<RsGoodsShop> rsGoodsShopList) throws ApiException {
        if (null == rsGoodsShopList || rsGoodsShopList.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsShopMapper.insertBatch(rsGoodsShopList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.saveGoodsShopBatchModel.ex", (Throwable)e);
        }
    }

    private RsGoodsShop getGoodsShopModelById(Integer goodsShopId) {
        if (null == goodsShopId) {
            return null;
        }
        try {
            return this.rsGoodsShopMapper.selectByPrimaryKey(goodsShopId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.getGoodsShopModelById", (Throwable)e);
            return null;
        }
    }

    private RsGoodsShop getGoodsShopModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsShopMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.getGoodsShopModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGoodsShopModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsShopMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.delGoodsShopModelByCode.ex", (Throwable)e);
        }
    }

    protected void delGoodsShopModelByGoodsCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsShopMapper.delByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.delGoodsShopModelByGoodsCode.ex", (Throwable)e);
        }
    }

    private void deleteGoodsShopModel(Integer goodsShopId) throws ApiException {
        if (null == goodsShopId) {
            return;
        }
        try {
            this.rsGoodsShopMapper.deleteByPrimaryKey(goodsShopId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.deleteGoodsShopModel.ex", (Throwable)e);
        }
    }

    private void updateGoodsShopModel(RsGoodsShop rsGoodsShop) throws ApiException {
        if (null == rsGoodsShop) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsShopMapper.updateByPrimaryKey(rsGoodsShop);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.updateGoodsShopModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.updateGoodsShopModel.num");
        }
    }

    private void updateStateGoodsShopModel(Integer goodsShopId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsShopId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsShopId", goodsShopId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsShopMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.updateStateGoodsShopModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.updateStateGoodsShopModel.null");
        }
    }

    private void updateStateGoodsShopModelByCode(String tenantCode, String goodsShopCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsShopCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsShopCode", goodsShopCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsShopMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.updateStateGoodsShopModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.updateStateGoodsShopModelByCode.null");
        }
    }

    private RsGoodsShop makeGoodsShop(RsGoodsShopDomain rsGoodsShopDomain, RsGoodsShop rsGoodsShop) {
        if (null == rsGoodsShopDomain) {
            return null;
        }
        if (null == rsGoodsShop) {
            rsGoodsShop = new RsGoodsShop();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsShop, (Object)rsGoodsShopDomain);
            return rsGoodsShop;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.makeGoodsShop", (Throwable)e);
            return null;
        }
    }

    private RsGoodsShopReDomain makeRsGoodsShopReDomain(RsGoodsShop rsGoodsShop) {
        if (null == rsGoodsShop) {
            return null;
        }
        RsGoodsShopReDomain rsGoodsShopReDomain = new RsGoodsShopReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsShopReDomain, (Object)rsGoodsShop);
            return rsGoodsShopReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.makeRsGoodsShopReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsShop> queryGoodsShopModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsShopMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.queryGoodsShopModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsShop(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsShopMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.countGoodsShop", (Throwable)e);
        }
        return i;
    }

    private RsGoodsShop createRsGoodsShop(RsGoodsShopDomain rsGoodsShopDomain) {
        String msg = this.checkGoodsShop(rsGoodsShopDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.saveGoodsShop.checkGoodsShop", msg);
        }
        RsGoodsShop rsGoodsShop = this.makeGoodsShop(rsGoodsShopDomain, null);
        this.setGoodsShopDefault(rsGoodsShop);
        return rsGoodsShop;
    }

    @Override
    public String saveGoodsShop(RsGoodsShopDomain rsGoodsShopDomain) throws ApiException {
        RsGoodsShop rsGoodsShop = this.createRsGoodsShop(rsGoodsShopDomain);
        this.saveGoodsShopModel(rsGoodsShop);
        return rsGoodsShop.getGoodsShopCode();
    }

    @Override
    public String saveGoodsShopBatch(List<RsGoodsShopDomain> rsGoodsShopDomainList) throws ApiException {
        if (null == rsGoodsShopDomainList || rsGoodsShopDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsShop> rsGoodsShopList = new ArrayList<RsGoodsShop>();
        String code = "";
        for (RsGoodsShopDomain rsGoodsShopDomain : rsGoodsShopDomainList) {
            RsGoodsShop rsGoodsShop = this.createRsGoodsShop(rsGoodsShopDomain);
            code = rsGoodsShop.getGoodsShopCode();
            rsGoodsShopList.add(rsGoodsShop);
        }
        this.saveGoodsShopBatchModel(rsGoodsShopList);
        return code;
    }

    @Override
    public String saveGoodsShopBatchByGoodsCode(List<RsGoodsShopDomain> rsGoodsShopDomainList) throws ApiException {
        if (null == rsGoodsShopDomainList || rsGoodsShopDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsShop> rsGoodsShopList = new ArrayList<RsGoodsShop>();
        String code = "";
        StringBuilder stringBuffer = new StringBuilder("");
        HashMap<String, String> map = new HashMap<String, String>();
        for (RsGoodsShopDomain rsGoodsShopDomain : rsGoodsShopDomainList) {
            RsGoodsShop rsGoodsShop = this.createRsGoodsShop(rsGoodsShopDomain);
            code = rsGoodsShop.getGoodsShopCode();
            rsGoodsShopDomain.setGoodsShopCode(code);
            rsGoodsShopList.add(rsGoodsShop);
            if (!StringUtils.isNotBlank((String)rsGoodsShop.getGoodsCode()) || null != map.get(rsGoodsShopDomain.getGoodsCode())) continue;
            this.deleteGoodsShopByGoodsCode(rsGoodsShopDomain.getTenantCode(), rsGoodsShopDomain.getGoodsCode());
            map.put(rsGoodsShopDomain.getGoodsCode(), rsGoodsShopDomain.getGoodsCode());
            if (!StringUtils.isNotBlank((String)rsGoodsShop.getGoodsNo())) continue;
            stringBuffer.append(rsGoodsShopDomain.getGoodsNo());
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        this.saveGoodsShopBatchModel(rsGoodsShopList);
        return stringBuffer.toString();
    }

    @Override
    public String saveNewGoodsShopBatch(List<RsGoodsShopDomain> rsGoodsShopDomainList) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsShopDomainList)) {
            return null;
        }
        String code = "";
        ArrayList<RsGoodsShop> rsGoodsShopList = new ArrayList<RsGoodsShop>();
        for (RsGoodsShopDomain rsGoodsShopDomain : rsGoodsShopDomainList) {
            RsGoodsShop rsGoodsShop = this.createRsGoodsShop(rsGoodsShopDomain);
            code = rsGoodsShop.getGoodsShopCode();
            rsGoodsShopList.add(rsGoodsShop);
        }
        this.saveGoodsShopBatchModel(rsGoodsShopList);
        return code;
    }

    @Override
    public void updateGoodsShopState(Integer goodsShopId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == goodsShopId) {
            return;
        }
        this.updateStateGoodsShopModel(goodsShopId, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsShopStateByCode(String tenantCode, String goodsShopCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)goodsShopCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGoodsShopModelByCode(tenantCode, goodsShopCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsShop(RsGoodsShopDomain rsGoodsShopDomain) throws ApiException {
        String msg = this.checkGoodsShop(rsGoodsShopDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.updateGoodsShop.checkGoodsShop", msg);
        }
        RsGoodsShop oldRsGoodsShop = this.getGoodsShopModelById(rsGoodsShopDomain.getGoodsShopId());
        if (null == oldRsGoodsShop) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.updateGoodsShop.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsShop rsGoodsShop = this.makeGoodsShop(rsGoodsShopDomain, oldRsGoodsShop);
        this.setGoodsShopUpdataDefault(rsGoodsShop);
        this.updateGoodsShopModel(rsGoodsShop);
    }

    @Override
    public RsGoodsShop getGoodsShop(Integer goodsShopId) {
        if (null == goodsShopId) {
            return null;
        }
        return this.getGoodsShopModelById(goodsShopId);
    }

    @Override
    public void deleteGoodsShop(Integer goodsShopId) throws ApiException {
        if (null == goodsShopId) {
            return;
        }
        this.deleteGoodsShopModel(goodsShopId);
    }

    @Override
    public QueryResult<RsGoodsShop> queryGoodsShopPage(Map<String, Object> map) {
        List<RsGoodsShop> rsGoodsShopList = this.queryGoodsShopModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsShop(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsShopList);
        return queryResult;
    }

    @Override
    public RsGoodsShop getGoodsShopByCode(String tenantCode, String goodsShopCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsShopCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsShopCode", goodsShopCode);
        return this.getGoodsShopModelByCode(map);
    }

    @Override
    public List<RsGoodsShop> getGoodsShopByCodeWrite(String tenantCode, String goodsClassCode) {
        if (null == goodsClassCode) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsClassCode", goodsClassCode);
        return this.getInfuencerModelById(map);
    }

    private List<RsGoodsShop> getInfuencerModelById(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        try {
            return this.rsGoodsShopMapper.getByCodes(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsShopServiceImpl.getInfuencerModelById", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteGoodsShopByCode(String tenantCode, String goodsShopCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsShopCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsShopCode", goodsShopCode);
        this.delGoodsShopModelByCode(map);
    }

    @Override
    public void deleteGoodsShopByGoodsCode(String tenantCode, String goodsCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", goodsCode);
        List<RsGoodsShop> goodsShopList = this.queryGoodsShopModelPage(map);
        if (ListUtil.isEmpty(goodsShopList)) {
            return;
        }
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        for (RsGoodsShop rsGoodsShop : goodsShopList) {
            rmap.put("goodsShopCode", rsGoodsShop.getGoodsShopCode());
            rmap.put("tenantCode", rsGoodsShop.getTenantCode());
            this.delGoodsShopModelByCode(rmap);
        }
    }

    @Override
    public int deleteGoodsShopByMap(Map<String, Object> map) {
        int i = 0;
        if (null == map || map.isEmpty()) {
            return i;
        }
        if (map.get("skuCode") == null && map.get("skuNo") == null && map.get("goodsCode") == null && map.get("goodsNo") == null) {
            this.logger.error("rs.RsGoodsShopServiceImpl.deleteGoodsShopByMap", map);
            return i;
        }
        try {
            i = this.rsGoodsShopMapper.delByMap(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsShopServiceImpl.delGoodsShopModelByCode.ex", (Throwable)e);
        }
        return i;
    }
}

