/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsDeviceInfoMapper;
import com.yqbsoft.laser.service.resources.domain.RsDeviceInfoDomain;
import com.yqbsoft.laser.service.resources.domain.RsDeviceInfoReDomain;
import com.yqbsoft.laser.service.resources.model.RsDeviceInfo;
import com.yqbsoft.laser.service.resources.service.RsDeviceInfoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsDeviceInfoServiceImpl
extends BaseServiceImpl
implements RsDeviceInfoService {
    private static final String SYS_CODE = "rs.RsDeviceInfoServiceImpl";
    private RsDeviceInfoMapper rsDeviceInfoMapper;

    public void setRsDeviceInfoMapper(RsDeviceInfoMapper rsDeviceInfoMapper) {
        this.rsDeviceInfoMapper = rsDeviceInfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsDeviceInfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsDeviceInfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDeviceInfo(RsDeviceInfoDomain rsDeviceInfoDomain) {
        if (null == rsDeviceInfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsDeviceInfoDomain.getDeviceCode())) {
            msg = msg + "DeviceCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsDeviceInfoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDeviceInfoDefault(RsDeviceInfo rsDeviceInfo) {
        if (null == rsDeviceInfo) {
            return;
        }
        if (null == rsDeviceInfo.getDataState()) {
            rsDeviceInfo.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsDeviceInfo.getGmtCreate()) {
            rsDeviceInfo.setGmtCreate(date);
        }
        rsDeviceInfo.setGmtModified(date);
        if (StringUtils.isBlank((String)rsDeviceInfo.getTenantCode())) {
            rsDeviceInfo.setTenantCode(this.getNo(null, "RsDeviceInfo", "rsDeviceInfo", rsDeviceInfo.getTenantCode()));
        }
    }

    private int getDeviceInfoMaxCode() {
        int code = 0;
        try {
            return this.rsDeviceInfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsDeviceInfoServiceImpl.getDeviceInfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDeviceInfoUpdataDefault(RsDeviceInfo rsDeviceInfo) {
        if (null == rsDeviceInfo) {
            return;
        }
        rsDeviceInfo.setGmtModified(this.getSysDate());
    }

    private void saveDeviceInfoModel(RsDeviceInfo rsDeviceInfo) throws ApiException {
        if (null == rsDeviceInfo) {
            return;
        }
        try {
            this.rsDeviceInfoMapper.insert(rsDeviceInfo);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.saveDeviceInfoModel.ex", (Throwable)e);
        }
    }

    private void saveDeviceInfoBatchModel(List<RsDeviceInfo> rsDeviceInfoList) throws ApiException {
        if (null == rsDeviceInfoList || rsDeviceInfoList.isEmpty()) {
            return;
        }
        try {
            this.rsDeviceInfoMapper.insertBatch(rsDeviceInfoList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.saveDeviceInfoBatchModel.ex", (Throwable)e);
        }
    }

    private RsDeviceInfo getDeviceInfoModelById(Integer deviceId) {
        if (null == deviceId) {
            return null;
        }
        try {
            return this.rsDeviceInfoMapper.selectByPrimaryKey(deviceId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDeviceInfoServiceImpl.getDeviceInfoModelById", (Throwable)e);
            return null;
        }
    }

    private RsDeviceInfo getDeviceInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsDeviceInfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDeviceInfoServiceImpl.getDeviceInfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDeviceInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDeviceInfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.delDeviceInfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.delDeviceInfoModelByCode.num");
        }
    }

    private void deleteDeviceInfoModel(Integer deviceId) throws ApiException {
        if (null == deviceId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDeviceInfoMapper.deleteByPrimaryKey(deviceId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.deleteDeviceInfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.deleteDeviceInfoModel.num");
        }
    }

    private void updateDeviceInfoModel(RsDeviceInfo rsDeviceInfo) throws ApiException {
        if (null == rsDeviceInfo) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDeviceInfoMapper.updateByPrimaryKey(rsDeviceInfo);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.updateDeviceInfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.updateDeviceInfoModel.num");
        }
    }

    private void updateStateDeviceInfoModel(Integer deviceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == deviceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deviceId", deviceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsDeviceInfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.updateStateDeviceInfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.updateStateDeviceInfoModel.null");
        }
    }

    private void updateStateDeviceInfoModelByCode(String tenantCode, String deviceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)deviceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("deviceCode", deviceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsDeviceInfoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.updateStateDeviceInfoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.updateStateDeviceInfoModelByCode.null");
        }
    }

    private RsDeviceInfo makeDeviceInfo(RsDeviceInfoDomain rsDeviceInfoDomain, RsDeviceInfo rsDeviceInfo) {
        if (null == rsDeviceInfoDomain) {
            return null;
        }
        if (null == rsDeviceInfo) {
            rsDeviceInfo = new RsDeviceInfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsDeviceInfo, (Object)rsDeviceInfoDomain);
            return rsDeviceInfo;
        }
        catch (Exception e) {
            this.logger.error("rs.RsDeviceInfoServiceImpl.makeDeviceInfo", (Throwable)e);
            return null;
        }
    }

    private RsDeviceInfoReDomain makeRsDeviceInfoReDomain(RsDeviceInfo rsDeviceInfo) {
        if (null == rsDeviceInfo) {
            return null;
        }
        RsDeviceInfoReDomain rsDeviceInfoReDomain = new RsDeviceInfoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsDeviceInfoReDomain, (Object)rsDeviceInfo);
            return rsDeviceInfoReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsDeviceInfoServiceImpl.makeRsDeviceInfoReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsDeviceInfo> queryDeviceInfoModelPage(Map<String, Object> parammap) {
        try {
            return this.rsDeviceInfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDeviceInfoServiceImpl.queryDeviceInfoModel", (Throwable)e);
            return null;
        }
    }

    private int countDeviceInfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsDeviceInfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDeviceInfoServiceImpl.countDeviceInfo", (Throwable)e);
        }
        return i;
    }

    private RsDeviceInfo createRsDeviceInfo(RsDeviceInfoDomain rsDeviceInfoDomain) {
        String msg = this.checkDeviceInfo(rsDeviceInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.saveDeviceInfo.checkDeviceInfo", msg);
        }
        RsDeviceInfo rsDeviceInfo = this.makeDeviceInfo(rsDeviceInfoDomain, null);
        this.setDeviceInfoDefault(rsDeviceInfo);
        return rsDeviceInfo;
    }

    @Override
    public String saveDeviceInfo(RsDeviceInfoDomain rsDeviceInfoDomain) throws ApiException {
        RsDeviceInfo rsDeviceInfo = this.createRsDeviceInfo(rsDeviceInfoDomain);
        this.saveDeviceInfoModel(rsDeviceInfo);
        return rsDeviceInfo.getTenantCode();
    }

    @Override
    public String saveDeviceInfoBatch(List<RsDeviceInfoDomain> rsDeviceInfoDomainList) throws ApiException {
        if (null == rsDeviceInfoDomainList || rsDeviceInfoDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsDeviceInfo> rsDeviceInfoList = new ArrayList<RsDeviceInfo>();
        String code = "";
        for (RsDeviceInfoDomain rsDeviceInfoDomain : rsDeviceInfoDomainList) {
            RsDeviceInfo rsDeviceInfo = this.createRsDeviceInfo(rsDeviceInfoDomain);
            code = rsDeviceInfo.getTenantCode();
            rsDeviceInfoList.add(rsDeviceInfo);
        }
        this.saveDeviceInfoBatchModel(rsDeviceInfoList);
        return code;
    }

    @Override
    public void updateDeviceInfoState(Integer deviceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == deviceId) {
            return;
        }
        this.updateStateDeviceInfoModel(deviceId, dataState, oldDataState, map);
    }

    @Override
    public void updateDeviceInfoStateByCode(String tenantCode, String deviceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDeviceInfoModelByCode(tenantCode, deviceCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDeviceInfo(RsDeviceInfoDomain rsDeviceInfoDomain) throws ApiException {
        String msg = this.checkDeviceInfo(rsDeviceInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.updateDeviceInfo.checkDeviceInfo", msg);
        }
        RsDeviceInfo oldRsDeviceInfo = this.getDeviceInfoModelById(rsDeviceInfoDomain.getDeviceId());
        if (null == oldRsDeviceInfo) {
            throw new ApiException("rs.RsDeviceInfoServiceImpl.updateDeviceInfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsDeviceInfo rsDeviceInfo = this.makeDeviceInfo(rsDeviceInfoDomain, oldRsDeviceInfo);
        this.setDeviceInfoUpdataDefault(rsDeviceInfo);
        this.updateDeviceInfoModel(rsDeviceInfo);
    }

    @Override
    public RsDeviceInfo getDeviceInfo(Integer deviceId) {
        if (null == deviceId) {
            return null;
        }
        return this.getDeviceInfoModelById(deviceId);
    }

    @Override
    public void deleteDeviceInfo(Integer deviceId) throws ApiException {
        if (null == deviceId) {
            return;
        }
        this.deleteDeviceInfoModel(deviceId);
    }

    @Override
    public QueryResult<RsDeviceInfo> queryDeviceInfoPage(Map<String, Object> map) {
        List<RsDeviceInfo> rsDeviceInfoList = this.queryDeviceInfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDeviceInfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsDeviceInfoList);
        return queryResult;
    }

    @Override
    public RsDeviceInfo getDeviceInfoByCode(String tenantCode, String deviceCode) throws ApiException {
        if (StringUtils.isBlank((String)deviceCode) || StringUtils.isBlank((String)deviceCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("deviceCode", deviceCode);
        return this.getDeviceInfoModelByCode(map);
    }

    @Override
    public void deleteDeviceInfoByCode(String tenantCode, String deviceCode) throws ApiException {
        if (StringUtils.isBlank((String)deviceCode) || StringUtils.isBlank((String)deviceCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("deviceCode", deviceCode);
        this.delDeviceInfoModelByCode(map);
    }
}

