/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.index.StoreEnum;
import com.yqbsoft.laser.service.searchengine.util.ElasticConfig;
import com.yqbsoft.laser.service.searchengine.util.EshttpUtils;
import com.yqbsoft.laser.service.searchengine.util.HttpClientPoolHelper;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"elasticConfig"})
public class EsUtil {
    private static final SupperLogUtil logger = new SupperLogUtil(EsUtil.class);
    private static HttpClientPoolHelper httpcph = HttpClientPoolHelper.getInstance();
    private static String bash_searchurl;
    private static String bash_user;
    private static String bash_pw;
    @Autowired
    private ElasticConfig elasticConfig;
    private static RestHighLevelClient highLevelClient;
    private static Object lock;

    public static void main(String[] args) {
        try {
            System.out.println(EshttpUtils.processPostJson("http://www.baidu.com", null, null, null, "TLSv1.2"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean bluk(List<StoreDomain> storeDomainList) {
        String queryParamJson = "";
        BulkRequest request = new BulkRequest();
        Date starDate = new Date();
        Date endDate = new Date();
        logger.info("es111-\u5f00\u59cb\u65f6\u95f4\uff1a" + starDate);
        try {
            this.initBash();
            for (StoreDomain storeDomain : storeDomainList) {
                String data = storeDomain.getTenantCode();
                String requestType = storeDomain.getRequestType();
                String id = storeDomain.getBizId();
                if (StringUtils.isBlank((String)id)) {
                    return false;
                }
                String type = storeDomain.getBizType();
                if (StringUtils.isBlank((String)type)) {
                    return false;
                }
                if (StringUtils.isNotBlank((String)data)) {
                    data = data.toLowerCase();
                }
                if (StringUtils.isNotBlank((String)type)) {
                    type = type.toLowerCase();
                }
                String index = data + "-" + type;
                queryParamJson = "";
                if (null != storeDomain.getStoreObj()) {
                    queryParamJson = (String)storeDomain.getStoreObj();
                }
                if (StoreEnum.INSERT.getType().equals(requestType) || StoreEnum.SKUINSERT.getType().equals(requestType) || StoreEnum.SKUADD.getType().equals(requestType)) {
                    if (StringUtils.isBlank((String)queryParamJson)) {
                        logger.error("es.bluk.queryParamJson.insert", (Object)(index + "=" + id));
                        return false;
                    }
                    request.add(new IndexRequest(index, type, id).source(queryParamJson, XContentType.JSON));
                    logger.debug("es.bluk.queryParamJson.insert", (Object)(index + "=" + id));
                    continue;
                }
                if (StoreEnum.ESUPDATE.getType().equals(requestType) || StoreEnum.UPDATE.getType().equals(requestType) || StoreEnum.EDIT.getType().equals(requestType)) {
                    if (StringUtils.isBlank((String)queryParamJson)) {
                        logger.error("es.bluk.queryParamJson.update.null", (Object)(index + "=" + id));
                        return false;
                    }
                    request.add(new UpdateRequest(index, type, id).doc(queryParamJson, XContentType.JSON));
                    logger.debug("es.bluk.queryParamJson.update", (Object)(index + "=" + id));
                    continue;
                }
                if (StoreEnum.DELETE.getType().equals(requestType) || StoreEnum.DELETEOP.getType().equals(requestType) || StoreEnum.SKUDELETE.getType().equals(requestType) || StoreEnum.SKUDELETEOP.getType().equals(requestType) || StoreEnum.SKUDOWN.getType().equals(requestType) || StoreEnum.DOWN.getType().equals(requestType)) {
                    request.add(new DeleteRequest(index, type, id));
                    continue;
                }
                logger.error("es.bluk.type", (Object)(requestType + "=" + storeDomain.getBizId()));
                return true;
            }
            endDate = new Date();
            long time = endDate.getTime() - starDate.getTime();
            logger.info("es111-\u7ed3\u675f\u65f6\u95f4\uff1a" + endDate + "\uff0c\u8017\u65f6\uff1a" + time);
            request.timeout(TimeValue.timeValueSeconds((long)30L));
            request.waitForActiveShards(ActiveShardCount.ALL);
            starDate = new Date();
            logger.info("es222-\u5f00\u59cb\u65f6\u95f4\uff1a" + starDate);
            BulkResponse bulkResponse = highLevelClient.bulk(request, RequestOptions.DEFAULT);
            endDate = new Date();
            time = endDate.getTime() - starDate.getTime();
            logger.info("es222-\u7ed3\u675f\u65f6\u95f4\uff1a" + endDate + "\uff0c\u8017\u65f6\uff1a" + time);
            if (null == bulkResponse) {
                logger.error("es.bluk.null");
                return false;
            }
            if (bulkResponse.hasFailures()) {
                logger.error("es.bluk.error", (Object)bulkResponse.buildFailureMessage());
            }
            return true;
        }
        catch (Exception e) {
            logger.error("es.bluk.e", (Throwable)e);
            return false;
        }
    }

    public boolean customDeleteCondition(Map map) {
        this.initBash();
        String indexValue = String.valueOf(map.get("index"));
        if (StringUtils.isBlank((String)indexValue)) {
            logger.error("es.customDeleteCondition.params", (Object)"index is null");
            return false;
        }
        String conditionTypeValue = String.valueOf(map.get("conditionType"));
        map.remove("index");
        map.remove("conditionType");
        if (map.isEmpty()) {
            logger.error("es.customDeleteCondition.params", (Object)"params is null");
            return false;
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        map.forEach((key, value) -> {
            TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)(key + ".keyword"), (Object)value);
            if (StringUtils.isNotBlank((String)conditionTypeValue) && "must".equals(conditionTypeValue)) {
                queryBuilder.must((QueryBuilder)termQueryBuilder);
            } else {
                queryBuilder.should((QueryBuilder)termQueryBuilder);
            }
        });
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest();
        deleteByQueryRequest.setQuery((QueryBuilder)queryBuilder);
        deleteByQueryRequest.indices(new String[]{indexValue});
        try {
            BulkByScrollResponse bulkByScrollResponse = highLevelClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            long deleted = bulkByScrollResponse.getDeleted();
            logger.info("deleteByQuery " + deleted + " rows data from " + indexValue + " index.");
            return true;
        }
        catch (IOException e) {
            logger.error("es.deleteByQuery.e", (Object)"=", (Throwable)e);
            return false;
        }
    }

    private static HttpHost makeHttpHost(String s) {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        String[] address = s.split(":");
        String scheme = address[0];
        String ip = address[1].substring(2);
        int port = Integer.parseInt(address[2]);
        return new HttpHost(ip, port, scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBash() {
        if (null != highLevelClient) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (null != highLevelClient) {
                return;
            }
            try {
                bash_searchurl = this.elasticConfig.getUrl();
                bash_user = this.elasticConfig.getUsername();
                bash_pw = this.elasticConfig.getPassword();
                bash_pw = URLDecoder.decode(bash_pw, "UTF-8");
                logger.error("httpUrlInsert resourceBundle.usr1", (Object)(bash_user + "=" + bash_pw));
                String enpasswd = bash_pw;
                String[] split = bash_searchurl.split(",");
                HttpHost[] httpHostArray = new HttpHost[split.length];
                for (int i = 0; i < split.length; ++i) {
                    String item = split[i];
                    httpHostArray[i] = new HttpHost(item.split(":")[1].replace("//", ""), Integer.parseInt(item.split(":")[2].replace("/", "")), item.split(":")[0]);
                }
                SSLContext sslContext = null;
                try {
                    sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
                }
                catch (Exception e) {
                    logger.error("es.initBash.e", (Throwable)e);
                }
                final SSLContext finalSslContext = sslContext;
                RestClientBuilder builder = RestClient.builder((HttpHost[])httpHostArray);
                builder.setRequestConfigCallback(requestConfigBuilder -> {
                    requestConfigBuilder.setConnectTimeout(this.elasticConfig.getConnectTimeoutMillis());
                    requestConfigBuilder.setSocketTimeout(this.elasticConfig.getSocketTimeoutMillis());
                    requestConfigBuilder.setConnectionRequestTimeout(this.elasticConfig.getConnectionRequestTimeoutMillis());
                    return requestConfigBuilder;
                });
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                if (StringUtils.isNotBlank((String)enpasswd)) {
                    logger.error("httpUrlInsert resourceBundle.enpasswd", (Object)(bash_user + "=" + enpasswd));
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(bash_user, enpasswd));
                }
                builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        httpClientBuilder.disableAuthCaching();
                        httpClientBuilder.setMaxConnTotal(EsUtil.this.elasticConfig.getMaxConnectTotal());
                        httpClientBuilder.setMaxConnPerRoute(EsUtil.this.elasticConfig.getMaxConnectPerRoute());
                        httpClientBuilder.setSSLContext(finalSslContext);
                        httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
                highLevelClient = new RestHighLevelClient(builder);
            }
            catch (Exception e) {
                logger.error("httpUrlInsert resourceBundle.getString() Exception:", (Throwable)e);
            }
        }
    }

    public String httpUrlPoolGetByCode(String data, String type, String opcode) {
        if (StringUtils.isBlank((String)data) || StringUtils.isBlank((String)opcode)) {
            logger.error("httpUrlInsert.httpUrlPoolGetByCode.null");
            return null;
        }
        this.initBash();
        GetRequest request = new GetRequest(data + "-" + type, type, opcode);
        try {
            GetResponse response = highLevelClient.get(request, RequestOptions.DEFAULT);
            return response.getSourceAsString();
        }
        catch (IOException e) {
            logger.error("httpUrlInsert.httpUrlPoolGetByCode.e", (Throwable)e);
            return null;
        }
    }

    public SearchResponse queryEs(String data, String type, SearchSourceBuilder builder) {
        if (StringUtils.isBlank((String)data)) {
            logger.error("httpUrlInsert.queryEs.null");
            return null;
        }
        this.initBash();
        SearchRequest request = new SearchRequest();
        request.indices(new String[]{data + "-" + type});
        request.types(new String[]{type});
        request.source(builder);
        try {
            return highLevelClient.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.error("httpUrlInsert.queryEs.e", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String httpUrlPoolGetByCodeOld(String data, String type, String opcode) throws IOException {
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        this.initBash();
        String searchurl = bash_searchurl;
        String user = bash_user;
        String pw = bash_pw;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + opcode;
            logger.debug("esEsUtil.httpUrlPoolGetByCode", (Object)("searchurl:" + searchurl));
        }
        try {
            logger.debug("es.httpUrlPoolGetByCode", (Object)("searchurl:" + searchurl + ", opcode:" + opcode));
            String input = "";
            if (StringUtils.isNotBlank((String)pw)) {
                input = user + ":" + pw;
            }
            String string = httpcph.getRequest(searchurl, input);
            return string;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlPoolGetByCode.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpUrlPoolGet(String data, String type, String queryParamJson) throws IOException {
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        this.initBash();
        String searchurl = bash_searchurl;
        String user = bash_user;
        String pw = bash_pw;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/_search";
            logger.debug("es.EsUtil.httpUrlPoolGet", (Object)("searchurl:" + searchurl));
        }
        if (null == queryParamJson) {
            queryParamJson = "";
        }
        try {
            String input = "";
            if (StringUtils.isNotBlank((String)pw)) {
                input = user + ":" + pw;
            }
            logger.debug("es.find", (Object)("searchurl:" + searchurl + ", queryParamJson:" + queryParamJson));
            String string = httpcph.postRequest(searchurl, queryParamJson, input);
            return string;
        }
        catch (Exception e) {
            logger.error("es.EsUtil.httpUrlGet.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpUrlGet(String data, String type, String queryParamJson) throws IOException {
        String method = "GET";
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        this.initBash();
        String searchurl = bash_searchurl;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/_search";
            logger.info("EsUtil.httpUrlGet.searchurl", (Object)searchurl);
        }
        StringBuilder resultBuilder = new StringBuilder();
        if (null == queryParamJson) {
            queryParamJson = "";
        }
        try {
            String line;
            URL url = new URL(searchurl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method.toUpperCase());
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            conn.setRequestProperty("Content-Length", Integer.toString(queryParamJson.getBytes().length));
            conn.setRequestProperty("Content-Language", "zh-cn");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            if (StringUtils.isNotBlank((String)queryParamJson)) {
                out = conn.getOutputStream();
                out.write(queryParamJson.getBytes());
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                resultBuilder.append(line);
                resultBuilder.append('\r');
            }
            String string = resultBuilder.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public HttpsURLConnection getEsSSL(String method, String data, String type, String id, Integer len) {
        this.initBash();
        String searchurl = bash_searchurl;
        String username = bash_user;
        String password = bash_pw;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + id;
        }
        if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
            method = "POST";
            searchurl = searchurl + "/_update";
        }
        String input = "";
        if (StringUtils.isNotBlank((String)password)) {
            input = username + ":" + password;
        }
        HttpURLConnection connHttps = null;
        String protocol = "TLSv1.2";
        try {
            URL url = new URL(searchurl);
            if ("https".equals(url.getProtocol())) {
                SSLContext ctx = null;
                try {
                    if (StringUtils.isBlank((String)protocol)) {
                        protocol = "TLS";
                    }
                    ctx = SSLContext.getInstance(protocol);
                    ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                connHttps = (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)connHttps).setSSLSocketFactory(ctx.getSocketFactory());
                ((HttpsURLConnection)connHttps).setHostnameVerifier(new EshttpUtils.TrustAnyHostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            if (StringUtils.isNotBlank((String)password)) {
                input = username + ":" + password;
            }
            if (StringUtils.isNotBlank((String)input)) {
                Base64 base = new Base64();
                String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                connHttps.setRequestProperty("Authorization", "Basic " + encodedPassword);
            }
            connHttps.setRequestMethod(method.toUpperCase());
            connHttps.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connHttps.setRequestProperty("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
            connHttps.setUseCaches(false);
            connHttps.setDoOutput(true);
            connHttps.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
            logger.error("=========", (Object)searchurl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connHttps;
    }

    public HttpURLConnection getEs(String method, String data, String type, String id, Integer len) {
        this.initBash();
        String searchurl = bash_searchurl;
        if (StringUtils.isBlank((String)searchurl)) {
            logger.error("EsUtil.getEs.searchurl");
        }
        String username = bash_user;
        String password = bash_pw;
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + id;
        }
        if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
            method = "POST";
            searchurl = searchurl + "/_update";
        }
        String input = "";
        if (StringUtils.isNotBlank((String)password)) {
            input = username + ":" + password;
        }
        HttpURLConnection connHttps = null;
        try {
            URL url = new URL(searchurl);
            if (!"https".equals(url.getProtocol())) {
                connHttps = (HttpURLConnection)url.openConnection();
            }
            if (StringUtils.isNotBlank((String)password)) {
                input = username + ":" + password;
            }
            if (StringUtils.isNotBlank((String)input)) {
                Base64 base = new Base64();
                String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                connHttps.setRequestProperty("Authorization", "Basic " + encodedPassword);
            }
            connHttps.setRequestMethod(method.toUpperCase());
            connHttps.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connHttps.setRequestProperty("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
            connHttps.setUseCaches(false);
            connHttps.setDoOutput(true);
            connHttps.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        }
        catch (Exception e) {
            logger.error("====e=====", (Throwable)e);
        }
        return connHttps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void httpUrlInsert(String dataParamJson, String method, String data, String type, String id) throws Exception {
        if (null == dataParamJson) {
            dataParamJson = "";
        }
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        String searchurl = "";
        try {
            String responseResult;
            if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
                dataParamJson = "{\"doc\":" + dataParamJson + "}";
            }
            if ("DELETE".equals(method.toUpperCase())) {
                dataParamJson = "";
            }
            this.initBash();
            searchurl = bash_searchurl;
            if (StringUtils.isBlank((String)searchurl)) {
                logger.error("EsUtil.getEs.searchurl");
            }
            String username = bash_user;
            String password = bash_pw;
            if (StringUtils.isNotBlank((String)searchurl)) {
                searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + id;
            }
            if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
                method = "POST";
                searchurl = searchurl + "/_update";
            }
            String input = "";
            if (StringUtils.isNotBlank((String)password)) {
                input = username + ":" + password;
            }
            if (!StringUtils.isNotBlank((String)(responseResult = httpcph.postRequest(searchurl, dataParamJson, "application/json;charset=UTF-8", input)))) {
                logger.error("es.httpUrlInsert.error", (Object)(searchurl + "=" + method.toUpperCase() + "==" + responseResult));
                throw new ApiException("es", "Failed : HTTP error code : " + responseResult);
            }
            logger.info("es.httpUrlInsert.sucess", (Object)(searchurl + "=" + method.toUpperCase()));
        }
        catch (ApiException e) {
            logger.error("es.apiException", (Object)(searchurl + "=" + method.toUpperCase() + "="), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("es.exception", (Object)(searchurl + "=" + method.toUpperCase() + "="), (Throwable)e);
        }
    }

    static {
        lock = new Object();
    }

    private class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

