/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userrights.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userrights.dao.UrUserruleMapper;
import com.yqbsoft.laser.service.userrights.domain.UrUserruleDomain;
import com.yqbsoft.laser.service.userrights.domain.UrUserruleReDomain;
import com.yqbsoft.laser.service.userrights.model.UrUserrule;
import com.yqbsoft.laser.service.userrights.service.UrUserruleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UrUserruleServiceImpl
extends BaseServiceImpl
implements UrUserruleService {
    private static final String SYS_CODE = "ur.UrUserruleServiceImpl";
    private UrUserruleMapper urUserruleMapper;

    public void setUrUserruleMapper(UrUserruleMapper urUserruleMapper) {
        this.urUserruleMapper = urUserruleMapper;
    }

    private Date getSysDate() {
        try {
            return this.urUserruleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserruleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserrule(UrUserruleDomain urUserruleDomain) {
        if (null == urUserruleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)urUserruleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserruleDefault(UrUserrule urUserrule) {
        if (null == urUserrule) {
            return;
        }
        if (null == urUserrule.getDataState()) {
            urUserrule.setDataState(0);
        }
        if (null == urUserrule.getGmtCreate()) {
            urUserrule.setGmtCreate(this.getSysDate());
        }
        urUserrule.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)urUserrule.getUserruleCode())) {
            urUserrule.setUserruleCode(this.createUUIDString());
        }
    }

    private int getUserruleMaxCode() {
        int code = 0;
        try {
            return this.urUserruleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserruleServiceImpl.getUserruleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserruleUpdataDefault(UrUserrule urUserrule) {
        if (null == urUserrule) {
            return;
        }
        urUserrule.setGmtModified(this.getSysDate());
    }

    private void saveUserruleModel(UrUserrule urUserrule) throws ApiException {
        if (null == urUserrule) {
            return;
        }
        try {
            this.urUserruleMapper.insert(urUserrule);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserruleServiceImpl.saveUserruleModel.ex", (Throwable)e);
        }
    }

    private void saveUserruleBatchModel(List<UrUserrule> urUserruleList) throws ApiException {
        if (null == urUserruleList || urUserruleList.isEmpty()) {
            return;
        }
        try {
            this.urUserruleMapper.insertBatch(urUserruleList);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserruleServiceImpl.saveUserruleBatchModel.ex", (Throwable)e);
        }
    }

    private UrUserrule getUserruleModelById(Integer userruleId) {
        if (null == userruleId) {
            return null;
        }
        try {
            return this.urUserruleMapper.selectByPrimaryKey(userruleId);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserruleServiceImpl.getUserruleModelById", (Throwable)e);
            return null;
        }
    }

    private UrUserrule getUserruleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.urUserruleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserruleServiceImpl.getUserruleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserruleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserruleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserruleServiceImpl.delUserruleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserruleServiceImpl.delUserruleModelByCode.num");
        }
    }

    private void deleteUserruleModel(Integer userruleId) throws ApiException {
        if (null == userruleId) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserruleMapper.deleteByPrimaryKey(userruleId);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserruleServiceImpl.deleteUserruleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserruleServiceImpl.deleteUserruleModel.num");
        }
    }

    private void updateUserruleModel(UrUserrule urUserrule) throws ApiException {
        if (null == urUserrule) {
            return;
        }
        int i = 0;
        try {
            i = this.urUserruleMapper.updateByPrimaryKeySelective(urUserrule);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserruleServiceImpl.updateUserruleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ur.UrUserruleServiceImpl.updateUserruleModel.num");
        }
    }

    private void updateStateUserruleModel(Integer userruleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userruleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userruleId", userruleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.urUserruleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserruleServiceImpl.updateStateUserruleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ur.UrUserruleServiceImpl.updateStateUserruleModel.null");
        }
    }

    private void updateStateUserruleModelByCode(String tenantCode, String userruleCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)userruleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userruleCode", userruleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.urUserruleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ur.UrUserruleServiceImpl.updateStateUserruleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ur.UrUserruleServiceImpl.updateStateUserruleModelByCode.null");
        }
    }

    private UrUserrule makeUserrule(UrUserruleDomain urUserruleDomain, UrUserrule urUserrule) {
        if (null == urUserruleDomain) {
            return null;
        }
        if (null == urUserrule) {
            urUserrule = new UrUserrule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)urUserrule, (Object)urUserruleDomain);
            return urUserrule;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserruleServiceImpl.makeUserrule", (Throwable)e);
            return null;
        }
    }

    private UrUserruleReDomain makeUrUserruleReDomain(UrUserrule urUserrule) {
        if (null == urUserrule) {
            return null;
        }
        UrUserruleReDomain urUserruleReDomain = new UrUserruleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)urUserruleReDomain, (Object)urUserrule);
            return urUserruleReDomain;
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserruleServiceImpl.makeUrUserruleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UrUserrule> queryUserruleModelPage(Map<String, Object> parammap) {
        try {
            return this.urUserruleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserruleServiceImpl.queryUserruleModel", (Throwable)e);
            return null;
        }
    }

    private int countUserrule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.urUserruleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ur.UrUserruleServiceImpl.countUserrule", (Throwable)e);
        }
        return i;
    }

    private UrUserrule createUrUserrule(UrUserruleDomain urUserruleDomain) {
        String msg = this.checkUserrule(urUserruleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ur.UrUserruleServiceImpl.saveUserrule.checkUserrule", msg);
        }
        UrUserrule urUserrule = this.makeUserrule(urUserruleDomain, null);
        this.setUserruleDefault(urUserrule);
        return urUserrule;
    }

    @Override
    public String saveUserrule(UrUserruleDomain urUserruleDomain) throws ApiException {
        UrUserrule urUserrule = this.createUrUserrule(urUserruleDomain);
        this.saveUserruleModel(urUserrule);
        return urUserrule.getUserruleCode();
    }

    @Override
    public String saveUserruleBatch(List<UrUserruleDomain> urUserruleDomainList) throws ApiException {
        if (null == urUserruleDomainList || urUserruleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UrUserrule> urUserruleList = new ArrayList<UrUserrule>();
        String code = "";
        for (UrUserruleDomain urUserruleDomain : urUserruleDomainList) {
            UrUserrule urUserrule = this.createUrUserrule(urUserruleDomain);
            code = urUserrule.getUserruleCode();
            urUserruleList.add(urUserrule);
        }
        this.saveUserruleBatchModel(urUserruleList);
        return code;
    }

    @Override
    public void updateUserruleState(Integer userruleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserruleModel(userruleId, dataState, oldDataState);
    }

    @Override
    public void updateUserruleStateByCode(String tenantCode, String userruleCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserruleModelByCode(tenantCode, userruleCode, dataState, oldDataState);
    }

    @Override
    public void updateUserrule(UrUserruleDomain urUserruleDomain) throws ApiException {
        String msg = this.checkUserrule(urUserruleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ur.UrUserruleServiceImpl.updateUserrule.checkUserrule", msg);
        }
        UrUserrule oldUrUserrule = this.getUserruleModelById(urUserruleDomain.getUserruleId());
        if (null == oldUrUserrule) {
            throw new ApiException("ur.UrUserruleServiceImpl.updateUserrule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UrUserrule urUserrule = this.makeUserrule(urUserruleDomain, oldUrUserrule);
        this.setUserruleUpdataDefault(urUserrule);
        this.updateUserruleModel(urUserrule);
    }

    @Override
    public UrUserrule getUserrule(Integer userruleId) {
        return this.getUserruleModelById(userruleId);
    }

    @Override
    public void deleteUserrule(Integer userruleId) throws ApiException {
        this.deleteUserruleModel(userruleId);
    }

    @Override
    public QueryResult<UrUserrule> queryUserrulePage(Map<String, Object> map) {
        List<UrUserrule> urUserruleList = this.queryUserruleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserrule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(urUserruleList);
        return queryResult;
    }

    @Override
    public UrUserrule getUserruleByCode(String tenantCode, String userruleCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userruleCode", userruleCode);
        return this.getUserruleModelByCode(map);
    }

    @Override
    public void deleteUserruleByCode(String tenantCode, String userruleCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userruleCode", userruleCode);
        this.delUserruleModelByCode(map);
    }
}

