/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.ches.EsSendEnginePutThread;
import com.yqbsoft.laser.service.warehouse.ches.SendPutThread;
import com.yqbsoft.laser.service.warehouse.domain.OcContractDomain;
import com.yqbsoft.laser.service.warehouse.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.OcRefundDomain;
import com.yqbsoft.laser.service.warehouse.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.warehouse.domain.ParamsUtils;
import com.yqbsoft.laser.service.warehouse.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.RsSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.warehouse.domain.StockDomain;
import com.yqbsoft.laser.service.warehouse.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.warehouse.domain.WhChannelsendDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhChannelsendlistDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkuNumBean;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhDomain;
import com.yqbsoft.laser.service.warehouse.model.RsGoodsRel;
import com.yqbsoft.laser.service.warehouse.model.RsSku;
import com.yqbsoft.laser.service.warehouse.model.WhChannelsend;
import com.yqbsoft.laser.service.warehouse.model.WhChannelsendlist;
import com.yqbsoft.laser.service.warehouse.model.WhStoreSku;
import com.yqbsoft.laser.service.warehouse.model.WhWarehouse;
import com.yqbsoft.laser.service.warehouse.service.WhChannelsendService;
import com.yqbsoft.laser.service.warehouse.service.WhChannelsendlistService;
import com.yqbsoft.laser.service.warehouse.service.WhOpstoreService;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsBaseService;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsService;
import com.yqbsoft.laser.service.warehouse.service.WhWarehouseService;
import com.yqbsoft.laser.service.warehouse.service.impl.WhChannelsendServiceImpl;
import com.yqbsoft.laser.service.warehouse.service.impl.WhChannelsendlistServiceImpl;
import com.yqbsoft.laser.service.warehouse.util.WarehouseUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhStoreGoodsBaseServiceImpl
extends BaseServiceImpl
implements WhStoreGoodsBaseService {
    private static final String SYS_CODE = "wh.WhStoreGoodsBaseServiceImpl";
    WhStoreGoodsService whStoreGoodsService;
    private WhChannelsendService whChannelsendService;
    private WhChannelsendlistService whChannelsendlistService;
    private WhOpstoreService whOpstoreService;
    WhWarehouseService whWarehouseService;

    public void setWhWarehouseService(WhWarehouseService whWarehouseService) {
        this.whWarehouseService = whWarehouseService;
    }

    public void setWhChannelsendService(WhChannelsendService whChannelsendService) {
        this.whChannelsendService = whChannelsendService;
    }

    public void setWhChannelsendlistService(WhChannelsendlistService whChannelsendlistService) {
        this.whChannelsendlistService = whChannelsendlistService;
    }

    public void setWhStoreGoodsService(WhStoreGoodsService whStoreGoodsService) {
        this.whStoreGoodsService = whStoreGoodsService;
    }

    public void setWhOpstoreService(WhOpstoreService whOpstoreService) {
        this.whOpstoreService = whOpstoreService;
    }

    @Override
    public String sendSaveStoreGoodsBatch(List<WhStoreGoodsDomain> whStoreGoodsDomainList) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whStoreGoodsService.saveStoreGoodsBatch(whStoreGoodsDomainList);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
        return "";
    }

    @Override
    public String sendUpdateStoreSkuNum(List<WhStoreSkuNumBean> whStoreSkuNumBeanList) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whStoreGoodsService.updateStoreSkuNum(whStoreSkuNumBeanList);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
        return "";
    }

    @Override
    public void sendSaveSendChannelsend(WhStoreSku whStoreSku) {
        this.whStoreGoodsService.saveSendChannelsend(whStoreSku);
    }

    @Override
    public void sendSavechannelsendBatch(List<WhChannelsendDomain> whChannelsendDomainList) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whChannelsendService.saveChannelsendBatch(whChannelsendDomainList);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
    }

    @Override
    public void sendSavechannelsendlistBatch(List<WhChannelsendlistDomain> whChannelsendlistDomainList) throws ApiException {
        this.whChannelsendlistService.saveChannelsendlistBatch(whChannelsendlistDomainList);
    }

    @Override
    public void sendSaveChannelsend(WhChannelsend whChannelsend) {
        List<WhChannelsendlist> whChannelsendlistList = this.whChannelsendService.saveSendChannelsend(whChannelsend);
        if (ListUtil.isNotEmpty(whChannelsendlistList)) {
            WhChannelsendlistServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(WhChannelsendlistServiceImpl.getEsSendEngineService(), whChannelsendlistList));
        }
    }

    @Override
    public String sendUpdateSkuLockNum(StockDomain stockDomain) {
        if (null == stockDomain) {
            return "error";
        }
        ArrayList<StockDomain> stockDomainList = new ArrayList<StockDomain>();
        stockDomainList.add(stockDomain);
        try {
            List<WhChannelsend> whChannelsendList = this.whStoreGoodsService.updateSkuLockNum(stockDomainList);
            if (ListUtil.isNotEmpty(whChannelsendList)) {
                WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
            }
            return "success";
        }
        catch (Exception e) {
            return "error";
        }
    }

    @Override
    public String sendUpdateSkuOutNum(List<StockDomain> stockDomainList) {
        try {
            List<WhChannelsend> whChannelsendList = this.whStoreGoodsService.updateSkuLockNum(stockDomainList);
            if (ListUtil.isNotEmpty(whChannelsendList)) {
                WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
            }
            if (ListUtil.isEmpty(whChannelsendList)) {
                return "error";
            }
        }
        catch (Exception e) {
            return "error";
        }
        return "success";
    }

    @Override
    public void sendSaveWhOpstoreBatch(List<WhOpstoreDomain> whOpstoreDomainList) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whOpstoreService.saveOpstoreBatch(whOpstoreDomainList);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
    }

    @Override
    public String sendSaveOpstore(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whOpstoreService.saveOpstore(whOpstoreDomain);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
        return whOpstoreDomain.getOpstoreCode();
    }

    @Override
    public String sendSaveOpstoreTwo(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whOpstoreService.saveOpstoreTwo(whOpstoreDomain);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
        return whOpstoreDomain.getOpstoreCode();
    }

    @Override
    public String sendSaveSggoods(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (null == sgSendgoodsReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoods.null", (Object)"param is null");
            return "error";
        }
        try {
            WhOpstoreDomain whOpstoreDomain = this.makeWhOpstoreDomain(sgSendgoodsReDomain, "1", "X1");
            this.sendSaveOpstore(whOpstoreDomain);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoods.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveSggoodsLockOut(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (null == sgSendgoodsReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsLockOut.null", (Object)"param is null");
            return "error";
        }
        try {
            WhOpstoreDomain whOpstoreDomain = this.makeWhOpstoreDomain(sgSendgoodsReDomain, "5", "X1");
            this.sendSaveOpstore(whOpstoreDomain);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsLockOut.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveSggoodsLock(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (null == sgSendgoodsReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsLock.null", (Object)"param is null");
            return "error";
        }
        try {
            WhOpstoreDomain whOpstoreDomain = this.makeWhOpstoreDomain(sgSendgoodsReDomain, "4", "X3");
            this.sendSaveOpstore(whOpstoreDomain);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsLock.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendOcRefundOut(OcRefundReDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendOcRefundOut.null", (Object)"param is null");
            return "error";
        }
        try {
            WhOpstoreDomain whOpstoreDomain = this.makeWhOpstoreDomain(ocRefundDomain, "1", "0", "0", "X1");
            String eStr = this.checkWhData(whOpstoreDomain);
            if (StringUtils.isNotBlank((String)eStr)) {
                this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendOcRefundOut.checkWhData.e", (Object)eStr);
                return "error";
            }
            this.sendSaveOpstore(whOpstoreDomain);
        }
        catch (ApiException e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendOcRefundOut.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendOcRefund(OcRefundReDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendOcRefund.null", (Object)"param is null");
            return "error";
        }
        try {
            WhOpstoreDomain whOpstoreDomain = this.makeWhOpstoreDomain(ocRefundDomain, "1", "0", "1", "X2");
            String eStr = this.checkWhData(whOpstoreDomain);
            if (StringUtils.isNotBlank((String)eStr)) {
                this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendOcRefund.checkWhData.e", (Object)eStr);
                return "error";
            }
            this.sendSaveOpstore(whOpstoreDomain);
        }
        catch (ApiException e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendOcRefund.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendOcContractIn(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendOcContractIn.null", (Object)"param is null");
            return "error";
        }
        try {
            ocContractDomain.setMemberCode(ocContractDomain.getMemberBcode());
            ocContractDomain.setMemberName(ocContractDomain.getMemberBname());
            this.makeWhOpstoreDomain(ocContractDomain, "1", "R1");
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendOcContractIn.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveSggoodsIn(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (null == sgSendgoodsReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsIn.null", (Object)"param is null");
            return "error";
        }
        try {
            sgSendgoodsReDomain.setMemberCode(sgSendgoodsReDomain.getMemberBcode());
            sgSendgoodsReDomain.setMemberName(sgSendgoodsReDomain.getMemberBname());
            WhOpstoreDomain whOpstoreDomain = this.makeWhOpstoreDomain(sgSendgoodsReDomain, "1", "R1");
            this.sendSaveOpstore(whOpstoreDomain);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsIn.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendRefundContractLock(OcRefundDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendContractLock.null", (Object)"param is null");
            return "error";
        }
        try {
            this.makeRefundWhOpstoreDomain(ocRefundDomain, "1", "X2");
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendContractLock.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public WhStoreSku getContractGoodsByWhStoreSku(OcContractGoodsDomain ocContractGoodsDomain, String contractType) {
        if (null == ocContractGoodsDomain || StringUtils.isBlank((String)contractType)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.getContractGoodsByWhStoreSku", (Object)("contractType" + contractType + "ocContractGoodsDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain)));
            return null;
        }
        UmUserinfoDomainBean umUserinfoDomainBean = null;
        umUserinfoDomainBean = this.makeUmuserinfo(ocContractGoodsDomain);
        if (null == umUserinfoDomainBean) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.getContractGoodsByWhStoreSku", (Object)("getContractGoodsByWhStoreSku" + ocContractGoodsDomain.getMemberBcode()));
            return null;
        }
        ocContractGoodsDomain.setContractType(contractType);
        WarehouseUtil warehouseUtil = new WarehouseUtil();
        WhUserwhDomain whUserwhDomain = warehouseUtil.makeWhUserwh(ocContractGoodsDomain, umUserinfoDomainBean);
        if (null == whUserwhDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.getContractGoodsByWhStoreSku", (Object)("umUserinfoDomainBean" + JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean) + "ocContractGoodsDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain)));
            return null;
        }
        ocContractGoodsDomain.setWarehouseCode(whUserwhDomain.getWarehouseCode());
        return this.getWhStoreSku(ocContractGoodsDomain);
    }

    private WhStoreSku getWhStoreSku(OcContractGoodsDomain ocContractGoodsDomain) {
        QueryResult queryStoreSkuPage;
        WhStoreSku whStoreSku = null;
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuNo())) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> whStoreSkuMap = new HashMap<String, String>();
            map.put("warehouseCode", ocContractGoodsDomain.getWarehouseCode());
            map.put("skuNo", ocContractGoodsDomain.getSkuNo());
            map.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            map.put("storeType", "0");
            whStoreSkuMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
            queryStoreSkuPage = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", whStoreSkuMap, WhStoreSku.class);
            if (queryStoreSkuPage == null || ListUtil.isEmpty((Collection)queryStoreSkuPage.getList())) {
                this.logger.error("wh.WhStoreGoodsBaseServiceImpl.getWhStoreSku", (Object)("getWhStoreSku" + whStoreSkuMap));
                return null;
            }
        } else {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.getWhStoreSku", (Object)("ocContractGoodsDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain)));
            return null;
        }
        whStoreSku = (WhStoreSku)queryStoreSkuPage.getList().get(0);
        return whStoreSku;
    }

    @Override
    public String sendContractLock(OcContractDomain ocContractReDomain) throws ApiException {
        if (null == ocContractReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendContractLock.null", (Object)"param is null");
            return "error";
        }
        try {
            this.makeWhOpstoreDomain(ocContractReDomain, "3", "X3");
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendContractLock.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendCancelContractLock(OcContractDomain ocContractReDomain) throws ApiException {
        if (null == ocContractReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendContractLock.null", (Object)"param is null");
            return "error";
        }
        try {
            this.makeWhOpstoreDomain(ocContractReDomain, "4", "R3");
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendContractLock.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    private String checkWhData(WhOpstoreDomain whOpstoreDomain) {
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList;
        String eStr = "";
        if (null == whOpstoreDomain) {
            return "checkWhData.param is null";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode())) {
            eStr = eStr + "warehouseCode.null;";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
            eStr = eStr + "storeGoodsBtype.null;";
        }
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return eStr + "whOpstoreGoodsDomainList.null;";
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                eStr = eStr + whOpstoreGoodsDomain.getGoodsNo() + ":whOpstoreSkuDomainList.null;";
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsNo())) {
                eStr = eStr + whOpstoreGoodsDomain.getGoodsNo() + ":goodsNo.null;";
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getWarehouseCode())) {
                    eStr = eStr + whOpstoreGoodsDomain.getGoodsNo() + ":warehouseCode.null;";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getStoreWhlocal())) {
                    eStr = eStr + whOpstoreGoodsDomain.getGoodsNo() + ":storeWhlocal.null;";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuBarcode())) {
                    eStr = eStr + whOpstoreGoodsDomain.getGoodsNo() + ":skuBarcode.null;";
                }
                if (!StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) continue;
                eStr = eStr + whOpstoreGoodsDomain.getGoodsNo() + ":skuNo.null;";
            }
        }
        return eStr;
    }

    private WhOpstoreDomain makeWhOpstoreDomain(OcRefundReDomain ocRefundDomain, String StoreGoodsType, String storeType, String opstoreDir, String storeGoodsBtype) {
        if (null == ocRefundDomain || ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return null;
        }
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreDomain, (Object)ocRefundDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
        whOpstoreDomain.setStoreGoodsType(StoreGoodsType);
        whOpstoreDomain.setStoreType(storeType);
        whOpstoreDomain.setOpstoreOcode(ocRefundDomain.getRefundCode());
        whOpstoreDomain.setOpstoreNcode(ocRefundDomain.getContractBillcode());
        whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        ArrayList<OcRefundGoodsDomain> goodsList = new ArrayList<OcRefundGoodsDomain>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            if (!StringUtils.isBlank((Integer)ocRefundGoodsDomain.getRefundGoodsType()) && 0 != ocRefundGoodsDomain.getRefundGoodsType()) continue;
            if (StringUtils.isBlank((String)ocRefundGoodsDomain.getGoodsPro())) {
                ocRefundGoodsDomain.setGoodsPro("");
            }
            if ("5".equals(ocRefundGoodsDomain.getGoodsPro())) continue;
            goodsList.add(ocRefundGoodsDomain);
        }
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList");
        }
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(goodsList));
        this.assMap(contractGoodsList, map);
        map.keySet().stream().forEach(key -> {
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            this.assWhOpstoreGoodsDomain(((JSONArray)map.get(key)).get(0), whOpstoreGoodsDomainList, whOpstoreGoodsDomain);
            ((JSONArray)map.get(key)).forEach(cg -> this.assWhOpstoreSkuDomain((JSONObject)cg, (List<WhOpstoreSkuDomain>)whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain, opstoreDir));
            whOpstoreGoodsDomain.setOpstoreDir(opstoreDir);
            whOpstoreGoodsDomain.setStoreType(storeType);
            whOpstoreGoodsDomain.setStoreGoodsType(StoreGoodsType);
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.whOpstoreSkuDomainList", (Object)map);
                throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.whOpstoreSkuDomainList");
            }
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        });
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.whOpstoreGoodsDomainList", map);
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.whOpstoreGoodsDomainList");
        }
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.checkGoodsClass(whOpstoreDomain);
        return whOpstoreDomain;
    }

    private void assRefundData(OcRefundReDomain ocRefundDomain) {
        List sgSendgoodsGoodsDomains;
        if (null == ocRefundDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.assRefundData", (Object)"param is null");
            throw new ApiException("assRefundData.param is null");
        }
        List<SgSendgoodsGoodsDomain> queryDbSendGoodsList = this.querySgSendGoods(ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode());
        if (ListUtil.isEmpty(queryDbSendGoodsList)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.assRefundData", (Object)"param is null");
            throw new ApiException("assRefundData.\u67e5\u8be2\u53d1\u8d27\u5355\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomains = new ArrayList<OcRefundGoodsDomain>();
        HashMap sgGoodsListMap = new HashMap();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : queryDbSendGoodsList) {
            String contractGoodsCode = sgSendgoodsGoodsDomain.getContractGoodsCode();
            if (sgGoodsListMap.containsKey(contractGoodsCode)) {
                ((List)sgGoodsListMap.get(contractGoodsCode)).add(sgSendgoodsGoodsDomain);
                continue;
            }
            sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
            sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDomain);
            sgGoodsListMap.put(contractGoodsCode, sgSendgoodsGoodsDomains);
        }
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        if (ListUtil.isNotEmpty(ocRefundGoodsDomainList)) {
            block5: for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
                if ("5".equals(ocRefundGoodsDomain.getGoodsPro())) continue;
                sgSendgoodsGoodsDomains = (List)sgGoodsListMap.get(ocRefundGoodsDomain.getContractGoodsCode());
                if (ListUtil.isEmpty(sgSendgoodsGoodsDomains)) {
                    this.logger.error("wh.WhStoreGoodsBaseServiceImplsgGoodsListMap.null", (Object)JsonUtil.buildNormalBinder().toJson(sgGoodsListMap));
                    throw new ApiException(ocRefundGoodsDomain.getContractGoodsCode() + "\u672a\u627e\u5230\u53d1\u8d27\u5355\u6570\u636e");
                }
                if (sgSendgoodsGoodsDomains.size() >= 2) {
                    BigDecimal sgGoodsNum = BigDecimal.ZERO;
                    for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsGoodsDomains) {
                        sgGoodsNum = sgGoodsNum.add(null == sgSendgoodsGoodsDomain.getGoodsTopnum() ? BigDecimal.ZERO : sgSendgoodsGoodsDomain.getGoodsTopnum());
                    }
                    if (sgGoodsNum.compareTo(ocRefundGoodsDomain.getRefundGoodsNum()) == 0) {
                        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsGoodsDomains) {
                            try {
                                OcRefundGoodsDomain ocRefundGoods = new OcRefundGoodsDomain();
                                BeanUtils.copyAllPropertys((Object)ocRefundGoods, (Object)ocRefundGoodsDomain);
                                ocRefundGoods.setWarehouseCode(sgSendgoodsGoodsDomain.getWarehouseCode());
                                ocRefundGoods.setWarehouseName(sgSendgoodsGoodsDomain.getWarehouseName());
                                ocRefundGoods.setMemberContact("2002");
                                ocRefundGoods.setMemberContactQq(sgSendgoodsGoodsDomain.getMemberContactQq());
                                ocRefundGoods.setGoodsTopnum(sgSendgoodsGoodsDomain.getGoodsTopnum());
                                ocRefundGoods.setGoodsTopweight(sgSendgoodsGoodsDomain.getGoodsTopweight());
                                ocRefundGoodsDomains.add(ocRefundGoods);
                            }
                            catch (Exception exception) {}
                        }
                        continue;
                    }
                    BigDecimal refundGoodsNum = ocRefundGoodsDomain.getRefundGoodsNum();
                    BigDecimal refundGoodsWeight = ocRefundGoodsDomain.getRefundGoodsWeight();
                    for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsGoodsDomains) {
                        try {
                            OcRefundGoodsDomain ocRefundGoods = new OcRefundGoodsDomain();
                            BeanUtils.copyAllPropertys((Object)ocRefundGoods, (Object)ocRefundGoodsDomain);
                            ocRefundGoods.setWarehouseCode(sgSendgoodsGoodsDomain.getWarehouseCode());
                            ocRefundGoods.setWarehouseName(sgSendgoodsGoodsDomain.getWarehouseName());
                            ocRefundGoods.setMemberContact("2002");
                            ocRefundGoods.setMemberContactQq(sgSendgoodsGoodsDomain.getMemberContactQq());
                            if (refundGoodsNum.subtract(sgSendgoodsGoodsDomain.getGoodsTopnum()).compareTo(BigDecimal.ZERO) >= 0) {
                                ocRefundGoods.setGoodsTopnum(sgSendgoodsGoodsDomain.getGoodsTopnum());
                                ocRefundGoods.setGoodsTopweight(sgSendgoodsGoodsDomain.getGoodsTopweight());
                                refundGoodsNum = refundGoodsNum.subtract(sgSendgoodsGoodsDomain.getGoodsTopnum());
                                refundGoodsWeight = refundGoodsWeight.subtract(sgSendgoodsGoodsDomain.getGoodsTopweight());
                                ocRefundGoodsDomains.add(ocRefundGoods);
                                continue;
                            }
                            ocRefundGoods.setGoodsTopnum(refundGoodsNum);
                            ocRefundGoods.setGoodsTopweight(refundGoodsWeight);
                            ocRefundGoodsDomains.add(ocRefundGoods);
                            continue block5;
                        }
                        catch (Exception exception) {
                        }
                    }
                    continue;
                }
                SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = (SgSendgoodsGoodsDomain)sgSendgoodsGoodsDomains.get(0);
                ocRefundGoodsDomain.setWarehouseCode(sgSendgoodsGoodsDomain.getWarehouseCode());
                ocRefundGoodsDomain.setWarehouseName(sgSendgoodsGoodsDomain.getWarehouseName());
                ocRefundGoodsDomain.setMemberContact("2002");
                ocRefundGoodsDomain.setMemberContactQq(sgSendgoodsGoodsDomain.getMemberContactQq());
                ocRefundGoodsDomain.setGoodsTopnum(ocRefundGoodsDomain.getRefundGoodsNum());
                ocRefundGoodsDomain.setGoodsTopweight(ocRefundGoodsDomain.getRefundGoodsWeight());
                ocRefundGoodsDomains.add(ocRefundGoodsDomain);
            }
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomains);
    }

    private List<SgSendgoodsGoodsDomain> querySgSendGoods(final String contractBillcode, final String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.querySgSendGoods", (Object)("param is null:" + contractBillcode + "-" + tenantCode));
            throw new ApiException("querySgSendGoods.param is null");
        }
        final HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("contractBillcode", contractBillcode);
                this.put("contractGoodsType", "0");
                this.put("tenantCode", tenantCode);
            }
        };
        HashMap<String, Object> sendMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)paramMap));
            }
        };
        QueryResult queryResutl = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", sendMap, SgSendgoodsGoodsDomain.class);
        if (null != queryResutl && ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
            return queryResutl.getList();
        }
        return null;
    }

    private WhOpstoreDomain makeWhOpstoreDomain(SgSendgoodsReDomain sgSendgoodsReDomain, String storeGoodsType, String storeGoodsBtype) {
        if (null == sgSendgoodsReDomain || ListUtil.isEmpty(sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList())) {
            return null;
        }
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreDomain, (Object)sgSendgoodsReDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
        whOpstoreDomain.setStoreGoodsType(storeGoodsType);
        whOpstoreDomain.setStoreType("0");
        whOpstoreDomain.setOpstoreOcode(sgSendgoodsReDomain.getSendgoodsCode());
        whOpstoreDomain.setOpstoreNcode(sgSendgoodsReDomain.getContractBillcode());
        whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        ArrayList<SgSendgoodsGoodsDomain> goodsList = new ArrayList<SgSendgoodsGoodsDomain>();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList()) {
            if (!StringUtils.isBlank((Integer)sgSendgoodsGoodsDomain.getContractGoodsType()) && 0 != sgSendgoodsGoodsDomain.getContractGoodsType()) continue;
            if (StringUtils.isBlank((String)sgSendgoodsGoodsDomain.getGoodsPro())) {
                sgSendgoodsGoodsDomain.setGoodsPro("");
            }
            if ("5".equals(sgSendgoodsGoodsDomain.getGoodsPro())) continue;
            goodsList.add(sgSendgoodsGoodsDomain);
        }
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain));
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList");
        }
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(goodsList));
        this.assMap(contractGoodsList, map);
        map.keySet().stream().forEach(key -> {
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            this.assWhOpstoreGoodsDomain(((JSONArray)map.get(key)).get(0), whOpstoreGoodsDomainList, whOpstoreGoodsDomain);
            ((JSONArray)map.get(key)).forEach(cg -> this.assWhOpstoreSkuDomain((JSONObject)cg, (List<WhOpstoreSkuDomain>)whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain, "0"));
            whOpstoreGoodsDomain.setOpstoreDir("0");
            whOpstoreGoodsDomain.setStoreType("0");
            whOpstoreGoodsDomain.setStoreGoodsType("1");
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        });
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.logger.info("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.domain1", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        this.checkGoodsClass(whOpstoreDomain);
        this.logger.info("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.domain2", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        return whOpstoreDomain;
    }

    private UmUserinfoDomainBean checkUmuserinfo(OcContractDomain ocContractReDomain) {
        UmUserinfoDomainBean userinfoDomainBean = null;
        if (!EmptyUtil.isEmpty((Object)ocContractReDomain) && StringUtils.isNotBlank((String)ocContractReDomain.getMemberBcode())) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("userinfoCode", ocContractReDomain.getMemberBcode());
            userMap.put("tenantCode", ocContractReDomain.getTenantCode());
            String UmUserJson = this.internalInvoke("um.userbase.getUserinfoByCode", userMap);
            if (StringUtils.isBlank((String)UmUserJson)) {
                throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList-------" + JsonUtil.buildNonDefaultBinder().toJson(userMap));
            }
            userinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(UmUserJson, UmUserinfoDomainBean.class);
        }
        return userinfoDomainBean;
    }

    private void makeWhOpstoreDomain(OcContractDomain ocContractReDomain, String storeGoodsType, String storeGoodsBtype) {
        WarehouseUtil warehouseUtil;
        if (null == ocContractReDomain || ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl\u8ba2\u5355\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ArrayList goodsList = new ArrayList();
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        ArrayList<OcContractGoodsDomain> ocContractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
            if (!"1".equals(storeGoodsType) && StringUtils.equals((CharSequence)"1", (CharSequence)ocContractGoodsDomain.getContractGoodsGtype()) || StringUtils.equals((CharSequence)"5", (CharSequence)ocContractGoodsDomain.getGoodsType())) continue;
            if (StringUtils.isBlank((Integer)ocContractGoodsDomain.getContractGoodsType())) {
                ocContractGoodsDomain.setContractGoodsType(0);
            }
            if (3 != ocContractGoodsDomain.getContractGoodsType() && 0 != ocContractGoodsDomain.getContractGoodsType()) continue;
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsPro())) {
                ocContractGoodsDomain.setGoodsPro("");
            }
            if (!"5".equals(ocContractGoodsDomain.getGoodsPro())) {
                warehouseUtil = new WarehouseUtil();
                whOpstoreDomain = this.makeWhOpstoreDomainMap(ocContractReDomain, ocContractGoodsDomain, null, storeGoodsType, storeGoodsBtype);
                if (null == whOpstoreDomain) continue;
                this.sendSaveOpstore(whOpstoreDomain);
                continue;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            HashMap<String, String> relMap = new HashMap<String, String>();
            paramMap.put("goodsCode", ocContractGoodsDomain.getGoodsCode());
            paramMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            relMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
            QueryResult goodsRelQueryResult = this.sendReSupObject("rs.goodsOther.queryGoodsRelPage", relMap, RsGoodsRel.class);
            if (!ListUtil.isNotEmpty((Collection)goodsRelQueryResult.getList())) continue;
            for (RsGoodsRel rsGoodsRel : goodsRelQueryResult.getList()) {
                OcContractGoodsDomain occontractGoodsDomain = new OcContractGoodsDomain();
                HashMap<String, String> skuNoMap = new HashMap<String, String>();
                HashMap<String, String> skuNoMapStr = new HashMap<String, String>();
                skuNoMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
                skuNoMap.put("skuCode", rsGoodsRel.getSkuCode());
                skuNoMapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(skuNoMap));
                String s = this.internalInvoke("rs.sku.getSkuByCode", skuNoMapStr);
                RsSku rsSku = (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(s, RsSku.class);
                if (null == rsSku) {
                    this.logger.error("wh.WhStoreGoodsBaseServiceImpl.SaveSplitContract.rsSku", (Object)"rsSku is null");
                    throw new ApiException("wh.WhStoreGoodsBaseServiceImpl\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
                }
                try {
                    BeanUtils.copyAllPropertys((Object)occontractGoodsDomain, (Object)rsSku);
                }
                catch (Exception e) {
                    throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.contractSgOccontractReDomain.copyStr", (Throwable)e);
                }
                occontractGoodsDomain.setMemberBcode(ocContractReDomain.getMemberBcode());
                occontractGoodsDomain.setGoodsCamount(rsGoodsRel.getGoodsRelNum().multiply(ocContractGoodsDomain.getGoodsCamount()));
                occontractGoodsDomain.setGoodsNum(rsGoodsRel.getGoodsRelNum().multiply(ocContractGoodsDomain.getGoodsCamount()));
                ocContractGoodsDomain.setPricesetNprice(rsGoodsRel.getPricesetNprice());
                ocContractGoodsDomainList.add(occontractGoodsDomain);
            }
        }
        if (ListUtil.isNotEmpty(ocContractGoodsDomainList)) {
            ocContractReDomain.setGoodsList(ocContractGoodsDomainList);
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                ocContractGoodsDomain.setChannelCode(null);
                warehouseUtil = new WarehouseUtil();
                whOpstoreDomain = this.makeWhOpstoreDomainMap(ocContractReDomain, ocContractGoodsDomain, null, storeGoodsType, storeGoodsBtype);
                if (null == whOpstoreDomain) continue;
                this.sendSaveOpstore(whOpstoreDomain);
            }
        }
    }

    private void makeRefundWhOpstoreDomain(OcRefundDomain ocRefundDomain, String storeGoodsType, String storeGoodsBtype) {
        if (null == ocRefundDomain || ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl\u8ba2\u5355\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ocRefundDomain.setChannelCode(null);
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            whOpstoreDomain = this.makeRefundWhOpstoreDomainMap(ocRefundDomain, ocRefundGoodsDomain, null, storeGoodsType, storeGoodsBtype);
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.whOpstoreDomain-------" + JsonUtil.buildNonDefaultBinder().toJson((Object)whOpstoreDomain));
            if (null == whOpstoreDomain) continue;
            this.sendSaveOpstore(whOpstoreDomain);
        }
    }

    private WhOpstoreDomain makeWhOpstoreDomainMap(OcContractDomain ocContractReDomain, OcContractGoodsDomain ocContractGoodsDomain, WhUserwhDomain whUserwhDomain, String storeGoodsType, String storeGoodsBtype) {
        String PreSaleWarehouse;
        String DistributionWarehouse;
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreDomain, (Object)ocContractReDomain);
            whOpstoreDomain.setChannelCode(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whOpstoreDomain.setChannelCode(ocContractReDomain.getChannelCode());
        whOpstoreDomain.setChannelName(ocContractReDomain.getChannelName());
        whOpstoreDomain.setCheckGiftGoods(false);
        whOpstoreDomain.setTenantCode(ocContractReDomain.getTenantCode());
        whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
        whOpstoreDomain.setStoreGoodsType(storeGoodsType);
        whOpstoreDomain.setStoreType("0");
        whOpstoreDomain.setDataState(ocContractReDomain.getDataState());
        whOpstoreDomain.setOpstoreOcode(ocContractReDomain.getContractBillcode());
        whOpstoreDomain.setOpstoreNcode(ocContractReDomain.getContractBillcode());
        whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
        UmUserinfoDomainBean umUserinfoDomainBean = null;
        umUserinfoDomainBean = this.makeUmuserinfo(ocContractGoodsDomain);
        if (null == umUserinfoDomainBean) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomainMap", (Object)("sgOccontractReDomain" + ocContractGoodsDomain.getMemberBcode()));
            return null;
        }
        WarehouseUtil warehouseUtil = new WarehouseUtil();
        ocContractGoodsDomain.setContractType(ocContractReDomain.getContractType());
        whUserwhDomain = warehouseUtil.makeWhUserwh(ocContractGoodsDomain, umUserinfoDomainBean);
        if (null == whUserwhDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.ocContractGoodsDomain", (Object)("ocContractGoodsDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain) + "umUserinfoDomainBean" + JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean)));
            whUserwhDomain = new WhUserwhDomain();
            whUserwhDomain.setWarehouseCode(whOpstoreDomain.getMemberCode());
            whUserwhDomain.setWarehouseName(whOpstoreDomain.getMemberName());
        } else {
            ocContractGoodsDomain.setWarehouseCode(whUserwhDomain.getWarehouseCode());
            ocContractGoodsDomain.setWarehouseName(whUserwhDomain.getWarehouseName());
        }
        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomainMap.warehouseCode" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoodsDomain.getWarehouseCode()));
        String url = WhStoreGoodsBaseServiceImpl.getUrl(ocContractGoodsDomain.getTenantCode(), "NewWarehouse", "NewWarehouse");
        if (StringUtils.isNotBlank((String)url) && ocContractReDomain.getContractType().equals(url)) {
            WhStoreSku whStoreSku = this.checkWarehouseInfoMap(ocContractGoodsDomain, "1");
            if (null != whStoreSku) {
                ocContractGoodsDomain.setWarehouseCode(whStoreSku.getWarehouseCode());
                ocContractGoodsDomain.setWarehouseName(whStoreSku.getWarehouseName());
                whOpstoreDomain.setStoreType("1");
            } else {
                this.logger.error(SYS_CODE, (Object)".whWarehouse\u67e5\u8be2\u4e0d\u5230\u65b0\u5e97\u4ed3");
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)(DistributionWarehouse = WhStoreGoodsBaseServiceImpl.getUrl(ocContractGoodsDomain.getTenantCode(), "DistributionWarehouse", "DistributionWarehouse"))) && ocContractReDomain.getContractType().equals(DistributionWarehouse)) {
            WhStoreSku whStoreSku = this.checkWarehouseInfoMap(ocContractGoodsDomain, "2");
            if (null != whStoreSku) {
                ocContractGoodsDomain.setWarehouseCode(whStoreSku.getWarehouseCode());
                ocContractGoodsDomain.setWarehouseName(whStoreSku.getWarehouseName());
                whOpstoreDomain.setStoreType("2");
            } else {
                this.logger.error(SYS_CODE, (Object)".whWarehouse\u67e5\u8be2\u4e0d\u5230\u5206\u8d27\u4ed3");
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)(PreSaleWarehouse = WhStoreGoodsBaseServiceImpl.getUrl(ocContractGoodsDomain.getTenantCode(), "PreSaleWarehouse", "PreSaleWarehouse"))) && ocContractReDomain.getContractType().equals(PreSaleWarehouse)) {
            WhStoreSku whStoreSku = this.checkWarehouseInfoMap(ocContractGoodsDomain, "2");
            if (null != whStoreSku) {
                ocContractGoodsDomain.setWarehouseCode(whStoreSku.getWarehouseCode());
                ocContractGoodsDomain.setWarehouseName(whStoreSku.getWarehouseName());
                whOpstoreDomain.setStoreType("2");
            } else {
                this.logger.error(SYS_CODE, (Object)".whWarehouse\u67e5\u8be2\u4e0d\u5230\u5206\u8d27\u4ed3");
                return null;
            }
        }
        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomainMap.warehouseCodeStr" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoodsDomain.getWarehouseCode()));
        goodsList.add(ocContractGoodsDomain);
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList");
        }
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(goodsList));
        this.assMap(contractGoodsList, map);
        map.keySet().stream().forEach(key -> {
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            this.assWhOpstoreGoodsDomain(((JSONArray)map.get(key)).get(0), whOpstoreGoodsDomainList, whOpstoreGoodsDomain);
            whOpstoreGoodsDomain.setChannelCode(whOpstoreDomain.getChannelCode());
            whOpstoreGoodsDomain.setChannelName(whOpstoreDomain.getChannelName());
            whOpstoreGoodsDomain.setMemberCode(whOpstoreDomain.getMemberCode());
            whOpstoreGoodsDomain.setMemberName(whOpstoreDomain.getMemberName());
            whOpstoreGoodsDomain.setMemberBcode(whOpstoreDomain.getMemberBcode());
            whOpstoreGoodsDomain.setMemberBname(whOpstoreDomain.getMemberBname());
            if (whOpstoreDomain.getStoreGoodsType().equals("0") || whOpstoreDomain.getStoreGoodsType().equals("4") || whOpstoreDomain.getStoreGoodsType().equals("1")) {
                whOpstoreGoodsDomain.setOpstoreDir("1");
            } else {
                whOpstoreGoodsDomain.setOpstoreDir("0");
            }
            ((JSONArray)map.get(key)).forEach(cg -> this.assWhOpstoreSkuDomain((JSONObject)cg, (List<WhOpstoreSkuDomain>)whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain, whOpstoreGoodsDomain.getOpstoreDir()));
            whOpstoreGoodsDomain.setStoreGoodsBtype(storeGoodsBtype);
            whOpstoreGoodsDomain.setStoreType(whOpstoreDomain.getStoreType());
            whOpstoreGoodsDomain.setStoreGoodsType(storeGoodsType);
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        });
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.checkGoodsClassMap(whUserwhDomain, whOpstoreDomain);
        this.logger.info("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.domain2", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        return whOpstoreDomain;
    }

    private WhOpstoreDomain makeRefundWhOpstoreDomainMap(OcRefundDomain ocContractReDomain, OcRefundGoodsDomain ocContractGoodsDomain, WhUserwhDomain whUserwhDomain, String storeGoodsType, String storeGoodsBtype) {
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreDomain, (Object)ocContractReDomain);
            whOpstoreDomain.setChannelCode(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OcContractDomain ocContractDomain = this.getOccontract(ocContractReDomain);
        whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
        if (ocContractDomain.getDataState() >= 3) {
            whOpstoreDomain.setStoreGoodsType(storeGoodsType);
        } else {
            whOpstoreDomain.setStoreGoodsType("4");
        }
        whOpstoreDomain.setStoreType("0");
        whOpstoreDomain.setOpstoreOcode(ocContractReDomain.getContractBillcode());
        whOpstoreDomain.setOpstoreNcode(ocContractReDomain.getContractBillcode());
        whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        ArrayList<OcRefundGoodsDomain> goodsList = new ArrayList<OcRefundGoodsDomain>();
        UmUserinfoDomainBean umUserinfoDomainBean = null;
        umUserinfoDomainBean = this.makeUmuserinfo(ocContractGoodsDomain);
        if (null == umUserinfoDomainBean) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomainMap", (Object)("sgOccontractReDomain" + ocContractGoodsDomain.getMemberBcode()));
            return null;
        }
        WarehouseUtil warehouseUtil = new WarehouseUtil();
        whUserwhDomain = warehouseUtil.makeRefundWhUserwh(ocContractGoodsDomain, umUserinfoDomainBean);
        if (null == whUserwhDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.ocContractGoodsDomain", (Object)("ocContractGoodsDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain) + "umUserinfoDomainBean" + JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean)));
            return null;
        }
        if (ocContractDomain.getDataState() >= 3) {
            ocContractGoodsDomain.setWarehouseCode(whUserwhDomain.getCompanyCode());
        } else {
            ocContractGoodsDomain.setWarehouseCode(whUserwhDomain.getWarehouseCode());
        }
        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomainMap.warehouseCode" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoodsDomain.getWarehouseCode()));
        String url = WhStoreGoodsBaseServiceImpl.getUrl(ocContractGoodsDomain.getTenantCode(), "NewWarehouse", "NewWarehouse");
        if (StringUtils.isNotBlank((String)url) && ocContractReDomain.getContractType().equals(url)) {
            WhStoreSku whStoreSku = this.checkWarehouseInfoMap(ocContractGoodsDomain);
            if (null != whStoreSku) {
                ocContractGoodsDomain.setWarehouseCode(whStoreSku.getWarehouseCode());
                ocContractGoodsDomain.setWarehouseName(whStoreSku.getWarehouseName());
                whOpstoreDomain.setStoreType("1");
            } else {
                this.logger.error(SYS_CODE, (Object)".whWarehouse\u67e5\u8be2\u4e0d\u5230\u65b0\u5e97\u4ed3");
                return null;
            }
        }
        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomainMap.warehouseCodeStr" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoodsDomain.getWarehouseCode()));
        goodsList.add(ocContractGoodsDomain);
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList");
        }
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(goodsList));
        this.assMap(contractGoodsList, map);
        map.keySet().stream().forEach(key -> {
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            this.assWhOpstoreGoodsDomain(((JSONArray)map.get(key)).get(0), whOpstoreGoodsDomainList, whOpstoreGoodsDomain);
            if (ocContractDomain.getDataState() >= 3) {
                whOpstoreGoodsDomain.setOpstoreDir("1");
            } else {
                whOpstoreGoodsDomain.setOpstoreDir("0");
            }
            ((JSONArray)map.get(key)).forEach(cg -> this.assWhOpstoreSkuDomain((JSONObject)cg, (List<WhOpstoreSkuDomain>)whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain, whOpstoreGoodsDomain.getOpstoreDir()));
            if (ocContractDomain.getDataState() >= 3) {
                whOpstoreGoodsDomain.setStoreGoodsBtype(storeGoodsBtype);
            } else {
                whOpstoreGoodsDomain.setStoreGoodsBtype("4");
            }
            whOpstoreGoodsDomain.setStoreType(whOpstoreDomain.getStoreType());
            whOpstoreGoodsDomain.setStoreGoodsType(storeGoodsType);
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        });
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.checkGoodsClassMap(whUserwhDomain, whOpstoreDomain);
        this.logger.info("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.domain2", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        return whOpstoreDomain;
    }

    public OcContractDomain getOccontract(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        map.put("contractBillcode", ocRefundDomain.getContractBillcode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        OcContractDomain contract = (OcContractDomain)this.getForObject("oc.contract.getContractByCode", OcContractDomain.class, invokeMap);
        if (null == contract) {
            new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728" + JsonUtil.buildNonDefaultBinder().toJson(invokeMap));
        }
        return contract;
    }

    public static String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    private WhStoreSku checkWarehouseInfoMap(OcContractGoodsDomain ocContractGoodsDomain, String storeType) {
        WhStoreSku whStoreSku = null;
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuNo())) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> whStoreSkuMap = new HashMap<String, String>();
            map.put("warehouseCode", ocContractGoodsDomain.getWarehouseCode());
            map.put("skuNo", ocContractGoodsDomain.getSkuNo());
            map.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            map.put("storeType", storeType);
            whStoreSkuMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
            QueryResult queryStoreSkuPage = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", whStoreSkuMap, WhStoreSku.class);
            if (queryStoreSkuPage == null || ListUtil.isEmpty((Collection)queryStoreSkuPage.getList())) {
                new ApiException("wh.WhStoreGoodsBaseServiceImpl\u6ca1\u6709\u67e5\u8be2\u5230\u4ed3\u5e93\uff0c\u4ed3\u5e93\u5f02\u5e38" + JsonUtil.buildNormalBinder().toJson(whStoreSkuMap));
            }
            whStoreSku = (WhStoreSku)queryStoreSkuPage.getList().get(0);
        } else {
            new ApiException("wh.WhStoreGoodsBaseServiceImpl\u53d1\u8d27\u5355\u6570\u636e\u6709\u5f02\u5e38");
        }
        return whStoreSku;
    }

    private WhStoreSku checkWarehouseInfoMap(OcRefundGoodsDomain ocContractGoodsDomain) {
        WhStoreSku whStoreSku = null;
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuNo())) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> whStoreSkuMap = new HashMap<String, String>();
            map.put("warehouseCode", ocContractGoodsDomain.getWarehouseCode());
            map.put("skuNo", ocContractGoodsDomain.getSkuNo());
            map.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            map.put("storeType", "1");
            whStoreSkuMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
            QueryResult queryStoreSkuPage = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", whStoreSkuMap, WhStoreSku.class);
            if (queryStoreSkuPage == null || ListUtil.isEmpty((Collection)queryStoreSkuPage.getList())) {
                new ApiException("wh.WhStoreGoodsBaseServiceImpl\u6ca1\u6709\u67e5\u8be2\u5230\u65b0\u5e97\u4ed3\uff0c\u65b0\u5e97\u4ed3\u5f02\u5e38" + JsonUtil.buildNormalBinder().toJson(whStoreSkuMap));
            }
            whStoreSku = (WhStoreSku)queryStoreSkuPage.getList().get(0);
        } else {
            new ApiException("wh.WhStoreGoodsBaseServiceImpl\u53d1\u8d27\u5355\u6570\u636e\u6709\u5f02\u5e38");
        }
        return whStoreSku;
    }

    private UmUserinfoDomainBean makeUmuserinfo(OcContractGoodsDomain ocContractGoodsDomain) {
        UmUserinfoDomainBean userinfoDomainBean = null;
        if (!EmptyUtil.isEmpty((Object)ocContractGoodsDomain) && StringUtils.isNotBlank((String)ocContractGoodsDomain.getMemberBcode())) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("userinfoCode", ocContractGoodsDomain.getMemberBcode());
            userMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            String UmUserJson = this.internalInvoke("um.userbase.getUserinfoByCode", userMap);
            if (StringUtils.isBlank((String)UmUserJson)) {
                return null;
            }
            userinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(UmUserJson, UmUserinfoDomainBean.class);
        }
        return userinfoDomainBean;
    }

    private UmUserinfoDomainBean makeUmuserinfo(OcRefundGoodsDomain ocContractGoodsDomain) {
        UmUserinfoDomainBean userinfoDomainBean = null;
        if (!EmptyUtil.isEmpty((Object)ocContractGoodsDomain) && StringUtils.isNotBlank((String)ocContractGoodsDomain.getMemberBcode())) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("userinfoCode", ocContractGoodsDomain.getMemberBcode());
            userMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            String UmUserJson = this.internalInvoke("um.userbase.getUserinfoByCode", userMap);
            if (StringUtils.isBlank((String)UmUserJson)) {
                return null;
            }
            userinfoDomainBean = (UmUserinfoDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(UmUserJson, UmUserinfoDomainBean.class);
        }
        return userinfoDomainBean;
    }

    public void checkGoodsClassMap(WhUserwhDomain whUserwhDomain, WhOpstoreDomain whOpstoreDomain) {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return;
        }
        HashMap paramMap = new HashMap();
        whOpstoreDomain.setChannelCode(null);
        whOpstoreDomain.setChannelName(null);
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            whOpstoreGoodsDomain.setChannelCode(null);
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsNo())) {
                throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.goodsNo", "\u5546\u54c1\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            }
            whOpstoreGoodsDomain.setStoreType(whOpstoreDomain.getStoreType());
            whOpstoreGoodsDomain.setStoreGoodsBtype(whOpstoreGoodsDomain.getStoreGoodsBtype());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) continue;
            whOpstoreGoodsDomain.setAreaName(whOpstoreDomain.getAreaName());
            String goodsCode = "";
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                WhStoreSku whStoreSku;
                QueryResult queryStoreSkuPage;
                HashMap<String, String> whStoreSkuMapJson;
                HashMap<String, String> whStoreSkuMap;
                whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreGoodsDomain.getStoreGoodsBtype());
                whOpstoreSkuDomain.setStoreType(whOpstoreDomain.getStoreType());
                if ("1".equals(whOpstoreDomain.getStoreGoodsType())) continue;
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                    throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.skuNo", "\u8d27\u54c1\u4fe1\u606f\u4e3a\u7a7a");
                }
                whOpstoreSkuDomain.setChannelCode(null);
                whOpstoreSkuDomain.setChannelName(null);
                HashMap paramSendMap = new HashMap();
                if (StringUtils.isNotBlank((String)whOpstoreDomain.getStoreType()) && whOpstoreDomain.getStoreType().equals("0")) {
                    whStoreSkuMap = new HashMap<String, String>();
                    whStoreSkuMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                    whStoreSkuMap.put("storeType", "0");
                    whStoreSkuMap.put("warehouseCode", whUserwhDomain.getWarehouseCode());
                    whStoreSkuMap.put("tenantCode", whOpstoreSkuDomain.getTenantCode());
                    whStoreSkuMapJson = new HashMap<String, String>();
                    whStoreSkuMapJson.put("map", JsonUtil.buildNonDefaultBinder().toJson(whStoreSkuMap));
                    queryStoreSkuPage = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", whStoreSkuMapJson, WhStoreSku.class);
                    if (null == queryStoreSkuPage || ListUtil.isEmpty((Collection)queryStoreSkuPage.getList())) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.queryStoreSkuPage", (Object)JsonUtil.buildNormalBinder().toJson(whStoreSkuMapJson));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u8be5\u5546\u54c1\u6ca1\u6709\u5e93\u5b58");
                    }
                    whStoreSku = (WhStoreSku)queryStoreSkuPage.getList().get(0);
                    if (null == whStoreSku) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.whStoreSku", (Object)JsonUtil.buildNormalBinder().toJson(whStoreSkuMap));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u4ed3\u5e93\u6570\u636e\u4e3a\u7a7a");
                    }
                    if (!StringUtils.equals((CharSequence)whOpstoreDomain.getStoreGoodsBtype(), (CharSequence)"R3") && whStoreSku.getGoodsSupplynum().compareTo(whOpstoreSkuDomain.getGoodsNum()) == -1) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.whStoreSku123", (Object)(whStoreSku.getGoodsSupplynum() + "\u51bb\u7ed3\u6570\u91cf" + whOpstoreSkuDomain.getGoodsNum()));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u4ed3\u5e93\u5e93\u5b58\u4e0d\u8db3");
                    }
                } else if (StringUtils.isNotBlank((String)whOpstoreDomain.getStoreType()) && whOpstoreDomain.getStoreType().equals("1")) {
                    whStoreSkuMap = new HashMap();
                    whStoreSkuMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                    whStoreSkuMap.put("storeType", "1");
                    whStoreSkuMap.put("warehouseCode", whUserwhDomain.getWarehouseCode());
                    whStoreSkuMap.put("tenantCode", whOpstoreSkuDomain.getTenantCode());
                    whStoreSkuMapJson = new HashMap();
                    whStoreSkuMapJson.put("map", JsonUtil.buildNonDefaultBinder().toJson(whStoreSkuMap));
                    queryStoreSkuPage = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", whStoreSkuMapJson, WhStoreSku.class);
                    if (null == queryStoreSkuPage || ListUtil.isEmpty((Collection)queryStoreSkuPage.getList())) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.queryStoreSkuPage", (Object)JsonUtil.buildNormalBinder().toJson(whStoreSkuMapJson));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u8be5\u5546\u54c1\u6ca1\u6709\u5e93\u5b58");
                    }
                    whStoreSku = (WhStoreSku)queryStoreSkuPage.getList().get(0);
                    if (null == whStoreSku) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.whStoreSku", (Object)JsonUtil.buildNormalBinder().toJson(whStoreSkuMap));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u4ed3\u5e93\u6570\u636e\u4e3a\u7a7a");
                    }
                    if (!StringUtils.equals((CharSequence)whOpstoreDomain.getStoreGoodsBtype(), (CharSequence)"R3") && whStoreSku.getGoodsSupplynum().compareTo(whOpstoreSkuDomain.getGoodsNum()) == -1) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.whStoreSku123", (Object)(whStoreSku.getGoodsSupplynum() + "\u51bb\u7ed3\u6570\u91cf" + whOpstoreSkuDomain.getGoodsNum()));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u4ed3\u5e93\u5e93\u5b58\u4e0d\u8db3");
                    }
                } else if (StringUtils.isNotBlank((String)whOpstoreDomain.getStoreType()) && whOpstoreDomain.getStoreType().equals("2")) {
                    whStoreSkuMap = new HashMap();
                    whStoreSkuMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                    whStoreSkuMap.put("storeType", "2");
                    whStoreSkuMap.put("warehouseCode", whUserwhDomain.getWarehouseCode());
                    whStoreSkuMap.put("tenantCode", whOpstoreSkuDomain.getTenantCode());
                    whStoreSkuMapJson = new HashMap();
                    whStoreSkuMapJson.put("map", JsonUtil.buildNonDefaultBinder().toJson(whStoreSkuMap));
                    queryStoreSkuPage = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", whStoreSkuMapJson, WhStoreSku.class);
                    if (null == queryStoreSkuPage || ListUtil.isEmpty((Collection)queryStoreSkuPage.getList())) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.queryStoreSkuPage", (Object)JsonUtil.buildNormalBinder().toJson(whStoreSkuMapJson));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u8be5\u5546\u54c1\u6ca1\u6709\u5e93\u5b58");
                    }
                    whStoreSku = (WhStoreSku)queryStoreSkuPage.getList().get(0);
                    if (null == whStoreSku) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.whStoreSku", (Object)JsonUtil.buildNormalBinder().toJson(whStoreSkuMap));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u4ed3\u5e93\u6570\u636e\u4e3a\u7a7a");
                    }
                    if (!StringUtils.equals((CharSequence)whOpstoreDomain.getStoreGoodsBtype(), (CharSequence)"R3") && whStoreSku.getGoodsSupplynum().compareTo(whOpstoreSkuDomain.getGoodsNum()) == -1) {
                        this.logger.error("wh.WhStoreGoodsBaseServiceImpl.whStoreSku123", (Object)(whStoreSku.getGoodsSupplynum() + "\u51bb\u7ed3\u6570\u91cf" + whOpstoreSkuDomain.getGoodsNum()));
                        throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u4ed3\u5e93\u5e93\u5b58\u4e0d\u8db3");
                    }
                }
                whOpstoreDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
                WhWarehouse whWarehouseReDomain = this.checkWarehouseInfo(whOpstoreDomain.getWarehouseCode(), whOpstoreGoodsDomain.getTenantCode());
                if (null == whWarehouseReDomain) {
                    this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.checkWarehouseInfo.null", (Object)whOpstoreDomain.getWarehouseCode());
                    throw new ApiException("\u4ed3\u5e93\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a\uff1a" + whOpstoreDomain.getWarehouseCode());
                }
                String areaName = whWarehouseReDomain.getAreaName();
                String area = areaName.substring(areaName.lastIndexOf(",") + 1, areaName.length());
                whOpstoreSkuDomain.setTargetChannelName(whWarehouseReDomain.getWarehousePhone());
                if (StringUtils.isBlank((String)area)) {
                    whOpstoreSkuDomain.setTargetChannelCode(areaName);
                } else {
                    whOpstoreSkuDomain.setTargetChannelCode(area);
                }
                whOpstoreSkuDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
                whOpstoreGoodsDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
                whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
                whOpstoreSkuDomain.setWarehouseCode(whWarehouseReDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
                whOpstoreSkuDomain.setPartsnameName(whOpstoreDomain.getOpstoreOcode());
                whOpstoreGoodsDomain.setWarehouseCode(whWarehouseReDomain.getWarehouseCode());
                whOpstoreGoodsDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
            }
            whOpstoreGoodsDomain.setAreaName(whOpstoreDomain.getAreaName());
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                whOpstoreSkuDomain.setPartsnameNumunit1(whOpstoreDomain.getOpstoreOcode());
                whOpstoreSkuDomain.setDataState(whOpstoreDomain.getDataState());
                whOpstoreGoodsDomain.setWarehouseCode(whOpstoreSkuDomain.getWarehouseCode());
            }
        }
    }

    public void checkGoodsClass(WhOpstoreDomain whOpstoreDomain) {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getWarehouseCode()) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        WhWarehouse whWarehouseReDomain = this.checkWarehouseInfo(whOpstoreDomain);
        if (null == whWarehouseReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.checkWarehouseInfo.null", (Object)whOpstoreDomain.getWarehouseCode());
            throw new ApiException("\u4ed3\u5e93\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a\uff1a" + whOpstoreDomain.getWarehouseCode());
        }
        whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
        String goodsClass = "plat";
        String memberCode = whWarehouseReDomain.getMemberCode();
        whOpstoreDomain.setMemberCode(memberCode);
        whOpstoreDomain.setMemberName(whWarehouseReDomain.getMemberName());
        if ("0".equals(whWarehouseReDomain.getWarehouseCtype()) || "1".equals(whWarehouseReDomain.getWarehouseCtype())) {
            goodsClass = "store";
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsNo())) {
                throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.goodsNo", "\u5546\u54c1\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            }
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) continue;
            String goodsCode = "";
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                    throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.skuNo", "\u8d27\u54c1\u4fe1\u606f\u4e3a\u7a7a");
                }
                HashMap<String, String> paramSendMap = new HashMap<String, String>();
                paramMap.clear();
                paramMap.put("goodsClass", goodsClass);
                paramMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                paramMap.put("memberCode", memberCode);
                paramMap.put("tenantCode", whOpstoreSkuDomain.getTenantCode());
                paramSendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
                QueryResult queryResutl = this.getQueryResutl("rs.sku.querySkuPage", paramSendMap, RsSkuDomain.class);
                if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.queryResutl", (Object)JsonUtil.buildNormalBinder().toJson(paramSendMap));
                    throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u8be5\u8d27\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                RsSkuDomain rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                if (null == rsSkuDomain) {
                    this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.rsSkuDomain", (Object)JsonUtil.buildNormalBinder().toJson(paramSendMap));
                    throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":Sku\u6570\u636e\u4e3a\u7a7a");
                }
                whOpstoreSkuDomain.setClasstreeCode(rsSkuDomain.getClasstreeCode());
                whOpstoreSkuDomain.setClasstreeName(rsSkuDomain.getClasstreeName());
                whOpstoreSkuDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
                whOpstoreSkuDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
                whOpstoreSkuDomain.setSkuEocode(rsSkuDomain.getSkuEocode());
                whOpstoreSkuDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
                whOpstoreSkuDomain.setSpuCode(rsSkuDomain.getSpuCode());
                whOpstoreSkuDomain.setSkuCode(rsSkuDomain.getSkuCode());
                whOpstoreSkuDomain.setSkuName(rsSkuDomain.getSkuName());
                whOpstoreSkuDomain.setOperatorCode(rsSkuDomain.getMschannelName());
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreSkuDomain.setMemberCode(rsSkuDomain.getMemberCode());
                whOpstoreSkuDomain.setMemberName(rsSkuDomain.getMemberName());
                whOpstoreSkuDomain.setMemberCcode(rsSkuDomain.getMemberCcode());
                whOpstoreSkuDomain.setMemberCname(rsSkuDomain.getMemberCname());
                whOpstoreSkuDomain.setStoreType(this.checkStoreType(whOpstoreSkuDomain));
                whOpstoreGoodsDomain.setStoreType(whOpstoreSkuDomain.getStoreType());
                goodsCode = rsSkuDomain.getGoodsCode();
            }
            paramMap.clear();
            paramMap.put("goodsCode", goodsCode);
            paramMap.put("tenantCode", whOpstoreGoodsDomain.getTenantCode());
            RsResourceGoodsDomain rsResourceGoods = (RsResourceGoodsDomain)this.readObj("rs.resourceGoods.getResourceGoodsByCodeStr", paramMap, "object", new Object[]{RsResourceGoodsDomain.class});
            if (null == rsResourceGoods) {
                this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.rsResourceGoods", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
                throw new ApiException(goodsCode + ":Goods\u6570\u636e\u4e3a\u7a7a");
            }
            whOpstoreDomain.setMemberCode(rsResourceGoods.getMemberCode());
            whOpstoreDomain.setMemberName(rsResourceGoods.getMemberName());
            whOpstoreDomain.setMemberCcode(rsResourceGoods.getMemberCcode());
            whOpstoreDomain.setMemberCname(rsResourceGoods.getMemberCname());
            whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
            whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
            whOpstoreGoodsDomain.setGoodsSpec5(rsResourceGoods.getGoodsProperty2());
            whOpstoreGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
            whOpstoreGoodsDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
            whOpstoreGoodsDomain.setSpuCode(rsResourceGoods.getSpuCode());
            whOpstoreGoodsDomain.setGoodsProperty(rsResourceGoods.getGoodsProperty3());
            whOpstoreGoodsDomain.setGoodsEocode(rsResourceGoods.getGoodsEocode());
            whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
            whOpstoreGoodsDomain.setMemberCode(rsResourceGoods.getMemberCode());
            whOpstoreGoodsDomain.setMemberName(rsResourceGoods.getMemberName());
            whOpstoreGoodsDomain.setMemberCcode(rsResourceGoods.getMemberCcode());
            whOpstoreGoodsDomain.setMemberCname(rsResourceGoods.getMemberCname());
        }
    }

    private WhWarehouse checkWarehouseInfo(WhOpstoreDomain whOpstoreDomain) {
        WhWarehouse whWarehouseReDomain = null;
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && StringUtils.isNotBlank((String)whOpstoreDomain.getWarehouseCode())) {
            HashMap<String, Object> whMap = new HashMap<String, Object>();
            whMap.put("warehouseCode", whOpstoreDomain.getWarehouseCode());
            whMap.put("tenantCode", whOpstoreDomain.getTenantCode());
            whWarehouseReDomain = this.whWarehouseService.getWarehouseByCode(whMap);
            if (EmptyUtil.isEmpty((Object)whWarehouseReDomain)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("warehouseOcode", whOpstoreDomain.getWarehouseCode());
                map.put("tenantCode", whOpstoreDomain.getTenantCode());
                QueryResult<WhWarehouse> whWarehouseQueryResult = this.whWarehouseService.queryWarehousePage(map);
                if (null == whWarehouseQueryResult || ListUtil.isEmpty((Collection)whWarehouseQueryResult.getList())) {
                    return null;
                }
                whWarehouseReDomain = (WhWarehouse)whWarehouseQueryResult.getList().get(0);
            }
        }
        return whWarehouseReDomain;
    }

    private WhWarehouse checkWarehouseInfo(String warehouseCode, String tenantCode) {
        WhWarehouse whWarehouseReDomain = null;
        if (StringUtils.isNotBlank((String)tenantCode) && StringUtils.isNotBlank((String)warehouseCode)) {
            HashMap<String, Object> whMap = new HashMap<String, Object>();
            whMap.put("warehouseCode", warehouseCode);
            whMap.put("tenantCode", tenantCode);
            whWarehouseReDomain = this.whWarehouseService.getWarehouseByCode(whMap);
        }
        return whWarehouseReDomain;
    }

    private String checkStoreType(WhOpstoreSkuDomain whOpstoreSkuDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreSkuDomain) && StringUtils.isNotBlank((String)whOpstoreSkuDomain.getStoreWhlocal())) {
            if (whOpstoreSkuDomain.getStoreWhlocal().indexOf("10") == 0) {
                return "0";
            }
            if (whOpstoreSkuDomain.getStoreWhlocal().indexOf("J0") == 0) {
                return "1";
            }
            if (whOpstoreSkuDomain.getStoreWhlocal().indexOf("20") == 0) {
                return "1";
            }
            return "0";
        }
        return "0";
    }

    private void assWhOpstoreGoodsDomain(JSONObject jsonObject, List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList, WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == jsonObject) {
            return;
        }
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)jsonObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
    }

    private void assMap(JSONArray contractGoodsList, Map<String, JSONArray> map) {
        contractGoodsList.stream().forEach(c -> {
            String key = c.getString("goodsNo") + "-" + c.getString("storeType");
            if (map.containsKey(key)) {
                ((JSONArray)map.get(key)).add(c);
            } else {
                JSONArray array = new JSONArray();
                array.add(c);
                map.put(key, array);
            }
        });
    }

    private void assMapAll(JSONArray contractGoodsList, Map<String, JSONArray> map) {
        contractGoodsList.stream().forEach(c -> {
            String key = c.getString("contractGoodsCode") + "-" + c.getString("goodsNo") + "-" + c.getString("storeType");
            if (map.containsKey(key)) {
                ((JSONArray)map.get(key)).add(c);
            } else {
                JSONArray array = new JSONArray();
                array.add(c);
                map.put(key, array);
            }
        });
    }

    private void assWhOpstoreSkuDomain(JSONObject jsonObject, List<WhOpstoreSkuDomain> whOpstoreSkuDomainList, WhOpstoreDomain whOpstoreDomain, WhOpstoreGoodsDomain whOpstoreGoodsDomain, String opStoreDir) {
        String goodsProperty5;
        if (null == jsonObject || null == whOpstoreDomain || null == whOpstoreGoodsDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.assWhOpstoreSkuDomain", (Object)"\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        if (jsonObject.containsKey((Object)"refundGoodsType")) {
            if (!"0".equals(String.valueOf(jsonObject.get((Object)"refundGoodsType")))) {
                this.logger.error("wh.WhStoreGoodsBaseServiceImpl.assWhOpstoreSkuDomain", (Object)"\u6362\u8d27\u7c7b\u578b\u4e0d\u6263\u51cf\u5e93\u5b58");
                return;
            }
        } else if (whOpstoreDomain.isCheckGiftGoods() && jsonObject.containsKey((Object)"contractGoodsType")) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.assWhOpstoreSkuDomain", (Object)"\u5546\u54c1\u4e0d\u6263\u51cf\u5e93\u5b58");
            if (null != jsonObject.get((Object)"contractGoodsType") && !"0".equals(String.valueOf(jsonObject.get((Object)"contractGoodsType")))) {
                return;
            }
        }
        if ("5".equals(String.valueOf(jsonObject.get((Object)"goodsPro")))) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.assWhOpstoreSkuDomain", (Object)"\u7ec4\u5408\u5546\u54c1\u4e0d\u5904\u7406\u5e93\u5b58");
            return;
        }
        if (null == whOpstoreDomain.getGoodsNum()) {
            whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsWeight()) {
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsAmt()) {
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)jsonObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (whOpstoreSkuDomain.getTenantCode().equals("2021122100000001") || whOpstoreSkuDomain.getTenantCode().equals("568457092274532359") || whOpstoreSkuDomain.getTenantCode().equals("2022071500000001")) {
            whOpstoreSkuDomain.setGoodsNum(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsNum")));
            whOpstoreSkuDomain.setGoodsWeight(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsWeight")));
        } else {
            whOpstoreSkuDomain.setGoodsNum(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsTopnum")));
            if (null == whOpstoreSkuDomain.getGoodsNum() || "".equals(whOpstoreSkuDomain.getGoodsNum()) || whOpstoreSkuDomain.getGoodsNum().compareTo(BigDecimal.ZERO) == -1) {
                whOpstoreSkuDomain.setGoodsNum(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsNum")));
            }
            whOpstoreSkuDomain.setGoodsWeight(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsTopweight")));
            if (null == whOpstoreSkuDomain.getGoodsWeight() || "".equals(whOpstoreSkuDomain.getGoodsWeight()) || whOpstoreSkuDomain.getGoodsWeight().compareTo(BigDecimal.ZERO) == -1) {
                whOpstoreSkuDomain.setGoodsWeight(ParamsUtils.getBigDecimal(jsonObject.get((Object)"goodsWeight")));
            }
        }
        if (null != jsonObject.get((Object)"goodsProperty5")) {
            goodsProperty5 = (String)jsonObject.get((Object)"goodsProperty5");
            whOpstoreSkuDomain.setSkuBarcode(goodsProperty5);
        }
        if (null != jsonObject.get((Object)"goodsProperty5")) {
            goodsProperty5 = (String)jsonObject.get((Object)"goodsProperty5");
            whOpstoreSkuDomain.setSkuBarcode(goodsProperty5);
        }
        if (null != jsonObject.get((Object)"classtreeName")) {
            String classtreeName = (String)jsonObject.get((Object)"classtreeName");
            whOpstoreSkuDomain.setClasstreeName(classtreeName);
            whOpstoreGoodsDomain.setClasstreeName(classtreeName);
        }
        whOpstoreSkuDomain.setOpstoreDir(opStoreDir);
        whOpstoreSkuDomain.setStoreType("0");
        whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreSkuDomain.getStoreGoodsBtype());
        whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
        whOpstoreDomain.setWarehouseCode(whOpstoreSkuDomain.getWarehouseCode());
        whOpstoreDomain.setWarehouseName(whOpstoreSkuDomain.getWarehouseName());
        if (null != jsonObject.get((Object)"memberContact")) {
            whOpstoreSkuDomain.setStoreWhlocal((String)jsonObject.get((Object)"memberContact"));
        }
        if (null != jsonObject.get((Object)"memberContactQq")) {
            whOpstoreSkuDomain.setSkuBarcode((String)jsonObject.get((Object)"memberContactQq"));
        }
        if (null == whOpstoreSkuDomain.getGoodsNum()) {
            whOpstoreSkuDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreSkuDomain.getGoodsWeight()) {
            whOpstoreSkuDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        whOpstoreDomain.setGoodsNum(whOpstoreDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreDomain.setGoodsWeight(whOpstoreDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreGoodsDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreGoodsDomain.setGoodsWeight(whOpstoreGoodsDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreSkuDomain.setMemberBcode(whOpstoreGoodsDomain.getMemberBcode());
        whOpstoreSkuDomain.setChannelCode(whOpstoreDomain.getChannelCode());
        whOpstoreSkuDomain.setChannelName(whOpstoreDomain.getChannelName());
        whOpstoreSkuDomain.setMemberCode(whOpstoreDomain.getMemberCode());
        whOpstoreSkuDomain.setMemberName(whOpstoreDomain.getMemberName());
        whOpstoreSkuDomain.setMemberBname(whOpstoreDomain.getMemberBname());
        whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
    }

    @Override
    public String sendUpdateOpstore(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whOpstoreService.updateOpstore(whOpstoreDomain);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
        return whOpstoreDomain.getOpstoreCode();
    }

    @Override
    public String sendSaveOpstoreBatch(List<WhOpstoreDomain> whOpstoreDomainList) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whOpstoreService.saveOpstoreBatch(whOpstoreDomainList);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
        return null;
    }

    @Override
    public String sendUpdateSkuNum(Map<String, Object> map, RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null != rsResourceGoodsDomain && "10".equals(rsResourceGoodsDomain.getGoodsPro())) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendUpdateSkuNum.map", (Object)"\u9884\u552e\u5546\u54c1");
            return "sucess";
        }
        List<WhChannelsend> whChannelsendList = this.whStoreGoodsService.updateSkuNum(map);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
        return "sucess";
    }

    @Override
    public String sendSaveOpstoreByOpCode(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whOpstoreService.saveOpstoreByOpCode(whOpstoreDomain);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
        return whOpstoreDomain.getOpstoreCode();
    }

    @Override
    public void sendUpdateOpstoreState(Integer opstoreId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whOpstoreService.updateOpstoreState(opstoreId, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
    }

    @Override
    public void sendUpdateOpstoreStateByCode(String tenantCode, String opstoreCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<WhChannelsend> whChannelsendList = this.whOpstoreService.updateOpstoreStateByCode(tenantCode, opstoreCode, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(whChannelsendList)) {
            WhChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(WhChannelsendServiceImpl.getSendService(), whChannelsendList));
        }
    }

    @Override
    public String sendSaveSggoodsLockStr(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (null == sgSendgoodsReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsLock.null", (Object)"param is null");
            return "error";
        }
        try {
            WhOpstoreDomain whOpstoreDomain = this.makeWhOpstoreDomainStr(sgSendgoodsReDomain, "4", "X3");
            this.sendSaveOpstore(whOpstoreDomain);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsLock.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveSggoodsReleaseStr(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (null == sgSendgoodsReDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsReleaseStr.null", (Object)"param is null");
            return "error";
        }
        try {
            long startTime = System.currentTimeMillis();
            WhOpstoreDomain whOpstoreDomain = this.makeWhOpstoreDomainStr(sgSendgoodsReDomain, "14", "14");
            this.logger.info("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsReleaseStr1", (Object)("\u8017\u65f6\u3010" + (System.currentTimeMillis() - startTime) + "\u3011"));
            startTime = System.currentTimeMillis();
            this.sendSaveOpstore(whOpstoreDomain);
            this.logger.info("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsReleaseStr2", (Object)("\u8017\u65f6\u3010" + (System.currentTimeMillis() - startTime) + "\u3011"));
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsReleaseStr.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    private WhOpstoreDomain makeWhOpstoreDomainStr(SgSendgoodsReDomain sgSendgoodsReDomain, String storeGoodsType, String storeGoodsBtype) {
        long startTime = System.currentTimeMillis();
        if (null == sgSendgoodsReDomain || ListUtil.isEmpty(sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList())) {
            return null;
        }
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreDomain, (Object)sgSendgoodsReDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
        whOpstoreDomain.setStoreGoodsType(storeGoodsType);
        whOpstoreDomain.setStoreType("0");
        whOpstoreDomain.setOpstoreOcode(sgSendgoodsReDomain.getSendgoodsCode());
        whOpstoreDomain.setOpstoreNcode(sgSendgoodsReDomain.getContractBillcode());
        whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        ArrayList<SgSendgoodsGoodsDomain> goodsList = new ArrayList<SgSendgoodsGoodsDomain>();
        List<SgSendgoodsGoodsDomain> c = sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList()) {
            if (EmptyUtil.isEmpty((Object)sgSendgoodsGoodsDomain.getContractGoodsRefnum())) {
                sgSendgoodsGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            sgSendgoodsGoodsDomain.setGoodsNum(sgSendgoodsGoodsDomain.getGoodsNum().subtract(sgSendgoodsGoodsDomain.getContractGoodsRefnum()));
            if (!StringUtils.isBlank((Integer)sgSendgoodsGoodsDomain.getContractGoodsType()) && 0 != sgSendgoodsGoodsDomain.getContractGoodsType()) continue;
            sgSendgoodsGoodsDomain.setMemberContact(null);
            if (StringUtils.isBlank((String)sgSendgoodsGoodsDomain.getGoodsPro())) {
                sgSendgoodsGoodsDomain.setGoodsPro("");
            }
            if ("5".equals(sgSendgoodsGoodsDomain.getGoodsPro())) continue;
            goodsList.add(sgSendgoodsGoodsDomain);
        }
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain));
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.goodsList");
        }
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(goodsList));
        this.assMapAll(contractGoodsList, map);
        String opDirs = "0";
        if ("14".equals(storeGoodsType)) {
            opDirs = "1";
        }
        String finalOpDirs = opDirs;
        map.keySet().stream().forEach(key -> {
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            this.assWhOpstoreGoodsDomain(((JSONArray)map.get(key)).get(0), whOpstoreGoodsDomainList, whOpstoreGoodsDomain);
            ((JSONArray)map.get(key)).forEach(cg -> this.assWhOpstoreSkuDomain((JSONObject)cg, (List<WhOpstoreSkuDomain>)whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain, finalOpDirs));
            whOpstoreGoodsDomain.setOpstoreDir(finalOpDirs);
            whOpstoreGoodsDomain.setStoreType("0");
            whOpstoreGoodsDomain.setStoreGoodsType(storeGoodsType);
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        });
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.logger.debug("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.domain1", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        this.logger.info("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsReleaseStr11", (Object)("\u8017\u65f6\u3010" + (System.currentTimeMillis() - startTime) + "\u3011"));
        startTime = System.currentTimeMillis();
        this.checkGoodsClassStr(whOpstoreDomain);
        this.logger.debug("wh.WhStoreGoodsBaseServiceImpl.makeWhOpstoreDomain.domain2", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        this.logger.info("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsReleaseStr12", (Object)("\u8017\u65f6\u3010" + (System.currentTimeMillis() - startTime) + "\u3011"));
        return whOpstoreDomain;
    }

    public void checkGoodsClassStr(WhOpstoreDomain whOpstoreDomain) {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || EmptyUtil.isEmpty((Object)whOpstoreDomain.getWarehouseCode()) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String goodsClass = "B2B-DEA";
        long startTime = System.currentTimeMillis();
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsNo())) {
                throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.goodsNo", "\u5546\u54c1\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            }
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) continue;
            String goodsCode = "";
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("warehouseCode", whOpstoreSkuDomain.getWarehouseCode());
                map.put("tenantCode", whOpstoreDomain.getTenantCode());
                startTime = System.currentTimeMillis();
                QueryResult<WhWarehouse> whWarehouseQueryResult = this.whWarehouseService.queryWarehousePage(map);
                this.logger.info("wh.WhStoreGoodsBaseServiceImpl.sendSaveSggoodsReleaseStr121", (Object)("\u8017\u65f6\u3010" + (System.currentTimeMillis() - startTime) + "\u3011"));
                if (null == whWarehouseQueryResult || ListUtil.isEmpty((Collection)whWarehouseQueryResult.getList())) {
                    throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.whWarehouseQueryResult", "\u4ed3\u5e93\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a" + JsonUtil.buildNonDefaultBinder().toJson((Object)whOpstoreSkuDomain));
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                    throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.skuNo", "\u8d27\u54c1\u4fe1\u606f\u4e3a\u7a7a");
                }
                HashMap<String, String> paramSendMap = new HashMap<String, String>();
                paramMap.clear();
                paramMap.put("goodsClass", goodsClass);
                paramMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                paramMap.put("memberCode", whOpstoreSkuDomain.getMemberCode());
                paramMap.put("tenantCode", whOpstoreSkuDomain.getTenantCode());
                paramSendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
                QueryResult queryResutl = this.getQueryResutl("rs.sku.querySkuPage", paramSendMap, RsSkuDomain.class);
                if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.queryResutl", (Object)JsonUtil.buildNormalBinder().toJson(paramSendMap));
                    throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":\u8be5\u8d27\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                RsSkuDomain rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                if (null == rsSkuDomain) {
                    this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.rsSkuDomain", (Object)JsonUtil.buildNormalBinder().toJson(paramSendMap));
                    throw new ApiException(whOpstoreSkuDomain.getSkuNo() + ":Sku\u6570\u636e\u4e3a\u7a7a");
                }
                whOpstoreSkuDomain.setClasstreeCode(rsSkuDomain.getClasstreeCode());
                whOpstoreSkuDomain.setClasstreeName(rsSkuDomain.getClasstreeName());
                whOpstoreSkuDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
                whOpstoreSkuDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
                whOpstoreSkuDomain.setSkuEocode(rsSkuDomain.getSkuEocode());
                whOpstoreSkuDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
                whOpstoreSkuDomain.setSpuCode(rsSkuDomain.getSpuCode());
                whOpstoreSkuDomain.setSkuCode(rsSkuDomain.getSkuCode());
                whOpstoreSkuDomain.setSkuName(rsSkuDomain.getSkuName());
                whOpstoreSkuDomain.setOperatorCode(rsSkuDomain.getMschannelName());
                whOpstoreSkuDomain.setMemberCode(rsSkuDomain.getMemberCode());
                whOpstoreSkuDomain.setMemberName(rsSkuDomain.getMemberName());
                whOpstoreSkuDomain.setMemberCcode(null);
                whOpstoreSkuDomain.setMemberCname(rsSkuDomain.getMemberCname());
                whOpstoreSkuDomain.setStoreType(this.checkStoreType(whOpstoreSkuDomain));
                whOpstoreGoodsDomain.setStoreType(whOpstoreSkuDomain.getStoreType());
                goodsCode = rsSkuDomain.getGoodsCode();
            }
            paramMap.clear();
            paramMap.put("goodsCode", goodsCode);
            paramMap.put("tenantCode", whOpstoreGoodsDomain.getTenantCode());
            RsResourceGoodsDomain rsResourceGoods = (RsResourceGoodsDomain)this.readObj("rs.resourceGoods.getResourceGoodsByCodeStr", paramMap, "object", new Object[]{RsResourceGoodsDomain.class});
            if (null == rsResourceGoods) {
                this.logger.error("wh.WhStoreGoodsBaseServiceImpl.checkGoodsClass.rsResourceGoods", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
                throw new ApiException(goodsCode + ":Goods\u6570\u636e\u4e3a\u7a7a");
            }
            whOpstoreDomain.setMemberCode(rsResourceGoods.getMemberCode());
            whOpstoreDomain.setMemberName(rsResourceGoods.getMemberName());
            whOpstoreDomain.setMemberCcode(rsResourceGoods.getMemberCcode());
            whOpstoreDomain.setMemberCname(rsResourceGoods.getMemberCname());
            whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
            whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
            whOpstoreGoodsDomain.setGoodsSpec5(rsResourceGoods.getGoodsProperty2());
            whOpstoreGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
            whOpstoreGoodsDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
            whOpstoreGoodsDomain.setSpuCode(rsResourceGoods.getSpuCode());
            whOpstoreGoodsDomain.setGoodsProperty(rsResourceGoods.getGoodsProperty3());
            whOpstoreGoodsDomain.setGoodsEocode(rsResourceGoods.getGoodsEocode());
            whOpstoreGoodsDomain.setMemberCode(rsResourceGoods.getMemberCode());
            whOpstoreGoodsDomain.setMemberName(rsResourceGoods.getMemberName());
            whOpstoreGoodsDomain.setMemberCcode(rsResourceGoods.getMemberCcode());
            whOpstoreGoodsDomain.setMemberCname(rsResourceGoods.getMemberCname());
        }
    }

    @Override
    public String sendSaveRefundReleaseStr(OcRefundDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveRefundReleaseStr.null", (Object)"param is null");
            return "error";
        }
        try {
            WhOpstoreDomain whOpstoreDomain = this.makeRefundToWhOpstoreDomain(ocRefundDomain, "18", "18");
            this.sendSaveOpstore(whOpstoreDomain);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.sendSaveRefundReleaseStr.e", (Object)e.toString(), (Throwable)e);
            return "error";
        }
        return "success";
    }

    private WhOpstoreDomain makeRefundToWhOpstoreDomain(OcRefundDomain ocRefundDomain, String storeGoodsBtype, String storeGoodsType) {
        if (null == ocRefundDomain || ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return null;
        }
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreDomain, (Object)ocRefundDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
        whOpstoreDomain.setStoreGoodsType(storeGoodsType);
        whOpstoreDomain.setStoreType("0");
        whOpstoreDomain.setOpstoreOcode(ocRefundDomain.getRefundCode());
        whOpstoreDomain.setOpstoreNcode(ocRefundDomain.getContractBillcode());
        whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        ArrayList<OcRefundGoodsDomain> goodsList = new ArrayList<OcRefundGoodsDomain>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            ocRefundGoodsDomain.setGoodsNum(ocRefundGoodsDomain.getRefundGoodsNum());
            ocRefundGoodsDomain.setMemberContact(null);
            if (StringUtils.isBlank((String)ocRefundGoodsDomain.getGoodsPro())) {
                ocRefundGoodsDomain.setGoodsPro("");
            }
            if ("5".equals(ocRefundGoodsDomain.getGoodsPro())) continue;
            goodsList.add(ocRefundGoodsDomain);
        }
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("wh.WhStoreGoodsBaseServiceImpl.makeRefundToWhOpstoreDomain.goodsList", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            throw new ApiException("wh.WhStoreGoodsBaseServiceImpl.makeRefundToWhOpstoreDomain.goodsList");
        }
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
        JSONArray contractGoodsList = JSONArray.json2array((String)JsonUtil.buildNormalBinder().toJson(goodsList));
        this.assMap(contractGoodsList, map);
        String opDirs = "0";
        if ("18".equals(storeGoodsType)) {
            opDirs = "1";
        }
        String finalOpDirs = opDirs;
        map.keySet().stream().forEach(key -> {
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            this.assWhOpstoreGoodsDomain(((JSONArray)map.get(key)).get(0), whOpstoreGoodsDomainList, whOpstoreGoodsDomain);
            ((JSONArray)map.get(key)).forEach(cg -> this.assWhOpstoreSkuDomain((JSONObject)cg, (List<WhOpstoreSkuDomain>)whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain, finalOpDirs));
            whOpstoreGoodsDomain.setOpstoreDir(finalOpDirs);
            whOpstoreGoodsDomain.setStoreType("0");
            whOpstoreGoodsDomain.setStoreGoodsType(storeGoodsType);
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        });
        whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        this.logger.info("wh.WhStoreGoodsBaseServiceImpl.sendSaveRefundReleaseStr.domain1", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        this.checkGoodsClassStr(whOpstoreDomain);
        this.logger.info("wh.WhStoreGoodsBaseServiceImpl.sendSaveRefundReleaseStr.domain2", (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        return whOpstoreDomain;
    }
}

