package com.taobao.middleware.logger.option;

import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;

/**
 * <pre>
 * 激活Logger的选项，包括：
 * Appender/Layout
 * Level
 * Additivity
 * </pre>
 * 
 * @author zhuyong 2014年3月20日 上午10:20:51
 */
public interface ActivateOption {

    public void activateConsoleAppender(String target, String encoding);
    public void activateAppender(String productName, String file, String encoding);

    public void activateAsyncAppender(String productName, String file, String encoding);

    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size);

    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size,
                                                       String datePattern);
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size,
                                                       String datePattern, int maxBackupIndex);


    public void activateAppenderWithSizeRolling(String productName, String file, String encoding, String size,
                                                int maxBackupIndex);


    public void activateAppender(Logger logger);


    public void setLevel(Level level);

 
    public void setAdditivity(boolean additivity);

 
    public String getProductName();
}
