package com.taobao.middleware.logger.option;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.*;
import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;

import java.io.File;
import java.util.Iterator;

/**
 * logback 0.9.18版本及以前适用
 * 
 * @author zhuyong 2014年3月20日 上午11:16:26
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class Logback918ActivateOption extends AbstractActiveOption {

    private ch.qos.logback.classic.Logger logger;

    public Logback918ActivateOption(Object logger) {
        if (logger instanceof ch.qos.logback.classic.Logger) {
            this.logger = (ch.qos.logback.classic.Logger) logger;
        } else {
            throw new IllegalArgumentException("logger must be instanceof ch.qos.logback.classic.Logger");
        }
    }

    @Override
    public void activateConsoleAppender(String target, String encoding) {
        ch.qos.logback.core.ConsoleAppender appender = new ch.qos.logback.core.ConsoleAppender();
        appender.setContext(LogbackLoggerContextUtil.getLoggerContext());
        appender.setTarget(target);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern());
        layout.setContext(LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout(layout);
        appender.start();

        logger.detachAndStopAllAppenders();
        logger.addAppender(appender);
    }

    @Override
    public void activateAppender(String productName, String file, String encoding) {
        ch.qos.logback.core.Appender appender = getLogbackDailyRollingFileAppender(productName, file, encoding);
        logger.detachAndStopAllAppenders();
        logger.addAppender(appender);

        setProductName(productName);
    }

    @Override
    public void activateAsyncAppender(String productName, String file, String encoding) {
        AsyncAppender asynAppender = new AsyncAppender();
        asynAppender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".AsyncAppender");
        asynAppender.setContext(LogbackLoggerContextUtil.getLoggerContext());
        ch.qos.logback.core.Appender appender = getLogbackDailyRollingFileAppender(productName, file, encoding);
        asynAppender.addAppender(appender);
        asynAppender.start();
        logger.detachAndStopAllAppenders();
        logger.addAppender(asynAppender);

        setProductName(productName);
    }

    @Override
    public void setLevel(Level level) {
        logger.setLevel(ch.qos.logback.classic.Level.valueOf(level.getName()));
    }

    @Override
    public void setAdditivity(boolean additivity) {
        logger.setAdditive(additivity);
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size) {
        ch.qos.logback.core.Appender appender = getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding,
                                                                                          size);
        logger.detachAndStopAllAppenders();
        logger.addAppender(appender);

        setProductName(productName);
    }

    protected ch.qos.logback.core.Appender getLogbackDailyRollingFileAppender(String productName, String file,
                                                                              String encoding) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext(LogbackLoggerContextUtil.getLoggerContext());

        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));

        TimeBasedRollingPolicy rolling = new TimeBasedRollingPolicy();
        rolling.setParent(appender);
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%d{yyyy-MM-dd}");
        rolling.setContext(LogbackLoggerContextUtil.getLoggerContext());
        rolling.start();
        appender.setRollingPolicy(rolling);

        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext(LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout(layout);

        // 启动
        appender.start();

        return appender;
    }

    protected ch.qos.logback.core.Appender getLogbackDailyAndSizeRollingFileAppender(String productName, String file,
                                                                                     String encoding, String size) {
        return getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size, "yyyy-MM-dd", -1);
    }

    @Override
    public void activateAppender(Logger logger) {
        if (!(logger.getDelegate() instanceof ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException("logger must be ch.qos.logback.classic.Logger, but it's "
                                               + logger.getDelegate().getClass());
        }
        this.logger.detachAndStopAllAppenders();

        Iterator<ch.qos.logback.core.Appender<ILoggingEvent>> iter = ((ch.qos.logback.classic.Logger) logger.getDelegate()).iteratorForAppenders();
        while (iter.hasNext()) {
            ch.qos.logback.core.Appender<ILoggingEvent> appender = iter.next();
            this.logger.addAppender(appender);
        }
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size,
                                                       String datePattern) {
        ch.qos.logback.core.Appender appender = getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding,
                                                                                          size, datePattern, -1);
        logger.detachAndStopAllAppenders();
        logger.addAppender(appender);

        setProductName(productName);
    }

    protected ch.qos.logback.core.Appender getLogbackDailyAndSizeRollingFileAppender(String productName, String file,
                                                                                     String encoding, String size,
                                                                                     String datePattern,
                                                                                     int maxBackupIndex) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext(LogbackLoggerContextUtil.getLoggerContext());

        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));

        TimeBasedRollingPolicy rolling = new TimeBasedRollingPolicy();
        rolling.setParent(appender);
        if (maxBackupIndex >= 0) {
            rolling.setMaxHistory(maxBackupIndex);
        }
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%d{" + datePattern + "}.%i");
        rolling.setContext(LogbackLoggerContextUtil.getLoggerContext());

        SizeAndTimeBasedFNATP fnatp = new SizeAndTimeBasedFNATP();
        fnatp.setMaxFileSize(size);
        fnatp.setTimeBasedRollingPolicy(rolling);
        rolling.setTimeBasedFileNamingAndTriggeringPolicy(fnatp);

        rolling.start();
        appender.setRollingPolicy(rolling);

        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext(LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout(layout);

        // 启动
        appender.start();

        return appender;
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size,
                                                       String datePattern, int maxBackupIndex) {
        ch.qos.logback.core.Appender appender = getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding,
                                                                                          size, datePattern,
                                                                                          maxBackupIndex);
        logger.detachAndStopAllAppenders();
        logger.addAppender(appender);

        setProductName(productName);
    }

    @Override
    public void activateAppenderWithSizeRolling(String productName, String file, String encoding, String size,
                                                int maxBackupIndex) {
        ch.qos.logback.core.Appender appender = getSizeRollingAppender(productName, file, encoding, size,
                                                                       maxBackupIndex);
        logger.detachAndStopAllAppenders();
        logger.addAppender(appender);

        setProductName(productName);
    }

    protected ch.qos.logback.core.Appender getSizeRollingAppender(String productName, String file, String encoding,
                                                                  String size, int maxBackupIndex) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext(LogbackLoggerContextUtil.getLoggerContext());

        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));

        SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy();
        triggerPolicy.setMaxFileSize(size);
        triggerPolicy.setContext(LogbackLoggerContextUtil.getLoggerContext());
        triggerPolicy.start();

        FixedWindowRollingPolicy rolling = new FixedWindowRollingPolicy();
        rolling.setContext(LogbackLoggerContextUtil.getLoggerContext());
        rolling.setParent(appender);
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%i");
        rolling.setParent(appender);
        if (maxBackupIndex >= 0) {
            rolling.setMaxIndex(maxBackupIndex);
        }
        rolling.start();

        appender.setRollingPolicy(rolling);
        appender.setTriggeringPolicy(triggerPolicy);

        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext(LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout(layout);

        // 启动
        appender.start();
        return appender;
    }
}
