/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core;

import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.AnalyzeContext;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.ISegmenter;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.core.Lexeme;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.dic.Dictionary;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.dic.Hit;
import java.util.LinkedList;
import java.util.List;

class CJKSegmenter
implements ISegmenter {
    static final String SEGMENTER_NAME = "CJK_SEGMENTER";
    private List<Hit> tmpHits = new LinkedList<Hit>();

    CJKSegmenter() {
    }

    @Override
    public void analyze(AnalyzeContext context) {
        if (0 != context.getCurrentCharType()) {
            Hit singleCharHit;
            if (!this.tmpHits.isEmpty()) {
                Hit[] tmpArray;
                for (Hit hit : tmpArray = this.tmpHits.toArray(new Hit[this.tmpHits.size()])) {
                    hit = Dictionary.getSingleton().matchWithHit(context.getSegmentBuff(), context.getCursor(), hit);
                    if (hit.isMatch()) {
                        Lexeme newLexeme = new Lexeme(context.getBufferOffset(), hit.getBegin(), context.getCursor() - hit.getBegin() + 1, 4);
                        context.addLexeme(newLexeme);
                        if (hit.isPrefix()) continue;
                        this.tmpHits.remove(hit);
                        continue;
                    }
                    if (!hit.isUnmatch()) continue;
                    this.tmpHits.remove(hit);
                }
            }
            if ((singleCharHit = Dictionary.getSingleton().matchInMainDict(context.getSegmentBuff(), context.getCursor(), 1)).isMatch()) {
                Lexeme newLexeme = new Lexeme(context.getBufferOffset(), context.getCursor(), 1, 4);
                context.addLexeme(newLexeme);
                if (singleCharHit.isPrefix()) {
                    this.tmpHits.add(singleCharHit);
                }
            } else if (singleCharHit.isPrefix()) {
                this.tmpHits.add(singleCharHit);
            }
        } else {
            this.tmpHits.clear();
        }
        if (context.isBufferConsumed()) {
            this.tmpHits.clear();
        }
        if (this.tmpHits.isEmpty()) {
            context.unlockBuffer(SEGMENTER_NAME);
        } else {
            context.lockBuffer(SEGMENTER_NAME);
        }
    }

    @Override
    public void reset() {
        this.tmpHits.clear();
    }
}

