/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.dic;

import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.cfg.Configuration;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.dic.DictSegment;
import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.dic.Hit;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class Dictionary {
    private static final Logger LOGGER = Logger.getLogger(Dictionary.class);
    private static final String PATH_DIC_MAIN = "classpath:com/qianjiang/common/lucene/ikAnalyzer/org/wltea/analyzer/dic/main.dic";
    private static final String PATH_DIC_QUANTIFIER = "classpath:com/qianjiang/common/lucene/ikAnalyzer/org/wltea/analyzer/dic/quantifier.dic";
    private static Dictionary singleton;
    private DictSegment _MainDict;
    private DictSegment _StopWordDict;
    private DictSegment _QuantifierDict;
    private Configuration cfg;

    private Dictionary(Configuration cfg) {
        this.cfg = cfg;
        this.loadMainDict();
        this.loadStopWordDict();
        this.loadQuantifierDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Dictionary initial(Configuration cfg) {
        if (singleton != null) return singleton;
        Class<Dictionary> clazz = Dictionary.class;
        synchronized (Dictionary.class) {
            if (singleton != null) return singleton;
            singleton = new Dictionary(cfg);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public static Dictionary getSingleton() {
        if (singleton == null) {
            throw new IllegalStateException("\u8bcd\u5178\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initial\u65b9\u6cd5");
        }
        return singleton;
    }

    public void addWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.fillSegment(word.trim().toLowerCase().toCharArray());
            }
        }
    }

    public void disableWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.disableSegment(word.trim().toLowerCase().toCharArray());
            }
        }
    }

    public Hit matchInMainDict(char[] charArray) {
        return Dictionary.singleton._MainDict.match(charArray);
    }

    public Hit matchInMainDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._MainDict.match(charArray, begin, length);
    }

    public Hit matchInQuantifierDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._QuantifierDict.match(charArray, begin, length);
    }

    public Hit matchWithHit(char[] charArray, int currentIndex, Hit matchedHit) {
        DictSegment ds = matchedHit.getMatchedDictSegment();
        return ds.match(charArray, currentIndex, 1, matchedHit);
    }

    public boolean isStopWord(char[] charArray, int begin, int length) {
        return Dictionary.singleton._StopWordDict.match(charArray, begin, length).isMatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMainDict() {
        this._MainDict = new DictSegment(Character.valueOf('\u0000'));
        FileInputStream is = null;
        try {
            is = new FileInputStream(PATH_DIC_MAIN);
        }
        catch (FileNotFoundException e1) {
            LOGGER.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "utf-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
            } while (theWord != null);
            br.close();
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Main Dictionary loading exception.", (Throwable)ioe);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                    is = null;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.loadExtDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtDict() {
        List<String> extDictFiles = this.cfg.getExtDictionarys();
        if (extDictFiles != null) {
            InputStream is = null;
            for (String extDictName : extDictFiles) {
                LOGGER.debug((Object)("\u52a0\u8f7d\u6269\u5c55\u8bcd\u5178\uff1a" + extDictName));
                is = this.getClass().getClassLoader().getResourceAsStream(extDictName);
                if (is == null) continue;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"), 512);
                    String theWord = null;
                    do {
                        if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                        this._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
                    } while (theWord != null);
                    br.close();
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)"Extension Dictionary loading exception.", (Throwable)ioe);
                }
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStopWordDict() {
        this._StopWordDict = new DictSegment(Character.valueOf('\u0000'));
        List<String> extStopWordDictFiles = this.cfg.getExtStopWordDictionarys();
        if (extStopWordDictFiles != null) {
            InputStream is = null;
            for (String extStopWordDictName : extStopWordDictFiles) {
                LOGGER.debug((Object)("\u52a0\u8f7d\u6269\u5c55\u505c\u6b62\u8bcd\u5178\uff1a" + extStopWordDictName));
                is = this.getClass().getClassLoader().getResourceAsStream(extStopWordDictName);
                if (is == null) continue;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"), 512);
                    String theWord = null;
                    do {
                        if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                        this._StopWordDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
                    } while (theWord != null);
                    br.close();
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)"Extension Stop word Dictionary loading exception.", (Throwable)ioe);
                }
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQuantifierDict() {
        this._QuantifierDict = new DictSegment(Character.valueOf('\u0000'));
        FileInputStream is = null;
        try {
            is = new FileInputStream(PATH_DIC_QUANTIFIER);
        }
        catch (FileNotFoundException e1) {
            LOGGER.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "utf-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._QuantifierDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
            } while (theWord != null);
            br.close();
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Quantifier Dictionary loading exception.", (Throwable)ioe);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                    is = null;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

