/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.service.impl;

import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.bean.GoodsCate;
import com.qianjiang.channel.dao.GoodsCateMapper;
import com.qianjiang.mobile.bean.MobCateBar;
import com.qianjiang.mobile.dao.MobCateBarMapper;
import com.qianjiang.mobile.service.MobCateBarService;
import com.qianjiang.mobile.vo.MobCateBarVo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="MobCateBarService")
public class MobCateBarServiceImpl
implements MobCateBarService {
    @Resource(name="MobCateBarMapper")
    private MobCateBarMapper mobCateBarMapper;
    @Resource(name="ChannelGoodsCateMapper")
    private GoodsCateMapper goodsCateMapper;
    private static final MyLogger LOGGER = new MyLogger(MobCateBarServiceImpl.class);

    @Override
    public List<ChannelAdver> selectStoreListImage(String userStatus) {
        return this.mobCateBarMapper.selectStoreListImage(userStatus);
    }

    @Override
    public PageBean selectStoreListImageByPages(PageBean pb, String useStatus) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("useStatus", useStatus);
        pb.setRows(this.mobCateBarMapper.selectTurnsAdvertsCount(map));
        map.put("startRowNum", pb.getStartRowNum());
        map.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.mobCateBarMapper.selectTurnsAdvertsList(map));
        return pb;
    }

    @Override
    public PageBean selectStoreListQianggouImage(PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        pb.setRows(this.mobCateBarMapper.selectStoreListQianggouImageCount());
        map.put("startRowNum", pb.getStartRowNum());
        map.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.mobCateBarMapper.selectStoreListQianggouImage(map));
        return pb;
    }

    @Override
    public PageBean selectMobCateBarByPb(PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            pb.setRows(this.mobCateBarMapper.selectCountByPb());
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.mobCateBarMapper.selectAllByPb(map));
        }
        catch (Exception e) {
            LOGGER.error("\u79fb\u52a8\u7248\u5206\u9875\u67e5\u8be2\u9519\u8bef\uff1a=>", e);
        }
        return pb;
    }

    @Override
    public List<MobCateBarVo> selectMobCateBarForSite() {
        return this.mobCateBarMapper.selectAll();
    }

    @Override
    public List<MobCateBar> selectMobCateBarForMobChoose() {
        return this.mobCateBarMapper.selectAllForMobChoose();
    }

    @Override
    public MobCateBar selectMobcateBarById(Long mobcatebarId) {
        return this.mobCateBarMapper.selectByPrimaryKey(mobcatebarId);
    }

    @Override
    public int createMobCateBar(MobCateBar mobCateBar) {
        List<GoodsCate> list;
        int n = -1;
        Date date = new Date();
        mobCateBar.setCreateDate(date);
        mobCateBar.setUpdateDate(date);
        n = this.mobCateBarMapper.insertSelective(mobCateBar);
        if (mobCateBar.getGrade() == 1 && null != (list = this.goodsCateMapper.queryGoosCateByParentId(mobCateBar.getCateId())) && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                MobCateBar child = new MobCateBar();
                child.setCateId(list.get(i).getCatId());
                child.setParentId(mobCateBar.getCateBarId());
                child.setName(list.get(i).getCatName());
                child.setGrade(2);
                child.setSort(i + 1);
                child.setIsUsing("1");
                child.setDelflag("0");
                child.setCreateDate(date);
                child.setUpdateDate(date);
                this.mobCateBarMapper.insertSelective(child);
                long cateId = list.get(i).getCatId();
                List<GoodsCate> threeList = this.goodsCateMapper.queryGoosCateByParentId(cateId);
                if (null == threeList || threeList.size() <= 0) continue;
                for (int j = 0; j < threeList.size(); ++j) {
                    MobCateBar threeChild = new MobCateBar();
                    threeChild.setCateId(threeList.get(j).getCatId());
                    threeChild.setParentId(child.getCateBarId());
                    threeChild.setName(threeList.get(j).getCatName());
                    threeChild.setGrade(3);
                    threeChild.setSort(j + 1);
                    threeChild.setIsUsing("1");
                    threeChild.setDelflag("0");
                    threeChild.setCreateDate(date);
                    threeChild.setUpdateDate(date);
                    this.mobCateBarMapper.insertSelective(threeChild);
                }
            }
        }
        return n;
    }

    @Override
    public int updateMobCateBar(MobCateBar mobCateBar) {
        List<MobCateBar> list;
        Date date = new Date();
        if ("0".equals(mobCateBar.getIsUsing()) && !(list = this.mobCateBarMapper.selectByParentId(mobCateBar.getCateBarId())).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                MobCateBar cateBar = list.get(i);
                cateBar.setIsUsing("0");
                cateBar.setUpdateDate(date);
                this.mobCateBarMapper.updateByPrimaryKeySelective(cateBar);
            }
        }
        mobCateBar.setUpdateDate(date);
        return this.mobCateBarMapper.updateByPrimaryKeySelective(mobCateBar);
    }

    @Override
    public int deleteMobCateBar(Long mobCateBarId) {
        Date date = new Date();
        MobCateBar mobCateBar = this.mobCateBarMapper.selectByPrimaryKey(mobCateBarId);
        mobCateBar.setDelflag("1");
        mobCateBar.setUpdateDate(date);
        List<MobCateBar> list = this.mobCateBarMapper.selectByParentId(mobCateBar.getCateBarId());
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                MobCateBar cateBar = list.get(i);
                cateBar.setDelflag("1");
                cateBar.setUpdateDate(date);
                this.mobCateBarMapper.updateByPrimaryKeySelective(cateBar);
                List<MobCateBar> nodelist = this.mobCateBarMapper.selectByParentId(cateBar.getCateBarId());
                if (nodelist == null || nodelist.size() <= 0) continue;
                for (MobCateBar cat : nodelist) {
                    cat.setDelflag("1");
                    cat.setUpdateDate(date);
                    this.mobCateBarMapper.updateByPrimaryKeySelective(cat);
                }
            }
        }
        return this.mobCateBarMapper.updateByPrimaryKeySelective(mobCateBar);
    }

    @Override
    public boolean checkMobCateBarIsOnly(Long cateId) {
        return this.mobCateBarMapper.selectCountByCateId(cateId) <= 0;
    }

    @Override
    public boolean checkDelete(Long mobCateBarId) {
        boolean b = true;
        List<MobCateBar> list = this.mobCateBarMapper.selectByParentId(mobCateBarId);
        if (null != list && !list.isEmpty()) {
            b = false;
        }
        return b;
    }

    @Override
    public int changeUserdStatus(Long mobCateBarId) {
        List<MobCateBar> list;
        Date date = new Date();
        MobCateBar mobCateBar = this.mobCateBarMapper.selectByPrimaryKey(mobCateBarId);
        String status = "0".equals(mobCateBar.getIsUsing()) ? "1" : "0";
        mobCateBar.setIsUsing(status);
        if (mobCateBar.getGrade() == 1 && "0".equals(mobCateBar.getIsUsing()) && !(list = this.mobCateBarMapper.selectByParentId(mobCateBar.getCateBarId())).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                MobCateBar cateBar = list.get(i);
                cateBar.setIsUsing("0");
                cateBar.setUpdateDate(date);
                this.mobCateBarMapper.updateByPrimaryKeySelective(cateBar);
            }
        }
        mobCateBar.setUpdateDate(date);
        return this.mobCateBarMapper.updateByPrimaryKeySelective(mobCateBar);
    }

    @Override
    public List<MobCateBar> selectOneMobCate() {
        return this.mobCateBarMapper.selectOneMobCate();
    }

    @Override
    public List<MobCateBarVo> queryMobcateBarById(Long mobcatebarId) {
        return this.mobCateBarMapper.queryMobcateBarById(mobcatebarId);
    }

    @Override
    public List<MobCateBarVo> queryUsingMobCateBar(Long mobCateBarId) {
        return this.mobCateBarMapper.queryUsingMobCateBar(mobCateBarId);
    }

    @Override
    public List<MobCateBarVo> findMobileAllCates() {
        return null;
    }
}

