/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.bean.StatisticsCode;
import com.qianjiang.system.dao.IStatisticsCodeDao;
import com.qianjiang.system.service.IStatisticsCodeBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="statisticsCodeBizImpl")
public class StatisticsCodeBizImpl
implements IStatisticsCodeBiz {
    private static final MyLogger LOGGER = new MyLogger(StatisticsCodeBizImpl.class);
    private IStatisticsCodeDao statisticsCodeDaoImpl;
    @Resource
    private RedisAdapter redisAdapter;

    public final IStatisticsCodeDao getStatisticsCodeDaoImpl() {
        return this.statisticsCodeDaoImpl;
    }

    @Resource(name="statisticsCodeDaoImpl")
    public final void setStatisticsCodeDaoImpl(IStatisticsCodeDao statisticsCodeDaoImpl) {
        this.statisticsCodeDaoImpl = statisticsCodeDaoImpl;
    }

    @Override
    public final boolean saveStatisticsCode(StatisticsCode statisticsCode) {
        if (statisticsCode == null) {
            LOGGER.error("\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\uff01");
            return false;
        }
        try {
            this.redisAdapter.delete("CURRSTATISTICSCODE_KEY");
            return this.statisticsCodeDaoImpl.saveStatisticsCode(statisticsCode);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return false;
        }
    }

    @Override
    public final int updateStatisticsCode(StatisticsCode statisticsCode) {
        if (statisticsCode == null) {
            LOGGER.error("\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fee\u6539\u64cd\u4f5c\uff01");
            return 0;
        }
        try {
            this.redisAdapter.delete("CURRSTATISTICSCODE_KEY");
            return this.statisticsCodeDaoImpl.updateStatisticsCode(statisticsCode);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final StatisticsCode getStatisticsCodeById(int id) {
        if (id == 0) {
            LOGGER.error("\u5bf9\u8c61\u7edf\u8ba1\u4ee3\u7801\u7684id\u4e3a0\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return null;
        }
        try {
            return this.statisticsCodeDaoImpl.getStatisticsCodeById(id);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
    }

    @Override
    public final List<StatisticsCode> getStatisticsCodeByIds(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61\u7edf\u8ba1\u4ee3\u7801\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return Collections.emptyList();
        }
        try {
            return this.statisticsCodeDaoImpl.getStatisticsCodeByIds(ids);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return Collections.emptyList();
        }
    }

    @Override
    public final int deleteStatisticsCode(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61\u7edf\u8ba1\u4ee3\u7801\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return 0;
        }
        try {
            this.redisAdapter.delete("CURRSTATISTICSCODE_KEY");
            return this.statisticsCodeDaoImpl.deleteStatisticsCode(ids);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final int updateStatisticsCodeFieldById(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u66f4\u65b0\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\uff01");
            return 0;
        }
        if (parameter.containsKey("ids")) {
            String ids = (String)parameter.get("ids");
            ArrayList<String> idList = new ArrayList<String>();
            if (ids.contains(",")) {
                for (String id : ids.split(",")) {
                    idList.add(id);
                }
            } else {
                idList.add(ids);
            }
            parameter.put("ids", idList);
        }
        try {
            this.redisAdapter.delete("CURRSTATISTICSCODE_KEY");
            return this.statisticsCodeDaoImpl.updateStatisticsCodeFieldById(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final int getStatisticsCodeByFieldTotal(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636e\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.statisticsCodeDaoImpl.getStatisticsCodeByFieldTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final PageBean getStatisticsCodeByField(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636e\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.getStatisticsCodeByFieldTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put("startRowNum", pageBean.getStartRowNum());
            parameter.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.statisticsCodeDaoImpl.getStatisticsCodeByField(parameter));
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
        return pageBean;
    }

    @Override
    public final int queryStatisticsCodeTotal(Map<String, Object> parameter) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.statisticsCodeDaoImpl.queryStatisticsCodeTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final PageBean queryStatisticsCodeByPage(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5206\u9875\u67e5\u8be2\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.queryStatisticsCodeTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put("startRowNum", pageBean.getStartRowNum());
            parameter.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.statisticsCodeDaoImpl.queryStatisticsCodeByPage(parameter));
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
        return pageBean;
    }

    @Override
    public boolean changeUserdStatus(Long scodeId) {
        boolean b = false;
        try {
            StatisticsCode scode = this.statisticsCodeDaoImpl.getStatisticsCodeById(scodeId.intValue());
            if ("0".equals(scode.getUsedStatus())) {
                scode.setUsedStatus("1");
            } else {
                scode.setUsedStatus("0");
            }
            this.redisAdapter.delete("CURRSTATISTICSCODE_KEY");
            return this.statisticsCodeDaoImpl.updateStatisticsCode(scode) > 0;
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u7edf\u8ba1\u4ee3\u7801\u542f\u7528\u72b6\u6001\u9519\u8bef:=>", e);
            return b;
        }
    }

    @Override
    public List<StatisticsCode> getCurrStatisticsCode() {
        List<StatisticsCode> list = null;
        try {
            list = (List<StatisticsCode>)this.redisAdapter.get("CURRSTATISTICSCODE_KEY");
            if (!CollectionUtils.isEmpty((Collection)list)) {
                return list;
            }
            list = this.statisticsCodeDaoImpl.selectAllStatisticsCode();
            this.redisAdapter.put("CURRSTATISTICSCODE_KEY", new ArrayList<StatisticsCode>(list));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7edf\u8ba1\u4ee3\u7801\u9519\u8bef:=>", e);
        }
        return list;
    }
}

