/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.AreaPackage;
import com.qianjiang.system.dao.IAreaPackageDao;
import com.qianjiang.system.service.IAreaPackageBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="areaPackageBizImpl")
public class AreaPackageBizImpl
implements IAreaPackageBiz {
    private static final MyLogger LOGGER = new MyLogger(AreaPackageBizImpl.class);
    private IAreaPackageDao areaPackageDaoImpl;

    public IAreaPackageDao getAreaPackageDaoImpl() {
        return this.areaPackageDaoImpl;
    }

    @Resource(name="areaPackageDaoImpl")
    public void setAreaPackageDaoImpl(IAreaPackageDao areaPackageDaoImpl) {
        this.areaPackageDaoImpl = areaPackageDaoImpl;
    }

    @Override
    public boolean saveAreaPackage(AreaPackage areaPackage) {
        if (areaPackage == null) {
            LOGGER.error("\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\uff01");
            return false;
        }
        try {
            return this.areaPackageDaoImpl.saveAreaPackage(areaPackage);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return false;
        }
    }

    @Override
    public int updateAreaPackage(AreaPackage areaPackage) {
        if (areaPackage == null) {
            LOGGER.error("\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fee\u6539\u64cd\u4f5c\uff01");
            return 0;
        }
        if ("1".equals(areaPackage.getDefaultPackage())) {
            this.areaPackageDaoImpl.changeAllDefaultStatusToNot();
        }
        try {
            return this.areaPackageDaoImpl.updateAreaPackage(areaPackage);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public AreaPackage getAreaPackageById(int id) {
        if (id == 0) {
            LOGGER.error("\u5bf9\u8c61\u5730\u533a\u8bbe\u7f6e\u7684id\u4e3a0\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return null;
        }
        try {
            return this.areaPackageDaoImpl.getAreaPackageById(id);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return null;
        }
    }

    @Override
    public List<AreaPackage> getAreaPackageByIds(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61\u5730\u533a\u8bbe\u7f6e\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return Collections.emptyList();
        }
        try {
            return this.areaPackageDaoImpl.getAreaPackageByIds(ids);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return Collections.emptyList();
        }
    }

    @Override
    public int deleteAreaPackage(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61\u5730\u533a\u8bbe\u7f6e\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return 0;
        }
        try {
            return this.areaPackageDaoImpl.deleteAreaPackage(ids);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public int updateAreaPackageFieldById(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u66f4\u65b0\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\uff01");
            return 0;
        }
        if (parameter.containsKey("ids")) {
            String ids = (String)parameter.get("ids");
            ArrayList<String> idList = new ArrayList<String>();
            if (ids.contains(",")) {
                for (String id : ids.split(",")) {
                    idList.add(id);
                }
            } else {
                idList.add(ids);
            }
            parameter.put("ids", idList);
        }
        try {
            return this.areaPackageDaoImpl.updateAreaPackageFieldById(parameter);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public int getAreaPackageByFieldTotal(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636e\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.areaPackageDaoImpl.getAreaPackageByFieldTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public PageBean getAreaPackageByField(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636e\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.getAreaPackageByFieldTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put("startRowNum", pageBean.getStartRowNum());
            parameter.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.areaPackageDaoImpl.getAreaPackageByField(parameter));
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return null;
        }
        return pageBean;
    }

    @Override
    public int queryAreaPackageTotal(Map<String, Object> parameter) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.areaPackageDaoImpl.queryAreaPackageTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    @Override
    public PageBean queryAreaPackageByPage(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5206\u9875\u67e5\u8be2\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.queryAreaPackageTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put("startRowNum", pageBean.getStartRowNum());
            parameter.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.areaPackageDaoImpl.queryAreaPackageByPage(parameter));
        }
        catch (Exception e) {
            LOGGER.error("", e);
            return null;
        }
        return pageBean;
    }

    @Override
    public void deleteById(Integer areaPackageId) {
        AreaPackage areaPackage = new AreaPackage();
        areaPackage.setAreaPackageId(areaPackageId);
        areaPackage.setDeleteStatus(1);
        this.areaPackageDaoImpl.updateAreaPackage(areaPackage);
    }
}

