/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.freight.service.impl;

import com.alibaba.fastjson.JSON;
import com.qianjiang.freight.bean.Express;
import com.qianjiang.freight.bean.FreightExpress;
import com.qianjiang.freight.bean.FreightExpressAll;
import com.qianjiang.freight.bean.FreightTemplate;
import com.qianjiang.freight.bean.SysCity;
import com.qianjiang.freight.bean.SysLogisticsCompany;
import com.qianjiang.freight.dao.ExpressInfoMapper;
import com.qianjiang.freight.dao.FreightExpressAllMapper;
import com.qianjiang.freight.dao.FreightExpressMapper;
import com.qianjiang.freight.dao.FreightTemplateMapper;
import com.qianjiang.freight.dao.SysCityMapper;
import com.qianjiang.freight.dao.SysLogisticsCompanyMapper;
import com.qianjiang.freight.service.FreightTemplateService;
import com.qianjiang.util.MapUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="FreightTemplateService")
public class FreightTemplateServiceImpl
implements FreightTemplateService {
    private static final String FREIGHTTHIRDID = "freightThirdId";
    private static final String START = "_start";
    private static final String POSTAGE = "_postage";
    private static final String PLUS = "_plus";
    private static final String POSTAGEPLUS = "_postageplus";
    private static final String AREAS = "_areas";
    private static final String FREIGHTISDEFAULT = "freightIsDefault";
    @Resource(name="FreightTemplateMapper")
    private FreightTemplateMapper freightTemplateMapper;
    @Resource(name="FreightExpressMapper")
    private FreightExpressMapper freightExpressMapper;
    @Resource(name="SysLogisticsCompanyMapper")
    private SysLogisticsCompanyMapper sysLogisticsCompanyMapper;
    @Resource(name="SysCityMapper")
    private SysCityMapper sysCityMapper;
    @Resource(name="FreightExpressAllMapper")
    private FreightExpressAllMapper freightExpressAllMapper;
    @Resource(name="expressInfoMapperThird")
    private ExpressInfoMapper expressInfoMapper;

    @Override
    public List<FreightTemplate> searchAllTemplate(FreightTemplate freightTemplate) {
        Map<String, Object> map = MapUtil.getParamsMap(freightTemplate);
        List<FreightTemplate> list = this.freightTemplateMapper.searchAllTemplateList(map);
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                List<FreightExpress> fe = this.freightExpressMapper.selectTemplateExpress(list.get(i).getFreightTemplateId());
                for (int q = 0; q < fe.size(); ++q) {
                    if ("0".equals(freightTemplate.getFreightThirdId().toString())) {
                        fe.get(q).setSysLogisticsCompany(this.sysLogisticsCompanyMapper.selectCompanyById(fe.get(q).getLogComId()));
                    } else {
                        fe.get(q).setExpress(this.expressInfoMapper.selectByshoreExpId(fe.get(q).getLogComId()));
                    }
                    if (fe.get(q).getFreightExpressAll() == null || fe.get(q).getFreightExpressAll().isEmpty() || fe.get(q).getFreightExpressAll().size() <= 0) continue;
                    List<FreightExpressAll> fall = fe.get(q).getFreightExpressAll();
                    for (int j = 0; j < fall.size(); ++j) {
                        String[] cityIds;
                        String areaIds = fall.get(j).getExpressArea();
                        if ("".equals(areaIds) || (cityIds = areaIds.split(",")) == null || cityIds.length == 0) continue;
                        StringBuilder tempName = new StringBuilder();
                        for (int n = 0; n < cityIds.length; ++n) {
                            SysCity city = this.sysCityMapper.selectCityById(Long.valueOf(cityIds[n]));
                            if (city == null) continue;
                            tempName.append(city.getCityName());
                            if (n >= cityIds.length - 1) continue;
                            tempName.append(",");
                        }
                        fall.get(j).setAllCityName(tempName.toString());
                    }
                    fe.get(q).setFreightExpressAll(fall);
                }
                list.get(i).setFreightExpressList(fe);
            }
        }
        return list;
    }

    @Override
    @Transactional
    public int copyFreightTemplate(Long freightTemplateId) {
        FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateById(freightTemplateId);
        int insertFlag = 0;
        if (ft != null) {
            ft.setFreightCreateTime(new Date());
            ft.setFreightModifyTime(new Date());
            ft.setFreightTemplateId(null);
            ft.setFreightNoDelete("0");
            ft.setFreightIsDefault("0");
            ft.setFreightTemplateName(ft.getFreightTemplateName() + "\u7684\u526f\u672c");
            insertFlag = this.freightTemplateMapper.insertNewFreightTemplate(ft);
            if (insertFlag == 1) {
                Long newFreightTemplateId = this.freightTemplateMapper.selectFreightTemplateLastId();
                List<FreightExpress> fe = this.freightExpressMapper.selectTemplateExpress(freightTemplateId);
                if (fe != null && !fe.isEmpty()) {
                    for (int i = 0; i < fe.size(); ++i) {
                        fe.get(i).setDistributionId(null);
                        fe.get(i).setFreightTemplateId(newFreightTemplateId);
                        int einsetFlag = this.freightExpressMapper.insertNewFreightExpress(fe.get(i));
                        if (einsetFlag != 1) continue;
                        Long newDistributionId = this.freightExpressMapper.selectLastDistributionId();
                        List<FreightExpressAll> falist = fe.get(i).getFreightExpressAll();
                        if (falist == null || falist.isEmpty()) continue;
                        for (int j = 0; j < falist.size(); ++j) {
                            falist.get(j).setDistributionId(newDistributionId);
                            falist.get(j).setExpressAreaId(null);
                        }
                        this.freightExpressAllMapper.insertFreightExpressAll(falist);
                    }
                }
            }
        }
        return insertFlag;
    }

    @Override
    @Transactional
    public int deleteFreightTemplate(Long freightTemplateId, Long freightThirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightTemplateId", freightTemplateId);
        map.put(FREIGHTTHIRDID, freightThirdId);
        int delFlag = this.freightTemplateMapper.deleteFreightTemplate(map);
        if (delFlag == 1) {
            List<FreightExpress> fe = this.freightExpressMapper.selectTemplateExpress(freightTemplateId);
            for (int i = 0; i < fe.size(); ++i) {
                int f = this.freightExpressMapper.deleteTemplateExpress(fe.get(i).getDistributionId());
                if (f <= 0) continue;
                this.freightExpressAllMapper.deleteTemplateExpressAll(fe.get(i).getDistributionId());
            }
        }
        return delFlag;
    }

    @Override
    @Transactional
    public int defaultFreightTemplate(FreightTemplate freightTemplate) {
        int s = this.freightTemplateMapper.noDefaultFreightTemplate(freightTemplate);
        int defaultFlag = 0;
        if (s > 0) {
            defaultFlag = this.freightTemplateMapper.defaultFreightTemplate(freightTemplate);
        }
        return defaultFlag;
    }

    @Override
    public FreightTemplate selectFreightTemplateDetail(Long freightTemplateId) {
        FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateById(freightTemplateId);
        if (ft != null) {
            List<FreightExpress> fe = this.freightExpressMapper.selectTemplateExpress(ft.getFreightTemplateId());
            for (int q = 0; q < fe.size(); ++q) {
                if ("0".equals(ft.getFreightThirdId().toString())) {
                    fe.get(q).setSysLogisticsCompany(this.sysLogisticsCompanyMapper.selectCompanyById(fe.get(q).getLogComId()));
                } else {
                    fe.get(q).setExpress(this.expressInfoMapper.selectByshoreExpId(fe.get(q).getLogComId()));
                }
                if (fe.get(q).getFreightExpressAll() == null || fe.get(q).getFreightExpressAll().isEmpty() || fe.get(q).getFreightExpressAll().size() <= 0) continue;
                List<FreightExpressAll> fall = fe.get(q).getFreightExpressAll();
                for (int j = 0; j < fall.size(); ++j) {
                    String[] cityIds;
                    String areaIds = fall.get(j).getExpressArea();
                    if ("".equals(areaIds) || (cityIds = areaIds.split(",")) == null || cityIds.length == 0) continue;
                    StringBuilder tempName = new StringBuilder();
                    for (int n = 0; n < cityIds.length; ++n) {
                        SysCity city = this.sysCityMapper.selectCityById(Long.valueOf(cityIds[n]));
                        if (city == null) continue;
                        tempName.append(city.getCityName());
                        if (n >= cityIds.length - 1) continue;
                        tempName.append(",");
                    }
                    fall.get(j).setAllCityName(tempName.toString());
                }
                fe.get(q).setFreightExpressAll(fall);
            }
            ft.setFreightExpressList(fe);
        }
        return ft;
    }

    @Override
    @Transactional
    public int saveFreight(Map<String, Object> requestMap, FreightTemplate freightTemplate) {
        String[] logComIds;
        Long freightTemplateId = Long.valueOf((String)requestMap.get("freightTemplateId"));
        List<FreightExpress> freightExpress = this.freightExpressMapper.selectTemplateExpress(freightTemplateId);
        if (freightExpress != null) {
            for (int i = 0; i < freightExpress.size(); ++i) {
                if (freightExpress.get(i) == null) continue;
                this.freightExpressAllMapper.deleteTemplateExpressAll(freightExpress.get(i).getDistributionId());
            }
        }
        this.freightExpressMapper.deleteFreExpByTid(freightTemplateId);
        freightTemplate.setFreightTemplateId(freightTemplateId);
        freightTemplate.setFreightModifyTime(new Date());
        int s = this.freightTemplateMapper.updateByPrimaryKeySelective(freightTemplate);
        if (s == 1 && (logComIds = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get("logComId")), String[].class)) != null && logComIds.length > 0) {
            for (int i = 0; i < logComIds.length; ++i) {
                FreightExpressAll fea;
                int j;
                Long distributionId;
                FreightExpress fe;
                String[] areass;
                String[] postageplus;
                String[] pluss;
                String[] postages;
                String[] starts;
                String excode = "";
                if (requestMap.get("thirdId") != null) {
                    Express ex = this.expressInfoMapper.selectByshoreExpId(Long.valueOf(logComIds[i]));
                    excode = ex.getExpCompany();
                    Long exComId = ex.getShoreExpId();
                    if (ex == null) continue;
                    starts = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + START)), String[].class);
                    postages = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + POSTAGE)), String[].class);
                    pluss = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + PLUS)), String[].class);
                    postageplus = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + POSTAGEPLUS)), String[].class);
                    areass = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + AREAS)), String[].class);
                    if (starts == null || starts.length <= 0) continue;
                    fe = new FreightExpress();
                    fe.setLogComId(exComId);
                    fe.setFreightTemplateId(freightTemplateId);
                    fe.setExpressStart(Long.valueOf(starts[0]));
                    fe.setExpressPostage(new BigDecimal(postages[0].trim()));
                    fe.setExpressPlusN1(Long.valueOf(pluss[0]));
                    fe.setExpressPostageplus(new BigDecimal(postageplus[0].trim()));
                    this.freightExpressMapper.insertNewFreightExpress(fe);
                    distributionId = this.freightExpressMapper.selectLastDistributionId();
                    if (starts.length <= 1) continue;
                    for (j = 1; j < starts.length; ++j) {
                        fea = new FreightExpressAll();
                        fea.setExpressArea(areass[j]);
                        fea.setExpressStart(Long.valueOf(starts[j]));
                        fea.setExpressPostage(new BigDecimal(postages[j].trim()));
                        fea.setExpressPlusN1(Long.valueOf(pluss[j]));
                        fea.setExpressPostageplus(new BigDecimal(postageplus[j].trim()));
                        fea.setDistributionId(distributionId);
                        this.freightExpressAllMapper.insertSelective(fea);
                    }
                    continue;
                }
                SysLogisticsCompany sc = this.sysLogisticsCompanyMapper.selectCompanyById(Long.valueOf(logComIds[i]));
                if (sc == null) continue;
                starts = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + START)), String[].class);
                postages = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + POSTAGE)), String[].class);
                pluss = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + PLUS)), String[].class);
                postageplus = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + POSTAGEPLUS)), String[].class);
                areass = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + AREAS)), String[].class);
                if (starts == null || starts.length <= 0) continue;
                fe = new FreightExpress();
                fe.setLogComId(sc.getLogComId());
                fe.setFreightTemplateId(freightTemplateId);
                fe.setExpressStart(Long.valueOf(starts[0]));
                fe.setExpressPostage(new BigDecimal(postages[0].trim()));
                fe.setExpressPlusN1(Long.valueOf(pluss[0]));
                fe.setExpressPostageplus(new BigDecimal(postageplus[0].trim()));
                this.freightExpressMapper.insertNewFreightExpress(fe);
                distributionId = this.freightExpressMapper.selectLastDistributionId();
                if (starts.length <= 1) continue;
                for (j = 1; j < starts.length; ++j) {
                    fea = new FreightExpressAll();
                    fea.setExpressArea(areass[j]);
                    fea.setExpressStart(Long.valueOf(starts[j]));
                    fea.setExpressPostage(new BigDecimal(postages[j].trim()));
                    fea.setExpressPlusN1(Long.valueOf(pluss[j]));
                    fea.setExpressPostageplus(new BigDecimal(postageplus[j].trim()));
                    fea.setDistributionId(distributionId);
                    this.freightExpressAllMapper.insertSelective(fea);
                }
            }
        }
        return s;
    }

    @Override
    @Transactional
    public int addFreight(Map<String, Object> requestMap, FreightTemplate freightTemplate) {
        String[] logComIds;
        freightTemplate.setFreightCreateTime(new Date());
        freightTemplate.setFreightModifyTime(new Date());
        int count = this.freightTemplateMapper.insertNewFreightTemplate(freightTemplate);
        Long ferightTemplateId = this.freightTemplateMapper.selectFreightTemplateLastId();
        if (count == 1 && (logComIds = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get("logComId")), String[].class)) != null && logComIds.length > 0) {
            for (int i = 0; i < logComIds.length; ++i) {
                FreightExpressAll fea;
                int j;
                Long distributionId;
                FreightExpress fe;
                String[] areass;
                String[] postageplus;
                String[] pluss;
                String[] postages;
                String[] starts;
                Long exComId;
                String excode = "";
                if (requestMap.get("thirdId") != null) {
                    Express ex = this.expressInfoMapper.selectByshoreExpId(Long.valueOf(logComIds[i]));
                    excode = ex.getExpCompany();
                    exComId = ex.getShoreExpId();
                    if (ex == null) continue;
                    starts = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + START)), String[].class);
                    postages = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + POSTAGE)), String[].class);
                    pluss = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + PLUS)), String[].class);
                    postageplus = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + POSTAGEPLUS)), String[].class);
                    areass = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + AREAS)), String[].class);
                    if (starts == null || starts.length <= 0 || "".equals(starts[0].trim())) continue;
                    fe = new FreightExpress();
                    fe.setLogComId(exComId);
                    fe.setFreightTemplateId(ferightTemplateId);
                    fe.setExpressStart(Long.valueOf(starts[0]));
                    fe.setExpressPostage(new BigDecimal(postages[0].trim()));
                    fe.setExpressPlusN1(Long.valueOf(pluss[0]));
                    fe.setExpressPostageplus(new BigDecimal(postageplus[0].trim()));
                    this.freightExpressMapper.insertNewFreightExpress(fe);
                    distributionId = this.freightExpressMapper.selectLastDistributionId();
                    if (starts.length <= 1 || "".equals(starts[0].trim())) continue;
                    for (j = 1; j < starts.length; ++j) {
                        fea = new FreightExpressAll();
                        fea.setExpressArea(areass[j]);
                        fea.setExpressStart(Long.valueOf(starts[j]));
                        fea.setExpressPostage(new BigDecimal(postages[j].trim()));
                        fea.setExpressPlusN1(Long.valueOf(pluss[j]));
                        fea.setExpressPostageplus(new BigDecimal(postageplus[j].trim()));
                        fea.setDistributionId(distributionId);
                        this.freightExpressAllMapper.insertSelective(fea);
                    }
                    continue;
                }
                SysLogisticsCompany sc = this.sysLogisticsCompanyMapper.selectCompanyById(Long.valueOf(logComIds[i]));
                excode = sc.getCode();
                exComId = sc.getLogComId();
                if (sc == null) continue;
                starts = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + START)), String[].class);
                postages = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + POSTAGE)), String[].class);
                pluss = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + PLUS)), String[].class);
                postageplus = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + POSTAGEPLUS)), String[].class);
                areass = (String[])JSON.parseObject((String)JSON.toJSONString((Object)requestMap.get(excode + AREAS)), String[].class);
                if (starts == null || starts.length <= 0) continue;
                fe = new FreightExpress();
                fe.setLogComId(exComId);
                fe.setFreightTemplateId(ferightTemplateId);
                fe.setExpressStart(Long.valueOf(starts[0]));
                fe.setExpressPostage(new BigDecimal(postages[0].trim()));
                fe.setExpressPlusN1(Long.valueOf(pluss[0]));
                fe.setExpressPostageplus(new BigDecimal(postageplus[0].trim()));
                this.freightExpressMapper.insertNewFreightExpress(fe);
                distributionId = this.freightExpressMapper.selectLastDistributionId();
                if (starts.length <= 1) continue;
                for (j = 1; j < starts.length; ++j) {
                    fea = new FreightExpressAll();
                    fea.setExpressArea(areass[j]);
                    fea.setExpressStart(Long.valueOf(starts[j]));
                    fea.setExpressPostage(new BigDecimal(postages[j].trim()));
                    fea.setExpressPlusN1(Long.valueOf(pluss[j]));
                    fea.setExpressPostageplus(new BigDecimal(postageplus[j].trim()));
                    fea.setDistributionId(distributionId);
                    this.freightExpressAllMapper.insertSelective(fea);
                }
            }
        }
        return count;
    }

    @Override
    public BigDecimal getExpressPrice(Long distributionId, Long cityId, Long thirdId, Integer num, BigDecimal weight) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(FREIGHTISDEFAULT, "1");
        paramMap.put(FREIGHTTHIRDID, thirdId);
        FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
        if (ft != null) {
            List<FreightExpress> fe = this.freightExpressMapper.selectTemplateExpress(ft.getFreightTemplateId());
            if (fe != null && !fe.isEmpty()) {
                if (distributionId != null && thirdId == 0L) {
                    for (int i = 0; i < fe.size(); ++i) {
                        if (!distributionId.equals(fe.get(i).getDistributionId())) continue;
                        List<FreightExpressAll> fall = fe.get(i).getFreightExpressAll();
                        if (fall != null && !fall.isEmpty()) {
                            for (int j = 0; j < fall.size(); ++j) {
                                String area = fall.get(j).getExpressArea();
                                String[] cityIds = area.split(",");
                                boolean flag = false;
                                for (String ciId : cityIds) {
                                    if (!ciId.equals(cityId.toString())) continue;
                                    flag = true;
                                    break;
                                }
                                if (!flag) continue;
                                return this.computeFreightAll(ft.getFreightMethods(), fall.get(j), num, weight);
                            }
                            return this.computeFreight(ft.getFreightMethods(), fe.get(i), num, weight);
                        }
                        return this.computeFreight(ft.getFreightMethods(), fe.get(i), num, weight);
                    }
                } else {
                    List<FreightExpressAll> fall = fe.get(0).getFreightExpressAll();
                    if (fall != null && !fall.isEmpty()) {
                        for (int j = 0; j < fall.size(); ++j) {
                            String area = fall.get(j).getExpressArea();
                            String[] cityIds = area.split(",");
                            boolean flag = false;
                            for (String ciId : cityIds) {
                                if (!ciId.equals(cityId.toString())) continue;
                                flag = true;
                                break;
                            }
                            if (!flag) continue;
                            return this.computeFreightAll(ft.getFreightMethods(), fall.get(j), num, weight);
                        }
                        return this.computeFreight(ft.getFreightMethods(), fe.get(0), num, weight);
                    }
                    return this.computeFreight(ft.getFreightMethods(), fe.get(0), num, weight);
                }
            }
            return new BigDecimal(0);
        }
        return new BigDecimal(0);
    }

    public BigDecimal computeFreightAll(String motheds, FreightExpressAll frall, Integer num, BigDecimal weight) {
        BigDecimal price = new BigDecimal(0);
        if (num == 0) {
            return price;
        }
        if ("0".equals(motheds)) {
            if (num < Integer.parseInt(frall.getExpressStart().toString())) {
                int a = 0;
                BigDecimal temp = frall.getExpressPostageplus().multiply(new BigDecimal(a));
                price = frall.getExpressPostage().add(temp);
            } else {
                int a = num - Integer.parseInt(frall.getExpressStart().toString());
                BigDecimal temp = frall.getExpressPostageplus().multiply(new BigDecimal(a).divide(new BigDecimal(frall.getExpressPlusN1()), 0, 0));
                price = frall.getExpressPostage().add(temp);
            }
            return price;
        }
        if (weight.compareTo(new BigDecimal(frall.getExpressStart())) == -1) {
            BigDecimal a = new BigDecimal(0);
            BigDecimal temp = frall.getExpressPostageplus().multiply(a);
            price = frall.getExpressPostage().add(temp);
        } else {
            BigDecimal a = weight.subtract(new BigDecimal(frall.getExpressStart()));
            BigDecimal temp = frall.getExpressPostageplus().multiply(a.divide(new BigDecimal(frall.getExpressPlusN1()), 0, 0));
            price = frall.getExpressPostage().add(temp);
        }
        return price;
    }

    public BigDecimal computeFreight(String motheds, FreightExpress fe, Integer num, BigDecimal weight) {
        BigDecimal price = new BigDecimal(0);
        if (num == 0) {
            return price;
        }
        if ("0".equals(motheds)) {
            if (num < Integer.parseInt(fe.getExpressStart().toString())) {
                int a = 0;
                BigDecimal temp = fe.getExpressPostageplus().multiply(new BigDecimal(a));
                price = fe.getExpressPostage().add(temp);
            } else {
                int a = num - Integer.parseInt(fe.getExpressStart().toString());
                BigDecimal temp = fe.getExpressPostageplus().multiply(new BigDecimal(a).divide(new BigDecimal(fe.getExpressPlusN1()), 0, 0));
                price = fe.getExpressPostage().add(temp);
            }
            return price;
        }
        if (weight.compareTo(new BigDecimal(fe.getExpressStart())) == -1) {
            BigDecimal a = new BigDecimal(0);
            BigDecimal temp = fe.getExpressPostageplus().multiply(a);
            price = fe.getExpressPostage().add(temp);
        } else {
            BigDecimal a = weight.subtract(new BigDecimal(fe.getExpressStart()));
            BigDecimal temp = fe.getExpressPostageplus().multiply(a.divide(new BigDecimal(fe.getExpressPlusN1()), 0, 0));
            price = fe.getExpressPostage().add(temp);
        }
        return price;
    }

    @Override
    public List<FreightExpress> selectFreightTemplateDefault() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(FREIGHTISDEFAULT, "1");
        paramMap.put(FREIGHTTHIRDID, "0");
        FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
        if (ft != null) {
            List<FreightExpress> fe = this.freightExpressMapper.selectTemplateExpress(ft.getFreightTemplateId());
            if (fe != null) {
                for (int i = 0; i < fe.size(); ++i) {
                    fe.get(i).setSysLogisticsCompany(this.sysLogisticsCompanyMapper.selectCompanyById(fe.get(i).getLogComId()));
                    fe.get(i).setFreightTemplate(ft);
                }
            }
            return fe;
        }
        return new ArrayList<FreightExpress>();
    }

    @Override
    public FreightExpress selectFreightExpressByDistriThirdId(Long thirdId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(FREIGHTISDEFAULT, "1");
        paramMap.put(FREIGHTTHIRDID, thirdId);
        FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
        if (ft != null) {
            if ("1".equals(ft.getFreightPackageMail())) {
                return new FreightExpress();
            }
            List<FreightExpress> fe = this.freightExpressMapper.selectTemplateExpress(ft.getFreightTemplateId());
            if (fe != null && !fe.isEmpty()) {
                fe.get(0).setExpress(this.expressInfoMapper.selectByshoreExpId(fe.get(0).getLogComId()));
                return fe.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public List<FreightTemplate> queryTemplate() {
        return this.freightTemplateMapper.queryTemplate();
    }
}

