/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.service.impl;

import com.qianjiang.information.bean.InformationType;
import com.qianjiang.information.dao.ThirdInforTypeMapper;
import com.qianjiang.information.service.ThirdInforTypeService;
import com.qianjiang.information.vo.InformationTypeVo;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ThirdInforTypeService")
public class ThirdInforTypeServiceImpl
implements ThirdInforTypeService {
    @Resource(name="ThirdInforTypeMapper")
    private ThirdInforTypeMapper thirdInforTypeMapper;
    private static final String TEMP2 = "temp2";

    @Override
    public void delInformation(Long infoTypeId, Long loginUserId) {
        InformationType infoType = this.selectByPrimaryKey(infoTypeId);
        infoType.setDelflag("1");
        infoType.setUpdateUserId(loginUserId);
        infoType.setUpdateDate(new Date());
        this.updateInformation(infoType);
    }

    @Override
    public void batchDelInformation(Long[] ids, Long loginUserId) {
        if (null != ids && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                this.delInformation(ids[i], loginUserId);
            }
        }
    }

    @Override
    public void saveInformation(InformationType record, String thirdId) {
        if (record.getParentId() == 0L) {
            record.setGrade(1);
        } else {
            record.setGrade(this.thirdInforTypeMapper.selectByPrimaryKey(record.getParentId()).getGrade() + 1);
        }
        record.setTemp1("1");
        record.setTemp2(thirdId);
        Date date = new Date();
        record.setCreateDate(date);
        record.setUpdateDate(date);
        this.thirdInforTypeMapper.insertSelective(record);
    }

    @Override
    public void updateInformation(InformationType record) {
        if (record.getParentId() == 0L) {
            record.setGrade(1);
        } else {
            record.setGrade(this.thirdInforTypeMapper.selectByPrimaryKey(record.getParentId()).getGrade() + 1);
        }
        record.setUpdateDate(new Date());
        this.thirdInforTypeMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public InformationType selectByPrimaryKey(Long infoTypeId) {
        return this.thirdInforTypeMapper.selectByPrimaryKey(infoTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBean(PageBean pb, String typeName, String thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (null == typeName || "".equals(typeName)) {
                map.put(TEMP2, thirdId);
                pb.setRows(this.thirdInforTypeMapper.queryTotalCount(map));
                map.put("startRowNum", pb.getStartRowNum());
                map.put("endRowNum", pb.getEndRowNum());
                pb.setList(this.thirdInforTypeMapper.queryByPageBean(map));
            } else {
                map.put("searchText", typeName);
                map.put(TEMP2, thirdId);
                pb.setRows(this.thirdInforTypeMapper.queryTotalCountForSearch(map));
                map.put("startRowNum", pb.getStartRowNum());
                map.put("endRowNum", pb.getEndRowNum());
                pb.setList(this.thirdInforTypeMapper.queryByPageBeanForSearch(map));
            }
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public List<InformationTypeVo> selectAllByThirdId(String thirdId) {
        return this.thirdInforTypeMapper.selectAllByThirdId(thirdId);
    }

    @Override
    public List<InformationType> selectInfoTypeByAttr(String thirdId) {
        return this.thirdInforTypeMapper.selectInfoTypeByAttr(thirdId);
    }

    @Override
    public boolean checkDelWithInfoTypeId(Long infoTypeId) {
        return this.thirdInforTypeMapper.selectCountByParentId(infoTypeId) <= 0;
    }

    @Override
    public boolean checkAddInfoTypeByName(String name, String thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put(TEMP2, thirdId);
        return this.thirdInforTypeMapper.selectInfoTypeCountByName(map) <= 0;
    }

    @Override
    public boolean checkAddInfoTypeByName(String name, String thirdId, Long infoTypeId) {
        InformationType infoType = this.thirdInforTypeMapper.selectByPrimaryKey(infoTypeId);
        if (null != infoType) {
            if (infoType.getName().equals(name)) {
                return true;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", name);
            map.put(TEMP2, thirdId);
            return this.thirdInforTypeMapper.selectInfoTypeCountByName(map) <= 0;
        }
        return false;
    }

    @Override
    public List<InformationTypeVo> getInfoTypeList(Long parentId) {
        return this.thirdInforTypeMapper.selectByParentId(parentId);
    }
}

