/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.license.util.checkLicense.swing;

import com.qianjiang.license.util.checkLicense.swing.LoopedStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class ConsoleTextArea
extends JTextArea {
    public ConsoleTextArea(InputStream[] inStreams) {
        for (int i = 0; i < inStreams.length; ++i) {
            this.startConsoleReaderThread(inStreams[i]);
        }
    }

    public ConsoleTextArea() throws IOException {
        LoopedStreams ls = new LoopedStreams();
        PrintStream ps = new PrintStream(ls.getOutputStream());
        System.setOut(ps);
        System.setErr(ps);
        this.startConsoleReaderThread(ls.getInputStream());
    }

    private void startConsoleReaderThread(InputStream inStream) {
        final BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        new Thread(new Runnable(){

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer();
                try {
                    String s;
                    Document doc = ConsoleTextArea.this.getDocument();
                    while ((s = br.readLine()) != null) {
                        boolean caretAtEnd = false;
                        caretAtEnd = ConsoleTextArea.this.getCaretPosition() == doc.getLength();
                        sb.setLength(0);
                        ConsoleTextArea.this.append(sb.append(s).append('\n').toString());
                        if (!caretAtEnd) continue;
                        ConsoleTextArea.this.setCaretPosition(doc.getLength());
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "\u4ece\u63a7\u5236\u53f0\u8bfb\u53d6\u65e5\u5fd7\u9519\u8bef\uff1a" + e);
                    System.exit(1);
                }
            }
        }).start();
    }
}

