/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.manager.bean.Manager;
import com.qianjiang.manager.mapper.ManagerMapper;
import com.qianjiang.manager.service.ManagerSmsService;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.dao.SMSConfMapper;
import com.qianjiang.system.dao.SMSModelMapper;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.sms.SmsUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="managerSmsService")
public class ManagerSmsServiceImpl
implements ManagerSmsService {
    public static final MyLogger LOGGER = new MyLogger(ManagerSmsServiceImpl.class);
    private static final int NINE = 9;
    private static final int ELEVEN = 11;
    private static final int THIRDTEEN = 30;
    private static final int SIXTEEN = 60;
    private static final int THOUSAND = 1000;
    private static final int HTHOUSAND = 100000;
    private ManagerMapper managerMapper;
    @Autowired
    private SMSConfMapper smsConfMapper;
    @Autowired
    private SMSModelMapper smsModelMapper;

    @Override
    public int sendPost(Long loginUserId, String mobile) {
        String code = SmsUtil.getCode();
        JSONObject modelParam = new JSONObject();
        modelParam.put("code", (Object)code);
        String smsModelType = "1";
        try {
            Manager manager = this.managerMapper.selectCaptcha(loginUserId);
            if (manager.getAeadTime() == null || System.currentTimeMillis() - manager.getAeadTime().getTime() > 60000L) {
                SMSConf smsConf = this.smsConfMapper.querySmsConf();
                if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                    return 0;
                }
                String smsAppKey = smsConf.getSmsAppKey();
                String smsSerect = smsConf.getSmsSerect();
                String smsSign = smsConf.getSmsSign();
                SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
                String smsModelId = smsModel.getSmsModelId();
                String smsVersion = smsConf.getSmsVersion();
                manager.setCaptcha(code);
                manager.setAeadTime(new Date());
                boolean isSuccess = false;
                if ("0".equals(smsVersion)) {
                    isSuccess = SmsUtil.sendMsgCode(smsAppKey, smsSerect, smsSign, smsModelId, modelParam, smsModelType, mobile);
                } else if ("1".equals(smsVersion)) {
                    isSuccess = SmsUtil.sendSms(smsAppKey, smsSerect, smsSign, smsModelId, modelParam, smsModelType, mobile);
                }
                if (isSuccess) {
                    this.managerMapper.updateSmsCaptcha(manager);
                    return 1;
                }
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("", e);
        }
        return -1;
    }

    @Override
    public int getMCode(Long loginUserId, String code) {
        Manager manager = this.managerMapper.selectCaptcha(loginUserId);
        if (manager.getAeadTime() != null && System.currentTimeMillis() - manager.getAeadTime().getTime() > 1800000L) {
            return -1;
        }
        if (manager.getAeadTime() == null) {
            manager.setAeadTime(new Date());
        }
        if (code.equals(manager.getCaptcha())) {
            manager.setAeadTime(new Date(manager.getAeadTime().getTime() - 660000L));
            manager.setCaptcha(null);
            this.managerMapper.updateSmsCaptcha(manager);
            return 1;
        }
        return 0;
    }

    @Override
    public Manager queryManagerById(Long managerId) {
        return this.managerMapper.selectCaptcha(managerId);
    }

    public ManagerMapper getManagerMapper() {
        return this.managerMapper;
    }

    @Resource(name="managerMapper")
    public void setManagerMapper(ManagerMapper managerMapper) {
        this.managerMapper = managerMapper;
    }
}

