/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util;

import com.qianjiang.util.MyLogger;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;

public class XssMultipartHttpServletRequest
extends DefaultMultipartHttpServletRequest {
    private MyLogger logger = new MyLogger(XssMultipartHttpServletRequest.class);

    public XssMultipartHttpServletRequest(HttpServletRequest request, MultiValueMap<String, MultipartFile> mpFiles, Map<String, String[]> mpParams, Map<String, String> mpParamContentTypes) {
        super(request, mpFiles, mpParams, mpParamContentTypes);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return values;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.stripXSS(values[i], parameter);
            if (values[i].equals(encodedValues[i])) continue;
            this.logger.error("param is filterd by xssfilter and ip:" + super.getRemoteAddr());
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return this.stripXSS(value, parameter);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return this.stripXSS(value, name);
    }

    private String stripXSS(String value, String parameter) {
        String valueNew = value;
        if ("keyWords".equals(parameter)) {
            System.out.println("==========================");
        }
        if (this.getNoCheckParameter(parameter) && valueNew != null) {
            valueNew = valueNew.replaceAll("", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            valueNew = scriptPattern.matcher(valueNew).replaceAll("");
            scriptPattern = Pattern.compile("[%<>\"]+");
            valueNew = scriptPattern.matcher(valueNew).replaceAll("");
        }
        return valueNew;
    }

    private boolean getNoCheckParameter(String parameter) {
        String[] noFilterURLs;
        for (String parameters : noFilterURLs = new String[]{"goodsMobileDesc2", "goodsMobileDesc3", "goodsMobileDesc4", "goodsMobileDesc5", "goodsMobileDesc6", "mobileDesc", "goodsDetailDesc", "goodsMobileDesc", "bsetUseragreement", "mobileDesc2", "mobileDesc3", "mobileDesc4", "mobileDesc5", "mobileDesc6", "bsetUseragreementuser", "bsetCopyright", "content", "thirdUserment", "helpContent", "marketingDes", "giftDesc", "ipCont", "str", "pageDes", "title", "thirdProjectContext", "backInfoRemark", "backPriceRemark", "payHelp", "giftText", "logisticsSingleContent", "couponRemark", "code"}) {
            if (!parameter.equals(parameters)) continue;
            return false;
        }
        return true;
    }
}

