/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.bean.HelpCenter;
import com.qianjiang.system.dao.HelpCenterMapper;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.system.vo.HelpCenterVo;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="helpCenterService")
public class HelpCenterServiceImpl
implements HelpCenterService {
    @Resource(name="helpCenterMapper")
    private HelpCenterMapper helpCenterMapper;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public List<HelpCenterVo> selectCateByHelpname(String helpcatename) {
        return this.helpCenterMapper.selectCateByHelpname(helpcatename);
    }

    @Override
    public int insertHelpCenter(HelpCenter helpCenter) {
        helpCenter.setDelFlag("0");
        this.redisAdapter.delete("HELPCATELIST_KEY");
        this.redisAdapter.delete("ALLISFOOT_KEY");
        return this.helpCenterMapper.insertSelective(helpCenter);
    }

    @Override
    public int updateHelpCenter(HelpCenter helpCenter) {
        helpCenter.setModifyTime(new Date());
        this.redisAdapter.delete("HELPCATELIST_KEY");
        this.redisAdapter.delete("ALLISFOOT_KEY");
        return this.helpCenterMapper.updateByPrimaryKeySelective(helpCenter);
    }

    @Override
    public PageBean findByPageBean(PageBean pageBean, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        pageBean.setRows(this.helpCenterMapper.findTotalCount(map));
        map.put("startRowNum", pageBean.getStartRowNum());
        map.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setList(this.helpCenterMapper.findByPageBean(map));
        return pageBean;
    }

    @Override
    public PageBean findByPageBean(PageBean pageBean, SelectBean selectBean, Long helpcateId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        pageBean.setRows(this.helpCenterMapper.findTotalCount(map));
        map.put("startRowNum", pageBean.getStartRowNum());
        map.put("endRowNum", pageBean.getEndRowNum());
        map.put("helpcateId", helpcateId);
        pageBean.setList(this.helpCenterMapper.findByPageBean(map));
        return pageBean;
    }

    @Override
    public HelpCenter findByHelpId(Long helpId) {
        return this.helpCenterMapper.selectByPrimaryKey(helpId);
    }

    @Override
    public int deleteHelpCenter(String[] helpIds) {
        int count = 0;
        if (helpIds != null) {
            for (String id : helpIds) {
                count += this.helpCenterMapper.deleteByPrimaryKey(Long.parseLong(id));
            }
        }
        this.redisAdapter.delete("HELPCATELIST_KEY");
        this.redisAdapter.delete("ALLISFOOT_KEY");
        return count;
    }

    @Override
    public List<HelpCenter> findByCateId(Long helpCateId) {
        return this.helpCenterMapper.findByCateId(helpCateId);
    }

    @Override
    public List<HelpCenter> selectAllIsFoot() {
        List<HelpCenter> list = (List<HelpCenter>)this.redisAdapter.get("ALLISFOOT_KEY");
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        list = this.helpCenterMapper.selectAllIsFoot();
        this.redisAdapter.put("ALLISFOOT_KEY", new ArrayList<HelpCenter>(list));
        return list;
    }

    @Override
    public List<HelpCenter> selectAll() {
        return this.helpCenterMapper.selectAll();
    }

    @Override
    public List<HelpCenter> findByHelpCateId(String searchText, long helpCateId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("helpCateId", helpCateId);
        return this.helpCenterMapper.findByHelpCateId(map);
    }

    @Override
    public List<HelpCenter> findByHelpContext(String searchText) {
        return this.helpCenterMapper.selectByHelpContext(searchText);
    }
}

