/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.service.impl;

import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.dao.SysTempDao;
import com.qianjiang.temp.service.TempService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TempService")
public class TempServiceImpl
implements TempService {
    private static final String DELETE_STATUS = "deleteStatus";
    private static final String START_ROW_NUM = "startRowNum";
    private static final String END_ROW_NUM = "endRowNum";
    private static final Long TEMPTYPE = 137L;
    private static final Long STARTROWNUM = 0L;
    private static final Long ENDROWNUM = 1000L;
    private SysTempDao systempDao;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public List<SysTemp> queryAllSystemp() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DELETE_STATUS, "0");
        map.put(START_ROW_NUM, STARTROWNUM);
        map.put(END_ROW_NUM, ENDROWNUM);
        return this.systempDao.querySysTempByPage(map);
    }

    @Override
    public SysTemp getSystempById(Long systempId) {
        return this.systempDao.getSysTempById(systempId.intValue());
    }

    @Override
    public List<SysTemp> querySystempByType(Long typeId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tempType", typeId);
        map.put("standby2", "0");
        map.put(DELETE_STATUS, "0");
        map.put(START_ROW_NUM, STARTROWNUM);
        map.put(END_ROW_NUM, ENDROWNUM);
        return this.systempDao.getSysTempByField(map);
    }

    @Override
    public int updateSystemp(SysTemp temp) {
        return this.systempDao.updateSysTemp(temp);
    }

    @Override
    public SysTemp getCurrTemp() {
        List<SysTemp> list = (List<SysTemp>)this.redisAdapter.get("CURRSYSTEMP_KEY");
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (SysTemp)list.get(0);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tempType", TEMPTYPE);
        map.put("standby2", "0");
        map.put("usedStatus", "1");
        map.put(DELETE_STATUS, "0");
        map.put(START_ROW_NUM, STARTROWNUM);
        map.put(END_ROW_NUM, ENDROWNUM);
        list = this.systempDao.getSysTempByField(map);
        this.redisAdapter.put("CURRSYSTEMP_KEY", new ArrayList<SysTemp>(list));
        return list.get(0);
    }

    @Override
    public void setUserd(Long tempId) {
        this.redisAdapter.delete("CURRSYSTEMP_KEY");
        this.systempDao.setUserd(tempId);
        this.systempDao.removeUserd(tempId);
    }

    public SysTempDao getSystempDao() {
        return this.systempDao;
    }

    @Resource(name="SysTempDao")
    public void setSystempDao(SysTempDao systempDao) {
        this.systempDao = systempDao;
    }
}

