/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.lucene.main;

import com.qianjiang.common.lucene.ikanalyzer.org.wltea.analyzer.lucene.IKAnalyzer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryTermScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.springframework.stereotype.Service;

@Service(value="luceneIkUtil")
public class LuceneIKUtil {
    private static final Logger LOGGER = Logger.getLogger(LuceneIKUtil.class);
    private static final String CONTEXT = "context";
    private static final String LOGGERINFO1 = "\u521b\u5efa\u7d22\u5f15\u5931\u8d25";
    private Directory directory;
    private Analyzer analyzer;

    public LuceneIKUtil(String indexFilePath) {
        try {
            this.directory = FSDirectory.open((File)new File(indexFilePath));
            this.analyzer = new IKAnalyzer();
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u521d\u59cb\u5316FSDirectory\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public LuceneIKUtil() {
        this("/solr/www/mall/index1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(String sql) throws Exception {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_47, this.analyzer);
        IndexWriter indexWriter = new IndexWriter(this.directory, indexWriterConfig);
        indexWriter.deleteAll();
        File file = new File("/solr/www/mall/index1");
        if (file.exists()) {
            LuceneIKUtil.delAllFile("/solr/www/mall/index1");
        }
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        InputStream in = null;
        try {
            in = LuceneIKUtil.class.getClassLoader().getResourceAsStream("com/qianjiang/web/config/jdbc.properties");
            Properties p = new Properties();
            p.load(in);
            String url = p.getProperty("lucene.url");
            this.directory = FSDirectory.open((File)new File("/solr/www/mall/index1"));
            Class.forName(p.getProperty("jdbc.driver"));
            conn = DriverManager.getConnection(url);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (rs.getString("goods_info_name") == null) continue;
                Document document = new Document();
                document.add((IndexableField)new Field("id", rs.getString("goods_info_id"), Field.Store.YES, Field.Index.ANALYZED));
                document.add((IndexableField)new Field(CONTEXT, rs.getString("goods_info_name"), Field.Store.YES, Field.Index.ANALYZED));
                indexWriter.addDocument((Iterable)document);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)LOGGERINFO1, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (conn != null) {
                    conn.close();
                }
                indexWriter.close();
            }
            catch (IOException e1) {
                LOGGER.error((Object)LOGGERINFO1, (Throwable)e1);
            }
        }
    }

    public Document addDocument(Integer id, String productName) {
        Document doc = new Document();
        doc.add((IndexableField)new Field("id", String.valueOf(id), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((IndexableField)new Field(CONTEXT, productName, Field.Store.YES, Field.Index.ANALYZED));
        return doc;
    }

    public void update(Long productId, String productName) {
        try {
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_47, this.analyzer);
            IndexWriter indexWriter = new IndexWriter(this.directory, indexWriterConfig);
            Document document = this.addDocument(productId.intValue(), productName);
            Term term = new Term("id", String.valueOf(productId));
            indexWriter.updateDocument(term, (Iterable)document);
            indexWriter.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u66f4\u65b0\u7d22\u5f15\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void delete(Long productId) {
        try {
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_47, this.analyzer);
            IndexWriter indexWriter = new IndexWriter(this.directory, indexWriterConfig);
            Term term = new Term("id", productId + "");
            indexWriter.deleteDocuments(new Term[]{term});
            indexWriter.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u5220\u9664\u7d22\u5f15\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public Map<String, Object> searcher(String param, int param1, File path) {
        String paramNew = param;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        ArrayList<String> result = new ArrayList<String>();
        try {
            ScoreDoc[] scoreDocs;
            DirectoryReader indexReader = IndexReader.open((Directory)this.directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            MultiFieldQueryParser queryParser = new MultiFieldQueryParser(Version.LUCENE_47, new String[]{CONTEXT}, this.analyzer);
            String regEx = "[`~!@#$%^&*()+=|{}':;',//[//].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\"]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(paramNew);
            paramNew = m.replaceAll("").trim();
            Query query = queryParser.parse(paramNew);
            TopFieldCollector tfc = TopFieldCollector.create((Sort)Sort.RELEVANCE, (int)100, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
            indexSearcher.search(query, (Collector)tfc);
            TopDocs topDocs = tfc.topDocs();
            SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<font color='red'>", "</font>");
            QueryTermScorer fragmentScorer = new QueryTermScorer(query);
            Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)fragmentScorer);
            SimpleFragmenter fragmenter = new SimpleFragmenter(100);
            highlighter.setTextFragmenter((Fragmenter)fragmenter);
            for (ScoreDoc scDoc : scoreDocs = topDocs.scoreDocs) {
                if ((double)scDoc.score < 0.1) continue;
                Document document = indexSearcher.doc(scDoc.doc);
                String name = document.get(CONTEXT);
                String lighterName = highlighter.getBestFragment(this.analyzer, CONTEXT, name);
                if (null == lighterName) {
                    lighterName = name;
                }
                nameMap.put(document.get("id"), lighterName);
                result.add(document.get("id"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u7d22\u5f15\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)e);
        }
        resultMap.put("productIds", result);
        resultMap.put("productLightNames", nameMap);
        return resultMap;
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            LuceneIKUtil.delAllFile(path + "/" + tempList[i]);
            LuceneIKUtil.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public static void delFolder(String folderPath) {
        try {
            LuceneIKUtil.delAllFile(folderPath);
            String filePath = folderPath;
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u5220\u9664\u7a7a\u6587\u4ef6\u5939\u9519\u8bef", (Throwable)e);
        }
    }

    public Map<String, Object> dirceotry(String title) {
        return this.searcher(title, 100, new File("/solr/www/mall/index1"));
    }
}

