/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.Payment;
import com.qianjiang.system.dao.PaymentMapper;
import com.qianjiang.system.service.PaymentService;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="PaymentService")
public class PaymentServiceImpl
implements PaymentService {
    @Resource(name="PaymentMapper")
    private PaymentMapper paymentMapper;

    @Override
    public int deletePayment(Long paymentId, Long loginUserId) {
        Payment payment = this.paymentMapper.selectByPrimaryKey(paymentId);
        payment.setDelflag("1");
        payment.setUpdateUserId(loginUserId);
        payment.setUpdateDate(new Date());
        return this.paymentMapper.updateByPrimaryKeySelective(payment);
    }

    @Override
    public int createPayment(Payment record, Long loginUserId) {
        Date date = new Date();
        record.setCreateUserId(loginUserId);
        record.setCreateDate(date);
        record.setUpdateUserId(loginUserId);
        record.setUpdateDate(date);
        return this.paymentMapper.insertSelective(record);
    }

    @Override
    public Payment getPayment(Long paymentId) {
        return this.paymentMapper.selectByPrimaryKey(paymentId);
    }

    @Override
    public int updatePayment(Payment record, Long loginUserId) {
        record.setUpdateUserId(loginUserId);
        record.setUpdateDate(new Date());
        return this.paymentMapper.updateByPrimaryKeySelective(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectAllByPb(PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            pb.setRows(this.paymentMapper.selectAllCount());
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.paymentMapper.selectAllByPb(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public List<Payment> selectAllForSite() {
        return this.paymentMapper.selectAllForSite();
    }

    @Override
    public boolean setPaymentOpenStatus(Long paymentId, Long loginUserId) {
        Payment payment = this.paymentMapper.selectByPrimaryKey(paymentId);
        if ("0".equals(payment.getIsOpen())) {
            payment.setIsOpen("1");
        } else {
            payment.setIsOpen("0");
        }
        payment.setUpdateUserId(loginUserId);
        payment.setUpdateDate(new Date());
        int n = this.paymentMapper.updateByPrimaryKeySelective(payment);
        return n > 0;
    }

    @Override
    public boolean checkOpenCount(Long paymentId) {
        boolean bl = true;
        Payment pm = this.paymentMapper.selectByPrimaryKey(paymentId);
        if ("1".equals(pm.getIsOpen()) && this.paymentMapper.selectCountForSite() <= 1) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean checkDelete(Long paymentId) {
        Payment pm;
        boolean bl = true;
        if (this.paymentMapper.selectAllCount() <= 1) {
            bl = false;
        }
        if ("1".equals((pm = this.paymentMapper.selectByPrimaryKey(paymentId)).getIsOpen()) && this.paymentMapper.selectCountForSite() <= 1) {
            bl = false;
        }
        return bl;
    }
}

