/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.service.impl;

import com.qianjiang.information.bean.InforSubject;
import com.qianjiang.information.dao.InforSubjectMapper;
import com.qianjiang.information.service.InforSubjectServcie;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="InforSubjectServcieImpl")
public class InforSubjectServcieImpl
implements InforSubjectServcie {
    public static final MyLogger LOGGER = new MyLogger(InforSubjectServcieImpl.class);
    @Resource(name="InforSubjectMapperImpl")
    private InforSubjectMapper subjectMapper;

    @Override
    public int deleteSubject(Long subjectId) {
        return this.subjectMapper.deleteByPrimaryKey(subjectId);
    }

    @Override
    public int saveSubject(InforSubject record) {
        Date date = new Date();
        record.setCreateDate(date);
        record.setUpdateDate(date);
        return this.subjectMapper.insertSelective(record);
    }

    @Override
    public InforSubject getSubject(Map<String, Object> map) {
        return this.subjectMapper.selectByPrimaryKey(map);
    }

    @Override
    public List<InforSubject> selectListByCateId(Long helpcateId, Long subjectTypes) {
        return this.subjectMapper.selectListByCateId(helpcateId, subjectTypes);
    }

    @Override
    public int updateSubject(InforSubject record) {
        record.setUpdateDate(new Date());
        return this.subjectMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public PageBean selectPCSubjectByPageBean(PageBean pb, String title, String subjectTypes) {
        return this.selectSubjectByPageBean(pb, title, "1", null, subjectTypes);
    }

    @Override
    public PageBean selectMobileSubjectByPageBean(PageBean pb, String title, String subjectTypes) {
        return this.selectSubjectByPageBean(pb, title, "0", null, subjectTypes);
    }

    @Override
    public PageBean selectSubjectByPageBean(PageBean pb, String title, String terminalFlag, String isShow, String subjectTypes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("title", title);
            pb.setRows(this.subjectMapper.selectCountByTitleAndTemp2AndisShow(title, terminalFlag, null, subjectTypes));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            map.put("isShow", isShow);
            map.put("subjectTypes", subjectTypes);
            pb.setList(this.subjectMapper.selectByPageBean(map));
        }
        catch (Exception e) {
            LOGGER.error("", e);
            map = null;
        }
        return pb;
    }

    @Override
    public int batchDeleteSubject(Long[] ids) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long long1 : ids) {
            list.add(long1);
        }
        return this.subjectMapper.batchDeleteByList(list);
    }

    @Override
    public List<InforSubject> selectAllForSite() {
        return this.subjectMapper.selectAllForSite();
    }

    @Override
    public boolean checkByUrl(String url) {
        return this.subjectMapper.selectCountByUrl(url) <= 0;
    }

    @Override
    public InforSubject selectByIsShowAndId(Long subjectId) {
        return this.subjectMapper.selectByIsShowAndId(subjectId);
    }

    @Override
    public List<InforSubject> selectAllSubject() {
        return this.subjectMapper.selectAllSubject();
    }
}

