/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import com.qianjiang.util.JsonUtil;
import com.qianjiang.util.StringUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class IpUtil {
    private static final Logger LOGGER = Logger.getLogger(IpUtil.class);
    private static final String UNKNOWN = "unknown";

    private IpUtil() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("http_client_ip");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip != null && ip.indexOf(",") != -1) {
            ip = ip.substring(ip.lastIndexOf(",") + 1, ip.length()).trim();
        }
        return ip;
    }

    public static String[] getClientArea(HttpServletRequest request) {
        String ip = IpUtil.getIpAddr(request);
        ip = "117.88.148.251";
        request.getSession().setAttribute("ipAddress", (Object)ip);
        String url = "http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip=" + (ip == null ? "" : ip);
        String returnString = "";
        String[] areas = new String[]{"", "", "", "", ""};
        GetMethod postMethod = new GetMethod(url);
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        try {
            client.executeMethod((HttpMethod)postMethod);
            returnString = StringUtil.fromUnicode(postMethod.getResponseBodyAsString());
            Map<String, Object> result = JsonUtil.getMapFromJson(returnString);
            if ("1".toString().equals(result.get("ret"))) {
                areas[0] = result.get("country").toString();
                areas[1] = result.get("province").toString();
                areas[2] = result.get("city").toString();
                areas[3] = result.get("district").toString();
                areas[4] = result.get("isp").toString();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u6839\u636eip\u4e3a\uff1a" + ip + "\u83b7\u53d6\u5730\u533a\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)e);
        }
        return areas;
    }
}

