/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.mobile.service.impl;

import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.mobile.bean.MobSiteBasic;
import com.qianjiang.system.mobile.dao.MobSiteBasicMapper;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="MobSiteBasicService")
public class MobSiteBasicServiceImpl
implements MobSiteBasicService {
    private static final Logger LOGGER = Logger.getLogger(MobSiteBasicServiceImpl.class);
    @Resource(name="MobSiteBasicMapper")
    private MobSiteBasicMapper mobSiteBasicMapper;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public int saveMobSiteBasic(MobSiteBasic record) {
        this.redisAdapter.delete("CURRMOBSITEBASIC_KEY");
        return this.mobSiteBasicMapper.insertSelective(record);
    }

    @Override
    public int updateMobSiteBasic(MobSiteBasic record) {
        int n = -1;
        try {
            record.setUpdateDate(new Date());
            n = this.mobSiteBasicMapper.updateByPrimaryKeySelective(record);
            this.redisAdapter.delete("CURRMOBSITEBASIC_KEY");
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u4fee\u6539\u79fb\u52a8\u7248\u7ad9\u70b9\u4fe1\u606f\u5f02\u5e38\uff1a=\u300b", (Throwable)e);
        }
        return n;
    }

    @Override
    public MobSiteBasic selectCurrMobSiteBasic(String basePath) {
        MobSiteBasic siteBasic = null;
        try {
            siteBasic = (MobSiteBasic)this.redisAdapter.get("CURRMOBSITEBASIC_KEY");
            if (null != siteBasic) {
                return siteBasic;
            }
            siteBasic = this.mobSiteBasicMapper.selectCurr();
            if (siteBasic == null) {
                Date date = new Date();
                siteBasic = new MobSiteBasic();
                siteBasic.setSiteBasicId(1L);
                siteBasic.setSiteAddress("/mobile/");
                siteBasic.setName("mall\u5546\u57ce");
                siteBasic.setEname("mall");
                siteBasic.setTechnicalSupport("mall");
                siteBasic.setBackgroudColor("#2589c9");
                siteBasic.setBackgroudImage(basePath + "images/curtain_word.png");
                siteBasic.setCopyright("QIANGJIANG");
                siteBasic.setIsShowBuffer("1");
                siteBasic.setCreateDate(date);
                siteBasic.setUpdateDate(date);
                this.saveMobSiteBasic(siteBasic);
            }
            this.redisAdapter.put("CURRMOBSITEBASIC_KEY", siteBasic);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("H5\u7aef\u4e1a\u52a1\u5c42\u67e5\u8be2\u5f53\u524d\u7ad9\u70b9\u4fe1\u606f\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        return siteBasic;
    }
}

