/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.dao.AuthMapper;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="authService")
public class AuthServiceImpl
implements AuthService {
    @Resource(name="authMapper")
    private AuthMapper authMapper;

    @Override
    public PageBean findByPageBean(PageBean pageBean, SelectBean selectBean) {
        pageBean.setRows(this.authMapper.findTotalCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startRowNum", pageBean.getStartRowNum());
        map.put("endRowNum", pageBean.getEndRowNum());
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        pageBean.setList(this.authMapper.findByPageBean(map));
        return pageBean;
    }

    @Override
    public Auth findAuthByAuthType(String authType) {
        return this.authMapper.findAuthByAuthType(authType);
    }

    @Override
    public int insertAuth(Auth auth) {
        auth.setAuthDeleteFlag("0");
        auth.setAuthCreated(new Date());
        return this.authMapper.insertSelective(auth);
    }

    @Override
    public int deleteAuth(String[] authIds) {
        int count = 0;
        Auth auth = new Auth();
        auth.setAuthDeleted(new Date());
        if (authIds != null) {
            for (String id : authIds) {
                auth.setAuthId(Long.parseLong(id));
                count += this.authMapper.deleteByPrimaryKey(auth);
            }
        }
        return count;
    }

    @Override
    public Auth findAuthByAuthId(Long authId) {
        return this.authMapper.selectByPrimaryKey(authId);
    }

    @Override
    public int updateAuth(Auth auth) {
        auth.setAuthUpdated(new Date());
        return this.authMapper.updateByPrimaryKeySelective(auth);
    }

    @Override
    public boolean updateUserdStatus(Long authId) {
        Auth auth = this.authMapper.selectByPrimaryKey(authId);
        if ("0".equals(auth.getAuthShow())) {
            auth.setAuthShow("1");
        } else {
            auth.setAuthShow("0");
        }
        auth.setAuthUpdated(new Date());
        return this.authMapper.updateByPrimaryKeySelective(auth) > 0;
    }

    @Override
    public List<Auth> findByShow() {
        return this.authMapper.findByShow();
    }

    @Override
    public int deleteAuthById(Long authId) {
        Auth auth = new Auth();
        auth.setAuthId(authId);
        auth.setAuthDeleteFlag("1");
        auth.setAuthDeleted(new Date());
        return this.authMapper.updateByPrimaryKeySelective(auth);
    }

    @Override
    public PageBean findBywxPageBean(PageBean pageBean, SelectBean selectBean) {
        pageBean.setRows(this.authMapper.findTotalwxCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startRowNum", pageBean.getStartRowNum());
        map.put("endRowNum", pageBean.getEndRowNum());
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        pageBean.setList(this.authMapper.findByWxLogin(map));
        return pageBean;
    }
}

