/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.util;

import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class Logger {
    public static final MyLogger LOGGER = new MyLogger(Logger.class);
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String DEFAULT_CONFIG_FILE_NAME = "log4j.properties";
    private static final Logger defaultLogger = new Logger();
    private org.apache.log4j.Logger log4jLogger;

    private Logger() {
    }

    public Logger(Class<?> clazz) {
        this.log4jLogger = org.apache.log4j.Logger.getLogger(clazz);
    }

    public Logger(String name) {
        this.log4jLogger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public static final void initialize() {
        String file = null;
        try {
            file = Logger.getClassResourcePath(Logger.class, DEFAULT_CONFIG_FILE_NAME, DEFAULT_ENCODING);
        }
        catch (Exception e) {
            LOGGER.error("", e);
            file = null;
        }
        Logger.initialize(file);
    }

    public static final void setDefaultLoggerName(Class<?> clazz) {
        Logger.defaultLogger.log4jLogger = org.apache.log4j.Logger.getLogger(clazz);
    }

    public static final void setDefaultLoggerName(String name) {
        Logger.defaultLogger.log4jLogger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public static final Logger getDefaultLogger() {
        return defaultLogger;
    }

    public static final String getClassResourcePath(Class<?> clazz, String resPath, String pathEnc) {
        String path = null;
        try {
            URL url = Logger.getClassResource(clazz, resPath);
            if (url != null) {
                path = url.getPath();
                path = URLDecoder.decode(path, pathEnc);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("", e);
            path = null;
        }
        return path;
    }

    public static final URL getClassResource(Class<?> clazz, String resPath) {
        URL url = clazz.getResource(resPath);
        if (url == null) {
            ClassLoader loader = clazz.getClassLoader();
            if (loader != null) {
                url = loader.getResource(resPath);
            }
            if (url == null && (loader = Thread.currentThread().getContextClassLoader()) != null) {
                url = loader.getResource(resPath);
            }
        }
        return url;
    }

    public static final void initialize(String file) {
        PropertyConfigurator.configure((String)file);
    }

    public static final void initialize(Properties properties) {
        PropertyConfigurator.configure((Properties)properties);
    }

    public static final void shutdown() {
        LogManager.shutdown();
    }

    public final boolean isValid() {
        return this.log4jLogger != null;
    }

    public final void debug(Object msg) {
        this.log4jLogger.debug(msg);
    }

    public final void debug(String format, Object ... args) {
        this.debug(String.format(format, args));
    }

    public final void debug(Object msg, Throwable e) {
        this.log4jLogger.debug(msg, e);
    }

    public final void debug(Throwable e, String format, Object ... args) {
        this.debug((Object)String.format(format, args), e);
    }

    public final void trace(Object msg) {
        this.log4jLogger.trace(msg);
    }

    public final void trace(String format, Object ... args) {
        this.trace(String.format(format, args));
    }

    public final void trace(Object msg, Throwable e) {
        this.log4jLogger.trace(msg, e);
    }

    public final void trace(Throwable e, String format, Object ... args) {
        this.trace((Object)String.format(format, args), e);
    }

    public final void info(Object msg) {
        this.log4jLogger.info(msg);
    }

    public final void info(String format, Object ... args) {
        this.info(String.format(format, args));
    }

    public final void info(Object msg, Throwable e) {
        this.log4jLogger.info(msg, e);
    }

    public final void info(Throwable e, String format, Object ... args) {
        this.info((Object)String.format(format, args), e);
    }

    public final void warn(Object msg) {
        this.log4jLogger.warn(msg);
    }

    public final void warn(String format, Object ... args) {
        this.warn(String.format(format, args));
    }

    public final void warn(Object msg, Throwable e) {
        this.log4jLogger.warn(msg, e);
    }

    public final void warn(Throwable e, String format, Object ... args) {
        this.warn((Object)String.format(format, args), e);
    }

    public final void error(Object msg) {
        this.log4jLogger.error(msg);
    }

    public final void error(String format, Object ... args) {
        this.error(String.format(format, args));
    }

    public final void error(Object msg, Throwable e) {
        this.log4jLogger.error(msg, e);
    }

    public final void error(Throwable e, String format, Object ... args) {
        this.error((Object)String.format(format, args), e);
    }

    public final void fatal(Object msg) {
        this.log4jLogger.fatal(msg);
    }

    public final void fatal(String format, Object ... args) {
        this.fatal(String.format(format, args));
    }

    public final void fatal(Object msg, Throwable e) {
        this.log4jLogger.fatal(msg, e);
    }

    public final void fatal(Throwable e, String format, Object ... args) {
        this.fatal((Object)String.format(format, args), e);
    }

    public final void log(Level level, Object msg) {
        this.log4jLogger.log((Priority)level.toLog4jLevel(), msg);
    }

    public final void log(Level level, String format, Object ... args) {
        this.log(level, String.format(format, args));
    }

    public final void log(Level level, Object msg, Throwable e) {
        this.log4jLogger.log((Priority)level.toLog4jLevel(), msg, e);
    }

    public final void log(Throwable e, Level level, String format, Object ... args) {
        this.log(level, (Object)String.format(format, args), e);
    }

    public final void exception(Throwable e, Object action, Level level, boolean printStack) {
        StringBuilder msg = new StringBuilder("Execption occur on ");
        msg.append(action);
        msg.append(" --> ");
        msg.append(e.toString());
        String error = msg.toString();
        if (printStack) {
            this.log(level, (Object)error, e);
        } else {
            this.log(level, error);
        }
    }

    public final void fail(Object action, Object module, boolean printStack) {
        StringBuilder msg = new StringBuilder("Operation fail on ");
        msg.append(action);
        msg.append(" --> ");
        msg.append(module);
        this.error(msg.toString());
    }

    public final void logServerStartup(Object o) {
        this.info("->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->");
        this.info("starting: %s ...", o);
    }

    public final void logServerShutdown(Object o) {
        this.info("stoping: %s ...", o);
        this.info("<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-");
    }

    public static enum Level {
        ALL,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF,
        TRACE;


        public org.apache.log4j.Level toLog4jLevel() {
            return org.apache.log4j.Level.toLevel((String)this.name());
        }
    }
}

