/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.auth.oauth;

import com.qianjiang.auth.oauth.AbstractOAuth;
import com.qianjiang.auth.util.HttpUtil;
import com.qianjiang.auth.util.JsonUtil;
import com.qianjiang.auth.util.TokenUtil;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OAuthSina
extends AbstractOAuth {
    public static final MyLogger LOGGER = new MyLogger(OAuthSina.class);
    private static final String AUTH_URL = "https://api.weibo.com/oauth2/authorize";
    private static final String TOKEN_URL = "https://api.weibo.com/oauth2/access_token";
    private static final String TOKEN_INFO_URL = "https://api.weibo.com/oauth2/get_token_info";
    private static final String USER_INFO_URL = "https://api.weibo.com/2/users/show.json";
    public static final String getAuthorizeUrl1 = null;

    public OAuthSina() {
    }

    public OAuthSina(String authName, String clientId, String clientSecret, String redirectUri) {
        super(authName, clientId, clientSecret, redirectUri);
    }

    @Override
    public String getAuthorizeUrl() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", "sina");
        params.put("response_type", "code");
        params.put("client_id", this.getClientId());
        params.put("redirect_uri", this.getRedirectUri());
        try {
            return HttpUtil.appendQueryParams(AUTH_URL, params);
        }
        catch (IOException e) {
            LOGGER.error("" + e);
            return getAuthorizeUrl1;
        }
    }

    @Override
    public Map<String, Object> getUserInfoByCode(String code) {
        String accessToken = this.getTokenByCode(code);
        String openId = this.getTokenInfo(accessToken);
        String userinfo = this.getUserInfo(accessToken, openId);
        return JsonUtil.getMapFromJson(userinfo);
    }

    private String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.getClientId());
        params.put("client_secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.getRedirectUri());
        try {
            return TokenUtil.getAccessToken(HttpUtil.postForm(TOKEN_URL, params));
        }
        catch (IOException e) {
            LOGGER.error("" + e);
            return getAuthorizeUrl1;
        }
    }

    private String getTokenInfo(String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        try {
            return TokenUtil.getAccessToken(HttpUtil.postForm(TOKEN_INFO_URL, params));
        }
        catch (IOException e) {
            LOGGER.error("" + e);
            return getAuthorizeUrl1;
        }
    }

    private String getUserInfo(String accessToken, String openId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("uid", openId);
        try {
            return HttpUtil.postForm(USER_INFO_URL, params);
        }
        catch (IOException e) {
            LOGGER.error("" + e);
            return getAuthorizeUrl1;
        }
    }
}

