/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.service.impl;

import com.qianjiang.information.bean.InformationOnePage;
import com.qianjiang.information.dao.InformationOnePageMapper;
import com.qianjiang.information.service.InformationOnePageService;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="InformationOnePageService")
public class InformationOnePageServiceImpl
implements InformationOnePageService {
    private InformationOnePageMapper infoOnePageMapper;
    @Resource
    private RedisAdapter redisAdapter;

    public InformationOnePageMapper getInfoOnePageMapper() {
        return this.infoOnePageMapper;
    }

    @Resource(name="InformationOnePageMapper")
    public void setInfoOnePageMapper(InformationOnePageMapper infoOnePageMapper) {
        this.infoOnePageMapper = infoOnePageMapper;
    }

    @Override
    public int delInfoOnePage(Long infoOPId, Long userId) {
        InformationOnePage infoOnePage = this.infoOnePageMapper.selectByPrimaryKey(infoOPId);
        infoOnePage.setDelflag("1");
        infoOnePage.setUpdateUserId(userId);
        infoOnePage.setUpdateDate(new Date());
        this.redisAdapter.delete("INFORMATIONONEPAGE_KEY");
        return this.infoOnePageMapper.updateByPrimaryKeySelective(infoOnePage);
    }

    @Override
    public void batchDelInfoOnePage(Long[] ids, Long userId) {
        if (null != ids && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                this.delInfoOnePage(ids[i], userId);
            }
        }
    }

    @Override
    public int saveInfoOnePage(InformationOnePage record) {
        record.setDelflag("0");
        Date date = new Date();
        record.setCreateDate(date);
        record.setUpdateDate(date);
        this.redisAdapter.delete("INFORMATIONONEPAGE_KEY");
        return this.infoOnePageMapper.insert(record);
    }

    @Override
    public int updateInfoOnePage(InformationOnePage record) {
        record.setUpdateDate(new Date());
        this.redisAdapter.delete("INFORMATIONONEPAGE_KEY");
        return this.infoOnePageMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public InformationOnePage getInfoOnePageByID(Long infoOPId) {
        return this.infoOnePageMapper.selectByPrimaryKey(infoOPId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryInfoOnePageByPageBean(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            pb.setRows(this.infoOnePageMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.infoOnePageMapper.queryByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public boolean checkAddInfoOPByTitle(String title) {
        return this.infoOnePageMapper.selectInfoOPCountByTitle(title) <= 0;
    }

    @Override
    public boolean checkAddInfoOPByTitle(String title, Long infoOPId) {
        InformationOnePage infoOP = this.infoOnePageMapper.selectByPrimaryKey(infoOPId);
        if (null != infoOP) {
            if (infoOP.getTitle().equals(title)) {
                return true;
            }
            return this.infoOnePageMapper.selectInfoOPCountByTitle(title) <= 0;
        }
        return false;
    }

    @Override
    public List<InformationOnePage> selectInfoOPByTempAndTag(Long tempId, Long infoOPTagId) {
        List<InformationOnePage> list = (List<InformationOnePage>)this.redisAdapter.get("INFORMATIONONEPAGE_KEY");
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("infoTempId", tempId);
        map.put("infoOPTagId", infoOPTagId);
        list = this.infoOnePageMapper.selectByTempTag(map);
        this.redisAdapter.put("INFORMATIONONEPAGE_KEY", new ArrayList<InformationOnePage>(list));
        return list;
    }

    @Override
    public Integer selectInfoOPCountByTag(Long infoOPTagId) {
        return this.infoOnePageMapper.selectInfoOPCountByTag(infoOPTagId);
    }
}

