/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.service.impl;

import com.qianjiang.information.bean.Information;
import com.qianjiang.information.dao.InformationMapper;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.information.vo.InformationVo;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="InformationService")
public class InformationServiceImpl
implements InformationService {
    private static final String TYPEID = "typeId";
    private static final String STARTROWNUM = "startRowNum";
    private static final String ENDROWNUM = "endRowNum";
    private InformationMapper informationMapper;

    public InformationMapper getInformationMapper() {
        return this.informationMapper;
    }

    @Resource(name="InformationMapper")
    public void setInformationMapper(InformationMapper informationMapper) {
        this.informationMapper = informationMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBean(PageBean pb, SelectBean selectBean, Long typeId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            map.put(TYPEID, typeId);
            pb.setRows(this.informationMapper.queryTotalCount(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.informationMapper.queryByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    public int delInfo(Long infoId) {
        return this.informationMapper.deleteByPrimaryKey(infoId);
    }

    @Override
    public void batchDelInfo(Long[] ids) {
        if (null != ids && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                this.delInfo(ids[i]);
            }
        }
    }

    @Override
    public int saveInfo(Information record) {
        Date date = new Date();
        record.setDelflag("0");
        record.setCreateDate(date);
        record.setUpdateDate(date);
        return this.informationMapper.insert(record);
    }

    @Override
    public int updateInfo(Information record) {
        record.setUpdateDate(new Date());
        return this.informationMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public Information selectByPrimaryKey(Long infoId) {
        return this.informationMapper.selectByPrimaryKey(infoId);
    }

    @Override
    public List<InformationVo> selectAll() {
        return this.informationMapper.selectAll();
    }

    @Override
    public boolean checkDelInfoTypeByInfoCount(Long infoTypeId) {
        return this.informationMapper.selectInfoCountByTypeId(infoTypeId) <= 0;
    }

    @Override
    public boolean checkAddInfoByTitle(String title) {
        return this.informationMapper.selectInfoCountByTitle(title) <= 0;
    }

    @Override
    public boolean checkAddInfoByTitle(String title, Long infoId) {
        Information info = this.informationMapper.selectByPrimaryKey(infoId);
        if (null != info) {
            if (info.getTitle().equals(title)) {
                return true;
            }
            return this.informationMapper.selectInfoCountByTitle(title) <= 0;
        }
        return false;
    }

    @Override
    public List<InformationVo> selectByInfoType(Long infoTypeId) {
        return this.informationMapper.selectByInfoType(infoTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBeanForSite(PageBean pb, SelectBean selectBean, Long typeId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            map.put(TYPEID, typeId);
            map.put("isShow", "1");
            map.put("isThirdNews", "0");
            map.put("temp3", "0");
            pb.setRows(this.informationMapper.queryTotalCount(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.informationMapper.queryByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBeanForMobSite(PageBean pb, SelectBean selectBean, Long typeId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(TYPEID, typeId);
            map.put("isShow", "1");
            map.put("isThirdNews", "0");
            map.put("temp3", "1");
            pb.setRows(this.informationMapper.queryTotalCount(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.informationMapper.queryByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }
}

