/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.license.service.impl;

import com.qianjiang.license.bean.LicenseBean;
import com.qianjiang.license.bean.MultiFile;
import com.qianjiang.license.dao.LicenseMapper;
import com.qianjiang.license.service.LicenseImportService;
import com.qianjiang.license.util.checkLicense.LicenseUtil;
import com.qianjiang.license.util.checkLicense.MyRSAEnCoderTools;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.OnlineUserCountListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="licenseImportService")
public class LicenseImportServiceImpl
implements LicenseImportService {
    public static final MyLogger LOGGER = new MyLogger(LicenseImportServiceImpl.class);
    @Resource(name="licenseMapperImpl")
    private LicenseMapper licenseMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String importLicenseByLic(MultiFile multiFile) {
        try {
            if (null == multiFile) {
                String string = "2";
                return string;
            }
            if (!".lic".equals(multiFile.getOriginalFilename().substring(multiFile.getOriginalFilename().indexOf("."), multiFile.getOriginalFilename().length()))) {
                String string = "3";
                return string;
            }
            Map<String, Object> map = MyRSAEnCoderTools.checkLicenseFile(multiFile);
            if ("1".equals(map.get("flag"))) {
                HashMap prop = (HashMap)map.get("prop");
                LicenseBean bean = new LicenseBean();
                bean.setLocalIp((String)prop.get("LOCALIP"));
                bean.setLicenseStartTime(this.StringChangeToDate((String)prop.get("LICENSESTARTTIME")));
                bean.setLicenseEndTime(this.StringChangeToDate((String)prop.get("LICENSEENDTIME")));
                bean.setOnlineUserCount(Integer.parseInt((String)prop.get("ONLINEUSERCOUNT")));
                bean.setOnlineStoreUserCount(Integer.parseInt((String)prop.get("ONLINESTOREUSERCOUNT")));
                this.licenseMapper.insert(bean);
            }
            String string = map.get("flag").toString();
            return string;
        }
        finally {
            multiFile = null;
        }
    }

    @Override
    public LicenseBean selectByLastPrimaryKey() {
        return this.licenseMapper.selectByLastPrimaryKey();
    }

    @Override
    public String isQualified(String type) {
        if (!"third".equals(type) && !"user".equals(type)) {
            return "100";
        }
        LicenseBean licenseBean = this.licenseMapper.selectByLastPrimaryKey();
        if (licenseBean == null) {
            return "101";
        }
        if (LicenseUtil.isGreaterThanCurrentTime(licenseBean.licenseStartTime)) {
            return "102";
        }
        if (!LicenseUtil.isGreaterThanCurrentTime(licenseBean.licenseEndTime)) {
            return "103";
        }
        if ("third".equals(type)) {
            if (OnlineUserCountListener.onlineUserSessionCount >= licenseBean.getOnlineStoreUserCount()) {
                return "104";
            }
        } else if ("user".equals(type)) {
            if (OnlineUserCountListener.onlineUserSessionCount >= licenseBean.getOnlineUserCount()) {
                return "105";
            }
        } else {
            return "1";
        }
        return "1";
    }

    public Date StringChangeToDate(String dateString) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date date = sdf.parse(dateString);
            return date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

