/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.service.impl;

import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.temp.bean.TempToken;
import com.qianjiang.temp.dao.TempTokenMapper;
import com.qianjiang.temp.service.TempTokenService;
import com.qianjiang.util.MyLogger;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="TempTokenService")
public class TempTokenServiceImpl
implements TempTokenService {
    private static final MyLogger LOGGER = new MyLogger(TempTokenServiceImpl.class);
    @Resource(name="TempTokenMapper")
    private TempTokenMapper tokenMapper;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public int createToken(TempToken token) {
        int result = 0;
        try {
            Date date = new Date();
            token.setCreateDate(date);
            token.setUpdateDate(date);
            result = this.tokenMapper.insertSelective(token);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6dfb\u52a0\u6a21\u677ftoken\u9519\u8bef\uff1a=>" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int updateToken(TempToken token) {
        int result = 0;
        try {
            token.setUpdateDate(new Date());
            result = this.tokenMapper.updateByPrimaryKeySelective(token);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fee\u6539\u6a21\u677ftoken\u9519\u8bef\uff1a=>" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int deleteToken(Long tokenId) {
        int result = 0;
        try {
            result = this.tokenMapper.deleteByPrimaryKey(tokenId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5220\u9664\u6a21\u677ftoken\u9519\u8bef\uff1a=>" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public TempToken getCurrToken() {
        TempToken token = null;
        try {
            List<TempToken> list = this.tokenMapper.selectAllToken();
            if (list != null && !list.isEmpty()) {
                token = list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u83b7\u53d6\u5f53\u524d\u6a21\u677ftoken\u9519\u8bef\uff1a=>" + e.getMessage(), e);
        }
        return token;
    }

    @Override
    public TempToken selectTokenByType(String temp1) {
        TempToken tempToken = (TempToken)this.redisAdapter.get("TEMPTOKEN_KEY");
        if (null != tempToken) {
            return tempToken;
        }
        tempToken = this.tokenMapper.selectTokenByType(temp1);
        this.redisAdapter.put("TEMPTOKEN_KEY", tempToken);
        return tempToken;
    }

    @Override
    public int updateTokenValue(TempToken tToken) {
        int result = 0;
        String token = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            token = new BigInteger(1, md.digest()).toString(16);
            tToken.setToken(token);
            tToken.setUpdateDate(new Date());
            this.redisAdapter.delete("TEMPTOKEN_KEY");
            result = this.tokenMapper.updateTokenValue(tToken);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u66f4\u65b0token\u5931\u8d25\uff0c\u52a0\u5bc6\u5f02\u5e38\uff01" + e.getMessage(), e);
        }
        return result;
    }
}

