/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.Bar;
import com.qianjiang.system.dao.BarMapper;
import com.qianjiang.system.service.BarService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="barService")
public class BarServiceImpl
implements BarService {
    @Resource(name="barMapper")
    private BarMapper barMapper;

    @Override
    public PageBean findByPageBean(PageBean pageBean, SelectBean selectBean) {
        pageBean.setRows(this.barMapper.findTotalCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startRowNum", pageBean.getStartRowNum());
        map.put("endRowNum", pageBean.getEndRowNum());
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        pageBean.setList(this.barMapper.findByPageBean(map));
        return pageBean;
    }

    @Override
    public int insertBar(Bar bar) {
        bar.setDelFlag("0");
        return this.barMapper.insertSelective(bar);
    }

    @Override
    public int deleteBar(String[] barId) {
        int count = 0;
        if (barId != null) {
            for (String id : barId) {
                count += this.barMapper.deleteByPrimaryKey(Long.parseLong(id));
            }
        }
        return count;
    }

    @Override
    public Bar findByBarId(Long barId) {
        return this.barMapper.selectByPrimaryKey(barId);
    }

    @Override
    public int updateBar(Bar bar) {
        bar.setModifyTime(new Date());
        return this.barMapper.updateByPrimaryKeySelective(bar);
    }
}

