/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.system.bean.OSSConf;
import com.qianjiang.system.dao.OSSConfMapper;
import com.qianjiang.system.service.OSSConfService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="oSSConfServiceImpl")
public class OSSConfServiceImpl
implements OSSConfService {
    private static final MyLogger logger = new MyLogger(OSSConfServiceImpl.class);
    @Autowired
    private OSSConfMapper ossConfMapper;

    @Override
    public Map<String, Object> findAllOssConf(PageBean pageBean) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int no = 0;
        try {
            int count = this.ossConfMapper.countOssConf();
            pageBean.setRows(count);
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            List<OSSConf> list = this.ossConfMapper.findAllOssConf(paramMap);
            pageBean.setData(list);
            resultMap.put("pageBean", pageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5206\u9875\u67e5\u8be2oss\u5bf9\u8c61\u5b58\u50a8\u914d\u7f6e\u5931\u8d25" + e.getMessage(), e);
        }
        return resultMap;
    }

    @Override
    public OSSConf findByOssId(Long ossId) {
        OSSConf ossConf = new OSSConf();
        try {
            ossConf = this.ossConfMapper.findByOssId(ossId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u4e3b\u952eossId\u67e5\u8be2\u914d\u7f6e\u4fe1\u606f\u5931\u8d25" + e.getMessage(), e);
        }
        return ossConf;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Object> updateOssConf(OSSConf oSSConf) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String ossStatus = oSSConf.getOssStatus();
            logger.info("\u524d\u53f0\u4f20\u9012\u7684oss\u72b6\u6001,ossStatus:" + ossStatus);
            if ("0".equals(ossStatus)) {
                OSSConf ossConfInfo = this.ossConfMapper.findByOssId(oSSConf.getOssId());
                if ("1".equals(ossConfInfo.getOssStatus()) && this.ossConfMapper.countOssStatus() <= 1) {
                    resultMap.put("result", "unUsed");
                    return resultMap;
                }
            } else {
                OSSConf ossConfUsed = this.ossConfMapper.findByOssStatus();
                if (ossConfUsed != null) {
                    OSSConf conf = new OSSConf();
                    conf.setOssStatus("0");
                    conf.setOssId(ossConfUsed.getOssId());
                    this.ossConfMapper.updateOssConf(conf);
                }
            }
            this.ossConfMapper.updateOssConf(oSSConf);
            resultMap.put("result", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u4fee\u6539oss\u5bf9\u8c61\u8bbe\u7f6e\u5931\u8d25" + e.getMessage(), e);
            resultMap.put("result", false);
        }
        return resultMap;
    }

    @Override
    public OSSConf findByOssStatus() {
        return this.ossConfMapper.findByOssStatus();
    }
}

