/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.service.impl;

import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.bean.SeoConf;
import com.qianjiang.system.dao.ISeoConfDao;
import com.qianjiang.system.service.ISeoConfBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="seoConfBizImpl")
public class SeoConfBizImpl
implements ISeoConfBiz {
    private static final MyLogger LOGGER = new MyLogger(SeoConfBizImpl.class);
    private ISeoConfDao seoConfDaoImpl;
    @Resource
    private RedisAdapter redisAdapter;

    public final ISeoConfDao getSeoConfDaoImpl() {
        return this.seoConfDaoImpl;
    }

    @Resource(name="seoConfDaoImpl")
    public final void setSeoConfDaoImpl(ISeoConfDao seoConfDaoImpl) {
        this.seoConfDaoImpl = seoConfDaoImpl;
    }

    @Override
    public final boolean saveSeoConf(SeoConf seoConf) {
        if (seoConf == null) {
            LOGGER.error("SEO\u8bbe\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\uff01");
            return false;
        }
        try {
            if ("1".equals(seoConf.getUsedStatus())) {
                this.seoConfDaoImpl.updateSeoConfByUsedStatus();
            }
            this.redisAdapter.delete("SEO_KEY");
            return this.seoConfDaoImpl.saveSeoConf(seoConf);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return false;
        }
    }

    @Override
    public final int updateSeoConf(SeoConf seoConf) {
        if (seoConf == null) {
            LOGGER.error("SEO\u8bbe\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u4fee\u6539\u64cd\u4f5c\uff01");
            return 0;
        }
        try {
            this.redisAdapter.delete("SEO_KEY");
            return this.seoConfDaoImpl.updateSeoConf(seoConf);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public void createRoborts(SeoConf seoConf, String path, String basePath) {
        String mallpath = new File(path).getParent();
        File fl = new File(mallpath + "/site/robots.txt");
        try {
            if (!fl.getParentFile().exists()) {
                fl.getParentFile().mkdirs();
            }
            if (!fl.exists()) {
                fl.createNewFile();
            }
            FileWriter flw = new FileWriter(fl);
            flw.write("");
            flw.write(seoConf.getMeteDes());
            flw.append("\nSitemap:" + basePath + "sitemap.xml");
            flw.close();
        }
        catch (IOException e) {
            LOGGER.info(e);
        }
    }

    @Override
    public final SeoConf getSeoConfById(int id) {
        if (id == 0) {
            LOGGER.error("\u5bf9\u8c61SEO\u8bbe\u7f6e\u7684id\u4e3a0\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return null;
        }
        try {
            return this.seoConfDaoImpl.getSeoConfById(id);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
    }

    @Override
    public final List<SeoConf> getSeoConfByIds(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61SEO\u8bbe\u7f6e\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return Collections.emptyList();
        }
        try {
            return this.seoConfDaoImpl.getSeoConfByIds(ids);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return Collections.emptyList();
        }
    }

    @Override
    public final int deleteSeoConf(String ids) {
        if (ids == null || ids.trim().length() == 0) {
            LOGGER.error("\u5bf9\u8c61SEO\u8bbe\u7f6e\u7684id\u96c6\u5408\u5b57\u7b26\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u5bf9\u8c61\uff01");
            return 0;
        }
        try {
            this.redisAdapter.delete("SEO_KEY");
            return this.seoConfDaoImpl.deleteSeoConf(ids);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final int updateSeoConfFieldById(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u66f4\u65b0SEO\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\uff01");
            return 0;
        }
        if (parameter.containsKey("ids")) {
            String ids = (String)parameter.get("ids");
            ArrayList<String> idList = new ArrayList<String>();
            if (ids.contains(",")) {
                for (String id : ids.split(",")) {
                    idList.add(id);
                }
            } else {
                idList.add(ids);
            }
            parameter.put("ids", idList);
        }
        try {
            this.redisAdapter.delete("SEO_KEY");
            return this.seoConfDaoImpl.updateSeoConfFieldById(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final int getSeoConfByFieldTotal(Map<String, Object> parameter) {
        if (parameter == null || parameter.isEmpty()) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636eSEO\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2SEO\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.seoConfDaoImpl.getSeoConfByFieldTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final PageBean getSeoConfByField(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u6839\u636eSEO\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2SEO\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.getSeoConfByFieldTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put("startRowNum", pageBean.getStartRowNum());
            parameter.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.seoConfDaoImpl.getSeoConfByField(parameter));
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
        return pageBean;
    }

    @Override
    public final int querySeoConfTotal(Map<String, Object> parameter) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2SEO\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\u603b\u6570\uff01");
            return 0;
        }
        try {
            return this.seoConfDaoImpl.querySeoConfTotal(parameter);
        }
        catch (Exception e) {
            LOGGER.info(e);
            return 0;
        }
    }

    @Override
    public final PageBean querySeoConfByPage(Map<String, Object> parameter, PageBean pageBean) {
        if (parameter == null) {
            LOGGER.error("\u53c2\u6570Map\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5206\u9875\u67e5\u8be2SEO\u8bbe\u7f6e\u5bf9\u8c61\u4fe1\u606f\uff01");
            return null;
        }
        int no = 0;
        try {
            pageBean.setRows(this.querySeoConfTotal(parameter));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            parameter.put("startRowNum", pageBean.getStartRowNum());
            parameter.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.seoConfDaoImpl.querySeoConfByPage(parameter));
        }
        catch (Exception e) {
            LOGGER.info(e);
            return null;
        }
        return pageBean;
    }

    @Override
    public SeoConf querySeoByUsedStatus() {
        return this.seoConfDaoImpl.querySeoByUsedStatus();
    }

    @Override
    public int updateSeoConfByUsedStatus() {
        this.redisAdapter.delete("SEO_KEY");
        return this.seoConfDaoImpl.updateSeoConfByUsedStatus();
    }

    @Override
    public int deleteSeoConf(Long seoId) {
        this.redisAdapter.delete("SEO_KEY");
        return this.seoConfDaoImpl.deleteSeoByPrimaryKey(seoId);
    }
}

