/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.sitemap;

import com.qianjiang.system.sitemap.Sitemap;
import com.qianjiang.system.sitemap.Url;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;

public class CreateSiteMap {
    protected static final String URLSET_START = "<?xml version='1.0' encoding='UTF-8'?>\n<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\"\n         xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
    protected static final String URLSET_END = "\n</urlset>";
    protected static final String SITEMAPINDEX_START = "<?xml version='1.0' encoding='UTF-8'?>\n<sitemapindex xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/siteindex.xsd\"\n         xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
    protected static final String SITEMAPINDEX_END = "\n</sitemapindex>";

    private CreateSiteMap() {
    }

    public static void writeSitemapIndex(Writer writer, Iterator<? extends Sitemap> mappings) throws IOException {
        CreateSiteMap.writeXml(writer, SITEMAPINDEX_START, mappings, SITEMAPINDEX_END);
    }

    public static long writeUrlset(Writer writer, Iterator<? extends Url> urls) throws IOException {
        return CreateSiteMap.writeXml(writer, URLSET_START, urls, URLSET_END);
    }

    private static long writeXml(Writer writer, String start, Iterator<?> it, String end) throws IOException {
        writer.write(start);
        long count = CreateSiteMap.writeSubtree(writer, it);
        writer.write(end);
        return count;
    }

    public static long writeSubtree(Writer writer, Iterator<?> it) throws IOException {
        Marshaller m;
        long size = 0L;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Sitemap.class, Url.class});
            m = jc.createMarshaller();
            m.setProperty("jaxb.fragment", (Object)true);
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (PropertyException e) {
            throw new DataBindingException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                writer.write("\n");
            }
            try {
                m.marshal(it.next(), writer);
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
            ++size;
        }
        return size;
    }
}

