/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.deposit.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.deposit.bean.Bank;
import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.bean.DepositConst;
import com.qianjiang.deposit.bean.Trade;
import com.qianjiang.deposit.bean.TradeExample;
import com.qianjiang.deposit.bean.WithDrawExample;
import com.qianjiang.deposit.bean.Withdraw;
import com.qianjiang.deposit.bean.WithdrawForm;
import com.qianjiang.deposit.bean.WithdrawVo;
import com.qianjiang.deposit.mapper.TradeMapper;
import com.qianjiang.deposit.mapper.WithDrawMapper;
import com.qianjiang.deposit.service.BankService;
import com.qianjiang.deposit.service.DepositInter;
import com.qianjiang.deposit.service.TradeService;
import com.qianjiang.deposit.service.WithdrawInter;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UtilDate;
import com.qianjiang.util.web.ReturnJsonBuilder;
import com.qianjiang.util.web.ReturnJsonBuilderFactory;
import com.qianjiang.utils.SecurityUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="withdrawService")
public class WithdrawService
implements WithdrawInter {
    private Logger LOGGER = Logger.getLogger(WithdrawService.class);
    @Autowired
    TradeMapper tradeMapper;
    @Autowired
    DepositInter depositInter;
    @Autowired
    BankService bankService;
    @Autowired
    private WithDrawMapper mapper;
    @Autowired
    TradeService tradeService;
    @Autowired
    CustomerServiceMapper customerService;

    @Override
    @Transactional
    public Map<String, Object> confirm(Long id) {
        Trade trade = this.tradeMapper.selectById(id);
        ConcurrentHashMap<String, Object> rmap = new ConcurrentHashMap<String, Object>();
        if (trade == null || trade.getOrderStatus().equals("3")) {
            rmap.put("code", "1");
            rmap.put("msg", "\u786e\u8ba4\u6536\u6b3e\u5931\u8d25");
            return rmap;
        }
        Long customerId = trade.getCustomerId();
        Deposit deposit = this.depositInter.findByCustomerId(customerId);
        this.consumeDeposit(deposit, trade.getOrderPrice());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("status", "4");
        BigDecimal currentPrice = deposit.getFreezePreDeposit().add(deposit.getPreDeposit()).subtract(trade.getOrderPrice());
        map.put("currentPrice", currentPrice);
        Integer result = this.tradeMapper.updateById(map);
        rmap.put("code", "0");
        rmap.put("msg", "success");
        return rmap;
    }

    @Override
    public Integer confirmTask() {
        TradeExample example = new TradeExample();
        example.createCriteria().andOrderStatusEqualTo("3").andOrderTypeEqualTo("2").andUpdateTimeLessThan(DateUtils.addDays((Date)new Date(), (int)-7));
        Trade newTrade = new Trade();
        newTrade.setOrderStatus("4");
        List<Trade> tradeList = this.tradeMapper.selectByExample(example);
        int count = 0;
        for (Trade trade : tradeList) {
            Map<String, Object> rmap = this.confirm(trade.getId());
            if (!rmap.get("code").equals("0")) continue;
            ++count;
        }
        this.LOGGER.info((Object)("[\u5b9a\u65f6\u4efb\u52a1]\u9884\u5b58\u6b3e\u63d0\u73b0,\u81ea\u52a8\u786e\u8ba4\u6536\u6b3e,\u5171\u66f4\u65b0\u4ea4\u6613\u8bb0\u5f55" + tradeList.size() + "\u6761"));
        this.LOGGER.info((Object)("[\u5b9a\u65f6\u4efb\u52a1]\u6210\u529f" + count + "\u6761"));
        return count;
    }

    @Override
    public Integer updateByIdAndStatus(Trade trade, Long id, String status) {
        TradeExample example = new TradeExample();
        example.createCriteria().andIdEqualTo(id).andOrderStatusEqualTo(status);
        return this.tradeMapper.updateByExample(trade, example);
    }

    @Override
    public Integer consumeDeposit(Deposit deposit, BigDecimal amount) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", deposit.getId());
        BigDecimal freezePreDeposit = deposit.getFreezePreDeposit().subtract(amount);
        paramMap.put("freezePreDeposit", freezePreDeposit);
        if (freezePreDeposit.compareTo(BigDecimal.ZERO) == 0) {
            paramMap.put("freezePreDeposit", "0");
        }
        return this.depositInter.updateDeposit(paramMap);
    }

    @Override
    public Withdraw findById(Long tradeId) {
        return this.mapper.selectByPrimaryKey(tradeId);
    }

    @Override
    public int save(Withdraw withdraw) {
        return this.mapper.insertSelective(withdraw);
    }

    @Override
    public List<Withdraw> selectByExample(WithDrawExample example) {
        return this.mapper.selectByExample(example);
    }

    @Override
    public PageBean findByCustomerIdAndStatus(WithdrawForm withdrawForm) {
        PageBean pb = new PageBean();
        pb.setPageNo(withdrawForm.getPageNo());
        pb.setPageSize(withdrawForm.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerId", withdrawForm.getCustomerId());
        String status = withdrawForm.getStatus();
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (status.equals("3")) {
                map.put("statuses", new String[]{"2", "3"});
            } else {
                map.put("statuses", new String[]{status});
            }
        }
        map.put("types", new String[]{"2"});
        PageBean pageBean = this.tradeService.pageTrade(map, pb);
        return pageBean;
    }

    @Override
    public WithdrawVo findVoById(Long id, Long customerId) {
        Trade trade = this.tradeService.findByIdAndCustomerId(id, customerId);
        WithDrawExample example = new WithDrawExample();
        example.createCriteria().andTradeInfoIdEqualTo(id);
        Withdraw withdraw = this.mapper.selectByExample(example).get(0);
        WithdrawVo vo = new WithdrawVo();
        vo.setId(trade.getId());
        vo.setOrderCode(trade.getOrderCode());
        vo.setCreateTime(trade.getCreateTime());
        vo.setAccountName(withdraw.getAccountName());
        vo.setBankName(withdraw.getBankName());
        vo.setBankNo(withdraw.getBankNo());
        vo.setAmount(trade.getOrderPrice());
        vo.setRemark(trade.getTradeRemark());
        vo.setPayRemark(trade.getPayRemark());
        vo.setPayBillNum(trade.getPayBillNum());
        vo.setCertificateImg(trade.getCertificateImg());
        vo.setReviewedRemark(trade.getReviewedRemark());
        vo.setContactMobile(withdraw.getContactMobile());
        vo.setCustomerId(trade.getCustomerId());
        vo.setOrderStatus(trade.getOrderStatus());
        return vo;
    }

    @Override
    @Transactional
    public JSONObject create(WithdrawVo vo) throws IllegalArgumentException {
        JSONObject returnVal = new JSONObject();
        Long customerId = vo.getCustomerId();
        Customer customer = this.customerService.queryCustomerById(customerId);
        String encodePwd = SecurityUtil.getStoreLogpwd(customer.getUniqueCode(), vo.getPayPwd(), customer.getSaltVal());
        BigDecimal amount = vo.getAmount();
        Deposit deposit = this.depositInter.findByCustomerId(customerId);
        BigDecimal nextDeposit = deposit.getPreDeposit().subtract(amount);
        BigDecimal nextFrozenDeposit = deposit.getFreezePreDeposit().add(amount);
        vo.setCurrentPrice(deposit.getPreDeposit().add(deposit.getFreezePreDeposit()));
        String payPassword = deposit.getPayPassword();
        if (StringUtils.isBlank((CharSequence)payPassword)) {
            return ReturnJsonBuilderFactory.builder().code("1").msg(DepositConst.NOT_SET_DEPOSIT_PAY_PASSWORD).build();
        }
        if (deposit.getPasswordErrorCount() >= DepositConst.ERROR_TRY_COUNT) {
            returnVal.put("code", (Object)"2");
            returnVal.put("msg", (Object)DepositConst.CANNOT_WITHDRAW);
            return returnVal;
        }
        if (!encodePwd.equals(payPassword)) {
            int nextErrorCount = deposit.addPwdErrorCount();
            this.depositInter.updateErrorCount(customerId, nextErrorCount);
            returnVal.put("code", (Object)"3");
            returnVal.put("msg", (Object)MessageFormat.format(DepositConst.PIN_ERROR, 3 - nextErrorCount));
            return returnVal;
        }
        if (nextDeposit.compareTo(BigDecimal.ZERO) == -1) {
            returnVal.put("code", (Object)"4");
            returnVal.put("msg", (Object)DepositConst.INSUFFICIENCE_DEPOSIT);
            return returnVal;
        }
        if (nextFrozenDeposit.compareTo(BigDecimal.valueOf(0L)) <= 0) {
            returnVal.put("code", (Object)"4");
            returnVal.put("msg", (Object)DepositConst.INVALID_PRICE);
            return returnVal;
        }
        if (nextFrozenDeposit.compareTo(BigDecimal.valueOf(9.999999999E7)) == 1) {
            returnVal.put("code", (Object)"4");
            returnVal.put("msg", (Object)DepositConst.FROZNE_DEPOSIT_OUT_OF_RANGE);
            return returnVal;
        }
        Long bankId = vo.getReceivingBank();
        if (bankId != -1L) {
            Bank bank = this.bankService.findById(bankId);
            vo.setBankName(bank.getBankName());
        }
        this.freezeDeposit(deposit, amount);
        Date createTime = new Date();
        String orderCode = this.saveTrade(vo, createTime);
        Trade nextTrade = this.tradeService.findByOrderCode(orderCode);
        Long tradeId = nextTrade.getId();
        Withdraw withdraw = new Withdraw();
        BeanUtils.copyProperties((Object)vo, (Object)withdraw);
        withdraw.setTradeInfoId(tradeId);
        withdraw.setCreateTime(createTime);
        this.save(withdraw);
        returnVal.put("code", (Object)"0");
        returnVal.put("msg", (Object)"success");
        return ReturnJsonBuilderFactory.builder().data("tradeId", (Object)tradeId).defaultVal();
    }

    private Integer freezeDeposit(Deposit deposit, BigDecimal amount) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", deposit.getId());
        paramMap.put("customerId", deposit.getCustomerId());
        paramMap.put("preDeposit", deposit.getPreDeposit().subtract(amount));
        paramMap.put("freezePreDeposit", deposit.getFreezePreDeposit().add(amount));
        return this.depositInter.updateDeposit(paramMap);
    }

    private String saveTrade(WithdrawVo vo, Date createTime) {
        Long customerId = vo.getCustomerId();
        String orderCode = "W" + UtilDate.mathString((Date)createTime) + (RandomUtils.nextInt((int)9000) + 1000);
        Trade trade = new Trade();
        trade.setCustomerId(customerId);
        trade.setCreatePerson(customerId);
        trade.setOrderPrice(vo.getAmount());
        trade.setCurrentPrice(vo.getCurrentPrice());
        trade.setOrderCode(orderCode);
        trade.setOrderStatus("0");
        trade.setOrderType("2");
        trade.setTradeRemark(vo.getRemark());
        trade.setCreateTime(createTime);
        this.tradeService.saveTrade(trade);
        return orderCode;
    }

    @Override
    public JSONObject cancel(Long id, Long customerId) {
        Trade nextTrade = new Trade();
        nextTrade.setOrderStatus("8");
        Integer result = this.tradeService.updateByIdAndStatus(nextTrade, id, customerId, "0");
        if (result == 0) {
            return ReturnJsonBuilderFactory.builder().code("1").msg("\u53c2\u6570\u9519\u8bef,\u64cd\u4f5c\u5931\u8d25").build();
        }
        Trade trade = this.tradeService.findById(id);
        Deposit deposit = this.depositInter.findByCustomerId(customerId);
        this.unFreezeDeposit(deposit, trade.getOrderPrice());
        return new ReturnJsonBuilder().code("0").msg("success").build();
    }

    @Override
    @Transactional
    public JSONObject confirm(Long id, Long customerId) {
        Trade nextTrade = new Trade();
        nextTrade.setOrderStatus("4");
        Integer result = this.tradeService.updateByIdAndStatus(nextTrade, id, customerId, "3");
        if (result == 0) {
            return ReturnJsonBuilderFactory.builder().code("1").msg("\u786e\u8ba4\u6536\u6b3e\u5931\u8d25").build();
        }
        Trade trade = this.tradeService.findById(id);
        Deposit deposit = this.depositInter.findByCustomerId(customerId);
        this.consumeDeposit(deposit, trade.getOrderPrice());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("status", "4");
        BigDecimal currentPrice = deposit.getFreezePreDeposit().add(deposit.getPreDeposit()).subtract(trade.getOrderPrice());
        map.put("currentPrice", currentPrice);
        this.tradeService.updateById(map);
        return new ReturnJsonBuilder().code("0").msg("success").build();
    }

    private Integer unFreezeDeposit(Deposit deposit, BigDecimal amount) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", deposit.getId());
        paramMap.put("customerId", deposit.getCustomerId());
        paramMap.put("preDeposit", deposit.getPreDeposit().add(amount));
        BigDecimal freezePreDeposit = deposit.getFreezePreDeposit().subtract(amount);
        paramMap.put("freezePreDeposit", freezePreDeposit);
        if (freezePreDeposit.compareTo(BigDecimal.ZERO) == 0) {
            paramMap.put("freezePreDeposit", "0");
        }
        return this.depositInter.updateDeposit(paramMap);
    }
}

